/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.Filters;
import org.mapstruct.ap.internal.util.Nouns;

public class Type
extends ModelElement
implements Comparable<Type> {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeFactory typeFactory;
    private final TypeMirror typeMirror;
    private final TypeElement typeElement;
    private final List<Type> typeParameters;
    private final Type implementationType;
    private final Type componentType;
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final boolean isInterface;
    private final boolean isEnumType;
    private final boolean isIterableType;
    private final boolean isCollectionType;
    private final boolean isMapType;
    private final boolean isImported;
    private final boolean isVoid;
    private final List<String> enumConstants;
    private Map<String, ExecutableElement> getters = null;
    private List<ExecutableElement> allExecutables = null;
    private List<ExecutableElement> setters = null;
    private List<ExecutableElement> adders = null;
    private List<ExecutableElement> alternativeTargetAccessors = null;
    private Type boundingBase = null;

    public Type(Types typeUtils, Elements elementUtils, TypeFactory typeFactory, TypeMirror typeMirror, TypeElement typeElement, List<Type> typeParameters, Type implementationType, Type componentType, String packageName, String name, String qualifiedName, boolean isInterface, boolean isEnumType, boolean isIterableType, boolean isCollectionType, boolean isMapType, boolean isImported) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.typeFactory = typeFactory;
        this.typeMirror = typeMirror;
        this.typeElement = typeElement;
        this.typeParameters = typeParameters;
        this.componentType = componentType;
        this.implementationType = implementationType;
        this.packageName = packageName;
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.isInterface = isInterface;
        this.isEnumType = isEnumType;
        this.isIterableType = isIterableType;
        this.isCollectionType = isCollectionType;
        this.isMapType = isMapType;
        this.isImported = isImported;
        boolean bl = this.isVoid = typeMirror.getKind() == TypeKind.VOID;
        if (isEnumType) {
            this.enumConstants = new ArrayList<String>();
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                this.enumConstants.add(element.getSimpleName().toString());
            }
        } else {
            this.enumConstants = Collections.emptyList();
        }
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public List<String> getEnumConstants() {
        return this.enumConstants;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public boolean isIterableType() {
        return this.isIterableType || this.isArrayType();
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isMapType() {
        return this.isMapType;
    }

    public boolean isCollectionOrMapType() {
        return this.isCollectionType || this.isMapType;
    }

    public boolean isArrayType() {
        return this.componentType != null;
    }

    public boolean isTypeVar() {
        return this.typeMirror.getKind() == TypeKind.TYPEVAR;
    }

    public boolean isWildCardSuperBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildcardType = (WildcardType)this.typeMirror;
            result = wildcardType.getSuperBound() != null;
        }
        return result;
    }

    public boolean isWildCardExtendsBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildcardType = (WildcardType)this.typeMirror;
            result = wildcardType.getExtendsBound() != null;
        }
        return result;
    }

    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    public String getImportName() {
        return this.isArrayType() ? this.qualifiedName.substring(0, this.qualifiedName.length() - 2) : this.qualifiedName;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> result = new HashSet<Type>();
        result.add(this);
        if (this.componentType != null) {
            result.addAll(this.componentType.getImportTypes());
        }
        for (Type parameter : this.typeParameters) {
            result.addAll(parameter.getImportTypes());
        }
        return result;
    }

    public boolean isImported() {
        return this.isImported;
    }

    public boolean isAnnotatedWith(String annotationTypeName) {
        List<? extends AnnotationMirror> annotationMirrors = this.typeElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Name mirrorAnnotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!mirrorAnnotationName.contentEquals(annotationTypeName)) continue;
            return true;
        }
        return false;
    }

    public Type erasure() {
        return new Type(this.typeUtils, this.elementUtils, this.typeFactory, this.typeUtils.erasure(this.typeMirror), this.typeElement, this.typeParameters, this.implementationType, this.componentType, this.packageName, this.name, this.qualifiedName, this.isInterface, this.isEnumType, this.isIterableType, this.isCollectionType, this.isMapType, this.isImported);
    }

    public boolean isAssignableTo(Type other) {
        if (this.equals(other)) {
            return true;
        }
        return this.typeUtils.isAssignable(this.typeMirror, other.typeMirror);
    }

    public Map<String, ExecutableElement> getPropertyReadAccessors() {
        if (this.getters == null) {
            List<ExecutableElement> getterList = Filters.getterMethodsIn(this.getAllExecutables());
            LinkedHashMap<String, ExecutableElement> modifiableGetters = new LinkedHashMap<String, ExecutableElement>();
            for (ExecutableElement getter : getterList) {
                modifiableGetters.put(Executables.getPropertyName(getter), getter);
            }
            this.getters = Collections.unmodifiableMap(modifiableGetters);
        }
        return this.getters;
    }

    public Map<String, ExecutableElement> getPropertyWriteAccessors(CollectionMappingStrategyPrism cmStrategy) {
        ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>();
        candidates.addAll(this.getSetters());
        candidates.addAll(this.getAlternativeTargetAccessors());
        LinkedHashMap<String, ExecutableElement> result = new LinkedHashMap<String, ExecutableElement>();
        for (ExecutableElement candidate : candidates) {
            String targetPropertyName = Executables.getPropertyName(candidate);
            if (cmStrategy == CollectionMappingStrategyPrism.SETTER_PREFERRED || cmStrategy == CollectionMappingStrategyPrism.ADDER_PREFERRED) {
                Type targetType;
                ExecutableElement adderMethod = null;
                if (Executables.isSetterMethod(candidate)) {
                    targetType = this.typeFactory.getSingleParameter(this.typeElement, candidate).getType();
                    if (cmStrategy == CollectionMappingStrategyPrism.ADDER_PREFERRED) {
                        adderMethod = this.getAdderForType(targetType, targetPropertyName);
                    }
                } else if (Executables.isGetterMethod(candidate)) {
                    targetType = this.typeFactory.getReturnType(this.typeFactory.getMethodType(this.typeElement, candidate));
                    adderMethod = this.getAdderForType(targetType, targetPropertyName);
                }
                if (adderMethod != null) {
                    candidate = adderMethod;
                }
            }
            result.put(targetPropertyName, candidate);
        }
        return result;
    }

    private List<ExecutableElement> getAllExecutables() {
        if (this.allExecutables == null) {
            this.allExecutables = Executables.getAllEnclosedExecutableElements(this.elementUtils, this.typeElement);
        }
        return this.allExecutables;
    }

    private ExecutableElement getAdderForType(Type collectionProperty, String pluralPropertyName) {
        ArrayList<ExecutableElement> candidates = new ArrayList<ExecutableElement>();
        if (collectionProperty.isCollectionType && !collectionProperty.getTypeParameters().isEmpty()) {
            TypeMirror typeArg = collectionProperty.getTypeParameters().get(0).getTypeMirror();
            List<ExecutableElement> adderList = this.getAdders();
            for (ExecutableElement adder : adderList) {
                VariableElement arg = adder.getParameters().get(0);
                if (!arg.asType().equals(typeArg)) continue;
                candidates.add(adder);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ExecutableElement)candidates.get(0);
        }
        for (ExecutableElement candidate : candidates) {
            String elementName = Executables.getElementNameForAdder(candidate);
            if (!elementName.equals(Nouns.singularize(pluralPropertyName))) continue;
            return candidate;
        }
        return null;
    }

    private List<ExecutableElement> getSetters() {
        if (this.setters == null) {
            this.setters = Collections.unmodifiableList(Filters.setterMethodsIn(this.getAllExecutables()));
        }
        return this.setters;
    }

    private List<ExecutableElement> getAdders() {
        if (this.adders == null) {
            this.adders = Collections.unmodifiableList(Filters.adderMethodsIn(this.getAllExecutables()));
        }
        return this.adders;
    }

    private List<ExecutableElement> getAlternativeTargetAccessors() {
        if (this.alternativeTargetAccessors == null) {
            ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
            List<ExecutableElement> setterMethods = this.getSetters();
            ArrayList<ExecutableElement> getterMethods = new ArrayList<ExecutableElement>(this.getPropertyReadAccessors().values());
            for (ExecutableElement getterMethod : getterMethods) {
                if (!this.isCollectionOrMap(getterMethod) || this.correspondingSetterMethodExists(getterMethod, setterMethods)) continue;
                result.add(getterMethod);
            }
            this.alternativeTargetAccessors = Collections.unmodifiableList(result);
        }
        return this.alternativeTargetAccessors;
    }

    private boolean correspondingSetterMethodExists(ExecutableElement getterMethod, List<ExecutableElement> setterMethods) {
        String getterPropertyName = Executables.getPropertyName(getterMethod);
        for (ExecutableElement setterMethod : setterMethods) {
            String setterPropertyName = Executables.getPropertyName(setterMethod);
            if (!getterPropertyName.equals(setterPropertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollectionOrMap(ExecutableElement getterMethod) {
        return this.isCollection(getterMethod.getReturnType()) || this.isMap(getterMethod.getReturnType());
    }

    private boolean isCollection(TypeMirror candidate) {
        return this.isSubType(candidate, Collection.class);
    }

    private boolean isMap(TypeMirror candidate) {
        return this.isSubType(candidate, Map.class);
    }

    private boolean isSubType(TypeMirror candidate, Class<?> clazz) {
        String className = clazz.getCanonicalName();
        TypeMirror classType = this.typeUtils.erasure(this.elementUtils.getTypeElement(className).asType());
        return this.typeUtils.isSubtype(candidate, classType);
    }

    public int distanceTo(Type assignableOther) {
        return this.distanceTo(this.typeMirror, assignableOther.typeMirror);
    }

    private int distanceTo(TypeMirror base, TypeMirror targetType) {
        if (this.typeUtils.isSameType(base, targetType)) {
            return 0;
        }
        if (!this.typeUtils.isAssignable(base, targetType)) {
            return -1;
        }
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(base);
        int minDistanceOfSuperToTargetType = Integer.MAX_VALUE;
        for (TypeMirror typeMirror : directSupertypes) {
            int distanceToTargetType = this.distanceTo(typeMirror, targetType);
            if (distanceToTargetType < 0) continue;
            minDistanceOfSuperToTargetType = Math.min(minDistanceOfSuperToTargetType, distanceToTargetType);
        }
        return 1 + minDistanceOfSuperToTargetType;
    }

    public boolean canAccess(Type type, ExecutableElement method) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return this.isAssignableTo(type) || this.getPackageName().equals(type.getPackageName());
        }
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return this.getPackageName().equals(type.getPackageName());
        }
        return true;
    }

    public String getNull() {
        if (!this.isPrimitive() || this.isArrayType()) {
            return "null";
        }
        if ("boolean".equals(this.getName())) {
            return "false";
        }
        if ("byte".equals(this.getName())) {
            return "0";
        }
        if ("char".equals(this.getName())) {
            return "'\\u0000'";
        }
        if ("double".equals(this.getName())) {
            return "0.0";
        }
        if ("float".equals(this.getName())) {
            return "0.0f";
        }
        if ("int".equals(this.getName())) {
            return "0";
        }
        if ("long".equals(this.getName())) {
            return "0L";
        }
        if ("short".equals(this.getName())) {
            return "0";
        }
        throw new UnsupportedOperationException(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.typeUtils.isSameType(this.typeMirror, other.typeMirror);
    }

    @Override
    public int compareTo(Type o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public String toString() {
        return this.typeMirror.toString();
    }

    public String getIdentification() {
        if (this.isArrayType()) {
            return this.componentType.getName() + "Array";
        }
        return this.getTypeBound().getName();
    }

    public Type getTypeBound() {
        if (this.boundingBase != null) {
            return this.boundingBase;
        }
        this.boundingBase = this.typeFactory.getType(this.typeFactory.getTypeBound(this.getTypeMirror()));
        return this.boundingBase;
    }
}

