/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.processor.DefaultVersionInformation;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.version.VersionInformation;

public class DefaultModelElementProcessorContext
implements ModelElementProcessor.ProcessorContext {
    private final ProcessingEnvironment processingEnvironment;
    private final DelegatingMessager messager;
    private final Options options;
    private final TypeFactory typeFactory;
    private final VersionInformation versionInformation;

    public DefaultModelElementProcessorContext(ProcessingEnvironment processingEnvironment, Options options) {
        this.processingEnvironment = processingEnvironment;
        this.messager = new DelegatingMessager(processingEnvironment.getMessager());
        this.typeFactory = new TypeFactory(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils());
        this.options = options;
        this.versionInformation = DefaultVersionInformation.fromProcessingEnvironment(processingEnvironment);
    }

    @Override
    public Filer getFiler() {
        return this.processingEnvironment.getFiler();
    }

    @Override
    public Types getTypeUtils() {
        return this.processingEnvironment.getTypeUtils();
    }

    @Override
    public Elements getElementUtils() {
        return this.processingEnvironment.getElementUtils();
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public FormattingMessager getMessager() {
        return this.messager;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public VersionInformation getVersionInformation() {
        return this.versionInformation;
    }

    @Override
    public boolean isErroneous() {
        return this.messager.isErroneous();
    }

    private static class DelegatingMessager
    implements FormattingMessager {
        private final Messager delegate;
        private boolean isErroneous = false;

        public DelegatingMessager(Messager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void printMessage(Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, AnnotationMirror a, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e, a);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, AnnotationMirror a, AnnotationValue v, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e, a, v);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        public boolean isErroneous() {
            return this.isErroneous;
        }
    }
}

