/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.AnnotationMapperReference;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.OptionsHelper;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.MapperConfiguration;

public abstract class AnnotationBasedComponentModelProcessor
implements ModelElementProcessor<Mapper, Mapper> {
    private TypeFactory typeFactory;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        this.typeFactory = context.getTypeFactory();
        String componentModel = MapperConfiguration.getInstanceOn(mapperTypeElement).componentModel();
        String effectiveComponentModel = OptionsHelper.getEffectiveComponentModel(context.getOptions(), componentModel);
        if (!this.getComponentModelIdentifier().equalsIgnoreCase(effectiveComponentModel)) {
            return mapper;
        }
        for (Annotation typeAnnotation : this.getTypeAnnotations(mapper)) {
            mapper.addAnnotation(typeAnnotation);
        }
        if (!this.requiresGenerationOfDecoratorClass()) {
            mapper.removeDecorator();
        } else if (mapper.getDecorator() != null) {
            this.adjustDecorator(mapper);
        }
        List<Annotation> annotations = this.getMapperReferenceAnnotations();
        ListIterator<MapperReference> iterator = mapper.getReferencedMappers().listIterator();
        while (iterator.hasNext()) {
            MapperReference reference = iterator.next();
            iterator.remove();
            iterator.add(this.replacementMapperReference(reference, annotations));
        }
        return mapper;
    }

    protected void adjustDecorator(Mapper mapper) {
        Decorator decorator = mapper.getDecorator();
        for (Annotation typeAnnotation : this.getDecoratorAnnotations()) {
            decorator.addAnnotation(typeAnnotation);
        }
        decorator.removeConstructor();
        List<Annotation> annotations = this.getDelegatorReferenceAnnotations(mapper);
        ArrayList<MapperReference> replacement = new ArrayList<MapperReference>();
        if (!decorator.getMethods().isEmpty()) {
            for (Field field : decorator.getFields()) {
                replacement.add(this.replacementMapperReference(field, annotations));
            }
        }
        decorator.setFields(replacement);
    }

    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Collections.emptyList();
    }

    protected MapperReference replacementMapperReference(Field originalReference, List<Annotation> annotations) {
        return new AnnotationMapperReference(originalReference.getType(), originalReference.getVariableName(), annotations, originalReference.isUsed());
    }

    protected abstract String getComponentModelIdentifier();

    protected abstract List<Annotation> getTypeAnnotations(Mapper var1);

    protected List<Annotation> getDecoratorAnnotations() {
        return Collections.emptyList();
    }

    protected abstract List<Annotation> getMapperReferenceAnnotations();

    protected abstract boolean requiresGenerationOfDecoratorClass();

    @Override
    public int getPriority() {
        return 1100;
    }

    protected TypeFactory getTypeFactory() {
        return this.typeFactory;
    }
}

