/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Generated;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Constructor;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.version.VersionInformation;

public abstract class GeneratedType
extends ModelElement {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private final String packageName;
    private final String name;
    private final String superClassName;
    private final String interfacePackage;
    private final String interfaceName;
    private final List<Annotation> annotations;
    private final List<MappingMethod> methods;
    private final SortedSet<Type> extraImportedTypes;
    private final boolean suppressGeneratorTimestamp;
    private final boolean suppressGeneratorVersionComment;
    private final VersionInformation versionInformation;
    private final Accessibility accessibility;
    private List<? extends Field> fields;
    private Constructor constructor;
    private final Type generatedType;

    protected GeneratedType(TypeFactory typeFactory, String packageName, String name, String superClassName, String interfacePackage, String interfaceName, List<MappingMethod> methods, List<? extends Field> fields, Options options, VersionInformation versionInformation, Accessibility accessibility, SortedSet<Type> extraImportedTypes, Constructor constructor) {
        this.packageName = packageName;
        this.name = name;
        this.superClassName = superClassName;
        this.interfacePackage = interfacePackage;
        this.interfaceName = interfaceName;
        this.extraImportedTypes = extraImportedTypes;
        this.annotations = new ArrayList<Annotation>();
        this.methods = methods;
        this.fields = fields;
        this.suppressGeneratorTimestamp = options.isSuppressGeneratorTimestamp();
        this.suppressGeneratorVersionComment = options.isSuppressGeneratorVersionComment();
        this.versionInformation = versionInformation;
        this.accessibility = accessibility;
        this.generatedType = typeFactory.getType(Generated.class);
        this.constructor = constructor;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getInterfacePackage() {
        return this.interfacePackage;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public List<MappingMethod> getMethods() {
        return this.methods;
    }

    public List<? extends Field> getFields() {
        return this.fields;
    }

    public void setFields(List<? extends Field> fields) {
        this.fields = fields;
    }

    public boolean isSuppressGeneratorTimestamp() {
        return this.suppressGeneratorTimestamp;
    }

    public boolean isSuppressGeneratorVersionComment() {
        return this.suppressGeneratorVersionComment;
    }

    public VersionInformation getVersionInformation() {
        return this.versionInformation;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public SortedSet<Type> getImportTypes() {
        TreeSet<Type> importedTypes = new TreeSet<Type>();
        importedTypes.add(this.generatedType);
        for (MappingMethod mappingMethod : this.methods) {
            for (Type type : mappingMethod.getImportTypes()) {
                this.addWithDependents(importedTypes, type);
            }
        }
        for (Field field : this.fields) {
            if (!field.isTypeRequiresImport()) continue;
            for (Type type : field.getImportTypes()) {
                this.addWithDependents(importedTypes, type);
            }
        }
        for (Annotation annotation : this.annotations) {
            this.addWithDependents(importedTypes, annotation.getType());
        }
        for (Type type : this.extraImportedTypes) {
            this.addWithDependents(importedTypes, type);
        }
        return importedTypes;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void removeConstructor() {
        this.constructor = null;
    }

    protected void addWithDependents(Collection<Type> collection, Type typeToAdd) {
        if (typeToAdd == null) {
            return;
        }
        if (this.needsImportDeclaration(typeToAdd)) {
            if (typeToAdd.isArrayType()) {
                collection.add(typeToAdd.getComponentType());
            } else {
                collection.add(typeToAdd);
            }
        }
        for (Type type : typeToAdd.getTypeParameters()) {
            this.addWithDependents(collection, type);
        }
    }

    private boolean needsImportDeclaration(Type typeToAdd) {
        if (!typeToAdd.isImported()) {
            return false;
        }
        if (typeToAdd.getPackageName() == null) {
            return false;
        }
        if (typeToAdd.getPackageName().startsWith(JAVA_LANG_PACKAGE)) {
            return false;
        }
        return !typeToAdd.getPackageName().equals(this.packageName) || typeToAdd.getTypeElement().getNestingKind().isNested();
    }
}

