/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.LifecycleCallbackFactory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.assignment.LocalVarWrapper;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class MapMappingMethod
extends MappingMethod {
    private final Assignment keyAssignment;
    private final Assignment valueAssignment;
    private final MethodReference factoryMethod;
    private final boolean overridden;
    private final boolean mapNullToDefault;

    private MapMappingMethod(Method method, Assignment keyAssignment, Assignment valueAssignment, MethodReference factoryMethod, boolean mapNullToDefault, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        super(method, beforeMappingReferences, afterMappingReferences);
        this.keyAssignment = keyAssignment;
        this.valueAssignment = valueAssignment;
        this.factoryMethod = factoryMethod;
        this.overridden = method.overridesMethod();
        this.mapNullToDefault = mapNullToDefault;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public Assignment getKeyAssignment() {
        return this.keyAssignment;
    }

    public Assignment getValueAssignment() {
        return this.valueAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.keyAssignment != null) {
            types.addAll(this.keyAssignment.getImportTypes());
        }
        if (this.valueAssignment != null) {
            types.addAll(this.valueAssignment.getImportTypes());
        }
        if (this.factoryMethod == null && !this.isExistingInstanceMapping()) {
            types.addAll(this.getReturnType().getImportTypes());
            if (this.getReturnType().getImplementationType() != null) {
                types.addAll(this.getReturnType().getImplementationType().getImportTypes());
            }
        }
        return types;
    }

    public String getKeyVariableName() {
        return Strings.getSaveVariableName("key", this.getParameterNames());
    }

    public String getValueVariableName() {
        return Strings.getSaveVariableName("value", this.getParameterNames());
    }

    public String getEntryVariableName() {
        return Strings.getSaveVariableName("entry", this.getParameterNames());
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getResultType() == null ? 0 : this.getResultType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapMappingMethod other = (MapMappingMethod)obj;
        if (!this.getResultType().equals(other.getResultType())) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().getTypeParameters().get(0).equals(other.getSourceParameters().get(i).getType().getTypeParameters().get(0))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String keyDateFormat;
        private String valueDateFormat;
        private List<TypeMirror> keyQualifiers;
        private List<TypeMirror> valueQualifiers;
        private TypeMirror keyQualifyingTargetType;
        private TypeMirror valueQualifyingTargetType;
        private Method method;
        private MappingBuilderContext ctx;
        private NullValueMappingStrategyPrism nullValueMappingStrategy;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder keyDateFormat(String keyDateFormat) {
            this.keyDateFormat = keyDateFormat;
            return this;
        }

        public Builder valueDateFormat(String valueDateFormat) {
            this.valueDateFormat = valueDateFormat;
            return this;
        }

        public Builder keyQualifiers(List<TypeMirror> keyQualifiers) {
            this.keyQualifiers = keyQualifiers;
            return this;
        }

        public Builder valueQualifiers(List<TypeMirror> valueQualifiers) {
            this.valueQualifiers = valueQualifiers;
            return this;
        }

        public Builder keyQualifyingTargetType(TypeMirror keyQualifyingTargetType) {
            this.keyQualifyingTargetType = keyQualifyingTargetType;
            return this;
        }

        public Builder valueQualifyingTargetType(TypeMirror valueQualifyingTargetType) {
            this.valueQualifyingTargetType = valueQualifyingTargetType;
            return this;
        }

        public Builder nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        public MapMappingMethod build() {
            List<Type> sourceTypeParams = Collections.first(this.method.getSourceParameters()).getType().getTypeParameters();
            List<Type> resultTypeParams = this.method.getResultType().getTypeParameters();
            Type keySourceType = sourceTypeParams.get(0).getTypeBound();
            Type keyTargetType = resultTypeParams.get(0).getTypeBound();
            Assignment keyAssignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, "map key", keySourceType, keyTargetType, null, this.keyDateFormat, this.keyQualifiers, this.keyQualifyingTargetType, "entry.getKey()", false);
            if (keyAssignment == null) {
                if (this.method instanceof ForgedMethod) {
                    return null;
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.MAPMAPPING_KEY_MAPPING_NOT_FOUND, new Object[0]);
            }
            Type valueSourceType = sourceTypeParams.get(1).getTypeBound();
            Type valueTargetType = resultTypeParams.get(1).getTypeBound();
            Assignment valueAssignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, "map value", valueSourceType, valueTargetType, null, this.valueDateFormat, this.valueQualifiers, this.valueQualifyingTargetType, "entry.getValue()", false);
            if (this.method instanceof ForgedMethod) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (keyAssignment != null) {
                    forgedMethod.addThrownTypes(keyAssignment.getThrownTypes());
                }
                if (valueAssignment != null) {
                    forgedMethod.addThrownTypes(valueAssignment.getThrownTypes());
                }
            }
            if (valueAssignment == null) {
                if (this.method instanceof ForgedMethod) {
                    return null;
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.MAPMAPPING_VALUE_MAPPING_NOT_FOUND, new Object[0]);
            }
            boolean mapNullToDefault = false;
            if (this.method.getMapperConfiguration() != null) {
                mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
            }
            MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, this.method.getResultType(), null, null);
            keyAssignment = new LocalVarWrapper(keyAssignment, this.method.getThrownTypes());
            valueAssignment = new LocalVarWrapper(valueAssignment, this.method.getThrownTypes());
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleCallbackFactory.beforeMappingMethods(this.method, null, this.ctx);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleCallbackFactory.afterMappingMethods(this.method, null, this.ctx);
            return new MapMappingMethod(this.method, keyAssignment, valueAssignment, factoryMethod, mapNullToDefault, beforeMappingMethods, afterMappingMethods);
        }
    }
}

