/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.prism.BeanMappingPrism;
import org.mapstruct.ap.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.util.FormattingMessager;
import org.mapstruct.ap.util.Message;

public class BeanMapping {
    private final List<TypeMirror> qualifiers;
    private final TypeMirror resultType;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;

    public static BeanMapping fromPrism(BeanMappingPrism beanMapping, ExecutableElement method, FormattingMessager messager) {
        if (beanMapping == null) {
            return null;
        }
        boolean resultTypeIsDefined = !TypeKind.VOID.equals((Object)beanMapping.resultType().getKind());
        NullValueMappingStrategyPrism nullValueMappingStrategy = NullValueMappingStrategyPrism.valueOf(beanMapping.nullValueMappingStrategy());
        if (!resultTypeIsDefined && beanMapping.qualifiedBy().isEmpty() && nullValueMappingStrategy == NullValueMappingStrategyPrism.DEFAULT) {
            messager.printMessage((Element)method, Message.BEANMAPPING_NO_ELEMENTS, new Object[0]);
        }
        return new BeanMapping(beanMapping.qualifiedBy(), resultTypeIsDefined ? beanMapping.resultType() : null, nullValueMappingStrategy);
    }

    private BeanMapping(List<TypeMirror> qualifiers, TypeMirror mirror, NullValueMappingStrategyPrism nvms) {
        this.qualifiers = qualifiers;
        this.resultType = mirror;
        this.nullValueMappingStrategy = nvms;
    }

    public List<TypeMirror> getQualifiers() {
        return this.qualifiers;
    }

    public TypeMirror getResultType() {
        return this.resultType;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }
}

