/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.Conversion;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.util.NativeTypes;

public class WrapperToWrapperConversion
implements Conversion {
    private final Class<?> sourceType;
    private final Class<?> targetType;

    public WrapperToWrapperConversion(Class<?> sourceType, Class<?> targetType) {
        if (sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no wrapper type.");
        }
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no wrapper type.");
        }
        this.sourceType = NativeTypes.getPrimitiveType(sourceType);
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String to(String sourcePropertyAccessor, Type type) {
        if (this.sourceType == this.targetType) {
            return sourcePropertyAccessor;
        }
        return sourcePropertyAccessor + "." + this.targetType.getName() + "Value()";
    }

    @Override
    public String from(String targetPropertyAccessor, Type type) {
        if (this.sourceType == this.targetType) {
            return targetPropertyAccessor;
        }
        return targetPropertyAccessor + "." + this.sourceType.getName() + "Value()";
    }
}

