/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.conversion.CharToStringConversion;
import org.mapstruct.ap.conversion.CharWrapperToStringConversion;
import org.mapstruct.ap.conversion.Conversion;
import org.mapstruct.ap.conversion.EnumStringConversion;
import org.mapstruct.ap.conversion.PrimitiveToPrimitiveConversion;
import org.mapstruct.ap.conversion.PrimitiveToStringConversion;
import org.mapstruct.ap.conversion.PrimitiveToWrapperConversion;
import org.mapstruct.ap.conversion.ReverseConversion;
import org.mapstruct.ap.conversion.WrapperToStringConversion;
import org.mapstruct.ap.conversion.WrapperToWrapperConversion;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.util.TypeUtil;

public class Conversions {
    private TypeUtil typeUtil;
    private final Map<Key, Conversion> conversions = new HashMap<Key, Conversion>();
    private final DeclaredType enumType;
    private final DeclaredType stringType;

    public Conversions(Elements elementUtils, Types typeUtils, TypeUtil typeUtil) {
        this.typeUtil = typeUtil;
        this.enumType = typeUtils.getDeclaredType(elementUtils.getTypeElement(Enum.class.getCanonicalName()), new TypeMirror[0]);
        this.stringType = typeUtils.getDeclaredType(elementUtils.getTypeElement(String.class.getCanonicalName()), new TypeMirror[0]);
        this.registerNativeTypeConversion(Byte.TYPE, Byte.class);
        this.registerNativeTypeConversion(Byte.TYPE, Short.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Short.class);
        this.registerNativeTypeConversion(Byte.TYPE, Integer.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Integer.class);
        this.registerNativeTypeConversion(Byte.TYPE, Long.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Long.class);
        this.registerNativeTypeConversion(Byte.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Float.class);
        this.registerNativeTypeConversion(Byte.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Double.class);
        this.registerNativeTypeConversion(Byte.class, Short.TYPE);
        this.registerNativeTypeConversion(Byte.class, Short.class);
        this.registerNativeTypeConversion(Byte.class, Integer.TYPE);
        this.registerNativeTypeConversion(Byte.class, Integer.class);
        this.registerNativeTypeConversion(Byte.class, Long.TYPE);
        this.registerNativeTypeConversion(Byte.class, Long.class);
        this.registerNativeTypeConversion(Byte.class, Float.TYPE);
        this.registerNativeTypeConversion(Byte.class, Float.class);
        this.registerNativeTypeConversion(Byte.class, Double.TYPE);
        this.registerNativeTypeConversion(Byte.class, Double.class);
        this.registerNativeTypeConversion(Short.TYPE, Short.class);
        this.registerNativeTypeConversion(Short.TYPE, Integer.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Integer.class);
        this.registerNativeTypeConversion(Short.TYPE, Long.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Long.class);
        this.registerNativeTypeConversion(Short.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Float.class);
        this.registerNativeTypeConversion(Short.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Double.class);
        this.registerNativeTypeConversion(Short.class, Integer.TYPE);
        this.registerNativeTypeConversion(Short.class, Integer.class);
        this.registerNativeTypeConversion(Short.class, Long.TYPE);
        this.registerNativeTypeConversion(Short.class, Long.class);
        this.registerNativeTypeConversion(Short.class, Float.TYPE);
        this.registerNativeTypeConversion(Short.class, Float.class);
        this.registerNativeTypeConversion(Short.class, Double.TYPE);
        this.registerNativeTypeConversion(Short.class, Double.class);
        this.registerNativeTypeConversion(Integer.TYPE, Integer.class);
        this.registerNativeTypeConversion(Integer.TYPE, Long.TYPE);
        this.registerNativeTypeConversion(Integer.TYPE, Long.class);
        this.registerNativeTypeConversion(Integer.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Integer.TYPE, Float.class);
        this.registerNativeTypeConversion(Integer.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Integer.TYPE, Double.class);
        this.registerNativeTypeConversion(Integer.class, Long.TYPE);
        this.registerNativeTypeConversion(Integer.class, Long.class);
        this.registerNativeTypeConversion(Integer.class, Float.TYPE);
        this.registerNativeTypeConversion(Integer.class, Float.class);
        this.registerNativeTypeConversion(Integer.class, Double.TYPE);
        this.registerNativeTypeConversion(Integer.class, Double.class);
        this.registerNativeTypeConversion(Long.TYPE, Long.class);
        this.registerNativeTypeConversion(Long.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Long.TYPE, Float.class);
        this.registerNativeTypeConversion(Long.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Long.TYPE, Double.class);
        this.registerNativeTypeConversion(Long.class, Float.TYPE);
        this.registerNativeTypeConversion(Long.class, Float.class);
        this.registerNativeTypeConversion(Long.class, Double.TYPE);
        this.registerNativeTypeConversion(Long.class, Double.class);
        this.registerNativeTypeConversion(Float.TYPE, Float.class);
        this.registerNativeTypeConversion(Float.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Float.TYPE, Double.class);
        this.registerNativeTypeConversion(Float.class, Double.TYPE);
        this.registerNativeTypeConversion(Float.class, Double.class);
        this.registerNativeTypeConversion(Double.TYPE, Double.class);
        this.registerNativeTypeConversion(Boolean.TYPE, Boolean.class);
        this.registerNativeTypeConversion(Character.TYPE, Character.class);
        this.registerToStringConversion(Byte.TYPE);
        this.registerToStringConversion(Byte.class);
        this.registerToStringConversion(Short.TYPE);
        this.registerToStringConversion(Short.class);
        this.registerToStringConversion(Integer.TYPE);
        this.registerToStringConversion(Integer.class);
        this.registerToStringConversion(Long.TYPE);
        this.registerToStringConversion(Long.class);
        this.registerToStringConversion(Float.TYPE);
        this.registerToStringConversion(Float.class);
        this.registerToStringConversion(Double.TYPE);
        this.registerToStringConversion(Double.class);
        this.registerToStringConversion(Boolean.TYPE);
        this.registerToStringConversion(Boolean.class);
        this.register(Character.TYPE, String.class, new CharToStringConversion());
        this.register(Character.class, String.class, new CharWrapperToStringConversion());
        this.register(Enum.class, String.class, new EnumStringConversion());
    }

    private void registerNativeTypeConversion(Class<?> sourceType, Class<?> targetType) {
        if (sourceType.isPrimitive() && targetType.isPrimitive()) {
            this.register(sourceType, targetType, new PrimitiveToPrimitiveConversion(sourceType));
        } else if (sourceType.isPrimitive() && !targetType.isPrimitive()) {
            this.register(sourceType, targetType, new PrimitiveToWrapperConversion(sourceType, targetType));
        } else if (!sourceType.isPrimitive() && targetType.isPrimitive()) {
            this.register(sourceType, targetType, ReverseConversion.reverse(new PrimitiveToWrapperConversion(targetType, sourceType)));
        } else {
            this.register(sourceType, targetType, new WrapperToWrapperConversion(sourceType, targetType));
        }
    }

    private void registerToStringConversion(Class<?> sourceType) {
        if (sourceType.isPrimitive()) {
            this.register(sourceType, String.class, new PrimitiveToStringConversion(sourceType));
        } else {
            this.register(sourceType, String.class, new WrapperToStringConversion(sourceType));
        }
    }

    private void register(Class<?> sourceType, Class<?> targetType, Conversion conversion) {
        this.conversions.put(Key.forClasses(sourceType, targetType), conversion);
        this.conversions.put(Key.forClasses(targetType, sourceType), ReverseConversion.reverse(conversion));
    }

    public Conversion getConversion(Type sourceType, Type targetType) {
        if (sourceType.isEnumType() && targetType.equals(this.typeUtil.getType(this.stringType))) {
            sourceType = this.typeUtil.getType(this.enumType);
        } else if (targetType.isEnumType() && sourceType.equals(this.typeUtil.getType(this.stringType))) {
            targetType = this.typeUtil.getType(this.enumType);
        }
        return this.conversions.get(new Key(sourceType, targetType));
    }

    private static class Key {
        private final Type sourceType;
        private final Type targetType;

        private static Key forClasses(Class<?> sourceType, Class<?> targetType) {
            return new Key(Type.forClass(sourceType), Type.forClass(targetType));
        }

        private Key(Type sourceType, Type targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public String toString() {
            return "Key [sourceType=" + this.sourceType + ", targetType=" + this.targetType + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
            result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.sourceType == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType)) {
                return false;
            }
            return !(this.targetType == null ? other.targetType != null : !this.targetType.equals(other.targetType));
        }
    }
}

