/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import org.mapdb.elsa.ElsaSerializerPojo;

public class ElsaObjectInputStream
extends InputStream
implements ObjectInput {
    protected final DataInput input;
    protected ElsaSerializerPojo serializer;

    public ElsaObjectInputStream(InputStream stream) throws IOException {
        this(new DataInputStream(stream), new ElsaSerializerPojo());
    }

    public ElsaObjectInputStream(DataInput input, ElsaSerializerPojo serializer) throws IOException {
        this.input = input;
        this.serializer = serializer;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.serializer.deserialize(this.input);
    }

    @Override
    public int read() throws IOException {
        return this.input.readUnsignedByte();
    }

    @Override
    public void close() throws IOException {
        if (this.input instanceof Closeable) {
            ((Closeable)((Object)this.input)).close();
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.input.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.input.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.input.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.input.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.input.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.input.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.input.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.input.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.input.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.input.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.input.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.input.readUTF();
    }
}

