/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapdb.elsa.ElsaClassCallback;
import org.mapdb.elsa.ElsaClassInfoResolver;
import org.mapdb.elsa.ElsaSerializerBase;
import org.mapdb.elsa.ElsaSerializerPojo;

public final class ElsaMaker {
    protected ClassLoader classLoader = null;
    protected Object[] singletons = null;
    protected List<Class> classes = new ArrayList<Class>();
    protected ElsaClassCallback unknownClassNotification = null;
    protected Map<Class, ElsaSerializerBase.Serializer> registeredSers = new HashMap<Class, ElsaSerializerBase.Serializer>();
    protected Map<Class, Integer> registeredSerHeaders = new HashMap<Class, Integer>();
    protected Map<Integer, ElsaSerializerBase.Deserializer> registeredDeser = new HashMap<Integer, ElsaSerializerBase.Deserializer>();
    protected int objectStack = 0;

    public ElsaMaker singletons(Object ... singletons) {
        this.singletons = singletons;
        return this;
    }

    public ElsaSerializerPojo make() {
        return new ElsaSerializerPojo(this.classLoader, this.objectStack, this.singletons, this.registeredSers, this.registeredSerHeaders, this.registeredDeser, this.unknownClassNotification, new ElsaClassInfoResolver.ArrayBased(this.classes.toArray(new Class[0]), this.classLoader));
    }

    public ElsaMaker registerClasses(Class ... classes) {
        for (Class clazz : classes) {
            this.classes.add(clazz);
        }
        return this;
    }

    public ElsaMaker unknownClassNotification(ElsaClassCallback callback) {
        this.unknownClassNotification = callback;
        return this;
    }

    public <E> ElsaMaker registerSerializer(int header, Class<E> clazz, ElsaSerializerBase.Serializer<E> serializer) {
        if (this.registeredSers.containsKey(clazz)) {
            throw new IllegalArgumentException("Class already has Serializer registered: " + clazz);
        }
        this.registeredSers.put(clazz, serializer);
        this.registeredSerHeaders.put(clazz, header);
        return this;
    }

    public ElsaMaker registerDeserializer(int header, ElsaSerializerBase.Deserializer deser) {
        if (this.registeredDeser.get(header) != null) {
            throw new IllegalArgumentException("Deserializer for header is already registered: " + header);
        }
        this.registeredDeser.put(header, deser);
        return this;
    }

    public ElsaMaker referenceDisable() {
        this.objectStack = 1;
        return this;
    }

    public ElsaMaker referenceArrayEnable() {
        this.objectStack = 2;
        return this;
    }

    public ElsaMaker referenceHashMapEnable() {
        this.objectStack = 3;
        return this;
    }

    public ElsaMaker classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }
}

