/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.mapdb.elsa.ElsaSerializerPojo;

public class ElsaObjectOutputStream
extends OutputStream
implements ObjectOutput {
    protected final DataOutput out;
    protected final ElsaSerializerPojo serializer;

    public ElsaObjectOutputStream(DataOutput out, ElsaSerializerPojo serializer) throws IOException {
        this.out = out;
        this.serializer = serializer;
    }

    public ElsaObjectOutputStream(OutputStream out) throws IOException {
        this(new DataOutputStream(out), new ElsaSerializerPojo());
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.serializer.serialize(this.out, obj);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }
}

