/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.mapdb.elsa.SerializerPojo;

public abstract class ElsaStack {
    private SerializerPojo.ClassInfo[] classInfos = null;

    public abstract void add(Object var1);

    public abstract int identityIndexOf(Object var1);

    public abstract int getSize();

    public abstract Object getInstance(int var1);

    public int resolveClassId(String clazzName) {
        if (this.classInfos == null) {
            return -1;
        }
        for (int i = 0; i < this.classInfos.length; ++i) {
            if (!this.classInfos[i].name.equals(clazzName)) continue;
            return i;
        }
        return -1;
    }

    public int addClassInfo(SerializerPojo.ClassInfo clazzInfo) {
        if (this.classInfos == null) {
            this.classInfos = new SerializerPojo.ClassInfo[0];
        }
        int size = this.classInfos.length;
        this.classInfos = Arrays.copyOf(this.classInfos, size + 1);
        this.classInfos[size] = clazzInfo;
        return size;
    }

    public SerializerPojo.ClassInfo resolveClassInfo(int classId) {
        return this.classInfos[classId];
    }

    public static final class NoReferenceStack
    extends ElsaStack {
        @Override
        public void add(Object o) {
        }

        @Override
        public int identityIndexOf(Object obj) {
            return -1;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Object getInstance(int i) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class IdentityHashMapStack
    extends ElsaStack {
        private Map<Object, Integer> data = new IdentityHashMap<Object, Integer>();
        private List<Object> reverse = new ArrayList<Object>();

        @Override
        public void add(Object o) {
            int size = this.data.size();
            this.data.put(o, size);
            this.reverse.add(o);
        }

        @Override
        public int identityIndexOf(Object obj) {
            Integer ret = this.data.get(obj);
            return ret == null ? -1 : ret;
        }

        @Override
        public int getSize() {
            return this.reverse.size();
        }

        @Override
        public Object getInstance(int i) {
            return this.reverse.get(i);
        }
    }

    public static final class IdentityArray
    extends ElsaStack {
        private int size = 0;
        private Object[] data = new Object[1];
        public boolean forwardRefs = false;

        @Override
        public void add(Object o) {
            if (this.data.length == this.size) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[this.size] = o;
            ++this.size;
        }

        @Override
        public int identityIndexOf(Object obj) {
            for (int i = 0; i < this.size; ++i) {
                if (obj != this.data[i]) continue;
                this.forwardRefs = true;
                return i;
            }
            return -1;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public Object getInstance(int i) {
            return this.data[i];
        }
    }
}

