/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapdb.elsa.ClassCallback;
import org.mapdb.elsa.ClassInfoResolver;
import org.mapdb.elsa.SerializerBase;
import org.mapdb.elsa.SerializerPojo;

public class ElsaMaker {
    protected Object[] singletons = null;
    protected List<Class> classes = new ArrayList<Class>();
    protected ClassCallback unknownClassNotification = null;
    protected Map<Class, SerializerBase.Ser> registeredSers = new HashMap<Class, SerializerBase.Ser>();
    protected Map<Class, Integer> registeredSerHeaders = new HashMap<Class, Integer>();
    protected Map<Integer, SerializerBase.Deser> registeredDeser = new HashMap<Integer, SerializerBase.Deser>();

    public ElsaMaker singletons(Object ... singletons) {
        this.singletons = singletons;
        return this;
    }

    public SerializerPojo make() {
        return new SerializerPojo(this.singletons, this.registeredSers, this.registeredSerHeaders, this.registeredDeser, this.unknownClassNotification, new ClassInfoResolver.ArrayBased(this.classes.toArray(new Class[0])));
    }

    public ElsaMaker registerClasses(Class ... classes) {
        for (Class clazz : classes) {
            this.classes.add(clazz);
        }
        return this;
    }

    public ElsaMaker unknownClassNotification(ClassCallback callback) {
        this.unknownClassNotification = callback;
        return this;
    }

    public <E> ElsaMaker registerSer(int header, Class<E> clazz, SerializerBase.Ser<E> ser) {
        if (this.registeredSers.containsKey(clazz)) {
            throw new IllegalArgumentException("Class already has Ser registered: " + clazz);
        }
        this.registeredSers.put(clazz, ser);
        this.registeredSerHeaders.put(clazz, header);
        return this;
    }

    public ElsaMaker registerDeser(int header, SerializerBase.Deser deser) {
        if (this.registeredDeser.get(header) != null) {
            throw new IllegalArgumentException("Deser for header is already registered: " + header);
        }
        this.registeredDeser.put(header, deser);
        return this;
    }
}

