/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.mapdb.elsa.ElsaUtil;

public class SerializerBase {
    protected final Map<Class, Ser> ser = new IdentityHashMap<Class, Ser>();
    protected final Deser[] headerDeser = new Deser[255];
    protected static final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    protected static final Ser SER_STRING = new Ser<String>(){

        @Override
        public void serialize(DataOutput out, String value, FastArrayList objectStack) throws IOException {
            int len = value.length();
            if (len == 0) {
                out.write(125);
            } else {
                if (len <= 10) {
                    out.write(125 + len);
                } else {
                    out.write(136);
                    ElsaUtil.packInt(out, len);
                }
                for (int i = 0; i < len; ++i) {
                    ElsaUtil.packInt(out, value.charAt(i));
                }
            }
        }
    };
    protected static final Ser SER_LONG_ARRAY = new Ser<long[]>(){

        @Override
        public void serialize(DataOutput out, long[] val, FastArrayList objectStack) throws IOException {
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            for (long i : val) {
                max = Math.max(max, i);
                min = Math.min(min, i);
            }
            if (-128L <= min && max <= 127L) {
                out.write(120);
                ElsaUtil.packInt(out, val.length);
                for (long i : val) {
                    out.write((int)i);
                }
            } else if (-32768L <= min && max <= 32767L) {
                out.write(121);
                ElsaUtil.packInt(out, val.length);
                for (long i : val) {
                    out.writeShort((int)i);
                }
            } else if (0L <= min) {
                out.write(122);
                ElsaUtil.packInt(out, val.length);
                for (long l : val) {
                    ElsaUtil.packLong(out, l);
                }
            } else if (Integer.MIN_VALUE <= min && max <= Integer.MAX_VALUE) {
                out.write(123);
                ElsaUtil.packInt(out, val.length);
                for (long i : val) {
                    out.writeInt((int)i);
                }
            } else {
                out.write(124);
                ElsaUtil.packInt(out, val.length);
                for (long i : val) {
                    out.writeLong(i);
                }
            }
        }
    };
    protected static final Ser SER_INT_ARRAY = new Ser<int[]>(){

        @Override
        public void serialize(DataOutput out, int[] val, FastArrayList objectStack) throws IOException {
            int max = Integer.MIN_VALUE;
            int min = Integer.MAX_VALUE;
            for (int i : val) {
                max = Math.max(max, i);
                min = Math.min(min, i);
            }
            if (-128 <= min && max <= 127) {
                out.write(116);
                ElsaUtil.packInt(out, val.length);
                for (int i : val) {
                    out.write(i);
                }
            } else if (Short.MIN_VALUE <= min && max <= Short.MAX_VALUE) {
                out.write(117);
                ElsaUtil.packInt(out, val.length);
                for (int i : val) {
                    out.writeShort(i);
                }
            } else if (0 <= min) {
                out.write(118);
                ElsaUtil.packInt(out, val.length);
                for (int l : val) {
                    ElsaUtil.packInt(out, l);
                }
            } else {
                out.write(119);
                ElsaUtil.packInt(out, val.length);
                for (int i : val) {
                    out.writeInt(i);
                }
            }
        }
    };
    protected static final Ser SER_DOUBLE = new Ser<Double>(){

        @Override
        public void serialize(DataOutput out, Double value, FastArrayList objectStack) throws IOException {
            double v = value;
            if (v == -1.0) {
                out.write(102);
            } else if (v == 0.0) {
                out.write(103);
            } else if (v == 1.0) {
                out.write(104);
            } else if (v >= 0.0 && v <= 255.0 && (double)value.intValue() == v) {
                out.write(105);
                out.write(value.intValue());
            } else if ((double)value.shortValue() == v) {
                out.write(106);
                out.writeShort(value.shortValue());
            } else if ((double)value.intValue() == v) {
                out.write(107);
                out.writeInt(value.intValue());
            } else {
                out.write(108);
                out.writeDouble(v);
            }
        }
    };
    protected static final Ser SER_FLOAT = new Ser<Float>(){

        @Override
        public void serialize(DataOutput out, Float value, FastArrayList objectStack) throws IOException {
            float v = value.floatValue();
            if (v == -1.0f) {
                out.write(96);
            } else if (v == 0.0f) {
                out.write(97);
            } else if (v == 1.0f) {
                out.write(98);
            } else if (v >= 0.0f && v <= 255.0f && (float)value.intValue() == v) {
                out.write(99);
                out.write(value.intValue());
            } else if (v >= -32768.0f && v <= 32767.0f && (float)value.shortValue() == v) {
                out.write(100);
                out.writeShort(value.shortValue());
            } else {
                out.write(101);
                out.writeFloat(v);
            }
        }
    };
    protected static final Ser SER_SHORT = new Ser<Short>(){

        @Override
        public void serialize(DataOutput out, Short value, FastArrayList objectStack) throws IOException {
            short val = value;
            if (val == -1) {
                out.write(90);
            } else if (val == 0) {
                out.write(91);
            } else if (val == 1) {
                out.write(92);
            } else if (val > 0 && val < 255) {
                out.write(93);
                out.write(val);
            } else if (val < 0 && val > -255) {
                out.write(94);
                out.write(-val);
            } else {
                out.write(95);
                out.writeShort(val);
            }
        }
    };
    protected static final Ser SER_CHAR = new Ser<Character>(){

        @Override
        public void serialize(DataOutput out, Character value, FastArrayList objectStack) throws IOException {
            char val = value.charValue();
            if (val == '\u0000') {
                out.write(86);
            } else if (val == '\u0001') {
                out.write(87);
            } else if (val <= '\u00ff') {
                out.write(88);
                out.write(val);
            } else {
                out.write(89);
                out.writeChar(val);
            }
        }
    };
    protected static final Ser SER_BYTE = new Ser<Byte>(){

        @Override
        public void serialize(DataOutput out, Byte value, FastArrayList objectStack) throws IOException {
            byte val = value;
            if (val == -1) {
                out.write(82);
            } else if (val == 0) {
                out.write(83);
            } else if (val == 1) {
                out.write(84);
            } else {
                out.write(85);
                out.writeByte(val);
            }
        }
    };
    protected static final Ser SER_BOOLEAN = new Ser<Boolean>(){

        @Override
        public void serialize(DataOutput out, Boolean value, FastArrayList objectStack) throws IOException {
            out.write(value != false ? 2 : 3);
        }
    };
    protected static final Ser SER_LONG = new Ser<Long>(){

        @Override
        public void serialize(DataOutput out, Long value, FastArrayList objectStack) throws IOException {
            long val = value;
            if (val >= -9L && val <= 16L) {
                out.write((int)(39L + (val + 9L)));
                return;
            }
            if (val == Long.MIN_VALUE) {
                out.write(65);
                return;
            }
            if (val == Long.MAX_VALUE) {
                out.write(66);
                return;
            }
            if ((Math.abs(val) >>> 56 & 0xFFL) != 0L) {
                out.write(81);
                out.writeLong(val);
                return;
            }
            int neg = 0;
            if (val < 0L) {
                neg = -1;
                val = -val;
            }
            int size = 48;
            while ((val >> size & 0xFFL) == 0L) {
                size -= 8;
            }
            out.write(68 + size / 8 * 2 + neg);
            while (size >= 0) {
                out.write((int)(val >> size & 0xFFL));
                size -= 8;
            }
        }
    };
    protected static final Ser SER_INT = new Ser<Integer>(){

        @Override
        public void serialize(DataOutput out, Integer value, FastArrayList objectStack) throws IOException {
            int val = value;
            switch (val) {
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    out.write(4 + (val + 9));
                    return;
                }
                case -2147483648: {
                    out.write(30);
                    return;
                }
                case 0x7FFFFFFF: {
                    out.write(31);
                    return;
                }
            }
            if ((Math.abs(val) >>> 24 & 0xFF) != 0) {
                out.write(38);
                out.writeInt(val);
                return;
            }
            int neg = 0;
            if (val < 0) {
                neg = -1;
                val = -val;
            }
            int size = 24;
            while (((long)(val >> size) & 0xFFL) == 0L) {
                size -= 8;
            }
            out.write(33 + size / 8 * 2 + neg);
            while (size >= 0) {
                out.write((int)((long)(val >> size) & 0xFFL));
                size -= 8;
            }
        }
    };
    protected static final Ser<byte[]> SER_BYTE_ARRAY = new Ser<byte[]>(){

        @Override
        public void serialize(DataOutput out, byte[] b, FastArrayList objectStack) throws IOException {
            boolean allEqual = b.length > 0;
            for (int i = 1; i < b.length; ++i) {
                if (b[i - 1] == b[i]) continue;
                allEqual = false;
                break;
            }
            if (allEqual) {
                out.write(110);
                ElsaUtil.packInt(out, b.length);
                out.write(b[0]);
            } else {
                out.write(109);
                ElsaUtil.packInt(out, b.length);
                out.write(b);
            }
        }
    };
    protected static final Deser<byte[]> DESER_BYTE_ARRAY = new Deser(){

        public byte[] deserialize(DataInput in, FastArrayList objectStack) throws IOException {
            int size = ElsaUtil.unpackInt(in);
            byte[] ret = new byte[size];
            in.readFully(ret);
            return ret;
        }
    };
    protected final Map<Object, Integer> mapdb_all = new IdentityHashMap<Object, Integer>();
    protected final Map<Integer, Object> mapdb_reverse = new HashMap<Integer, Object>();

    protected static Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    protected static Class loadClass2(DataInput is) throws IOException {
        return SerializerBase.loadClass2(is.readUTF());
    }

    protected static Class loadClass2(String name) throws IOException {
        try {
            return SerializerBase.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected static Class loadClass3(String name) {
        try {
            return SerializerBase.loadClass2(name);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public SerializerBase() {
        this.initHeaderDeser();
        this.initSer();
        this.initMapdb();
    }

    protected void initSer() {
        this.ser.put(Integer.class, SER_INT);
        this.ser.put(Long.class, SER_LONG);
        this.ser.put(String.class, SER_STRING);
        this.ser.put(Boolean.class, SER_BOOLEAN);
        this.ser.put(String.class, SER_STRING);
        this.ser.put(Character.class, SER_CHAR);
        this.ser.put(Short.class, SER_SHORT);
        this.ser.put(Float.class, SER_FLOAT);
        this.ser.put(Double.class, SER_DOUBLE);
        this.ser.put(Byte.class, SER_BYTE);
        this.ser.put(byte[].class, SER_BYTE_ARRAY);
        this.ser.put(boolean[].class, new Ser<boolean[]>(){

            @Override
            public void serialize(DataOutput out, boolean[] value, FastArrayList objectStack) throws IOException {
                out.write(111);
                ElsaUtil.packInt(out, value.length);
                SerializerBase.writeBooleanArray(out, value);
            }
        });
        this.ser.put(char[].class, new Ser<char[]>(){

            @Override
            public void serialize(DataOutput out, char[] value, FastArrayList objectStack) throws IOException {
                out.write(113);
                ElsaUtil.packInt(out, value.length);
                for (char v : value) {
                    ElsaUtil.packInt(out, v);
                }
            }
        });
        this.ser.put(short[].class, new Ser<short[]>(){

            @Override
            public void serialize(DataOutput out, short[] value, FastArrayList objectStack) throws IOException {
                out.write(112);
                ElsaUtil.packInt(out, value.length);
                for (short v : value) {
                    out.writeShort(v);
                }
            }
        });
        this.ser.put(float[].class, new Ser<float[]>(){

            @Override
            public void serialize(DataOutput out, float[] value, FastArrayList objectStack) throws IOException {
                out.write(114);
                ElsaUtil.packInt(out, value.length);
                for (float v : value) {
                    out.writeFloat(v);
                }
            }
        });
        this.ser.put(double[].class, new Ser<double[]>(){

            @Override
            public void serialize(DataOutput out, double[] value, FastArrayList objectStack) throws IOException {
                out.write(115);
                ElsaUtil.packInt(out, value.length);
                for (double v : value) {
                    out.writeDouble(v);
                }
            }
        });
        this.ser.put(int[].class, SER_INT_ARRAY);
        this.ser.put(long[].class, SER_LONG_ARRAY);
        this.ser.put(BigInteger.class, new Ser<BigInteger>(){

            @Override
            public void serialize(DataOutput out, BigInteger value, FastArrayList objectStack) throws IOException {
                out.write(138);
                byte[] b = value.toByteArray();
                ElsaUtil.packInt(out, b.length);
                out.write(b);
            }
        });
        this.ser.put(BigDecimal.class, new Ser<BigDecimal>(){

            @Override
            public void serialize(DataOutput out, BigDecimal value, FastArrayList objectStack) throws IOException {
                out.write(137);
                byte[] b = value.unscaledValue().toByteArray();
                ElsaUtil.packInt(out, b.length);
                out.write(b);
                ElsaUtil.packInt(out, value.scale());
            }
        });
        this.ser.put(Class.class, new Ser<Class<?>>(){

            @Override
            public void serialize(DataOutput out, Class<?> value, FastArrayList objectStack) throws IOException {
                out.write(139);
                out.writeUTF(value.getName());
            }
        });
        this.ser.put(Date.class, new Ser<Date>(){

            @Override
            public void serialize(DataOutput out, Date value, FastArrayList objectStack) throws IOException {
                out.write(140);
                out.writeLong(value.getTime());
            }
        });
        this.ser.put(UUID.class, new Ser<UUID>(){

            @Override
            public void serialize(DataOutput out, UUID value, FastArrayList objectStack) throws IOException {
                out.write(141);
                out.writeLong(value.getMostSignificantBits());
                out.writeLong(value.getLeastSignificantBits());
            }
        });
        this.ser.put(Object[].class, new Ser<Object[]>(){

            @Override
            public void serialize(DataOutput out, Object[] b, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeObjectArray(out, b, objectStack);
            }
        });
        this.ser.put(ArrayList.class, new Ser<ArrayList>(){

            @Override
            public void serialize(DataOutput out, ArrayList value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeCollection(163, out, value, objectStack);
            }
        });
        this.ser.put(LinkedList.class, new Ser<Collection>(){

            @Override
            public void serialize(DataOutput out, Collection value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeCollection(170, out, value, objectStack);
            }
        });
        this.ser.put(HashSet.class, new Ser<Collection>(){

            @Override
            public void serialize(DataOutput out, Collection value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeCollection(168, out, value, objectStack);
            }
        });
        this.ser.put(LinkedHashSet.class, new Ser<Collection>(){

            @Override
            public void serialize(DataOutput out, Collection value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeCollection(169, out, value, objectStack);
            }
        });
        this.ser.put(HashMap.class, new Ser<Map>(){

            @Override
            public void serialize(DataOutput out, Map value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeMap(165, out, value, objectStack);
            }
        });
        this.ser.put(LinkedHashMap.class, new Ser<Map>(){

            @Override
            public void serialize(DataOutput out, Map value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeMap(166, out, value, objectStack);
            }
        });
        this.ser.put(Properties.class, new Ser<Map>(){

            @Override
            public void serialize(DataOutput out, Map value, FastArrayList objectStack) throws IOException {
                SerializerBase.this.serializeMap(171, out, value, objectStack);
            }
        });
        this.ser.put(TreeSet.class, new Ser<TreeSet>(){

            @Override
            public void serialize(DataOutput out, TreeSet l, FastArrayList objectStack) throws IOException {
                out.write(167);
                ElsaUtil.packInt(out, l.size());
                SerializerBase.this.serialize(out, l.comparator(), objectStack);
                for (Object o : l) {
                    SerializerBase.this.serialize(out, o, objectStack);
                }
            }
        });
        this.ser.put(TreeMap.class, new Ser<TreeMap<Object, Object>>(){

            @Override
            public void serialize(DataOutput out, TreeMap<Object, Object> l, FastArrayList objectStack) throws IOException {
                out.write(164);
                ElsaUtil.packInt(out, l.size());
                SerializerBase.this.serialize(out, l.comparator(), objectStack);
                for (Map.Entry<Object, Object> o : l.entrySet()) {
                    SerializerBase.this.serialize(out, o.getKey(), objectStack);
                    SerializerBase.this.serialize(out, o.getValue(), objectStack);
                }
            }
        });
    }

    public void serializeObjectArray(DataOutput out, Object[] b, FastArrayList objectStack) throws IOException {
        Class<?> componentType;
        boolean allNull = true;
        for (Object o : b) {
            if (o == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            out.write(161);
            ElsaUtil.packInt(out, b.length);
            componentType = b.getClass().getComponentType();
            this.serializeClass(out, componentType);
        } else {
            out.write(160);
            ElsaUtil.packInt(out, b.length);
            componentType = b.getClass().getComponentType();
            this.serializeClass(out, componentType);
            for (Object o : b) {
                this.serialize(out, o, objectStack);
            }
        }
    }

    protected void initHeaderDeser() {
        this.headerDeser[1] = new DeserSingleton(null);
        this.headerDeser[0] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                throw new IOError(new IOException("Zero Header, data corrupted"));
            }
        };
        this.headerDeser[172] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                throw new IOError(new IOException("Wrong header, data were probably serialized with java.lang.ObjectOutputStream, not with MapDB serialization"));
            }
        };
        this.headerDeser[3] = new DeserSingleton(Boolean.FALSE);
        this.headerDeser[2] = new DeserSingleton(Boolean.TRUE);
        this.headerDeser[4] = new DeserSingleton(-9);
        this.headerDeser[5] = new DeserSingleton(-8);
        this.headerDeser[6] = new DeserSingleton(-7);
        this.headerDeser[7] = new DeserSingleton(-6);
        this.headerDeser[8] = new DeserSingleton(-5);
        this.headerDeser[9] = new DeserSingleton(-4);
        this.headerDeser[10] = new DeserSingleton(-3);
        this.headerDeser[11] = new DeserSingleton(-2);
        this.headerDeser[12] = new DeserSingleton(-1);
        this.headerDeser[13] = new DeserSingleton(0);
        this.headerDeser[14] = new DeserSingleton(1);
        this.headerDeser[15] = new DeserSingleton(2);
        this.headerDeser[16] = new DeserSingleton(3);
        this.headerDeser[17] = new DeserSingleton(4);
        this.headerDeser[18] = new DeserSingleton(5);
        this.headerDeser[19] = new DeserSingleton(6);
        this.headerDeser[20] = new DeserSingleton(7);
        this.headerDeser[21] = new DeserSingleton(8);
        this.headerDeser[22] = new DeserSingleton(9);
        this.headerDeser[23] = new DeserSingleton(10);
        this.headerDeser[24] = new DeserSingleton(11);
        this.headerDeser[25] = new DeserSingleton(12);
        this.headerDeser[26] = new DeserSingleton(13);
        this.headerDeser[27] = new DeserSingleton(14);
        this.headerDeser[28] = new DeserSingleton(15);
        this.headerDeser[29] = new DeserSingleton(16);
        this.headerDeser[30] = new DeserSingleton(Integer.MIN_VALUE);
        this.headerDeser[31] = new DeserSingleton(Integer.MAX_VALUE);
        this.headerDeser[39] = new DeserSingleton(-9L);
        this.headerDeser[40] = new DeserSingleton(-8L);
        this.headerDeser[41] = new DeserSingleton(-7L);
        this.headerDeser[42] = new DeserSingleton(-6L);
        this.headerDeser[43] = new DeserSingleton(-5L);
        this.headerDeser[44] = new DeserSingleton(-4L);
        this.headerDeser[45] = new DeserSingleton(-3L);
        this.headerDeser[46] = new DeserSingleton(-2L);
        this.headerDeser[47] = new DeserSingleton(-1L);
        this.headerDeser[48] = new DeserSingleton(0L);
        this.headerDeser[49] = new DeserSingleton(1L);
        this.headerDeser[50] = new DeserSingleton(2L);
        this.headerDeser[51] = new DeserSingleton(3L);
        this.headerDeser[52] = new DeserSingleton(4L);
        this.headerDeser[53] = new DeserSingleton(5L);
        this.headerDeser[54] = new DeserSingleton(6L);
        this.headerDeser[55] = new DeserSingleton(7L);
        this.headerDeser[56] = new DeserSingleton(8L);
        this.headerDeser[57] = new DeserSingleton(9L);
        this.headerDeser[58] = new DeserSingleton(10L);
        this.headerDeser[59] = new DeserSingleton(11L);
        this.headerDeser[60] = new DeserSingleton(12L);
        this.headerDeser[61] = new DeserSingleton(13L);
        this.headerDeser[62] = new DeserSingleton(14L);
        this.headerDeser[63] = new DeserSingleton(15L);
        this.headerDeser[64] = new DeserSingleton(16L);
        this.headerDeser[65] = new DeserSingleton(Long.MIN_VALUE);
        this.headerDeser[66] = new DeserSingleton(Long.MAX_VALUE);
        this.headerDeser[86] = new DeserSingleton(Character.valueOf('\u0000'));
        this.headerDeser[87] = new DeserSingleton(Character.valueOf('\u0001'));
        this.headerDeser[90] = new DeserSingleton((short)-1);
        this.headerDeser[91] = new DeserSingleton((short)0);
        this.headerDeser[92] = new DeserSingleton((short)1);
        this.headerDeser[96] = new DeserSingleton(Float.valueOf(-1.0f));
        this.headerDeser[97] = new DeserSingleton(Float.valueOf(0.0f));
        this.headerDeser[98] = new DeserSingleton(Float.valueOf(1.0f));
        this.headerDeser[102] = new DeserSingleton(-1.0);
        this.headerDeser[103] = new DeserSingleton(0.0);
        this.headerDeser[104] = new DeserSingleton(1.0);
        this.headerDeser[82] = new DeserSingleton((byte)-1);
        this.headerDeser[83] = new DeserSingleton((byte)0);
        this.headerDeser[84] = new DeserSingleton((byte)1);
        this.headerDeser[125] = new DeserSingleton("");
        this.headerDeser[38] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return in.readInt();
            }
        };
        this.headerDeser[81] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return in.readLong();
            }
        };
        this.headerDeser[89] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return Character.valueOf(in.readChar());
            }
        };
        this.headerDeser[95] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return in.readShort();
            }
        };
        this.headerDeser[101] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return Float.valueOf(in.readFloat());
            }
        };
        this.headerDeser[108] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return in.readDouble();
            }
        };
        this.headerDeser[85] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return in.readByte();
            }
        };
        this.headerDeser[136] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.deserializeString(in, ElsaUtil.unpackInt(in));
            }
        };
        this.headerDeser[126] = new DeserStringLen(1);
        this.headerDeser[127] = new DeserStringLen(2);
        this.headerDeser[128] = new DeserStringLen(3);
        this.headerDeser[129] = new DeserStringLen(4);
        this.headerDeser[130] = new DeserStringLen(5);
        this.headerDeser[131] = new DeserStringLen(6);
        this.headerDeser[132] = new DeserStringLen(7);
        this.headerDeser[133] = new DeserStringLen(8);
        this.headerDeser[134] = new DeserStringLen(9);
        this.headerDeser[135] = new DeserStringLen(10);
        this.headerDeser[88] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return Character.valueOf((char)in.readUnsignedByte());
            }
        };
        this.headerDeser[93] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return (short)in.readUnsignedByte();
            }
        };
        this.headerDeser[94] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return (short)(-in.readUnsignedByte());
            }
        };
        this.headerDeser[99] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return Float.valueOf(in.readUnsignedByte());
            }
        };
        this.headerDeser[100] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return Float.valueOf(in.readShort());
            }
        };
        this.headerDeser[105] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return (double)in.readUnsignedByte();
            }
        };
        this.headerDeser[106] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return (double)in.readShort();
            }
        };
        this.headerDeser[107] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return (double)in.readInt();
            }
        };
        this.headerDeser[110] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                byte[] b = new byte[ElsaUtil.unpackInt(in)];
                Arrays.fill(b, in.readByte());
                return b;
            }
        };
        this.headerDeser[111] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                return SerializerBase.readBooleanArray(size, in);
            }
        };
        this.headerDeser[119] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                int[] ret = new int[size];
                for (int i = 0; i < size; ++i) {
                    ret[i] = in.readInt();
                }
                return ret;
            }
        };
        this.headerDeser[124] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                long[] ret = new long[size];
                for (int i = 0; i < size; ++i) {
                    ret[i] = in.readLong();
                }
                return ret;
            }
        };
        this.headerDeser[112] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                short[] ret = new short[size];
                for (int i = 0; i < size; ++i) {
                    ret[i] = in.readShort();
                }
                return ret;
            }
        };
        this.headerDeser[115] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                double[] ret = new double[size];
                for (int i = 0; i < size; ++i) {
                    ret[i] = in.readDouble();
                }
                return ret;
            }
        };
        this.headerDeser[114] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                float[] ret = new float[size];
                for (int i = 0; i < size; ++i) {
                    ret[i] = in.readFloat();
                }
                return ret;
            }
        };
        this.headerDeser[113] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                char[] ret = new char[size];
                for (int i = 0; i < size; ++i) {
                    ret[i] = (char)ElsaUtil.unpackInt(in);
                }
                return ret;
            }
        };
        this.headerDeser[109] = DESER_BYTE_ARRAY;
        this.headerDeser[116] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int[] ret = new int[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = in.readByte();
                }
                return ret;
            }
        };
        this.headerDeser[117] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int[] ret = new int[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = in.readShort();
                }
                return ret;
            }
        };
        this.headerDeser[118] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int[] ret = new int[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = ElsaUtil.unpackInt(in);
                }
                return ret;
            }
        };
        this.headerDeser[120] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                long[] ret = new long[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = in.readByte();
                }
                return ret;
            }
        };
        this.headerDeser[121] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                long[] ret = new long[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = in.readShort();
                }
                return ret;
            }
        };
        this.headerDeser[123] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                long[] ret = new long[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = in.readInt();
                }
                return ret;
            }
        };
        this.headerDeser[122] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                long[] ret = new long[ElsaUtil.unpackInt(in)];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = ElsaUtil.unpackLong(in);
                }
                return ret;
            }
        };
        this.headerDeser[138] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return new BigInteger(DESER_BYTE_ARRAY.deserialize(in, objectStack));
            }
        };
        this.headerDeser[137] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return new BigDecimal(new BigInteger(DESER_BYTE_ARRAY.deserialize(in, objectStack)), ElsaUtil.unpackInt(in));
            }
        };
        this.headerDeser[139] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                try {
                    return SerializerBase.loadClass(in.readUTF());
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
        };
        this.headerDeser[140] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return new Date(in.readLong());
            }
        };
        this.headerDeser[141] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return new UUID(in.readLong(), in.readLong());
            }
        };
        this.headerDeser[161] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                Class clazz = SerializerBase.loadClass2(in);
                return Array.newInstance(clazz, size);
            }
        };
        this.headerDeser[162] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                int size = ElsaUtil.unpackInt(in);
                Class clazz = SerializerBase.loadClass2(in);
                Object[] s = (Object[])Array.newInstance(clazz, size);
                for (int i = 0; i < size; ++i) {
                    s[i] = SerializerBase.this.deserialize(in, null);
                }
                return s;
            }
        };
        this.headerDeser[174] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return objectStack.data[ElsaUtil.unpackInt(in)];
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[163] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeArrayList(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[160] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeArrayObject(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[170] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeLinkedList(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[167] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeTreeSet(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[168] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeHashSet(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[169] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeLinkedHashSet(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[164] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeTreeMap(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[165] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeHashMap(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[166] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeLinkedHashMap(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[171] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeProperties(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[159] = new Deser(){

            public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
                return SerializerBase.this.deserializeSingleton(in, objectStack);
            }

            @Override
            public boolean needsObjectStack() {
                return true;
            }
        };
        this.headerDeser[36] = new DeserInt(3, true);
        this.headerDeser[37] = new DeserInt(3, false);
        this.headerDeser[34] = new DeserInt(2, true);
        this.headerDeser[35] = new DeserInt(2, false);
        this.headerDeser[32] = new DeserInt(1, true);
        this.headerDeser[33] = new DeserInt(1, false);
        this.headerDeser[79] = new DeserLong(7, true);
        this.headerDeser[80] = new DeserLong(7, false);
        this.headerDeser[77] = new DeserLong(6, true);
        this.headerDeser[78] = new DeserLong(6, false);
        this.headerDeser[75] = new DeserLong(5, true);
        this.headerDeser[76] = new DeserLong(5, false);
        this.headerDeser[73] = new DeserLong(4, true);
        this.headerDeser[74] = new DeserLong(4, false);
        this.headerDeser[71] = new DeserLong(3, true);
        this.headerDeser[72] = new DeserLong(3, false);
        this.headerDeser[69] = new DeserLong(2, true);
        this.headerDeser[70] = new DeserLong(2, false);
        this.headerDeser[67] = new DeserLong(1, true);
        this.headerDeser[68] = new DeserLong(1, false);
    }

    public void serialize(DataOutput out, Object obj) throws IOException {
        this.serialize(out, obj, new FastArrayList<Object>());
    }

    public void serialize(DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        if (obj == null) {
            out.write(1);
            return;
        }
        if (objectStack != null) {
            int indexInObjectStack = objectStack.identityIndexOf(obj);
            if (indexInObjectStack != -1) {
                out.write(174);
                ElsaUtil.packInt(out, indexInObjectStack);
                return;
            }
            objectStack.add(obj);
        }
        if (obj instanceof Object[]) {
            this.serializeObjectArray(out, (Object[])obj, objectStack);
            return;
        }
        Integer mapdbSingletonHeader = this.mapdb_all.get(obj);
        if (mapdbSingletonHeader != null) {
            out.write(159);
            ElsaUtil.packInt(out, mapdbSingletonHeader);
            return;
        }
        Ser s = this.ser.get(obj.getClass());
        if (s != null) {
            s.serialize(out, obj, objectStack);
            return;
        }
        this.serializeUnknownObject(out, obj, objectStack);
    }

    protected void serializeClass(DataOutput out, Class clazz) throws IOException {
        out.writeUTF(clazz.getName());
    }

    private void serializeMap(int header, DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Map l = (Map)obj;
        out.write(header);
        ElsaUtil.packInt(out, l.size());
        for (Map.Entry o : l.entrySet()) {
            this.serialize(out, o.getKey(), objectStack);
            this.serialize(out, o.getValue(), objectStack);
        }
    }

    private void serializeCollection(int header, DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        Collection l = (Collection)obj;
        out.write(header);
        ElsaUtil.packInt(out, l.size());
        for (Object o : l) {
            this.serialize(out, o, objectStack);
        }
    }

    static String deserializeString(DataInput buf, int len) throws IOException {
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (char)ElsaUtil.unpackInt(buf);
        }
        return new String(b);
    }

    public Object deserialize(DataInput in, int capacity) throws IOException {
        if (capacity == 0) {
            return null;
        }
        return this.deserialize(in, new FastArrayList<Object>());
    }

    public Object deserialize(DataInput in, FastArrayList<Object> objectStack) throws IOException {
        int head = in.readUnsignedByte();
        int oldObjectStackSize = objectStack.size;
        Object ret = null;
        Deser deser = this.headerDeser[head];
        ret = deser != null ? (Object)deser.deserialize(in, objectStack) : this.deserializeUnknownHeader(in, head, objectStack);
        if (head != 174 && ret != null && objectStack.size == oldObjectStackSize) {
            objectStack.add(ret);
        }
        return ret;
    }

    protected void initMapdb() {
    }

    private void mapdb_add(int header, Object singleton) {
        Integer old = this.mapdb_all.put(singleton, header);
        Object old2 = this.mapdb_reverse.put(header, singleton);
        if (old != null || old2 != null) {
            throw new AssertionError((Object)"singleton serializer conflict");
        }
    }

    public void assertSerializable(Object o) {
        if (o != null && !(o instanceof Serializable) && !this.mapdb_all.containsKey(o)) {
            throw new IllegalArgumentException("Not serializable: " + o.getClass());
        }
    }

    protected Object deserializeSingleton(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int head = ElsaUtil.unpackInt(is);
        Object singleton = this.mapdb_reverse.get(head);
        if (singleton == null) {
            throw new IOError(new IOException("Unknown header byte, data corrupted"));
        }
        if (singleton instanceof Deser) {
            singleton = ((Deser)singleton).deserialize(is, objectStack);
        }
        return singleton;
    }

    private Object[] deserializeArrayObject(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        Class clazz = SerializerBase.loadClass2(is);
        Object[] s = (Object[])Array.newInstance(clazz, size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s[i] = this.deserialize(is, objectStack);
        }
        return s;
    }

    private ArrayList<Object> deserializeArrayList(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        ArrayList<Object> s = new ArrayList<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedList deserializeLinkedList(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        LinkedList<Object> s = new LinkedList<Object>();
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private HashSet<Object> deserializeHashSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        HashSet<Object> s = new HashSet<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedHashSet<Object> deserializeLinkedHashSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        LinkedHashSet<Object> s = new LinkedHashSet<Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private TreeSet<Object> deserializeTreeSet(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        TreeSet<Object> s = new TreeSet<Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeSet(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.add(this.deserialize(is, objectStack));
        }
        return s;
    }

    private TreeMap<Object, Object> deserializeTreeMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        TreeMap<Object, Object> s = new TreeMap<Object, Object>();
        objectStack.add(s);
        Comparator comparator = (Comparator)this.deserialize(is, objectStack);
        if (comparator != null) {
            s = new TreeMap(comparator);
        }
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private HashMap<Object, Object> deserializeHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        HashMap<Object, Object> s = new HashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private LinkedHashMap<Object, Object> deserializeLinkedHashMap(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        LinkedHashMap<Object, Object> s = new LinkedHashMap<Object, Object>(size);
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    private Properties deserializeProperties(DataInput is, FastArrayList<Object> objectStack) throws IOException {
        int size = ElsaUtil.unpackInt(is);
        Properties s = new Properties();
        objectStack.add(s);
        for (int i = 0; i < size; ++i) {
            s.put(this.deserialize(is, objectStack), this.deserialize(is, objectStack));
        }
        return s;
    }

    protected void serializeUnknownObject(DataOutput out, Object obj, FastArrayList<Object> objectStack) throws IOException {
        throw new NotSerializableException("Could not serialize unknown object: " + obj.getClass().getName());
    }

    protected Object deserializeUnknownHeader(DataInput is, int head, FastArrayList<Object> objectStack) throws IOException {
        throw new IOException("Unknown serialization header: " + head);
    }

    protected static void writeBooleanArray(DataOutput out, boolean[] bool) throws IOException {
        int pos = 0;
        while (pos < bool.length) {
            int v = 0;
            for (int i = 0; i < 8 && pos < bool.length; ++i) {
                v += bool[pos++] ? 1 << i : 0;
            }
            out.write(v);
        }
    }

    protected static boolean[] readBooleanArray(int numBools, DataInput is) throws IOException {
        boolean[] ret = new boolean[numBools];
        int i = 0;
        while (i < numBools) {
            int b = is.readUnsignedByte();
            for (int j = 0; i < numBools && j < 8; ++j) {
                ret[i++] = (b >>> j & 1) != 0;
            }
        }
        return ret;
    }

    public boolean isSerializable(Object o) {
        if (this.mapdb_all.containsKey(o)) {
            return true;
        }
        return this.ser.containsKey(o.getClass());
    }

    protected static interface Header {
        public static final int ZERO_FAIL = 0;
        public static final int NULL = 1;
        public static final int BOOLEAN_TRUE = 2;
        public static final int BOOLEAN_FALSE = 3;
        public static final int INT_M9 = 4;
        public static final int INT_M8 = 5;
        public static final int INT_M7 = 6;
        public static final int INT_M6 = 7;
        public static final int INT_M5 = 8;
        public static final int INT_M4 = 9;
        public static final int INT_M3 = 10;
        public static final int INT_M2 = 11;
        public static final int INT_M1 = 12;
        public static final int INT_0 = 13;
        public static final int INT_1 = 14;
        public static final int INT_2 = 15;
        public static final int INT_3 = 16;
        public static final int INT_4 = 17;
        public static final int INT_5 = 18;
        public static final int INT_6 = 19;
        public static final int INT_7 = 20;
        public static final int INT_8 = 21;
        public static final int INT_9 = 22;
        public static final int INT_10 = 23;
        public static final int INT_11 = 24;
        public static final int INT_12 = 25;
        public static final int INT_13 = 26;
        public static final int INT_14 = 27;
        public static final int INT_15 = 28;
        public static final int INT_16 = 29;
        public static final int INT_MIN_VALUE = 30;
        public static final int INT_MAX_VALUE = 31;
        public static final int INT_MF1 = 32;
        public static final int INT_F1 = 33;
        public static final int INT_MF2 = 34;
        public static final int INT_F2 = 35;
        public static final int INT_MF3 = 36;
        public static final int INT_F3 = 37;
        public static final int INT = 38;
        public static final int LONG_M9 = 39;
        public static final int LONG_M8 = 40;
        public static final int LONG_M7 = 41;
        public static final int LONG_M6 = 42;
        public static final int LONG_M5 = 43;
        public static final int LONG_M4 = 44;
        public static final int LONG_M3 = 45;
        public static final int LONG_M2 = 46;
        public static final int LONG_M1 = 47;
        public static final int LONG_0 = 48;
        public static final int LONG_1 = 49;
        public static final int LONG_2 = 50;
        public static final int LONG_3 = 51;
        public static final int LONG_4 = 52;
        public static final int LONG_5 = 53;
        public static final int LONG_6 = 54;
        public static final int LONG_7 = 55;
        public static final int LONG_8 = 56;
        public static final int LONG_9 = 57;
        public static final int LONG_10 = 58;
        public static final int LONG_11 = 59;
        public static final int LONG_12 = 60;
        public static final int LONG_13 = 61;
        public static final int LONG_14 = 62;
        public static final int LONG_15 = 63;
        public static final int LONG_16 = 64;
        public static final int LONG_MIN_VALUE = 65;
        public static final int LONG_MAX_VALUE = 66;
        public static final int LONG_MF1 = 67;
        public static final int LONG_F1 = 68;
        public static final int LONG_MF2 = 69;
        public static final int LONG_F2 = 70;
        public static final int LONG_MF3 = 71;
        public static final int LONG_F3 = 72;
        public static final int LONG_MF4 = 73;
        public static final int LONG_F4 = 74;
        public static final int LONG_MF5 = 75;
        public static final int LONG_F5 = 76;
        public static final int LONG_MF6 = 77;
        public static final int LONG_F6 = 78;
        public static final int LONG_MF7 = 79;
        public static final int LONG_F7 = 80;
        public static final int LONG = 81;
        public static final int BYTE_M1 = 82;
        public static final int BYTE_0 = 83;
        public static final int BYTE_1 = 84;
        public static final int BYTE = 85;
        public static final int CHAR_0 = 86;
        public static final int CHAR_1 = 87;
        public static final int CHAR_255 = 88;
        public static final int CHAR = 89;
        public static final int SHORT_M1 = 90;
        public static final int SHORT_0 = 91;
        public static final int SHORT_1 = 92;
        public static final int SHORT_255 = 93;
        public static final int SHORT_M255 = 94;
        public static final int SHORT = 95;
        public static final int FLOAT_M1 = 96;
        public static final int FLOAT_0 = 97;
        public static final int FLOAT_1 = 98;
        public static final int FLOAT_255 = 99;
        public static final int FLOAT_SHORT = 100;
        public static final int FLOAT = 101;
        public static final int DOUBLE_M1 = 102;
        public static final int DOUBLE_0 = 103;
        public static final int DOUBLE_1 = 104;
        public static final int DOUBLE_255 = 105;
        public static final int DOUBLE_SHORT = 106;
        public static final int DOUBLE_INT = 107;
        public static final int DOUBLE = 108;
        public static final int ARRAY_BYTE = 109;
        public static final int ARRAY_BYTE_ALL_EQUAL = 110;
        public static final int ARRAY_BOOLEAN = 111;
        public static final int ARRAY_SHORT = 112;
        public static final int ARRAY_CHAR = 113;
        public static final int ARRAY_FLOAT = 114;
        public static final int ARRAY_DOUBLE = 115;
        public static final int ARRAY_INT_BYTE = 116;
        public static final int ARRAY_INT_SHORT = 117;
        public static final int ARRAY_INT_PACKED = 118;
        public static final int ARRAY_INT = 119;
        public static final int ARRAY_LONG_BYTE = 120;
        public static final int ARRAY_LONG_SHORT = 121;
        public static final int ARRAY_LONG_PACKED = 122;
        public static final int ARRAY_LONG_INT = 123;
        public static final int ARRAY_LONG = 124;
        public static final int STRING_0 = 125;
        public static final int STRING_1 = 126;
        public static final int STRING_2 = 127;
        public static final int STRING_3 = 128;
        public static final int STRING_4 = 129;
        public static final int STRING_5 = 130;
        public static final int STRING_6 = 131;
        public static final int STRING_7 = 132;
        public static final int STRING_8 = 133;
        public static final int STRING_9 = 134;
        public static final int STRING_10 = 135;
        public static final int STRING = 136;
        public static final int BIGDECIMAL = 137;
        public static final int BIGINTEGER = 138;
        public static final int CLASS = 139;
        public static final int DATE = 140;
        public static final int UUID = 141;
        public static final int SINGLETON = 159;
        public static final int ARRAY_OBJECT = 160;
        public static final int ARRAY_OBJECT_ALL_NULL = 161;
        public static final int ARRAY_OBJECT_NO_REFS = 162;
        public static final int ARRAYLIST = 163;
        public static final int TREEMAP = 164;
        public static final int HASHMAP = 165;
        public static final int LINKEDHASHMAP = 166;
        public static final int TREESET = 167;
        public static final int HASHSET = 168;
        public static final int LINKEDHASHSET = 169;
        public static final int LINKEDLIST = 170;
        public static final int PROPERTIES = 171;
        public static final int JAVA_SERIALIZATION = 172;
        public static final int POJO = 173;
        public static final int OBJECT_STACK = 174;
    }

    protected static interface HeaderMapDB {
        public static final int B_TREE_ARRAY_SERIALIZER = 56;
        public static final int THIS_SERIALIZER = 57;
        public static final int B_TREE_BASIC_KEY_SERIALIZER = 58;
        public static final int COMPARATOR_ARRAY = 59;
        public static final int SERIALIZER_COMPRESSION_WRAPPER = 60;
        public static final int B_TREE_COMPRESS_KEY_SERIALIZER = 64;
        public static final int SERIALIZER_ARRAY = 65;
        public static final int SERIALIZER_COMPRESSION_DEFLATE_WRAPPER = 72;
        public static final int SERIALIZER_COMPRESSION_WRAPPER2 = 73;
    }

    protected static final class FastArrayList<K> {
        public int size = 0;
        public K[] data = new Object[1];
        public boolean forwardRefs = false;

        public void add(K o) {
            if (this.data.length == this.size) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[this.size] = o;
            ++this.size;
        }

        public int identityIndexOf(Object obj) {
            for (int i = 0; i < this.size; ++i) {
                if (obj != this.data[i]) continue;
                this.forwardRefs = true;
                return i;
            }
            return -1;
        }
    }

    protected final class SerHeader
    implements Ser {
        final byte header;

        public SerHeader(int header) {
            this.header = (byte)header;
        }

        public void serialize(DataOutput out, Object value, FastArrayList objectStack) throws IOException {
            out.write(this.header);
        }
    }

    protected static final class DeserLong
    extends Deser {
        protected final int digits;
        protected final boolean minus;

        public DeserLong(int digits, boolean minus) {
            this.digits = digits;
            this.minus = minus;
        }

        public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
            long ret = in.readUnsignedByte() & 0xFF;
            for (int i = 1; i < this.digits; ++i) {
                ret = ret << 8 | (long)(in.readUnsignedByte() & 0xFF);
            }
            if (this.minus) {
                ret = -ret;
            }
            return ret;
        }
    }

    protected static final class DeserInt
    extends Deser {
        protected final int digits;
        protected final boolean minus;

        public DeserInt(int digits, boolean minus) {
            this.digits = digits;
            this.minus = minus;
        }

        public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
            int ret = in.readUnsignedByte() & 0xFF;
            for (int i = 1; i < this.digits; ++i) {
                ret = ret << 8 | in.readUnsignedByte() & 0xFF;
            }
            if (this.minus) {
                ret = -ret;
            }
            return ret;
        }
    }

    protected static final class DeserStringLen
    extends Deser {
        final int len;

        DeserStringLen(int len) {
            this.len = len;
        }

        public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
            return SerializerBase.deserializeString(in, this.len);
        }
    }

    protected final class DeserSingleton
    extends Deser {
        protected final Object singleton;

        public DeserSingleton(Object singleton) {
            this.singleton = singleton;
        }

        public Object deserialize(DataInput in, FastArrayList objectStack) throws IOException {
            return this.singleton;
        }
    }

    protected static abstract class Deser<A> {
        protected Deser() {
        }

        public abstract A deserialize(DataInput var1, FastArrayList var2) throws IOException;

        public boolean needsObjectStack() {
            return false;
        }
    }

    protected static interface Ser<A> {
        public void serialize(DataOutput var1, A var2, FastArrayList var3) throws IOException;
    }
}

