/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.mapdb.elsa.ElsaUtil;
import org.mapdb.elsa.SerializerPojo;

public final class ObjectOutputStream2
extends ObjectOutputStream {
    private SerializerPojo serializerPojo;
    private final SerializerPojo.ClassInfo[] classes;

    protected ObjectOutputStream2(SerializerPojo serializerPojo, OutputStream out) throws IOException, SecurityException {
        this(serializerPojo, out, serializerPojo.getClassInfos());
    }

    protected ObjectOutputStream2(SerializerPojo serializerPojo, OutputStream out, SerializerPojo.ClassInfo[] classes) throws IOException, SecurityException {
        super(out);
        this.serializerPojo = serializerPojo;
        this.classes = classes;
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        int classId = SerializerPojo.classToId(this.classes, desc.getName());
        ElsaUtil.packInt(this, classId);
        if (classId == -1) {
            this.writeUTF(desc.getName());
            this.serializerPojo.notifyMissingClassInfo(desc.getName());
        }
    }
}

