/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.Serializable;
import java.util.UUID;
import journal.Debug;
import journal.Debug$;
import longevity.effect.Effect$;
import longevity.persistence.DatabaseId;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.cassandra.CassandraId;
import longevity.persistence.cassandra.CassandraPRepo;
import org.joda.time.DateTime;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C*\u0003\u001f\r\u000b7o]1oIJ\f7I]3bi\u0016T!a\u0001\u0003\u0002\u0013\r\f7o]1oIJ\f'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\t%a\u0012+L\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0019\u0012A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003Q\u0001\"aC\u000b\n\u0005Ya!\u0001B+oSRDQ\u0001\u0007\u0001\u0005Be\taa\u0019:fCR,GC\u0001\u000e0!\rYB\u0004\u000b\u0007\u0001\t\u0015i\u0002A1\u0001\u001f\u0005\u00051UCA\u0010'#\t\u00013\u0005\u0005\u0002\fC%\u0011!\u0005\u0004\u0002\b\u001d>$\b.\u001b8h!\tYA%\u0003\u0002&\u0019\t\u0019\u0011I\\=\u0005\u000b\u001db\"\u0019A\u0010\u0003\u0003}\u00032!\u000b\u0016-\u001b\u0005!\u0011BA\u0016\u0005\u0005\u0019\u00016\u000b^1uKB\u00111$\f\u0003\u0006]\u0001\u0011\ra\b\u0002\u0002!\")\u0001g\u0006a\u0001Y\u0005\t\u0001\u000f\u0003\u00043\u0001\u0011\u0005AaM\u0001\fGJ,\u0017\r^3Ti\u0006$X\r\u0006\u0002\u001bi!)Q'\ra\u0001Q\u0005)1\u000f^1uK\")q\u0007\u0001C\u0005q\u0005\u00192M]3bi\u0016\u001cF/\u0019;f\u00052|7m[5oOR\u0011\u0001&\u000f\u0005\u0006uY\u0002\r\u0001K\u0001\u0002g\")A\b\u0001C\u0005{\u0005\u0019\"-\u001b8e\u0013:\u001cXM\u001d;Ti\u0006$X-\\3oiR\u0011aH\u0013\t\u0003\u007f!k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bAaY8sK*\u00111\tR\u0001\u0007IJLg/\u001a:\u000b\u0005\u00153\u0015\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003\u001d\u000b1aY8n\u0013\tI\u0005I\u0001\bC_VtGm\u0015;bi\u0016lWM\u001c;\t\u000bUZ\u0004\u0019\u0001\u0015\t\u000b1\u0003A\u0011B'\u0002\u001f%t7/\u001a:u'R\fG/Z7f]R,\u0012A\u0014\t\u0003\u007f=K!\u0001\u0015!\u0003#A\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000fB\u0003S\u0001\t\u0007qDA\u0001N!\u0015!Vk\u0016--\u001b\u0005\u0011\u0011B\u0001,\u0003\u00059\u0019\u0015m]:b]\u0012\u0014\u0018\r\u0015*fa>\u0004\"a\u0007\u000f\u0011\u0005m\t\u0006")
public interface CassandraCreate<F, M, P> {
    public static /* synthetic */ Object create$(CassandraCreate $this, Object p) {
        return $this.create(p);
    }

    default public F create(P p2) {
        Object fp = ((PRepo)((Object)this)).effect().pure(p2);
        Object fs = ((PRepo)((Object)this)).effect().map(fp, (Function1 & Serializable & scala.Serializable)p -> {
            Object object = ((CassandraPRepo)this).logger().backend().isDebugEnabled() ? ((CassandraPRepo)this).logger().handler().apply((Object)new Debug(new StringBuilder(33).append("executing CassandraPRepo.create: ").append(p).toString(), Debug$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
            None$ id = ((PRepo)((Object)this)).hasPrimaryKey() ? None$.MODULE$ : new Some((Object)new CassandraId(UUID.randomUUID()));
            None$ rowVersion = ((CassandraPRepo)this).persistenceConfig().optimisticLocking() ? new Some((Object)BoxesRunTime.boxToLong((long)0L)) : None$.MODULE$;
            None$ createdTimestamp = ((CassandraPRepo)this).persistenceConfig().writeTimestamps() ? new Some((Object)DateTime.now()) : None$.MODULE$;
            return PState$.MODULE$.apply((Option<DatabaseId>)id, (Option<Object>)rowVersion, (Option<DateTime>)createdTimestamp, (Option<DateTime>)createdTimestamp, p);
        });
        Object fs2 = ((PRepo)((Object)this)).effect().mapBlocking(fs, (Function1 & Serializable & scala.Serializable)s -> this.createStateBlocking((PState)s));
        return ((PRepo)((Object)this)).effect().map(fs2, (Function1 & Serializable & scala.Serializable)s -> {
            Object object = ((CassandraPRepo)this).logger().backend().isDebugEnabled() ? ((CassandraPRepo)this).logger().handler().apply((Object)new Debug(new StringBuilder(38).append("done executing CassandraPRepo.create: ").append(s).toString(), Debug$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
            return s;
        });
    }

    public static /* synthetic */ Object createState$(CassandraCreate $this, PState state) {
        return $this.createState(state);
    }

    default public F createState(PState<P> state) {
        return Effect$.MODULE$.Syntax(((PRepo)((Object)this)).effect().pure(state), ((PRepo)((Object)this)).implicitF()).mapBlocking((Function1 & Serializable & scala.Serializable)s -> this.createStateBlocking((PState)s));
    }

    private PState<P> createStateBlocking(PState<P> s) {
        ((Session)((CassandraPRepo)this).session().apply()).execute((Statement)this.bindInsertStatement(s));
        return s;
    }

    private BoundStatement bindInsertStatement(PState<P> state) {
        Seq<Object> bindings = ((CassandraPRepo)this).updateColumnValues(state, true);
        Object object = ((CassandraPRepo)this).logger().backend().isDebugEnabled() ? ((CassandraPRepo)this).logger().handler().apply((Object)new Debug(new StringBuilder(30).append("invoking CQL: ").append(this.insertStatement()).append(" with bindings: ").append(bindings).toString(), Debug$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        return this.insertStatement().bind((Object[])bindings.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    private PreparedStatement insertStatement() {
        Seq<String> names = ((CassandraPRepo)this).updateColumnNames(true);
        String columns = names.mkString(",\n  ");
        String substitutionPatterns = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(1).append(":").append((String)c).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
        String cql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(66).append("|\n    |INSERT INTO ").append(((CassandraPRepo)this).tableName()).append(" (\n    |  ").append(columns).append("\n    |) VALUES (\n    |  ").append(substitutionPatterns).append("\n    |)\n    |").toString())).stripMargin();
        return ((CassandraPRepo)this).preparedStatement(cql);
    }

    public static void $init$(CassandraCreate $this) {
    }
}

