/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.mongo;

import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import java.io.Serializable;
import longevity.exceptions.persistence.DuplicateKeyValException;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.mongo.DomainModelToBsonTranslator;
import longevity.persistence.mongo.MongoId;
import longevity.persistence.mongo.MongoPRepo;
import longevity.persistence.mongo.MongoSchema;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@ScalaSignature(bytes="\u0006\u0001m4\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001\u0003<\u0003\u00155{gnZ8Xe&$XM\u0003\u0002\u0004\t\u0005)Qn\u001c8h_*\u0011QAB\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0001\b\u0003%awN\\4fm&$\u00180\u0006\u0003\n_R\f4C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001'\u00051A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\u0015!\tYQ#\u0003\u0002\u0017\u0019\t!QK\\5u\u0011!A\u0002\u0001#b\u0001\n#I\u0012a\u00073p[\u0006Lg.T8eK2$vNQ:p]R\u0013\u0018M\\:mCR|'/F\u0001\u001b!\tYB$D\u0001\u0003\u0013\ti\"AA\u000eE_6\f\u0017N\\'pI\u0016dGk\u001c\"t_:$&/\u00198tY\u0006$xN\u001d\u0005\u0006?\u0001!\t\u0002I\u0001\rEN|gNR8s'R\fG/\u001a\u000b\u0003C%\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\t\t\u001cxN\u001c\u0006\u0002M\u0005\u0019qN]4\n\u0005!\u001a#\u0001\u0004\"t_:$unY;nK:$\b\"\u0002\u0016\u001f\u0001\u0004Y\u0013!B:uCR,\u0007c\u0001\u0017._5\tA!\u0003\u0002/\t\t1\u0001k\u0015;bi\u0016\u0004\"\u0001M\u0019\r\u0001\u0011)!\u0007\u0001b\u0001g\t\t\u0001+\u0005\u00025oA\u00111\"N\u0005\u0003m1\u0011qAT8uQ&tw\r\u0005\u0002\fq%\u0011\u0011\b\u0004\u0002\u0004\u0003:L\b\"B\u001e\u0001\t#a\u0014!\u0003;sC:\u001cH.\u0019;f)\t\tS\bC\u0003?u\u0001\u0007q&A\u0001q\u0011\u0015\u0001\u0005\u0001\"\u0005B\u0003u!\bN]8x\tV\u0004H.[2bi\u0016\\U-\u001f,bY\u0016C8-\u001a9uS>tGc\u0001\u001bC\u0007\")ah\u0010a\u0001_!)Ai\u0010a\u0001\u000b\u0006)1-Y;tKB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\b[>twm\u001c3c\u0015\u0005Q\u0015aA2p[&\u0011Aj\u0012\u0002\u0014\u001b>twm\\,sSR,W\t_2faRLwN\u001c\u0005\u0006\u001d\u0002!\tbT\u0001\b[>twm\\%e)\t\u0001\u0016\fE\u0002\f#NK!A\u0015\u0007\u0003\r=\u0003H/[8o!\t!v+D\u0001V\u0015\t16%A\u0003usB,7/\u0003\u0002Y+\nAqJ\u00196fGRLE\rC\u0003+\u001b\u0002\u00071\u0006C\u0003\\\u0001\u0011EA,\u0001\u0006xe&$X-U;fef$\"!X2\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u001c\u0013aC2p]Z,'o]5p]NL!AY0\u0003\t\t\u001bxN\u001c\u0005\u0006Ui\u0003\ra\u000b\u0005\u0006K\u0002!IAZ\u0001\nW\u0016Lh)\u001b7uKJ$\"!X4\t\u000b)\"\u0007\u0019A\u0016\t\u000b%\u0004A\u0011\u00026\u0002\r%$'i]8o)\tYg\u000e\u0005\u0002#Y&\u0011Qn\t\u0002\r\u0005N|gn\u00142kK\u000e$\u0018\n\u001a\u0005\u0006U!\u0004\ra\u000b\u0003\u0006a\u0002\u0011\r!\u001d\u0002\u0002\rV\u00111G\u001d\u0003\u0006g>\u0014\ra\r\u0002\u0002?\u0012)Q\u000f\u0001b\u0001g\t\tQ\nE\u0003\u001cofTx&\u0003\u0002y\u0005\tQQj\u001c8h_B\u0013V\r]8\u0011\u0005Az\u0007C\u0001\u0019u\u0001")
public interface MongoWrite<F, M, P> {
    public static /* synthetic */ DomainModelToBsonTranslator domainModelToBsonTranslator$(MongoWrite $this) {
        return $this.domainModelToBsonTranslator();
    }

    default public DomainModelToBsonTranslator domainModelToBsonTranslator() {
        return new DomainModelToBsonTranslator(((PRepo)((Object)this)).modelType().emblematic());
    }

    public static /* synthetic */ BsonDocument bsonForState$(MongoWrite $this, PState state) {
        return $this.bsonForState(state);
    }

    /*
     * WARNING - void declaration
     */
    default public BsonDocument bsonForState(PState<P> state) {
        void var2_2;
        BsonDocument document = this.translate(state.get());
        Object object = !((PRepo)((Object)this)).hasPrimaryKey() ? document.append("_id", (BsonValue)this.idBson(state)) : BoxedUnit.UNIT;
        state.rowVersion().foreach((Function1 & Serializable & scala.Serializable)v -> document.append("_rowVersion", (BsonValue)new BsonInt64(BoxesRunTime.unboxToLong((Object)v))));
        state.createdTimestamp().foreach((Function1 & Serializable & scala.Serializable)d -> document.append("_createdTimestamp", (BsonValue)new BsonDateTime(d.getMillis())));
        state.updatedTimestamp().foreach((Function1 & Serializable & scala.Serializable)d -> document.append("_updatedTimestamp", (BsonValue)new BsonDateTime(d.getMillis())));
        return var2_2;
    }

    public static /* synthetic */ BsonDocument translate$(MongoWrite $this, Object p) {
        return $this.translate(p);
    }

    default public BsonDocument translate(P p) {
        return this.domainModelToBsonTranslator().translate(p, true, ((PRepo)((Object)this)).pTypeKey()).asDocument();
    }

    public static /* synthetic */ Nothing$ throwDuplicateKeyValException$(MongoWrite $this, Object p, MongoWriteException cause) {
        return $this.throwDuplicateKeyValException(p, cause);
    }

    default public Nothing$ throwDuplicateKeyValException(P p, MongoWriteException cause) {
        String name;
        String string;
        UnanchoredRegex indexRegex = new StringOps(Predef$.MODULE$.augmentString("index: (?:[\\w\\.]*\\$)?(\\S+)\\s+dup key: \\{ :")).r().unanchored();
        Option option = ((Regex)indexRegex).unapplySeq((CharSequence)(string = cause.getMessage()));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw cause;
        }
        String string2 = name = (String)((LinearSeqOptimized)option.get()).apply(0);
        String name2 = string2;
        RealizedKey realizedKey = (RealizedKey)((PRepo)((Object)this)).realizedPType().keySet().find((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)MongoWrite.$anonfun$throwDuplicateKeyValException$1(this, name2, key))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw cause;
        });
        throw new DuplicateKeyValException(p, realizedKey.key(), (Exception)((Object)cause));
    }

    public static /* synthetic */ Option mongoId$(MongoWrite $this, PState state) {
        return $this.mongoId(state);
    }

    default public Option<ObjectId> mongoId(PState<P> state) {
        return state.id().map((Function1 & Serializable & scala.Serializable)x$1 -> ((MongoId)x$1).objectId());
    }

    public static /* synthetic */ Bson writeQuery$(MongoWrite $this, PState state) {
        return $this.writeQuery(state);
    }

    default public Bson writeQuery(PState<P> state) {
        Bson bson;
        if (((MongoPRepo)this).persistenceConfig().optimisticLocking()) {
            Bson bson2;
            Option<Object> option = state.rowVersion();
            if (option instanceof Some) {
                Some some = (Some)option;
                long rv = BoxesRunTime.unboxToLong((Object)some.value());
                bson2 = Filters.eq((String)"_rowVersion", (Object)new BsonInt64(rv));
            } else if (None$.MODULE$.equals(option)) {
                bson2 = Filters.exists((String)"_rowVersion", (boolean)false);
            } else {
                throw new MatchError(option);
            }
            Bson rvBson = bson2;
            bson = Filters.and((Bson[])new Bson[]{this.keyFilter(state), rvBson});
        } else {
            bson = this.keyFilter(state);
        }
        return bson;
    }

    private Bson keyFilter(PState<P> state) {
        Bson bson;
        Option option = ((PRepo)((Object)this)).realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            bson = this.pkFilter$1(key, state);
        } else if (None$.MODULE$.equals(option)) {
            bson = Filters.eq((String)"_id", (Object)this.idBson(state));
        } else {
            throw new MatchError(option);
        }
        return bson;
    }

    private BsonObjectId idBson(PState<P> state) {
        return new BsonObjectId((ObjectId)this.mongoId(state).get());
    }

    public static /* synthetic */ boolean $anonfun$throwDuplicateKeyValException$1(MongoWrite $this, String name$1, RealizedKey key) {
        String string = ((MongoSchema)((Object)$this)).indexName(key);
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Bson pkFilter$1(RealizedKey key, PState state$1) {
        String fieldName = key.realizedProp().inlinedPath();
        Object keyVal2 = key.keyValForP(state$1.get());
        BsonValue bson = this.domainModelToBsonTranslator().translate(keyVal2, false, key.keyValTypeKey());
        return Filters.eq((String)fieldName, (Object)bson);
    }

    public static void $init$(MongoWrite $this) {
    }
}

