/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.UUID;
import journal.Logger;
import journal.Logger$;
import longevity.config.PersistenceConfig;
import longevity.effect.Effect;
import longevity.emblem.emblematic.Emblematic;
import longevity.emblem.emblematic.traversors.sync.EmblematicToJsonTranslator;
import longevity.emblem.emblematic.traversors.sync.JsonToEmblematicTranslator;
import longevity.emblem.exceptions.CouldNotTraverseException;
import longevity.emblem.stringUtil$;
import longevity.exceptions.persistence.NotInDomainModelTranslationException;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.model.ptype.Key;
import longevity.model.query.Query;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.jdbc.JdbcCreate;
import longevity.persistence.jdbc.JdbcDelete;
import longevity.persistence.jdbc.JdbcId;
import longevity.persistence.jdbc.JdbcPRepo$;
import longevity.persistence.jdbc.JdbcQuery;
import longevity.persistence.jdbc.JdbcQuery$FilterInfo$;
import longevity.persistence.jdbc.JdbcRetrieve;
import longevity.persistence.jdbc.JdbcSchema;
import longevity.persistence.jdbc.JdbcUpdate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import streamadapter.Chunkerator;

@ScalaSignature(bytes="\u0006\u0001\r}f!B\u0001\u0003\u0001\u0011A!!\u0003&eE\u000e\u0004&+\u001a9p\u0015\t\u0019A!\u0001\u0003kI\n\u001c'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\t%\u0001\u0012\u0005J\n\t\u0001)1#&\f\u00194mA)1\u0002\u0004\b!G5\tA!\u0003\u0002\u000e\t\t)\u0001KU3q_B\u0011q\u0002\u0005\u0007\u0001\t\u0015\t\u0002A1\u0001\u0014\u0005\u000515\u0001A\u000b\u0003)y\t\"!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003H\u0005\u0003;]\u00111!\u00118z\t\u0015y\u0002C1\u0001\u0015\u0005\u0005y\u0006CA\b\"\t\u0015\u0011\u0003A1\u0001\u0015\u0005\u0005i\u0005CA\b%\t\u0015)\u0003A1\u0001\u0015\u0005\u0005\u0001\u0006#B\u0014)\u001d\u0001\u001aS\"\u0001\u0002\n\u0005%\u0012!A\u0003&eE\u000e\u001c6\r[3nCB)qe\u000b\b!G%\u0011AF\u0001\u0002\u000b\u0015\u0012\u00147m\u0011:fCR,\u0007#B\u0014/\u001d\u0001\u001a\u0013BA\u0018\u0003\u00051QEMY2SKR\u0014\u0018.\u001a<f!\u00159\u0013G\u0004\u0011$\u0013\t\u0011$AA\u0005KI\n\u001c\u0017+^3ssB)q\u0005\u000e\b!G%\u0011QG\u0001\u0002\u000b\u0015\u0012\u00147-\u00169eCR,\u0007#B\u00148\u001d\u0001\u001a\u0013B\u0001\u001d\u0003\u0005)QEMY2EK2,G/\u001a\u0005\nu\u0001\u0011\t\u0011)A\u0005w\u0001\u000ba!\u001a4gK\u000e$\bc\u0001\u001f?\u001d5\tQH\u0003\u0002;\r%\u0011q(\u0010\u0002\u0007\u000b\u001a4Wm\u0019;\n\u0005ib\u0001\"\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"J\u0003%iw\u000eZ3m)f\u0004X\rE\u0002E\u000f\u0002j\u0011!\u0012\u0006\u0003\r\u001a\tQ!\\8eK2L!\u0001S#\u0003\u00135{G-\u001a7UsB,\u0017B\u0001\"\r\u0011%Y\u0005A!A!\u0002\u0013au*A\u0003q)f\u0004X\r\u0005\u0003E\u001b\u0002\u001a\u0013B\u0001(F\u0005\u0015\u0001F+\u001f9f\u0013\tYE\u0002\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0005S\u0003E\u0001XM]:jgR,gnY3D_:4\u0017nZ\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011aKB\u0001\u0007G>tg-[4\n\u0005a+&!\u0005)feNL7\u000f^3oG\u0016\u001cuN\u001c4jO\"A!\f\u0001B\u0001B\u0003%1+\u0001\nqKJ\u001c\u0018n\u001d;f]\u000e,7i\u001c8gS\u001e\u0004\u0003\u0002\u0003/\u0001\u0005\u000b\u0007I\u0011C/\u0002\u0015\r|gN\\3di&|g.F\u0001_!\r1r,Y\u0005\u0003A^\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017aA:rY*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\tU\u0002\u0011\t\u0011)A\u0005=\u0006Y1m\u001c8oK\u000e$\u0018n\u001c8!\u0011\u0019a\u0007\u0001\"\u0001\u0005[\u00061A(\u001b8jiz\"bA\\8qcJ\u001c\b#B\u0014\u0001\u001d\u0001\u001a\u0003\"\u0002\u001el\u0001\u0004Y\u0004\"\u0002\"l\u0001\u0004\u0019\u0005\"B&l\u0001\u0004a\u0005\"B)l\u0001\u0004\u0019\u0006\"\u0002/l\u0001\u0004q\u0006bB;\u0001\u0005\u0004%\tB^\u0001\u0007Y><w-\u001a:\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT\u0011A_\u0001\bU>,(O\\1m\u0013\ta\u0018P\u0001\u0004M_\u001e<WM\u001d\u0005\u0007}\u0002\u0001\u000b\u0011B<\u0002\u000f1|wmZ3sA!Q\u0011\u0011\u0001\u0001C\u0002\u0013E!!a\u0001\u0002\u0013Q\f'\r\\3OC6,WCAA\u0003!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u00179RBAA\u0007\u0015\r\tyAE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Mq#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'9\u0002\u0002CA\u000f\u0001\u0001\u0006I!!\u0002\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0005\u0002$\u0005\u0019\u0002/\u0019:uSRLwN\\\"p[B|g.\u001a8ugV\u0011\u0011Q\u0005\t\u0007\u0003O\ti#!\r\u000e\u0005\u0005%\"bAA\u0016/\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0012\u0011\u0006\u0002\u0004'\u0016\f\bGBA\u001a\u0003\u0003\n\t\u0006E\u0005\u00026\u0005m2%a\u0010\u0002P5\u0011\u0011q\u0007\u0006\u0004\u0003s)\u0015\u0001\u0003:fC2L'0\u001a3\n\t\u0005u\u0012q\u0007\u0002\u0016%\u0016\fG.\u001b>fIB\u0013x\u000e]\"p[B|g.\u001a8u!\ry\u0011\u0011\t\u0003\f\u0003\u0007\n)%!A\u0001\u0002\u000b\u0005ACA\u0002`IEB!\"a\u0012\u0002J\u0005\u0005\t\u0011AA'\u0003!!\u0013M\\8oMVt\u0007\u0002CA&\u0001\u0001\u0006I!!\n\u0002)A\f'\u000f^5uS>t7i\\7q_:,g\u000e^:!\u0017\u0001\u00012aDA)\t-\t\u0019&!\u0012\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\u0007}##\u0007C\u0005\u0002X\u0001\u0011\r\u0011\"\u0005\u0002Z\u00059\u0002o\\:u!\u0006\u0014H/\u001b;j_:\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u00037\u0002b!a\n\u0002.\u0005u\u0003GBA0\u0003G\ny\u0007E\u0005\u00026\u0005m2%!\u0019\u0002nA\u0019q\"a\u0019\u0005\u0017\u0005\u0015\u0014qMA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0004?\u0012\u001a\u0004BCA$\u0003S\n\t\u0011!\u0001\u0002N!A\u00111\u000e\u0001!\u0002\u0013\tY&\u0001\rq_N$\b+\u0019:uSRLwN\\\"p[B|g.\u001a8ug\u0002\u00022aDA8\t-\t\t(a\u001a\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\u0007}#C\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0005\u0002$\u0005!\u0002O]5nCJL8*Z=D_6\u0004xN\\3oiND\u0001\"!\u001f\u0001A\u0003%\u0011QE\u0001\u0016aJLW.\u0019:z\u0017\u0016L8i\\7q_:,g\u000e^:!\u0011%\ti\b\u0001b\u0001\n#\ty(\u0001\u000bbGR,\u0018\r\\5{K\u0012\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003\u0003\u0003b!a!\u0002\n\u00065UBAAC\u0015\u0011\t9)!\u000b\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAF\u0003\u000b\u00131aU3ua!\ty)a%\u0002&\u0006-\u0006CCA\u001b\u0003w\t\t*a)\u0002*B\u0019q\"a%\u0005\u0019\u0005U\u0015qSA\u0001\u0002\u0003\u0015\t!!)\u0003\u0007}#\u0003\b\u0003\u0005\u0002\u001a\u0002!\tBAAN\u0003EIg\u000eZ3yK\u0012\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003;\u0003b!a\u0002\u0002 \u00065\u0015\u0002BAF\u00033\t\"aI\u000e\u0011\u0007=\t)\u000bB\u0006\u0002(\u0006]\u0015\u0011!A\u0001\u0006\u0003!\"aA0%sA\u0019q\"a+\u0005\u0017\u00055\u0016qSA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\n\u0004\u0007\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAA\u0003U\t7\r^;bY&TX\rZ\"p[B|g.\u001a8ug\u0002B\u0011\"!.\u0001\u0005\u0004%\t\"a.\u00025\u0015l'\r\\3nCRL7\rV8Kg>tGK]1og2\fGo\u001c:\u0016\u0005\u0005e\u0006\u0003BA^\u0003\u001bl!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\u0005gft7M\u0003\u0003\u0002D\u0006\u0015\u0017A\u0003;sCZ,'o]8sg*!\u0011qYAe\u0003))WN\u00197f[\u0006$\u0018n\u0019\u0006\u0004\u0003\u00174\u0011AB3nE2,W.\u0003\u0003\u0002P\u0006u&AG#nE2,W.\u0019;jGR{'j]8o)J\fgn\u001d7bi>\u0014\b\u0002CAj\u0001\u0001\u0006I!!/\u00027\u0015l'\r\\3nCRL7\rV8Kg>tGK]1og2\fGo\u001c:!\u0011%\t9\u000e\u0001b\u0001\n#\tI.\u0001\u000ekg>tGk\\#nE2,W.\u0019;jGR\u0013\u0018M\\:mCR|'/\u0006\u0002\u0002\\B!\u00111XAo\u0013\u0011\ty.!0\u00035)\u001bxN\u001c+p\u000b6\u0014G.Z7bi&\u001cGK]1og2\fGo\u001c:\t\u0011\u0005\r\b\u0001)A\u0005\u00037\f1D[:p]R{W)\u001c2mK6\fG/[2Ue\u0006t7\u000f\\1u_J\u0004\u0003bBAt\u0001\u0011E\u0011\u0011^\u0001\u000bG>dW/\u001c8OC6,G\u0003BAv\u0003k\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003c,\u0017\u0001\u00027b]\u001eLA!a\u0006\u0002p\"A\u0011q_As\u0001\u0004\tI0\u0001\u0003qe>\u0004\b\u0007CA~\u0003\u007f\u0014)Aa\u0003\u0011\u0015\u0005U\u00121HA\u007f\u0005\u0007\u0011I\u0001E\u0002\u0010\u0003\u007f$1B!\u0001\u0002v\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u0019:!\ry!Q\u0001\u0003\f\u0005\u000f\t)0!A\u0001\u0002\u000b\u0005AC\u0001\u0003`II\u0002\u0004cA\b\u0003\f\u0011Y!QBA{\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yFEM\u0019\t\u000f\tE\u0001\u0001\"\u0005\u0003\u0014\u0005Q1oY8sK\u0012\u0004\u0016\r\u001e5\u0015\t\u0005-(Q\u0003\u0005\t\u0003o\u0014y\u00011\u0001\u0003\u0018AB!\u0011\u0004B\u000f\u0005G\u0011I\u0003\u0005\u0006\u00026\u0005m\"1\u0004B\u0011\u0005O\u00012a\u0004B\u000f\t-\u0011yB!\u0006\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\t}##G\r\t\u0004\u001f\t\rBa\u0003B\u0013\u0005+\t\t\u0011!A\u0003\u0002Q\u0011Aa\u0018\u00133gA\u0019qB!\u000b\u0005\u0017\t-\"QCA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u0012D\u0007C\u0004\u00030\u0001!\tB!\r\u0002\u001d)\u001cxN\\*ue&twMR8s!R!\u0011Q\u0001B\u001a\u0011\u001d\u0011)D!\fA\u0002\r\n\u0011\u0001\u001d\u0005\b\u0005s\u0001A\u0011\u0003B\u001e\u0003E)\b\u000fZ1uK\u000e{G.^7o\u001d\u0006lWm\u001d\u000b\u0005\u0005{\u0011i\u0005\u0005\u0004\u0003@\t%\u0013Q\u0001\b\u0005\u0005\u0003\u0012)E\u0004\u0003\u0002\f\t\r\u0013\"\u0001\r\n\u0007\t\u001ds#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\"1\n\u0006\u0004\u0005\u000f:\u0002B\u0003B(\u0005o\u0001\n\u00111\u0001\u0003R\u0005A\u0011n]\"sK\u0006$X\rE\u0002\u0017\u0005'J1A!\u0016\u0018\u0005\u001d\u0011un\u001c7fC:DqA!\u0017\u0001\t#\u0011Y&\u0001\nva\u0012\fG/Z\"pYVlgNV1mk\u0016\u001cHC\u0002B/\u0005K\u0012y\u0007\u0005\u0004\u0003@\t%#q\f\t\u0004-\t\u0005\u0014b\u0001B2/\t1\u0011I\\=SK\u001aD\u0001Ba\u001a\u0003X\u0001\u0007!\u0011N\u0001\u0006gR\fG/\u001a\t\u0005\u0017\t-4%C\u0002\u0003n\u0011\u0011a\u0001U*uCR,\u0007B\u0003B(\u0005/\u0002\n\u00111\u0001\u0003R!9!1\u000f\u0001\u0005\u0012\tU\u0014\u0001B;vS\u0012$BAa\u001e\u0003\u0004B!!\u0011\u0010B@\u001b\t\u0011YHC\u0002\u0003~\u0015\fA!\u001e;jY&!!\u0011\u0011B>\u0005\u0011)V+\u0013#\t\u0011\t\u001d$\u0011\u000fa\u0001\u0005SBqAa\"\u0001\t#\t\u0019!\u0001\txQ\u0016\u0014X-Q:tS\u001etW.\u001a8ug\"9!1\u0012\u0001\u0005\u0012\t5\u0015!D<iKJ,')\u001b8eS:<7\u000f\u0006\u0003\u0003\u0010\nE\u0005CBA\u0014\u0003[\u0011y\u0006\u0003\u0005\u0003h\t%\u0005\u0019\u0001B5\u0011\u001d\u0011)\n\u0001C\u0005\u0005/\u000ba\u0002\u001d:paZ\u000bGNQ5oI&tw-\u0006\u0004\u0003\u001a\n\u0015&\u0011\u0017\u000b\u0007\u0005?\u0012YJ!.\t\u0011\tu%1\u0013a\u0001\u0005?\u000b\u0011bY8na>tWM\u001c;1\t\t\u0005&1\u0016\t\u000b\u0003k\tYDa)\u0003*\n=\u0006cA\b\u0003&\u0012A!q\u0015BJ\u0005\u0004\t\tK\u0001\u0002Q!B\u0019qBa+\u0005\u0017\t5&1TA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u001a\u0014\u0007E\u0002\u0010\u0005c#qAa-\u0003\u0014\n\u0007ACA\u0001B\u0011\u001d\u0011)Da%A\u0002\rBqA!/\u0001\t#\u0011Y,A\u0005kI\n\u001cg+\u00197vKR!!q\fB_\u0011\u001d\u0011yLa.A\u0002m\tQA^1mk\u0016DqAa1\u0001\t#\u0011)-\u0001\u0005kI\n\u001cG)\u0019;f)\u0011\u00119M!4\u0011\t\te$\u0011Z\u0005\u0005\u0005\u0017\u0014YH\u0001\u0003ECR,\u0007\u0002\u0003Bh\u0005\u0003\u0004\rA!5\u0002\u0003\u0011\u0004BAa5\u0003b6\u0011!Q\u001b\u0006\u0005\u0005/\u0014I.\u0001\u0003uS6,'\u0002\u0002Bn\u0005;\fAA[8eC*\u0011!q\\\u0001\u0004_J<\u0017\u0002\u0002Br\u0005+\u0014\u0001\u0002R1uKRKW.\u001a\u0005\b\u0005O\u0004A\u0011\u0003Bu\u0003U\u0011X\r\u001e:jKZ,gI]8n%\u0016\u001cX\u000f\u001c;TKR$BA!\u001b\u0003l\"A!Q\u001eBs\u0001\u0004\u0011y/A\u0005sKN,H\u000e^*fiB\u0019!M!=\n\u0007\tM8MA\u0005SKN,H\u000e^*fi\"9!q\u001f\u0001\u0005\u0012\te\u0018\u0001H2p]Z,'\u000f\u001e#va2L7-\u0019;f\u0017\u0016LX\t_2faRLwN\u001c\u000b\u0005\u0005w\u001ci\u0001E\u0004\u0017\u0005{\u001c\taa\u0002\n\u0007\t}xCA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\u0011\u0011yda\u0001\n\t\r\u0015!1\n\u0002\n)\"\u0014xn^1cY\u0016\u00042AFB\u0005\u0013\r\u0019Ya\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0003h\tU\b\u0019\u0001B5\u0011\u001d\u0019\t\u0002\u0001C!\u0007'\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000bA\u0011ba\u0006\u0001#\u0003%\tb!\u0007\u00027U\u0004H-\u0019;f\u0007>dW/\u001c8OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YB\u000b\u0003\u0003R\ru1FAB\u0010!\u0011\u0019\tca\u000b\u000e\u0005\r\r\"\u0002BB\u0013\u0007O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r%r#\u0001\u0006b]:|G/\u0019;j_:LAa!\f\u0004$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\rE\u0002!%A\u0005\u0012\re\u0011\u0001H;qI\u0006$XmQ8mk6tg+\u00197vKN$C-\u001a4bk2$HE\r\u0005\u000e\u0007k\u0001\u0001\u0013aA\u0001\u0002\u0013%1qG%\u0002\u001fM,\b/\u001a:%[>$W\r\u001c+za\u0016,\u0012aQ\u0004\t\u0007w\u0011\u0001\u0012\u0001\u0003\u0004>\u0005I!\n\u001a2d!J+\u0007o\u001c\t\u0004O\r}baB\u0001\u0003\u0011\u0003!1\u0011I\n\u0005\u0007\u007f\u0011y\u0006C\u0004m\u0007\u007f!\ta!\u0012\u0015\u0005\ru\u0002\u0002CB%\u0007\u007f!\taa\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0011\r531KB.\u0007?\"bba\u0014\u0004b\r\u00154\u0011NB7\u0007_\u001aI\n\u0005\u0005(\u0001\rE3\u0011LB/!\ry11\u000b\u0003\b#\r\u001d#\u0019AB++\r!2q\u000b\u0003\u0007?\rM#\u0019\u0001\u000b\u0011\u0007=\u0019Y\u0006\u0002\u0004#\u0007\u000f\u0012\r\u0001\u0006\t\u0004\u001f\r}CAB\u0013\u0004H\t\u0007A\u0003C\u0004;\u0007\u000f\u0002\raa\u0019\u0011\tqr4\u0011\u000b\u0005\b\u0005\u000e\u001d\u0003\u0019AB4!\u0011!ui!\u0017\t\u000f-\u001b9\u00051\u0001\u0004lA1A)TB-\u0007;BaAVB$\u0001\u0004\u0019\u0006\u0002CB9\u0007\u000f\u0002\raa\u001d\u0002\u0017A|G.\u001f*fa>|\u0005\u000f\u001e\t\u0006-\rU4\u0011P\u0005\u0004\u0007o:\"AB(qi&|g\u000e\r\u0003\u0004|\r}\u0004\u0003C\u0014\u0001\u0007#\u001aIf! \u0011\u0007=\u0019y\b\u0002\u0007\u0004\u0002\u000e\r\u0015\u0011!A\u0001\u0006\u0003\u00199J\u0001\u0003`IM\u0012\u0004\u0002CB9\u0007\u000f\u0002\ra!\"\u0011\u000bY\u0019)ha\"1\t\r%5\u0011\u0013\t\tO\u0001\u0019Yi!$\u0004\u0010B\u0019qba\u0015\u0011\u0007=\u0019Y\u0006E\u0002\u0010\u0007##Ab!!\u0004\u0004\u0006\u0005\t\u0011!B\u0001\u0007'\u000b2a!&\u001c!\ry1qL\t\u0004\u0007;Z\u0002B\u0002/\u0004H\u0001\u0007a\fC\u0006\u0004\u001e\u000e}\"\u0019!C\u0001\u0005\r}\u0015a\u00042bg&\u001cGk\u001c&eE\u000e$\u0016\u0010]3\u0016\u0005\r\u0005\u0006\u0003CAB\u0007G\u001b9+a;\n\t\r\u0015\u0016Q\u0011\u0002\u0004\u001b\u0006\u0004\b\u0007BBU\u0007o\u0003baa+\u00042\u000eUVBABW\u0015\t\u0019y+A\u0004usB,7.Z=\n\t\rM6Q\u0016\u0002\b)f\u0004XmS3z!\ry1q\u0017\u0003\f\u0007s\u001bY,!A\u0001\u0002\u000b\u0005AC\u0001\u0003`IM\u001a\u0004\"CB_\u0007\u007f\u0001\u000b\u0011BBQ\u0003A\u0011\u0017m]5d)>TEMY2UsB,\u0007\u0005")
public class JdbcPRepo<F, M, P>
extends PRepo<F, M, P>
implements JdbcSchema<F, M, P>,
JdbcCreate<F, M, P>,
JdbcRetrieve<F, M, P>,
JdbcQuery<F, M, P>,
JdbcUpdate<F, M, P>,
JdbcDelete<F, M, P> {
    private final PersistenceConfig persistenceConfig;
    private final Function0<Connection> connection;
    private final Logger logger;
    private final String tableName;
    private final Seq<RealizedPropComponent<P, ?, ?>> partitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents;
    private final Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents;
    private final EmblematicToJsonTranslator emblematicToJsonTranslator;
    private final JsonToEmblematicTranslator jsonToEmblematicTranslator;
    private volatile JdbcQuery$FilterInfo$ FilterInfo$module;
    private Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    private String longevity$persistence$jdbc$JdbcCreate$$insertSql;
    private volatile byte bitmap$0;

    public static <F, M, P> JdbcPRepo<F, M, P> apply(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Option<JdbcPRepo<F, M, ? super P>> option, Function0<Connection> function0) {
        return JdbcPRepo$.MODULE$.apply(effect, modelType, pType, persistenceConfig, option, function0);
    }

    @Override
    public F delete(PState<P> state) {
        return (F)JdbcDelete.delete$(this, state);
    }

    @Override
    public F update(PState<P> state) {
        return (F)JdbcUpdate.update$(this, state);
    }

    @Override
    public Chunkerator<PState<P>> queryToChunkerator(Query<P> query) {
        return JdbcQuery.queryToChunkerator$(this, query);
    }

    @Override
    public String queryWhereClause(JdbcQuery.FilterInfo filterInfo) {
        return JdbcQuery.queryWhereClause$(this, filterInfo);
    }

    @Override
    public <V> F retrieve(V keyVal2, Key<M, P, V> evidence$1) {
        return (F)JdbcRetrieve.retrieve$(this, keyVal2, evidence$1);
    }

    @Override
    public Option<PState<P>> retrieveFromPreparedStatement(PreparedStatement statement) {
        return JdbcRetrieve.retrieveFromPreparedStatement$(this, statement);
    }

    @Override
    public String keyValSelectStatementConjunction(RealizedKey<M, P, ?> key) {
        return JdbcRetrieve.keyValSelectStatementConjunction$(this, key);
    }

    @Override
    public F create(P p) {
        return (F)JdbcCreate.create$(this, p);
    }

    @Override
    public void createSchemaBlocking() {
        JdbcSchema.createSchemaBlocking$(this);
    }

    @Override
    public void createTable() {
        JdbcSchema.createTable$(this);
    }

    @Override
    public void addColumn(String columnName, String columnType) {
        JdbcSchema.addColumn$(this, columnName, columnType);
    }

    @Override
    public <A> String componentToJdbcType(RealizedPropComponent<? super P, ?, A> component2) {
        return JdbcSchema.componentToJdbcType$(this, component2);
    }

    @Override
    public void createUniqueIndexes() {
        JdbcSchema.createUniqueIndexes$(this);
    }

    @Override
    public void createNonUniqueIndexes() {
        JdbcSchema.createNonUniqueIndexes$(this);
    }

    @Override
    public void createIndex(boolean unique, String indexName, Seq<String> columnNames) {
        JdbcSchema.createIndex$(this, unique, indexName, columnNames);
    }

    @Override
    public JdbcQuery$FilterInfo$ FilterInfo() {
        if (this.FilterInfo$module == null) {
            this.FilterInfo$lzycompute$1();
        }
        return this.FilterInfo$module;
    }

    private Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement = JdbcRetrieve.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    }

    @Override
    public Map<RealizedKey<M, P, ?>, String> longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement$lzycompute() : this.longevity$persistence$jdbc$JdbcRetrieve$$keyValSelectStatement;
    }

    private String longevity$persistence$jdbc$JdbcCreate$$insertSql$lzycompute() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.longevity$persistence$jdbc$JdbcCreate$$insertSql = JdbcCreate.longevity$persistence$jdbc$JdbcCreate$$insertSql$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.longevity$persistence$jdbc$JdbcCreate$$insertSql;
    }

    @Override
    public String longevity$persistence$jdbc$JdbcCreate$$insertSql() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.longevity$persistence$jdbc$JdbcCreate$$insertSql$lzycompute() : this.longevity$persistence$jdbc$JdbcCreate$$insertSql;
    }

    public /* synthetic */ ModelType longevity$persistence$jdbc$JdbcPRepo$$super$modelType() {
        return super.modelType();
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public Function0<Connection> connection() {
        return this.connection;
    }

    public Logger logger() {
        return this.logger;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> partitionComponents() {
        return this.partitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents() {
        return this.postPartitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents() {
        return this.primaryKeyComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents() {
        return this.actualizedComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> indexedComponents() {
        Set keyComponents = (Set)((TraversableLike)this.realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JdbcPRepo.$anonfun$indexedComponents$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.realizedProp().realizedPropComponents(), Set$.MODULE$.canBuildFrom());
        Set props = (Set)super.pType().indexSet().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.props(), Set$.MODULE$.canBuildFrom());
        Set realizedProps = (Set)props.map((Function1 & Serializable & scala.Serializable)x$6 -> (RealizedProp)this.realizedPType().realizedProps().apply(x$6), Set$.MODULE$.canBuildFrom());
        Set indexComponents = (Set)((GenericTraversableTemplate)realizedProps.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.realizedPropComponents(), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (Set)keyComponents.$plus$plus((GenTraversableOnce)indexComponents);
    }

    public EmblematicToJsonTranslator emblematicToJsonTranslator() {
        return this.emblematicToJsonTranslator;
    }

    public JsonToEmblematicTranslator jsonToEmblematicTranslator() {
        return this.jsonToEmblematicTranslator;
    }

    public String columnName(RealizedPropComponent<?, ?, ?> prop) {
        return "prop_" + this.scoredPath(prop);
    }

    public String scoredPath(RealizedPropComponent<?, ?, ?> prop) {
        return prop.outerPropPath().inlinedPath().replace('.', '_');
    }

    public String jsonStringForP(P p) {
        String string;
        try {
            JsonAST.JValue x$21 = this.emblematicToJsonTranslator().translate(p, this.pTypeKey());
            Formats x$22 = JsonMethods$.MODULE$.render$default$2(x$21);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$21, x$22));
        }
        catch (CouldNotTraverseException e) {
            throw new NotInDomainModelTranslationException(e.typeKey().name(), e);
        }
        return string;
    }

    public Seq<String> updateColumnNames(boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnNames = isCreate ? this.names$1(this.actualizedComponents()) : this.names$1(this.indexedComponents());
        String string = "p";
        Seq withP = (Seq)componentColumnNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            String string2 = "created_timestamp";
            String string3 = "updated_timestamp";
            seq3 = (Seq)((SeqLike)withP.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            String string4 = "row_version";
            seq2 = (Seq)withDateTimes.$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            String string5 = "id";
            seq = (Seq)withRowVersion.$plus$colon((Object)string5, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        return seq;
    }

    public boolean updateColumnNames$default$1() {
        return true;
    }

    public Seq<Object> updateColumnValues(PState<P> state, boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnValues = isCreate ? this.values$1(this.actualizedComponents(), state) : this.values$1(this.indexedComponents(), state);
        String string = this.jsonStringForP(state.get());
        Seq withP = (Seq)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            Object object = state.createdTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.jdbcValue(value)).orNull(Predef$.MODULE$.$conforms());
            Object object2 = state.updatedTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.jdbcValue(value)).orNull(Predef$.MODULE$.$conforms());
            seq3 = (Seq)((SeqLike)withP.$plus$colon(object2, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            Object object = state.rowVersionOrNull();
            seq2 = (Seq)withDateTimes.$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            UUID uUID = this.uuid(state);
            seq = (Seq)withRowVersion.$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        return seq;
    }

    public boolean updateColumnValues$default$2() {
        return true;
    }

    public UUID uuid(PState<P> state) {
        return ((JdbcId)state.id().get()).uuid();
    }

    public String whereAssignments() {
        return this.hasPrimaryKey() ? ((TraversableOnce)((TraversableLike)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString("\nAND\n  ") : "id = :id";
    }

    public Seq<Object> whereBindings(PState<P> state) {
        return this.hasPrimaryKey() ? (Seq)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.outerPropPath().get().apply(state.get()), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{((JdbcId)state.id().get()).uuid()}));
    }

    private <PP, A> Object propValBinding(RealizedPropComponent<PP, ?, A> component2, P p) {
        return this.jdbcValue(component2.outerPropPath().get().apply(p));
    }

    public Object jdbcValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        } else if (object2 instanceof DateTime) {
            DateTime dateTime = (DateTime)object2;
            object = this.jdbcDate(dateTime);
        } else {
            object = value;
        }
        return object;
    }

    public Date jdbcDate(DateTime d) {
        return new Date(d.getMillis());
    }

    public PState<P> retrieveFromResultSet(ResultSet resultSet) {
        Tuple2 tuple2;
        None$ id = !this.hasPrimaryKey() ? new Some(new JdbcId(UUID.fromString(resultSet.getString("id")))) : None$.MODULE$;
        None$ rowVersion = this.persistenceConfig().optimisticLocking() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)resultSet.getLong("row_version"))) : None$.MODULE$;
        Tuple2 tuple22 = tuple2 = this.persistenceConfig().writeTimestamps() ? new Tuple2((Object)JdbcPRepo.toOptDateTime$1("created_timestamp", resultSet), (Object)JdbcPRepo.toOptDateTime$1("updated_timestamp", resultSet)) : new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option createdTimestamp = (Option)tuple2._1();
        Option updatedTimestamp = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)createdTimestamp, (Object)updatedTimestamp);
        Tuple2 tuple24 = tuple23;
        Option createdTimestamp2 = (Option)tuple24._1();
        Option updatedTimestamp2 = (Option)tuple24._2();
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(resultSet.getString("p")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Object p = this.jsonToEmblematicTranslator().translate(json, this.pTypeKey());
        return PState$.MODULE$.apply(id, (Option<Object>)rowVersion, (Option<DateTime>)createdTimestamp2, (Option<DateTime>)updatedTimestamp2, p);
    }

    public PartialFunction<Throwable, BoxedUnit> convertDuplicateKeyException(PState<P> state) {
        return PartialFunction$.MODULE$.empty();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JdbcPRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    private final void FilterInfo$lzycompute$1() {
        JdbcPRepo jdbcPRepo = this;
        synchronized (jdbcPRepo) {
            if (this.FilterInfo$module == null) {
                this.FilterInfo$module = new JdbcQuery$FilterInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$indexedComponents$1(RealizedKey x$3) {
        return x$3 instanceof RealizedPrimaryKey;
    }

    private final Seq names$1(Set components) {
        return (Seq)((SetLike)components.map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private final Seq values$1(Set components, PState state$1) {
        return (Seq)((TraversableLike)components.toSeq().sortBy((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)component2 -> this.propValBinding((RealizedPropComponent)component2, state$1.get()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Option toOptDateTime$1(String c, ResultSet resultSet$1) {
        return Option$.MODULE$.apply((Object)resultSet$1.getDate(c)).map((Function1 & Serializable & scala.Serializable)x$19 -> new DateTime(x$19, DateTimeZone.UTC));
    }

    public JdbcPRepo(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Function0<Connection> connection) {
        Seq seq;
        Seq seq2;
        this.persistenceConfig = persistenceConfig;
        this.connection = connection;
        super(effect, modelType, pType);
        JdbcSchema.$init$(this);
        JdbcCreate.$init$(this);
        JdbcRetrieve.$init$(this);
        JdbcQuery.$init$(this);
        JdbcUpdate.$init$(this);
        JdbcDelete.$init$(this);
        this.logger = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType((Object)this));
        this.tableName = stringUtil$.MODULE$.camelToUnderscore(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
        Option option = this.realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq2 = (Seq)key.partitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        this.partitionComponents = seq2;
        Option option2 = this.realizedPType().primaryKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq = (Seq)key.postPartitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        this.postPartitionComponents = seq;
        this.primaryKeyComponents = (Seq)this.partitionComponents().$plus$plus(this.postPartitionComponents(), Seq$.MODULE$.canBuildFrom());
        this.actualizedComponents = (Set)this.indexedComponents().$plus$plus(this.primaryKeyComponents());
        this.emblematicToJsonTranslator = new EmblematicToJsonTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$jdbc$JdbcPRepo$$super$modelType().emblematic();
            }
        };
        this.jsonToEmblematicTranslator = new JsonToEmblematicTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$jdbc$JdbcPRepo$$super$modelType().emblematic();
            }
        };
    }
}

