/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.Serializable;
import journal.Debug;
import journal.Debug$;
import longevity.exceptions.persistence.WriteConflictException;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.cassandra.CassandraPRepo;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00154\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C0\u0003\u001f\r\u000b7o]1oIJ\fW\u000b\u001d3bi\u0016T!a\u0001\u0003\u0002\u0013\r\f7o]1oIJ\f'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\t%aR,L\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0019\u0012A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003Q\u0001\"aC\u000b\n\u0005Ya!\u0001B+oSRDQ\u0001\u0007\u0001\u0005\u0002e\ta!\u001e9eCR,GC\u0001\u000e0!\rYB\u0004\u000b\u0007\u0001\t\u0015i\u0002A1\u0001\u001f\u0005\u00051UCA\u0010'#\t\u00013\u0005\u0005\u0002\fC%\u0011!\u0005\u0004\u0002\b\u001d>$\b.\u001b8h!\tYA%\u0003\u0002&\u0019\t\u0019\u0011I\\=\u0005\u000b\u001db\"\u0019A\u0010\u0003\u0003}\u00032!\u000b\u0016-\u001b\u0005!\u0011BA\u0016\u0005\u0005\u0019\u00016\u000b^1uKB\u00111$\f\u0003\u0006]\u0001\u0011\ra\b\u0002\u0002!\")\u0001g\u0006a\u0001Q\u0005)1\u000f^1uK\")!\u0007\u0001C\u0005g\u0005\u0019\"-\u001b8e+B$\u0017\r^3Ti\u0006$X-\\3oiR\u0019A\u0007Q!\u0011\u0005UrT\"\u0001\u001c\u000b\u0005]B\u0014\u0001B2pe\u0016T!!\u000f\u001e\u0002\r\u0011\u0014\u0018N^3s\u0015\tYD(\u0001\u0005eCR\f7\u000f^1y\u0015\u0005i\u0014aA2p[&\u0011qH\u000e\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011\u0015\u0001\u0014\u00071\u0001)\u0011\u0015\u0011\u0015\u00071\u0001\u000b\u0003)\u0011xn\u001e,feNLwN\u001c\u0005\t\t\u0002A)\u0019!C\u0005\u000b\u0006yQ\u000f\u001d3bi\u0016\u001cF/\u0019;f[\u0016tG/F\u0001G!\t)t)\u0003\u0002Im\t\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\t\u000b)\u0003A\u0011B&\u0002\u0013U\u0004H-\u0019;f\u0007FdW#\u0001'\u0011\u00055#fB\u0001(S!\tyE\"D\u0001Q\u0015\t\t&#\u0001\u0004=e>|GOP\u0005\u0003'2\ta\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111\u000b\u0004\u0005\u00061\u0002!IaS\u0001\u0012G>dW/\u001c8BgNLwM\\7f]R\u001c\b\"\u0002.\u0001\t\u0013Y\u0015aF<ji\"|W\u000f\u001e'pG.LgnZ+qI\u0006$XmQ9m\u0011\u0015a\u0006\u0001\"\u0003L\u0003Q9\u0018\u000e\u001e5M_\u000e\\\u0017N\\4Va\u0012\fG/Z\"rY\u0012)a\f\u0001b\u0001?\t\tQ\nE\u0003aC\u000e$G&D\u0001\u0003\u0013\t\u0011'A\u0001\bDCN\u001c\u0018M\u001c3sCB\u0013V\r]8\u0011\u0005ma\u0002CA\u000e^\u0001")
public interface CassandraUpdate<F, M, P> {
    public static /* synthetic */ Object update$(CassandraUpdate $this, PState state) {
        return $this.update(state);
    }

    default public F update(PState<P> state) {
        Object fs = ((PRepo)((Object)this)).effect().pure(state);
        Object fss = ((PRepo)((Object)this)).effect().map(fs, (Function1 & Serializable & scala.Serializable)s -> {
            Object object = ((CassandraPRepo)this).logger().backend().isDebugEnabled() ? ((CassandraPRepo)this).logger().handler().apply((Object)new Debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CassandraPRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})), Debug$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
            ((PRepo)((Object)this)).validateStablePrimaryKey(s);
            return new Tuple2(s, s.update(((CassandraPRepo)this).persistenceConfig().optimisticLocking(), ((CassandraPRepo)this).persistenceConfig().writeTimestamps()));
        });
        Object fsr = ((PRepo)((Object)this)).effect().mapBlocking(fss, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PState oldState = (PState)tuple2._1();
            PState newState = (PState)tuple2._2();
            ResultSet resultSet = ((Session)((CassandraPRepo)this).session().apply()).execute((Statement)this.bindUpdateStatement(newState, oldState.rowVersionOrNull()));
            Tuple2 tuple22 = new Tuple2((Object)newState, (Object)resultSet);
            return tuple22;
        });
        return ((PRepo)((Object)this)).effect().map(fsr, (Function1 & Serializable & scala.Serializable)x0$2 -> {
            PState s;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                boolean updateSuccess;
                s = (PState)tuple2._1();
                ResultSet r = (ResultSet)tuple2._2();
                if (((CassandraPRepo)this).persistenceConfig().optimisticLocking() && !(updateSuccess = r.one().getBool(0))) {
                    throw new WriteConflictException(s);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object object = ((CassandraPRepo)this).logger().backend().isDebugEnabled() ? ((CassandraPRepo)this).logger().handler().apply((Object)new Debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done executing CassandraPRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})), Debug$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
            PState pState = s;
            return pState;
        });
    }

    private BoundStatement bindUpdateStatement(PState<P> state, Object rowVersion) {
        Seq seq;
        if (((CassandraPRepo)this).persistenceConfig().optimisticLocking()) {
            Seq<Object> seq2 = ((CassandraPRepo)this).updateColumnValues(state, false);
            seq = (Seq)((SeqLike)((CassandraPRepo)this).whereBindings(state).$plus$plus$colon(seq2, Seq$.MODULE$.canBuildFrom())).$colon$plus(rowVersion, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq<Object> seq3 = ((CassandraPRepo)this).updateColumnValues(state, false);
            seq = (Seq)((CassandraPRepo)this).whereBindings(state).$plus$plus$colon(seq3, Seq$.MODULE$.canBuildFrom());
        }
        Seq columnBindings = seq;
        Object object = ((CassandraPRepo)this).logger().backend().isDebugEnabled() ? ((CassandraPRepo)this).logger().handler().apply((Object)new Debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoking CQL: ", " with bindings: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement().getQueryString(), columnBindings})), Debug$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        return this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement().bind((Object[])columnBindings.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public static /* synthetic */ PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement$(CassandraUpdate $this) {
        return $this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement();
    }

    default public PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement() {
        return ((CassandraPRepo)this).preparedStatement(this.updateCql());
    }

    private String updateCql() {
        return ((CassandraPRepo)this).persistenceConfig().optimisticLocking() ? this.withLockingUpdateCql() : this.withoutLockingUpdateCql();
    }

    private String columnAssignments() {
        return ((TraversableOnce)((CassandraPRepo)this).updateColumnNames(false).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    private String withoutLockingUpdateCql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n  |UPDATE ", "\n  |SET\n  |  ", "\n  |WHERE\n  |  ", "\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraPRepo)this).tableName(), this.columnAssignments(), ((CassandraPRepo)this).whereAssignments()})))).stripMargin();
    }

    private String withLockingUpdateCql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "\n  |IF\n  |  row_version = :row_version\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.withoutLockingUpdateCql()})))).stripMargin();
    }

    public static void $init$(CassandraUpdate $this) {
    }
}

