/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import journal.Logger;
import journal.Logger$;
import longevity.config.PersistenceConfig;
import longevity.effect.Effect;
import longevity.emblem.emblematic.Emblematic;
import longevity.emblem.emblematic.traversors.sync.EmblematicToJsonTranslator;
import longevity.emblem.emblematic.traversors.sync.JsonToEmblematicTranslator;
import longevity.emblem.exceptions.CouldNotTraverseException;
import longevity.emblem.stringUtil$;
import longevity.exceptions.persistence.NotInDomainModelTranslationException;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.model.ptype.Key;
import longevity.model.query.Query;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.cassandra.CassandraCreate;
import longevity.persistence.cassandra.CassandraDelete;
import longevity.persistence.cassandra.CassandraId;
import longevity.persistence.cassandra.CassandraPRepo$;
import longevity.persistence.cassandra.CassandraQuery;
import longevity.persistence.cassandra.CassandraQuery$FilterInfo$;
import longevity.persistence.cassandra.CassandraRetrieve;
import longevity.persistence.cassandra.CassandraSchema;
import longevity.persistence.cassandra.CassandraUpdate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import streamadapter.Chunkerator;

@ScalaSignature(bytes="\u0006\u0001\rug!B\u0001\u0003\u0001\u0019A!AD\"bgN\fg\u000e\u001a:b!J+\u0007o\u001c\u0006\u0003\u0007\u0011\t\u0011bY1tg\u0006tGM]1\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\nY>tw-\u001a<jif,B!\u0003\t\"IMA\u0001A\u0003\u0014+[A\u001ad\u0007E\u0003\f\u00199\u00013%D\u0001\u0005\u0013\tiAAA\u0003Q%\u0016\u0004x\u000e\u0005\u0002\u0010!1\u0001A!B\t\u0001\u0005\u0004\u0019\"!\u0001$\u0004\u0001U\u0011ACH\t\u0003+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011qAT8uQ&tw\r\u0005\u0002\u00179%\u0011Qd\u0006\u0002\u0004\u0003:LH!B\u0010\u0011\u0005\u0004!\"!A0\u0011\u0005=\tC!\u0002\u0012\u0001\u0005\u0004!\"!A'\u0011\u0005=!C!B\u0013\u0001\u0005\u0004!\"!\u0001)\u0011\u000b\u001dBc\u0002I\u0012\u000e\u0003\tI!!\u000b\u0002\u0003\u001f\r\u000b7o]1oIJ\f7k\u00195f[\u0006\u0004RaJ\u0016\u000fA\rJ!\u0001\f\u0002\u0003\u001f\r\u000b7o]1oIJ\f7I]3bi\u0016\u0004Ra\n\u0018\u000fA\rJ!a\f\u0002\u0003#\r\u000b7o]1oIJ\f'+\u001a;sS\u00164X\rE\u0003(c9\u00013%\u0003\u00023\u0005\tq1)Y:tC:$'/Y)vKJL\b#B\u00145\u001d\u0001\u001a\u0013BA\u001b\u0003\u0005=\u0019\u0015m]:b]\u0012\u0014\u0018-\u00169eCR,\u0007#B\u00148\u001d\u0001\u001a\u0013B\u0001\u001d\u0003\u0005=\u0019\u0015m]:b]\u0012\u0014\u0018\rR3mKR,\u0007\"\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001eA\u0003\u0019)gMZ3diB\u0019AH\u0010\b\u000e\u0003uR!A\u000f\u0004\n\u0005}j$AB#gM\u0016\u001cG/\u0003\u0002;\u0019!I!\t\u0001B\u0001B\u0003%1)S\u0001\n[>$W\r\u001c+za\u0016\u00042\u0001R$!\u001b\u0005)%B\u0001$\u0007\u0003\u0015iw\u000eZ3m\u0013\tAUIA\u0005N_\u0012,G\u000eV=qK&\u0011!\t\u0004\u0005\n\u0017\u0002\u0011\t\u0011)A\u0005\u0019>\u000bQ\u0001\u001d+za\u0016\u0004B\u0001R'!G%\u0011a*\u0012\u0002\u0006!RK\b/Z\u0005\u0003\u00172A\u0001\"\u0015\u0001\u0003\u0006\u0004%\tBU\u0001\u0012a\u0016\u00148/[:uK:\u001cWmQ8oM&<W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y3\u0011AB2p]\u001aLw-\u0003\u0002Y+\n\t\u0002+\u001a:tSN$XM\\2f\u0007>tg-[4\t\u0011i\u0003!\u0011!Q\u0001\nM\u000b!\u0003]3sg&\u001cH/\u001a8dK\u000e{gNZ5hA!AA\f\u0001BC\u0002\u0013EQ,A\u0004tKN\u001c\u0018n\u001c8\u0016\u0003y\u00032AF0b\u0013\t\u0001wCA\u0005Gk:\u001cG/[8oaA\u0011!m[\u0007\u0002G*\u0011A-Z\u0001\u0005G>\u0014XM\u0003\u0002gO\u00061AM]5wKJT!\u0001[5\u0002\u0011\u0011\fG/Y:uCbT\u0011A[\u0001\u0004G>l\u0017B\u00017d\u0005\u001d\u0019Vm]:j_:D\u0001B\u001c\u0001\u0003\u0002\u0003\u0006IAX\u0001\tg\u0016\u001c8/[8oA!)\u0001\u000f\u0001C\u0005c\u00061A(\u001b8jiz\"bA]:ukZ<\b#B\u0014\u0001\u001d\u0001\u001a\u0003\"\u0002\u001ep\u0001\u0004Y\u0004\"\u0002\"p\u0001\u0004\u0019\u0005\"B&p\u0001\u0004a\u0005\"B)p\u0001\u0004\u0019\u0006\"\u0002/p\u0001\u0004q\u0006bB=\u0001\u0005\u0004%\tB_\u0001\u0007Y><w-\u001a:\u0016\u0003m\u0004\"\u0001`@\u000e\u0003uT\u0011A`\u0001\bU>,(O\\1m\u0013\r\t\t! \u0002\u0007\u0019><w-\u001a:\t\u000f\u0005\u0015\u0001\u0001)A\u0005w\u00069An\\4hKJ\u0004\u0003BCA\u0005\u0001\t\u0007I\u0011\u0003\u0002\u0002\f\u0005IA/\u00192mK:\u000bW.Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019bF\u0007\u0003\u0003+Q1!a\u0006\u0013\u0003\u0019a$o\\8u}%\u0019\u00111D\f\u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\r\tYb\u0006\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u000e\u0005QA/\u00192mK:\u000bW.\u001a\u0011\t\u0013\u0005%\u0002A1A\u0005\u0012\u0005-\u0012a\u00059beRLG/[8o\u0007>l\u0007o\u001c8f]R\u001cXCAA\u0017!\u0019\ty#!\u000e\u0002:5\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0012AC2pY2,7\r^5p]&!\u0011qGA\u0019\u0005\r\u0019V-\u001d\u0019\u0007\u0003w\tI%!\u0017\u0011\u0013\u0005u\u00121I\u0012\u0002H\u0005]SBAA \u0015\r\t\t%R\u0001\te\u0016\fG.\u001b>fI&!\u0011QIA \u0005U\u0011V-\u00197ju\u0016$\u0007K]8q\u0007>l\u0007o\u001c8f]R\u00042aDA%\t-\tY%!\u0014\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\u0007}#\u0013\u0007\u0003\u0006\u0002P\u0005E\u0013\u0011!A\u0001\u0003+\n\u0001\u0002J1o_:4WO\u001c\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002.\u0005!\u0002/\u0019:uSRLwN\\\"p[B|g.\u001a8ug\u0002Z\u0001\u0001E\u0002\u0010\u00033\"1\"a\u0017\u0002N\u0005\u0005\t\u0011!B\u0001)\t\u0019q\f\n\u001a\t\u0013\u0005}\u0003A1A\u0005\u0012\u0005\u0005\u0014a\u00069pgR\u0004\u0016M\u001d;ji&|gnQ8na>tWM\u001c;t+\t\t\u0019\u0007\u0005\u0004\u00020\u0005U\u0012Q\r\u0019\u0007\u0003O\nY'a\u001e\u0011\u0013\u0005u\u00121I\u0012\u0002j\u0005U\u0004cA\b\u0002l\u0011Y\u0011QNA8\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\ryFe\r\u0005\u000b\u0003\u001f\n\t(!A\u0001\u0002\u0005U\u0003\u0002CA:\u0001\u0001\u0006I!a\u0019\u00021A|7\u000f\u001e)beRLG/[8o\u0007>l\u0007o\u001c8f]R\u001c\b\u0005E\u0002\u0010\u0003o\"1\"!\u001f\u0002p\u0005\u0005\t\u0011!B\u0001)\t\u0019q\f\n\u001b\t\u0013\u0005u\u0004A1A\u0005\u0012\u0005-\u0012\u0001\u00069sS6\f'/_&fs\u000e{W\u000e]8oK:$8\u000f\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA\u0017\u0003U\u0001(/[7bef\\U-_\"p[B|g.\u001a8ug\u0002B\u0011\"!\"\u0001\u0005\u0004%\t\"a\"\u0002)\u0005\u001cG/^1mSj,GmQ8na>tWM\u001c;t+\t\tI\t\u0005\u0004\u0002\f\u0006E\u0015QS\u0007\u0003\u0003\u001bSA!a$\u00022\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003'\u000biIA\u0002TKR\u0004\u0004\"a&\u0002\u001c\u00065\u00161\u0017\t\u000b\u0003{\t\u0019%!'\u0002,\u0006E\u0006cA\b\u0002\u001c\u0012a\u0011QTAP\u0003\u0003\u0005\tQ!\u0001\u0002*\n\u0019q\f\n\u001d\t\u0011\u0005\u0005\u0006\u0001\"\u0005\u0003\u0003G\u000b\u0011#\u001b8eKb,GmQ8na>tWM\u001c;t+\t\t)\u000b\u0005\u0004\u0002\u0010\u0005\u001d\u0016QS\u0005\u0005\u0003'\u000b\t#\u0005\u0002$7A\u0019q\"!,\u0005\u0017\u0005=\u0016qTA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0004?\u0012J\u0004cA\b\u00024\u0012Y\u0011QWAP\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yF%\r\u0019\t\u0011\u0005e\u0006\u0001)A\u0005\u0003\u0013\u000bQ#Y2uk\u0006d\u0017N_3e\u0007>l\u0007o\u001c8f]R\u001c\b\u0005C\u0005\u0002>\u0002\u0011\r\u0011\"\u0005\u0002@\u0006QR-\u001c2mK6\fG/[2U_*\u001bxN\u001c+sC:\u001cH.\u0019;peV\u0011\u0011\u0011\u0019\t\u0005\u0003\u0007\f).\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0011\u0019\u0018P\\2\u000b\t\u0005-\u0017QZ\u0001\u000biJ\fg/\u001a:t_J\u001c(\u0002BAh\u0003#\f!\"Z7cY\u0016l\u0017\r^5d\u0015\r\t\u0019NB\u0001\u0007K6\u0014G.Z7\n\t\u0005]\u0017Q\u0019\u0002\u001b\u000b6\u0014G.Z7bi&\u001cGk\u001c&t_:$&/\u00198tY\u0006$xN\u001d\u0005\t\u00037\u0004\u0001\u0015!\u0003\u0002B\u0006YR-\u001c2mK6\fG/[2U_*\u001bxN\u001c+sC:\u001cH.\u0019;pe\u0002B\u0011\"a8\u0001\u0005\u0004%\t\"!9\u00025)\u001cxN\u001c+p\u000b6\u0014G.Z7bi&\u001cGK]1og2\fGo\u001c:\u0016\u0005\u0005\r\b\u0003BAb\u0003KLA!a:\u0002F\nQ\"j]8o)>,UN\u00197f[\u0006$\u0018n\u0019+sC:\u001cH.\u0019;pe\"A\u00111\u001e\u0001!\u0002\u0013\t\u0019/A\u000ekg>tGk\\#nE2,W.\u0019;jGR\u0013\u0018M\\:mCR|'\u000f\t\u0005\b\u0003_\u0004A\u0011CAy\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u000b\u0005\u0003g\u0014\t\u0001\u0005\u0003\u0002v\u0006}XBAA|\u0015\u0011\tI0a?\u0002\t1\fgn\u001a\u0006\u0003\u0003{\fAA[1wC&!\u0011qDA|\u0011!\u0011\u0019!!<A\u0002\t\u0015\u0011\u0001\u00029s_B\u0004\u0004Ba\u0002\u0003\f\tE!q\u0003\t\u000b\u0003{\t\u0019E!\u0003\u0003\u0010\tU\u0001cA\b\u0003\f\u0011Y!Q\u0002B\u0001\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yF%M\u001d\u0011\u0007=\u0011\t\u0002B\u0006\u0003\u0014\t\u0005\u0011\u0011!A\u0001\u0006\u0003!\"\u0001B0%eA\u00022a\u0004B\f\t-\u0011IB!\u0001\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\t}##'\r\u0005\b\u0005;\u0001A\u0011\u0003B\u0010\u0003)\u00198m\u001c:fIB\u000bG\u000f\u001b\u000b\u0005\u0003g\u0014\t\u0003\u0003\u0005\u0003\u0004\tm\u0001\u0019\u0001B\u0012a!\u0011)C!\u000b\u00030\tU\u0002CCA\u001f\u0003\u0007\u00129C!\f\u00034A\u0019qB!\u000b\u0005\u0017\t-\"\u0011EA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u0012$\u0007E\u0002\u0010\u0005_!1B!\r\u0003\"\u0005\u0005\t\u0011!B\u0001)\t!q\f\n\u001a4!\ry!Q\u0007\u0003\f\u0005o\u0011\t#!A\u0001\u0002\u000b\u0005AC\u0001\u0003`II\"\u0004b\u0002B\u001e\u0001\u0011E!QH\u0001\u000fUN|gn\u0015;sS:<gi\u001c:Q)\u0011\tiAa\u0010\t\u000f\t\u0005#\u0011\ba\u0001G\u0005\t\u0001\u000fC\u0004\u0003F\u0001!\tBa\u0012\u0002#U\u0004H-\u0019;f\u0007>dW/\u001c8OC6,7\u000f\u0006\u0003\u0003J\te\u0003C\u0002B&\u0005+\niA\u0004\u0003\u0003N\tEc\u0002BA\n\u0005\u001fJ\u0011\u0001G\u0005\u0004\u0005':\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003o\u00119FC\u0002\u0003T]A!Ba\u0017\u0003DA\u0005\t\u0019\u0001B/\u0003!I7o\u0011:fCR,\u0007c\u0001\f\u0003`%\u0019!\u0011M\f\u0003\u000f\t{w\u000e\\3b]\"9!Q\r\u0001\u0005\u0012\t\u001d\u0014AE;qI\u0006$XmQ8mk6tg+\u00197vKN$bA!\u001b\u0003r\tm\u0004C\u0002B&\u0005+\u0012Y\u0007E\u0002\u0017\u0005[J1Aa\u001c\u0018\u0005\u0019\te.\u001f*fM\"A!1\u000fB2\u0001\u0004\u0011)(A\u0003ti\u0006$X\r\u0005\u0003\f\u0005o\u001a\u0013b\u0001B=\t\t1\u0001k\u0015;bi\u0016D!Ba\u0017\u0003dA\u0005\t\u0019\u0001B/\u0011\u001d\u0011y\b\u0001C\t\u0005\u0003\u000bA!^;jIR!!1\u0011BH!\u0011\u0011)Ia#\u000e\u0005\t\u001d%\u0002\u0002BE\u0003w\fA!\u001e;jY&!!Q\u0012BD\u0005\u0011)V+\u0013#\t\u0011\tM$Q\u0010a\u0001\u0005kBqAa%\u0001\t#\tY!\u0001\txQ\u0016\u0014X-Q:tS\u001etW.\u001a8ug\"9!q\u0013\u0001\u0005\u0012\te\u0015!D<iKJ,')\u001b8eS:<7\u000f\u0006\u0003\u0003\u001c\nu\u0005CBA\u0018\u0003k\u0011Y\u0007\u0003\u0005\u0003t\tU\u0005\u0019\u0001B;\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005G\u000ba\u0002\u001d:paZ\u000bGNQ5oI&tw-\u0006\u0004\u0003&\nE&Q\u0018\u000b\u0007\u0005W\u00129K!1\t\u0011\t%&q\u0014a\u0001\u0005W\u000b\u0011bY8na>tWM\u001c;1\t\t5&q\u0017\t\u000b\u0003{\t\u0019Ea,\u00036\nm\u0006cA\b\u00032\u0012A!1\u0017BP\u0005\u0004\tIK\u0001\u0002Q!B\u0019qBa.\u0005\u0017\te&qUA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u001a\u0014\u0007E\u0002\u0010\u0005{#qAa0\u0003 \n\u0007ACA\u0001B\u0011\u001d\u0011\tEa(A\u0002\rBqA!2\u0001\t#\u00119-\u0001\bdCN\u001c\u0018M\u001c3sCZ\u000bG.^3\u0015\t\t-$\u0011\u001a\u0005\b\u0005\u0017\u0014\u0019\r1\u0001\u001c\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011y\r\u0001C\t\u0005#\fQbY1tg\u0006tGM]1ECR,G\u0003\u0002Bj\u00053\u0004BA!\"\u0003V&!!q\u001bBD\u0005\u0011!\u0015\r^3\t\u0011\tm'Q\u001aa\u0001\u0005;\f\u0011\u0001\u001a\t\u0005\u0005?\u0014i/\u0004\u0002\u0003b*!!1\u001dBs\u0003\u0011!\u0018.\\3\u000b\t\t\u001d(\u0011^\u0001\u0005U>$\u0017M\u0003\u0002\u0003l\u0006\u0019qN]4\n\t\t=(\u0011\u001d\u0002\t\t\u0006$X\rV5nK\"9!1\u001f\u0001\u0005\u0012\tU\u0018a\u0004:fiJLWM^3Ge>l'k\\<\u0015\t\tU$q\u001f\u0005\t\u0005s\u0014\t\u00101\u0001\u0003|\u0006\u0019!o\\<\u0011\u0007\t\u0014i0C\u0002\u0003\u0000\u000e\u00141AU8x\u0011%\u0019\u0019\u0001\u0001a\u0001\n\u0013\u0019)!\u0001\nqe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\u001cXCAB\u0004!!\tYi!\u0003\u0002\u000e\r5\u0011\u0002BB\u0006\u0003\u001b\u00131!T1q!\r\u00117qB\u0005\u0004\u0007#\u0019'!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"I1Q\u0003\u0001A\u0002\u0013%1qC\u0001\u0017aJ,\u0007/\u0019:fIN#\u0018\r^3nK:$8o\u0018\u0013fcR!1\u0011DB\u0010!\r121D\u0005\u0004\u0007;9\"\u0001B+oSRD!b!\t\u0004\u0014\u0005\u0005\t\u0019AB\u0004\u0003\rAH%\r\u0005\t\u0007K\u0001\u0001\u0015)\u0003\u0004\b\u0005\u0019\u0002O]3qCJ,Gm\u0015;bi\u0016lWM\u001c;tA!91\u0011\u0006\u0001\u0005\u0012\r-\u0012!\u00059sKB\f'/\u001a3Ti\u0006$X-\\3oiR!1QBB\u0017\u0011!\u0019yca\nA\u0002\u00055\u0011aA2rY\"911\u0007\u0001\u0005B\rU\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0001\"CB\u001d\u0001E\u0005I\u0011CB\u001e\u0003q)\b\u000fZ1uK\u000e{G.^7o-\u0006dW/Z:%I\u00164\u0017-\u001e7uII*\"a!\u0010+\t\tu3qH\u0016\u0003\u0007\u0003\u0002Baa\u0011\u0004N5\u00111Q\t\u0006\u0005\u0007\u000f\u001aI%A\u0005v]\u000eDWmY6fI*\u001911J\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004P\r\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I11\u000b\u0001\u0012\u0002\u0013E11H\u0001\u001ckB$\u0017\r^3D_2,XN\u001c(b[\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\t\u001b\r]\u0003\u0001%A\u0002\u0002\u0003%Ia!\u0017J\u0003=\u0019X\u000f]3sI5|G-\u001a7UsB,W#A\"\b\u0011\ru#\u0001#\u0001\u0003\u0007?\nabQ1tg\u0006tGM]1Q%\u0016\u0004x\u000eE\u0002(\u0007C2q!\u0001\u0002\t\u0002\t\u0019\u0019g\u0005\u0003\u0004b\t-\u0004b\u00029\u0004b\u0011\u00051q\r\u000b\u0003\u0007?B\u0001ba\u001b\u0004b\u0011\u00051QN\u0001\u0006CB\u0004H._\u000b\t\u0007_\u001a)h! \u0004\u0002Rq1\u0011OBB\u0007\u000f\u001bYia$\u0004\u0012\u000em\u0006\u0003C\u0014\u0001\u0007g\u001aYha \u0011\u0007=\u0019)\bB\u0004\u0012\u0007S\u0012\raa\u001e\u0016\u0007Q\u0019I\b\u0002\u0004 \u0007k\u0012\r\u0001\u0006\t\u0004\u001f\ruDA\u0002\u0012\u0004j\t\u0007A\u0003E\u0002\u0010\u0007\u0003#a!JB5\u0005\u0004!\u0002b\u0002\u001e\u0004j\u0001\u00071Q\u0011\t\u0005yy\u001a\u0019\bC\u0004C\u0007S\u0002\ra!#\u0011\t\u0011;51\u0010\u0005\b\u0017\u000e%\u0004\u0019ABG!\u0019!Uja\u001f\u0004\u0000!1ak!\u001bA\u0002MC\u0001ba%\u0004j\u0001\u00071QS\u0001\fa>d\u0017PU3q_>\u0003H\u000fE\u0003\u0017\u0007/\u001bY*C\u0002\u0004\u001a^\u0011aa\u00149uS>t\u0007\u0007BBO\u0007C\u0003\u0002b\n\u0001\u0004t\rm4q\u0014\t\u0004\u001f\r\u0005F\u0001DBR\u0007K\u000b\t\u0011!A\u0003\u0002\re&\u0001B0%gIB\u0001ba%\u0004j\u0001\u00071q\u0015\t\u0006-\r]5\u0011\u0016\u0019\u0005\u0007W\u001b\u0019\f\u0005\u0005(\u0001\r56qVBY!\ry1Q\u000f\t\u0004\u001f\ru\u0004cA\b\u00044\u0012a11UBS\u0003\u0003\u0005\tQ!\u0001\u00046F\u00191qW\u000e\u0011\u0007=\u0019\t)E\u0002\u0004\u0000mAa\u0001XB5\u0001\u0004q\u0006bCB`\u0007C\u0012\r\u0011\"\u0001\u0003\u0007\u0003\fACY1tS\u000e$vnQ1tg\u0006tGM]1UsB,WCABb!!\tYi!\u0003\u0004F\u0006M\b\u0007BBd\u0007+\u0004ba!3\u0004P\u000eMWBABf\u0015\t\u0019i-A\u0004usB,7.Z=\n\t\rE71\u001a\u0002\b)f\u0004XmS3z!\ry1Q\u001b\u0003\f\u0007/\u001cI.!A\u0001\u0002\u000b\u0005AC\u0001\u0003`IM\u001a\u0004\"CBn\u0007C\u0002\u000b\u0011BBb\u0003U\u0011\u0017m]5d)>\u001c\u0015m]:b]\u0012\u0014\u0018\rV=qK\u0002\u0002")
public class CassandraPRepo<F, M, P>
extends PRepo<F, M, P>
implements CassandraSchema<F, M, P>,
CassandraCreate<F, M, P>,
CassandraRetrieve<F, M, P>,
CassandraQuery<F, M, P>,
CassandraUpdate<F, M, P>,
CassandraDelete<F, M, P> {
    private final PersistenceConfig persistenceConfig;
    private final Function0<Session> session;
    private final Logger logger;
    private final String tableName;
    private final Seq<RealizedPropComponent<P, ?, ?>> partitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents;
    private final Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents;
    private final EmblematicToJsonTranslator emblematicToJsonTranslator;
    private final JsonToEmblematicTranslator jsonToEmblematicTranslator;
    private Map<String, PreparedStatement> preparedStatements;
    private PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    private PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    private volatile CassandraQuery$FilterInfo$ FilterInfo$module;
    private Map<RealizedKey<M, P, ?>, PreparedStatement> longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements;
    private PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    private volatile byte bitmap$0;

    public static <F, M, P> CassandraPRepo<F, M, P> apply(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Option<CassandraPRepo<F, M, ? super P>> option, Function0<Session> function0) {
        return CassandraPRepo$.MODULE$.apply(effect, modelType, pType, persistenceConfig, option, function0);
    }

    @Override
    public F delete(PState<P> state) {
        return (F)CassandraDelete.delete$(this, state);
    }

    @Override
    public PreparedStatement deleteStatement() {
        return CassandraDelete.deleteStatement$(this);
    }

    @Override
    public F update(PState<P> state) {
        return (F)CassandraUpdate.update$(this, state);
    }

    @Override
    public Chunkerator<PState<P>> queryToChunkerator(Query<P> query) {
        return CassandraQuery.queryToChunkerator$(this, query);
    }

    @Override
    public String queryWhereClause(CassandraQuery.FilterInfo filterInfo) {
        return CassandraQuery.queryWhereClause$(this, filterInfo);
    }

    @Override
    public <V> F retrieve(V v, Key<M, P, V> evidence$1) {
        return (F)CassandraRetrieve.retrieve$(this, v, evidence$1);
    }

    @Override
    public Option<PState<P>> retrieveFromBoundStatement(BoundStatement statement) {
        return CassandraRetrieve.retrieveFromBoundStatement$(this, statement);
    }

    @Override
    public String keyValSelectStatementConjunction(RealizedKey<M, P, ?> key) {
        return CassandraRetrieve.keyValSelectStatementConjunction$(this, key);
    }

    @Override
    public F create(P p) {
        return (F)CassandraCreate.create$(this, p);
    }

    @Override
    public void createSchemaBlocking() {
        CassandraSchema.createSchemaBlocking$(this);
    }

    @Override
    public void createTable() {
        CassandraSchema.createTable$(this);
    }

    @Override
    public void addColumn(String columnName, String columnType) {
        CassandraSchema.addColumn$(this, columnName, columnType);
    }

    @Override
    public <A> String componentToCassandraType(RealizedPropComponent<? super P, ?, A> component2) {
        return CassandraSchema.componentToCassandraType$(this, component2);
    }

    @Override
    public void createIndexes() {
        CassandraSchema.createIndexes$(this);
    }

    @Override
    public void createIndex(RealizedPropComponent<? super P, ?, ?> component2) {
        CassandraSchema.createIndex$(this, component2);
    }

    @Override
    public void createIndex(String indexName, String columnName) {
        CassandraSchema.createIndex$(this, indexName, columnName);
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce = CassandraDelete.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$lzycompute() : this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement = CassandraUpdate.longevity$persistence$cassandra$CassandraUpdate$$updateStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement$lzycompute() : this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    }

    @Override
    public CassandraQuery$FilterInfo$ FilterInfo() {
        if (this.FilterInfo$module == null) {
            this.FilterInfo$lzycompute$1();
        }
        return this.FilterInfo$module;
    }

    @Override
    public Map<RealizedKey<M, P, ?>, PreparedStatement> longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements() {
        return this.longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements;
    }

    @Override
    public void longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements_$eq(Map<RealizedKey<M, P, ?>, PreparedStatement> x$1) {
        this.longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements = x$1;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.longevity$persistence$cassandra$CassandraCreate$$insertStatement = CassandraCreate.longevity$persistence$cassandra$CassandraCreate$$insertStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.longevity$persistence$cassandra$CassandraCreate$$insertStatement$lzycompute() : this.longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    }

    public /* synthetic */ ModelType longevity$persistence$cassandra$CassandraPRepo$$super$modelType() {
        return super.modelType();
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public Function0<Session> session() {
        return this.session;
    }

    public Logger logger() {
        return this.logger;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> partitionComponents() {
        return this.partitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents() {
        return this.postPartitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents() {
        return this.primaryKeyComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents() {
        return this.actualizedComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> indexedComponents() {
        Set keyComponents = (Set)((TraversableLike)this.realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CassandraPRepo.$anonfun$indexedComponents$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.realizedProp().realizedPropComponents(), Set$.MODULE$.canBuildFrom());
        Set props = (Set)super.pType().indexSet().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.props(), Set$.MODULE$.canBuildFrom());
        Set realizedProps = (Set)props.map((Function1 & Serializable & scala.Serializable)x$6 -> (RealizedProp)this.realizedPType().realizedProps().apply(x$6), Set$.MODULE$.canBuildFrom());
        Set indexComponents = (Set)((GenericTraversableTemplate)realizedProps.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.realizedPropComponents(), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (Set)keyComponents.$plus$plus((GenTraversableOnce)indexComponents);
    }

    public EmblematicToJsonTranslator emblematicToJsonTranslator() {
        return this.emblematicToJsonTranslator;
    }

    public JsonToEmblematicTranslator jsonToEmblematicTranslator() {
        return this.jsonToEmblematicTranslator;
    }

    public String columnName(RealizedPropComponent<?, ?, ?> prop) {
        return "prop_" + this.scoredPath(prop);
    }

    public String scoredPath(RealizedPropComponent<?, ?, ?> prop) {
        return prop.outerPropPath().inlinedPath().replace('.', '_');
    }

    public String jsonStringForP(P p) {
        String string;
        try {
            JsonAST.JValue x$21 = this.emblematicToJsonTranslator().translate(p, this.pTypeKey());
            Formats x$22 = JsonMethods$.MODULE$.render$default$2(x$21);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$21, x$22));
        }
        catch (CouldNotTraverseException e) {
            throw new NotInDomainModelTranslationException(e.typeKey().name(), e);
        }
        return string;
    }

    public Seq<String> updateColumnNames(boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnNames = isCreate ? this.names$1(this.actualizedComponents()) : this.names$1(this.indexedComponents());
        String string = "p";
        Seq withP = (Seq)componentColumnNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            String string2 = "created_timestamp";
            String string3 = "updated_timestamp";
            seq3 = (Seq)((SeqLike)withP.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            String string4 = "row_version";
            seq2 = (Seq)withDateTimes.$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            String string5 = "id";
            seq = (Seq)withRowVersion.$plus$colon((Object)string5, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        Seq withId = seq;
        return withId;
    }

    public boolean updateColumnNames$default$1() {
        return true;
    }

    public Seq<Object> updateColumnValues(PState<P> state, boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnValues = isCreate ? this.values$1(this.actualizedComponents(), state) : this.values$1(this.indexedComponents(), state);
        String string = this.jsonStringForP(state.get());
        Seq withP = (Seq)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            Object object = state.createdTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.cassandraValue(value)).orNull(Predef$.MODULE$.$conforms());
            Object object2 = state.updatedTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.cassandraValue(value)).orNull(Predef$.MODULE$.$conforms());
            seq3 = (Seq)((SeqLike)withP.$plus$colon(object2, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            Object object = state.rowVersionOrNull();
            seq2 = (Seq)withDateTimes.$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            UUID uUID = this.uuid(state);
            seq = (Seq)withRowVersion.$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        Seq withId = seq;
        return withId;
    }

    public boolean updateColumnValues$default$2() {
        return true;
    }

    public UUID uuid(PState<P> state) {
        return ((CassandraId)state.id().get()).uuid();
    }

    public String whereAssignments() {
        return this.hasPrimaryKey() ? ((TraversableOnce)((TraversableLike)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString("\nAND\n  ") : "id = :id";
    }

    public Seq<Object> whereBindings(PState<P> state) {
        return this.hasPrimaryKey() ? (Seq)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.outerPropPath().get().apply(state.get()), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{((CassandraId)state.id().get()).uuid()}));
    }

    private <PP, A> Object propValBinding(RealizedPropComponent<PP, ?, A> component2, P p) {
        return this.cassandraValue(component2.outerPropPath().get().apply(p));
    }

    public Object cassandraValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        } else if (object2 instanceof DateTime) {
            DateTime dateTime = (DateTime)object2;
            object = this.cassandraDate(dateTime);
        } else {
            object = value;
        }
        return object;
    }

    public Date cassandraDate(DateTime d) {
        return new Date(d.getMillis());
    }

    public PState<P> retrieveFromRow(Row row) {
        Tuple2 tuple2;
        None$ id = !this.hasPrimaryKey() ? new Some(new CassandraId(row.getUUID("id"))) : None$.MODULE$;
        None$ rowVersion = this.persistenceConfig().optimisticLocking() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong("row_version"))) : None$.MODULE$;
        Tuple2 tuple22 = tuple2 = this.persistenceConfig().writeTimestamps() ? new Tuple2((Object)CassandraPRepo.toOptDateTime$1("created_timestamp", row), (Object)CassandraPRepo.toOptDateTime$1("updated_timestamp", row)) : new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option createdTimestamp = (Option)tuple2._1();
        Option updatedTimestamp = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)createdTimestamp, (Object)updatedTimestamp);
        Tuple2 tuple24 = tuple23;
        Option createdTimestamp2 = (Option)tuple24._1();
        Option updatedTimestamp2 = (Option)tuple24._2();
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(row.getString("p")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Object p = this.jsonToEmblematicTranslator().translate(json, this.pTypeKey());
        return PState$.MODULE$.apply(id, (Option<Object>)rowVersion, (Option<DateTime>)createdTimestamp2, (Option<DateTime>)updatedTimestamp2, p);
    }

    private Map<String, PreparedStatement> preparedStatements() {
        return this.preparedStatements;
    }

    private void preparedStatements_$eq(Map<String, PreparedStatement> x$1) {
        this.preparedStatements = x$1;
    }

    public PreparedStatement preparedStatement(String cql) {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if (!this.preparedStatements().contains((Object)cql)) {
                this.preparedStatements_$eq((Map<String, PreparedStatement>)this.preparedStatements().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cql), (Object)((Session)this.session().apply()).prepare(cql))));
            }
        }
        return (PreparedStatement)this.preparedStatements().apply((Object)cql);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CassandraPRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    private final void FilterInfo$lzycompute$1() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if (this.FilterInfo$module == null) {
                this.FilterInfo$module = new CassandraQuery$FilterInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$indexedComponents$1(RealizedKey x$3) {
        return x$3 instanceof RealizedPrimaryKey;
    }

    private final Seq names$1(Set components) {
        return (Seq)((SetLike)components.map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private final Seq values$1(Set components, PState state$1) {
        return (Seq)((TraversableLike)components.toSeq().sortBy((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)component2 -> this.propValBinding((RealizedPropComponent)component2, state$1.get()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Option toOptDateTime$1(String c, Row row$1) {
        return Option$.MODULE$.apply((Object)row$1.getTimestamp(c)).map((Function1 & Serializable & scala.Serializable)x$19 -> new DateTime(x$19, DateTimeZone.UTC));
    }

    public CassandraPRepo(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Function0<Session> session) {
        Seq seq;
        Seq seq2;
        this.persistenceConfig = persistenceConfig;
        this.session = session;
        super(effect, modelType, pType);
        CassandraSchema.$init$(this);
        CassandraCreate.$init$(this);
        CassandraRetrieve.$init$(this);
        CassandraQuery.$init$(this);
        CassandraUpdate.$init$(this);
        CassandraDelete.$init$(this);
        this.logger = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType((Object)this));
        this.tableName = stringUtil$.MODULE$.camelToUnderscore(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
        Option option = this.realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq2 = (Seq)key.partitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        this.partitionComponents = seq2;
        Option option2 = this.realizedPType().primaryKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq = (Seq)key.postPartitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        this.postPartitionComponents = seq;
        this.primaryKeyComponents = (Seq)this.partitionComponents().$plus$plus(this.postPartitionComponents(), Seq$.MODULE$.canBuildFrom());
        this.actualizedComponents = (Set)this.indexedComponents().$plus$plus(this.primaryKeyComponents());
        this.emblematicToJsonTranslator = new EmblematicToJsonTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$cassandra$CassandraPRepo$$super$modelType().emblematic();
            }
        };
        this.jsonToEmblematicTranslator = new JsonToEmblematicTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$cassandra$CassandraPRepo$$super$modelType().emblematic();
            }
        };
        this.preparedStatements = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

