/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.cassandra.CassandraPRepo;
import longevity.persistence.cassandra.CassandraPRepo$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055bAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u0002\"\ty1)Y:tC:$'/Y*dQ\u0016l\u0017M\u0003\u0002\u0004\t\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000b\u0019\t1\u0002]3sg&\u001cH/\u001a8dK*\tq!A\u0005m_:<WM^5usV1\u0011\"a\u0005\u0002\u001e5\u001b\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0014\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001\u000b\u0011\u0005-)\u0012B\u0001\f\r\u0005\u0011)f.\u001b;\t\ra\u0001A\u0011\u0003\u0003\u0014\u0003Q\u0019'/Z1uKN\u001b\u0007.Z7b\u00052|7m[5oO\")!\u0004\u0001C\t'\u0005Y1M]3bi\u0016$\u0016M\u00197f\u0011\u0015a\u0002\u0001\"\u0003\u001e\u0003\u0015IG\rR3g+\u0005q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007'R\u0014\u0018N\\4\t\u000b\u001d\u0002A\u0011\u0002\u0015\u0002;\u0005\u001cG/^1mSj,GmQ8na>tWM\u001c;D_2,XN\u001c#fMN,\u0012!\u000b\t\u0003UEr!aK\u0018\u0011\u00051bQ\"A\u0017\u000b\u00059\u0012\u0012A\u0002\u001fs_>$h(\u0003\u00021\u0019\u00051\u0001K]3eK\u001aL!!\n\u001a\u000b\u0005Ab\u0001\"\u0002\u001b\u0001\t\u0013A\u0013!\u00049sS6\f'/_&fs\u0012+g\rC\u00037\u0001\u0011%\u0001&\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7og\")\u0001\b\u0001C\u0005Q\u0005!\u0002o\\:u!\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]NDQA\u000f\u0001\u0005\nm\n\u0011bY8mk6tG)\u001a4\u0015\u0005%b\u0004\"B\u001f:\u0001\u0004q\u0014!C2p[B|g.\u001a8ua\u0011y\u0014j\u0016.\u0011\u000b\u0001+uIV-\u000e\u0003\u0005S!AQ\"\u0002\u0011I,\u0017\r\\5{K\u0012T!\u0001\u0012\u0004\u0002\u000b5|G-\u001a7\n\u0005\u0019\u000b%!\u0006*fC2L'0\u001a3Qe>\u00048i\\7q_:,g\u000e\u001e\t\u0003\u0011&c\u0001\u0001B\u0005Ky\u0005\u0005\t\u0011!B\u0001\u0017\n\u0019q\fJ\u0019\u0012\u00051\u001b\u0006C\u0001%N\t\u0015q\u0005A1\u0001P\u0005\u0005\u0001\u0016C\u0001)T!\tY\u0011+\u0003\u0002S\u0019\t9aj\u001c;iS:<\u0007CA\u0006U\u0013\t)FBA\u0002B]f\u0004\"\u0001S,\u0005\u0013ac\u0014\u0011!A\u0001\u0006\u0003y%aA0%eA\u0011\u0001J\u0017\u0003\n7r\n\t\u0011!A\u0003\u0002=\u00131a\u0018\u00134\u0011\u0015i\u0006\u0001\"\u0005_\u0003%\tG\rZ\"pYVlg\u000eF\u0002\u0015?\u0006DQ\u0001\u0019/A\u0002%\n!bY8mk6tg*Y7f\u0011\u0015\u0011G\f1\u0001*\u0003)\u0019w\u000e\\;n]RK\b/\u001a\u0005\u0006I\u0002!\t\"Z\u0001\u0019G>l\u0007o\u001c8f]R$vnQ1tg\u0006tGM]1UsB,WC\u00014r)\tIs\rC\u0003>G\u0002\u0007\u0001\u000eM\u0002jW:\u0004R\u0001Q#k[B\u0004\"\u0001S6\u0005\u00131<\u0017\u0011!A\u0001\u0006\u0003Y%aA0%iA\u0011\u0001J\u001c\u0003\n_\u001e\f\t\u0011!A\u0003\u0002=\u00131a\u0018\u00136!\tA\u0015\u000fB\u0003sG\n\u0007qJA\u0001B\u0011\u0015!\b\u0001\"\u0005\u0014\u00035\u0019'/Z1uK&sG-\u001a=fg\")a\u000f\u0001C\to\u0006Y1M]3bi\u0016Le\u000eZ3y)\t!\u0002\u0010C\u0003>k\u0002\u0007\u0011\u0010M\u0003{y~\f)\u0001\u0005\u0004A\u000bnt\u00181\u0001\t\u0003\u0011r$\u0011\" =\u0002\u0002\u0003\u0005)\u0011A&\u0003\u0007}#c\u0007\u0005\u0002I\u007f\u0012Q\u0011\u0011\u0001=\u0002\u0002\u0003\u0005)\u0011A(\u0003\u0007}#s\u0007E\u0002I\u0003\u000b!!\"a\u0002y\u0003\u0003\u0005\tQ!\u0001P\u0005\ryF\u0005\u000f\u0005\u0007m\u0002!\t\"a\u0003\u0015\u000bQ\ti!!\u0005\t\u000f\u0005=\u0011\u0011\u0002a\u0001S\u0005I\u0011N\u001c3fq:\u000bW.\u001a\u0005\u0007A\u0006%\u0001\u0019A\u0015\u0005\u000f\u0005U\u0001A1\u0001\u0002\u0018\t\ta)F\u0002P\u00033!q!a\u0007\u0002\u0014\t\u0007qJA\u0001`\t\u0019\ty\u0002\u0001b\u0001\u001f\n\tQ\nE\u0005\u0002$\u0005\u0015\u0012\u0011FA\u0016\u00196\t!!C\u0002\u0002(\t\u0011abQ1tg\u0006tGM]1Q%\u0016\u0004x\u000eE\u0002I\u0003'\u00012\u0001SA\u000f\u0001")
public interface CassandraSchema<F, M, P> {
    public static /* synthetic */ void createSchemaBlocking$(CassandraSchema $this) {
        $this.createSchemaBlocking();
    }

    default public void createSchemaBlocking() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug("creating schema for table {}", new Object[]{((CassandraPRepo)this).tableName()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.createTable();
        this.createIndexes();
        if (((CassandraPRepo)this).persistenceConfig().optimisticLocking()) {
            this.addColumn("row_version", "bigint");
        }
        if (((CassandraPRepo)this).persistenceConfig().writeTimestamps()) {
            this.addColumn("created_timestamp", "timestamp");
            this.addColumn("updated_timestamp", "timestamp");
        }
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug("done creating schema for table {}", new Object[]{((CassandraPRepo)this).tableName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ void createTable$(CassandraSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", ",\n    |  ", "\n    |)\n    |WITH COMPRESSION = { 'sstable_compression': 'SnappyCompressor' };\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraPRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug("executing CQL: {}", new Object[]{createTable});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((Session)((CassandraPRepo)this).session().apply()).execute(createTable);
    }

    private String idDef() {
        return ((PRepo)((Object)this)).hasPrimaryKey() ? "" : "\n  id uuid,";
    }

    private String actualizedComponentColumnDefs() {
        return ((TraversableOnce)((CassandraPRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component2 -> this.columnDef((RealizedPropComponent)component2), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String primaryKeyDef() {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(((PRepo)((Object)this)).hasPrimaryKey(), ((CassandraPRepo)this).postPartitionComponents().nonEmpty());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns(), this.postPartitionColumns()}));
            }
        }
        if (sp2 == null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (!bl || bl3) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()}));
    }

    private String partitionColumns() {
        return ((TraversableOnce)((CassandraPRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraPRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String postPartitionColumns() {
        return ((TraversableOnce)((CassandraPRepo)this).postPartitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraPRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? super P, ?, ?> component2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraPRepo)this).columnName(component2), this.componentToCassandraType(component2)}));
    }

    public static /* synthetic */ void addColumn$(CassandraSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String cql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraPRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug("executing CQL: {}", new Object[]{cql});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            ((Session)((CassandraPRepo)this).session().apply()).execute(cql);
        }
        catch (Throwable throwable) {
            InvalidQueryException invalidQueryException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidQueryException && (invalidQueryException = (InvalidQueryException)throwable2).getMessage().contains("because it conflicts with an existing column")) {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ String componentToCassandraType$(CassandraSchema $this, RealizedPropComponent component2) {
        return $this.componentToCassandraType(component2);
    }

    default public <A> String componentToCassandraType(RealizedPropComponent<? super P, ?, A> component2) {
        return (String)CassandraPRepo$.MODULE$.basicToCassandraType().apply(component2.componentTypeKey());
    }

    public static /* synthetic */ void createIndexes$(CassandraSchema $this) {
        $this.createIndexes();
    }

    default public void createIndexes() {
        ((CassandraPRepo)this).indexedComponents().foreach((Function1 & Serializable & scala.Serializable)component2 -> {
            this.createIndex(component2);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, RealizedPropComponent component2) {
        $this.createIndex(component2);
    }

    default public void createIndex(RealizedPropComponent<? super P, ?, ?> component2) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraPRepo)this).tableName(), ((CassandraPRepo)this).scoredPath(component2)}));
        this.createIndex(indexName, ((CassandraPRepo)this).columnName(component2));
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, String indexName, String columnName) {
        $this.createIndex(indexName, columnName);
    }

    default public void createIndex(String indexName, String columnName) {
        BoxedUnit boxedUnit;
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE INDEX IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexName, ((CassandraPRepo)this).tableName(), columnName}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug("executing CQL: {}", new Object[]{createIndex});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((Session)((CassandraPRepo)this).session().apply()).execute(createIndex);
    }

    public static void $init$(CassandraSchema $this) {
    }
}

