/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import longevity.config.PersistenceConfig;
import longevity.effect.Effect;
import longevity.emblem.emblematic.Emblematic;
import longevity.emblem.emblematic.traversors.sync.EmblematicToJsonTranslator;
import longevity.emblem.emblematic.traversors.sync.JsonToEmblematicTranslator;
import longevity.emblem.exceptions.CouldNotTraverseException;
import longevity.emblem.stringUtil$;
import longevity.exceptions.persistence.NotInDomainModelTranslationException;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.model.ptype.Key;
import longevity.model.query.Query;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.PState$;
import longevity.persistence.cassandra.CassandraCreate;
import longevity.persistence.cassandra.CassandraDelete;
import longevity.persistence.cassandra.CassandraId;
import longevity.persistence.cassandra.CassandraPRepo$;
import longevity.persistence.cassandra.CassandraQuery;
import longevity.persistence.cassandra.CassandraQuery$FilterInfo$;
import longevity.persistence.cassandra.CassandraRetrieve;
import longevity.persistence.cassandra.CassandraSchema;
import longevity.persistence.cassandra.CassandraUpdate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import streamadapter.Chunkerator;

@ScalaSignature(bytes="\u0006\u0001\r]g!B\u0001\u0003\u0001\u0019A!AD\"bgN\fg\u000e\u001a:b!J+\u0007o\u001c\u0006\u0003\u0007\u0011\t\u0011bY1tg\u0006tGM]1\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\nY>tw-\u001a<jif,B!\u0003\t\"IMI\u0001A\u0003\u0014+[A\u001ad'\u000f\t\u0006\u00171q\u0001eI\u0007\u0002\t%\u0011Q\u0002\u0002\u0002\u0006!J+\u0007o\u001c\t\u0003\u001fAa\u0001\u0001B\u0003\u0012\u0001\t\u00071CA\u0001G\u0007\u0001)\"\u0001\u0006\u0010\u0012\u0005UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"a\u0002(pi\"Lgn\u001a\t\u0003-qI!!H\f\u0003\u0007\u0005s\u0017\u0010B\u0003 !\t\u0007ACA\u0001`!\ty\u0011\u0005B\u0003#\u0001\t\u0007ACA\u0001N!\tyA\u0005B\u0003&\u0001\t\u0007ACA\u0001Q!\u00159\u0003F\u0004\u0011$\u001b\u0005\u0011\u0011BA\u0015\u0003\u0005=\u0019\u0015m]:b]\u0012\u0014\u0018mU2iK6\f\u0007#B\u0014,\u001d\u0001\u001a\u0013B\u0001\u0017\u0003\u0005=\u0019\u0015m]:b]\u0012\u0014\u0018m\u0011:fCR,\u0007#B\u0014/\u001d\u0001\u001a\u0013BA\u0018\u0003\u0005E\u0019\u0015m]:b]\u0012\u0014\u0018MU3ue&,g/\u001a\t\u0006OEr\u0001eI\u0005\u0003e\t\u0011abQ1tg\u0006tGM]1Rk\u0016\u0014\u0018\u0010E\u0003(i9\u00013%\u0003\u00026\u0005\ty1)Y:tC:$'/Y+qI\u0006$X\rE\u0003(o9\u00013%\u0003\u00029\u0005\ty1)Y:tC:$'/\u0019#fY\u0016$X\r\u0005\u0002;\u00036\t1H\u0003\u0002={\u0005a1oY1mC2|wmZ5oO*\u0011ahP\u0001\tif\u0004Xm]1gK*\t\u0001)A\u0002d_6L!AQ\u001e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\n\t\u0002\u0011\t\u0011)A\u0005\u000b*\u000ba!\u001a4gK\u000e$\bc\u0001$I\u001d5\tqI\u0003\u0002E\r%\u0011\u0011j\u0012\u0002\u0007\u000b\u001a4Wm\u0019;\n\u0005\u0011c\u0001\"\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'T\u0003%iw\u000eZ3m)f\u0004X\rE\u0002O#\u0002j\u0011a\u0014\u0006\u0003!\u001a\tQ!\\8eK2L!AU(\u0003\u00135{G-\u001a7UsB,\u0017B\u0001'\r\u0011%)\u0006A!A!\u0002\u00131\u0016,A\u0003q)f\u0004X\r\u0005\u0003O/\u0002\u001a\u0013B\u0001-P\u0005\u0015\u0001F+\u001f9f\u0013\t)F\u0002\u0003\u0005\\\u0001\t\u0015\r\u0011\"\u0005]\u0003E\u0001XM]:jgR,gnY3D_:4\u0017nZ\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001MB\u0001\u0007G>tg-[4\n\u0005\t|&!\u0005)feNL7\u000f^3oG\u0016\u001cuN\u001c4jO\"AA\r\u0001B\u0001B\u0003%Q,\u0001\nqKJ\u001c\u0018n\u001d;f]\u000e,7i\u001c8gS\u001e\u0004\u0003\u0002\u00034\u0001\u0005\u000b\u0007I\u0011C4\u0002\u000fM,7o]5p]V\t\u0001\u000eE\u0002\u0017S.L!A[\f\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u00017t\u001b\u0005i'B\u00018p\u0003\u0011\u0019wN]3\u000b\u0005A\f\u0018A\u00023sSZ,'O\u0003\u0002s\u007f\u0005AA-\u0019;bgR\f\u00070\u0003\u0002u[\n91+Z:tS>t\u0007\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011\u00025\u0002\u0011M,7o]5p]\u0002BQ\u0001\u001f\u0001\u0005\ne\fa\u0001P5oSRtDC\u0002>|yvtx\u0010E\u0003(\u00019\u00013\u0005C\u0003Eo\u0002\u0007Q\tC\u0003Mo\u0002\u0007Q\nC\u0003Vo\u0002\u0007a\u000bC\u0003\\o\u0002\u0007Q\fC\u0003go\u0002\u0007\u0001\u000e\u0003\u0006\u0002\u0004\u0001\u0011\r\u0011\"\u0005\u0003\u0003\u000b\t\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003/qA!a\u0003\u0002\u0014A\u0019\u0011QB\f\u000e\u0005\u0005=!bAA\t%\u00051AH]8pizJ1!!\u0006\u0018\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011DA\u000e\u0005\u0019\u0019FO]5oO*\u0019\u0011QC\f\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u000f\t!\u0002^1cY\u0016t\u0015-\\3!\u0011%\t\u0019\u0003\u0001b\u0001\n#\t)#A\nqCJ$\u0018\u000e^5p]\u000e{W\u000e]8oK:$8/\u0006\u0002\u0002(A1\u0011\u0011FA\u0018\u0003gi!!a\u000b\u000b\u0007\u00055r#\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002,\t\u00191+Z91\r\u0005U\u00121IA*!%\t9$!\u0010$\u0003\u0003\n\t&\u0004\u0002\u0002:)\u0019\u00111H(\u0002\u0011I,\u0017\r\\5{K\u0012LA!a\u0010\u0002:\t)\"+Z1mSj,G\r\u0015:pa\u000e{W\u000e]8oK:$\bcA\b\u0002D\u0011Y\u0011QIA$\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\ryF%\r\u0005\u000b\u0003\u0013\nY%!A\u0001\u0002\u0005=\u0013\u0001\u0003\u0013b]>tg-\u001e8\t\u0011\u00055\u0003\u0001)A\u0005\u0003O\tA\u0003]1si&$\u0018n\u001c8D_6\u0004xN\\3oiN\u00043\u0002\u0001\t\u0004\u001f\u0005MCaCA+\u0003\u000f\n\t\u0011!A\u0003\u0002Q\u00111a\u0018\u00133\u0011%\tI\u0006\u0001b\u0001\n#\tY&A\fq_N$\b+\u0019:uSRLwN\\\"p[B|g.\u001a8ugV\u0011\u0011Q\f\t\u0007\u0003S\ty#a\u00181\r\u0005\u0005\u0014QMA9!%\t9$!\u0010$\u0003G\ny\u0007E\u0002\u0010\u0003K\"1\"a\u001a\u0002j\u0005\u0005\t\u0011!B\u0001)\t\u0019q\fJ\u001a\t\u0015\u0005%\u00131NA\u0001\u0002\u0003\ty\u0005\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA/\u0003a\u0001xn\u001d;QCJ$\u0018\u000e^5p]\u000e{W\u000e]8oK:$8\u000f\t\t\u0004\u001f\u0005EDaCA:\u0003S\n\t\u0011!A\u0003\u0002Q\u00111a\u0018\u00135\u0011%\t9\b\u0001b\u0001\n#\t)#\u0001\u000bqe&l\u0017M]=LKf\u001cu.\u001c9p]\u0016tGo\u001d\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002(\u0005)\u0002O]5nCJL8*Z=D_6\u0004xN\\3oiN\u0004\u0003\"CA@\u0001\t\u0007I\u0011CAA\u0003Q\t7\r^;bY&TX\rZ\"p[B|g.\u001a8ugV\u0011\u00111\u0011\t\u0007\u0003\u000b\u000bY)a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003W\t\u0011\"[7nkR\f'\r\\3\n\t\u00055\u0015q\u0011\u0002\u0004'\u0016$\b\u0007CAI\u0003+\u000b9+!,\u0011\u0015\u0005]\u0012QHAJ\u0003K\u000bY\u000bE\u0002\u0010\u0003+#A\"a&\u0002\u001a\u0006\u0005\t\u0011!B\u0001\u0003G\u00131a\u0018\u00139\u0011!\tY\n\u0001C\t\u0005\u0005u\u0015!E5oI\u0016DX\rZ\"p[B|g.\u001a8ugV\u0011\u0011q\u0014\t\u0007\u0003\u0013\t\t+a$\n\t\u00055\u00151D\t\u0003Gm\u00012aDAT\t-\tI+!'\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\u0007}#\u0013\bE\u0002\u0010\u0003[#1\"a,\u0002\u001a\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u00191\u0011!\t\u0019\f\u0001Q\u0001\n\u0005\r\u0015!F1diV\fG.\u001b>fI\u000e{W\u000e]8oK:$8\u000f\t\u0005\n\u0003o\u0003!\u0019!C\t\u0003s\u000b!$Z7cY\u0016l\u0017\r^5d)>T5o\u001c8Ue\u0006t7\u000f\\1u_J,\"!a/\u0011\t\u0005u\u0016qZ\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006!1/\u001f8d\u0015\u0011\t)-a2\u0002\u0015Q\u0014\u0018M^3sg>\u00148O\u0003\u0003\u0002J\u0006-\u0017AC3nE2,W.\u0019;jG*\u0019\u0011Q\u001a\u0004\u0002\r\u0015l'\r\\3n\u0013\u0011\t\t.a0\u00035\u0015k'\r\\3nCRL7\rV8Kg>tGK]1og2\fGo\u001c:\t\u0011\u0005U\u0007\u0001)A\u0005\u0003w\u000b1$Z7cY\u0016l\u0017\r^5d)>T5o\u001c8Ue\u0006t7\u000f\\1u_J\u0004\u0003\"CAm\u0001\t\u0007I\u0011CAn\u0003iQ7o\u001c8U_\u0016k'\r\\3nCRL7\r\u0016:b]Nd\u0017\r^8s+\t\ti\u000e\u0005\u0003\u0002>\u0006}\u0017\u0002BAq\u0003\u007f\u0013!DS:p]R{W)\u001c2mK6\fG/[2Ue\u0006t7\u000f\\1u_JD\u0001\"!:\u0001A\u0003%\u0011Q\\\u0001\u001cUN|g\u000eV8F[\ndW-\\1uS\u000e$&/\u00198tY\u0006$xN\u001d\u0011\t\u000f\u0005%\b\u0001\"\u0005\u0002l\u0006Q1m\u001c7v[:t\u0015-\\3\u0015\t\u00055\u00181 \t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0018\u0001\u00026bm\u0006LA!!\u0007\u0002r\"A\u0011Q`At\u0001\u0004\ty0\u0001\u0003qe>\u0004\b\u0007\u0003B\u0001\u0005\u000b\u0011YA!\u0005\u0011\u0015\u0005]\u0012Q\bB\u0002\u0005\u0013\u0011y\u0001E\u0002\u0010\u0005\u000b!1Ba\u0002\u0002|\u0006\u0005\t\u0011!B\u0001)\t!q\fJ\u0019:!\ry!1\u0002\u0003\f\u0005\u001b\tY0!A\u0001\u0002\u000b\u0005AC\u0001\u0003`II\u0002\u0004cA\b\u0003\u0012\u0011Y!1CA~\u0003\u0003\u0005\tQ!\u0001\u0015\u0005\u0011yFEM\u0019\t\u000f\t]\u0001\u0001\"\u0005\u0003\u001a\u0005Q1oY8sK\u0012\u0004\u0016\r\u001e5\u0015\t\u00055(1\u0004\u0005\t\u0003{\u0014)\u00021\u0001\u0003\u001eAB!q\u0004B\u0012\u0005S\u0011y\u0003\u0005\u0006\u00028\u0005u\"\u0011\u0005B\u0014\u0005[\u00012a\u0004B\u0012\t-\u0011)Ca\u0007\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\t}##G\r\t\u0004\u001f\t%Ba\u0003B\u0016\u00057\t\t\u0011!A\u0003\u0002Q\u0011Aa\u0018\u00133gA\u0019qBa\f\u0005\u0017\tE\"1DA\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u0012D\u0007C\u0004\u00036\u0001!\tBa\u000e\u0002\u001d)\u001cxN\\*ue&twMR8s!R!\u0011q\u0001B\u001d\u0011\u001d\u0011YDa\rA\u0002\r\n\u0011\u0001\u001d\u0005\b\u0005\u007f\u0001A\u0011\u0003B!\u0003E)\b\u000fZ1uK\u000e{G.^7o\u001d\u0006lWm\u001d\u000b\u0005\u0005\u0007\u0012\u0019\u0006\u0005\u0004\u0003F\t=\u0013q\u0001\b\u0005\u0005\u000f\u0012YE\u0004\u0003\u0002\u000e\t%\u0013\"\u0001\r\n\u0007\t5s#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\"\u0011\u000b\u0006\u0004\u0005\u001b:\u0002B\u0003B+\u0005{\u0001\n\u00111\u0001\u0003X\u0005A\u0011n]\"sK\u0006$X\rE\u0002\u0017\u00053J1Aa\u0017\u0018\u0005\u001d\u0011un\u001c7fC:DqAa\u0018\u0001\t#\u0011\t'\u0001\nva\u0012\fG/Z\"pYVlgNV1mk\u0016\u001cHC\u0002B2\u0005W\u0012)\b\u0005\u0004\u0003F\t=#Q\r\t\u0004-\t\u001d\u0014b\u0001B5/\t1\u0011I\\=SK\u001aD\u0001B!\u001c\u0003^\u0001\u0007!qN\u0001\u0006gR\fG/\u001a\t\u0005\u0017\tE4%C\u0002\u0003t\u0011\u0011a\u0001U*uCR,\u0007B\u0003B+\u0005;\u0002\n\u00111\u0001\u0003X!9!\u0011\u0010\u0001\u0005\u0012\tm\u0014\u0001B;vS\u0012$BA! \u0003\nB!!q\u0010BC\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\u0006U\u0018\u0001B;uS2LAAa\"\u0003\u0002\n!Q+V%E\u0011!\u0011iGa\u001eA\u0002\t=\u0004b\u0002BG\u0001\u0011E\u0011QA\u0001\u0011o\",'/Z!tg&<g.\\3oiNDqA!%\u0001\t#\u0011\u0019*A\u0007xQ\u0016\u0014XMQ5oI&twm\u001d\u000b\u0005\u0005+\u00139\n\u0005\u0004\u0002*\u0005=\"Q\r\u0005\t\u0005[\u0012y\t1\u0001\u0003p!9!1\u0014\u0001\u0005\n\tu\u0015A\u00049s_B4\u0016\r\u001c\"j]\u0012LgnZ\u000b\u0007\u0005?\u0013YKa.\u0015\r\t\u0015$\u0011\u0015B^\u0011!\u0011\u0019K!'A\u0002\t\u0015\u0016!C2p[B|g.\u001a8ua\u0011\u00119K!-\u0011\u0015\u0005]\u0012Q\bBU\u0005_\u0013)\fE\u0002\u0010\u0005W#\u0001B!,\u0003\u001a\n\u0007\u00111\u0015\u0002\u0003!B\u00032a\u0004BY\t-\u0011\u0019L!)\u0002\u0002\u0003\u0005)\u0011\u0001\u000b\u0003\t}#3'\r\t\u0004\u001f\t]Fa\u0002B]\u00053\u0013\r\u0001\u0006\u0002\u0002\u0003\"9!1\bBM\u0001\u0004\u0019\u0003b\u0002B`\u0001\u0011E!\u0011Y\u0001\u000fG\u0006\u001c8/\u00198ee\u00064\u0016\r\\;f)\u0011\u0011)Ga1\t\u000f\t\u0015'Q\u0018a\u00017\u0005)a/\u00197vK\"9!\u0011\u001a\u0001\u0005\u0012\t-\u0017!D2bgN\fg\u000e\u001a:b\t\u0006$X\r\u0006\u0003\u0003N\nM\u0007\u0003\u0002B@\u0005\u001fLAA!5\u0003\u0002\n!A)\u0019;f\u0011!\u0011)Na2A\u0002\t]\u0017!\u00013\u0011\t\te'q]\u0007\u0003\u00057TAA!8\u0003`\u0006!A/[7f\u0015\u0011\u0011\tOa9\u0002\t)|G-\u0019\u0006\u0003\u0005K\f1a\u001c:h\u0013\u0011\u0011IOa7\u0003\u0011\u0011\u000bG/\u001a+j[\u0016DqA!<\u0001\t#\u0011y/A\bsKR\u0014\u0018.\u001a<f\rJ|WNU8x)\u0011\u0011yG!=\t\u0011\tM(1\u001ea\u0001\u0005k\f1A]8x!\ra'q_\u0005\u0004\u0005sl'a\u0001*po\"I!Q \u0001A\u0002\u0013%!q`\u0001\u0013aJ,\u0007/\u0019:fIN#\u0018\r^3nK:$8/\u0006\u0002\u0004\u0002AA\u0011QQB\u0002\u0003\u000f\u00199!\u0003\u0003\u0004\u0006\u0005\u001d%aA'baB\u0019An!\u0003\n\u0007\r-QNA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RD\u0011ba\u0004\u0001\u0001\u0004%Ia!\u0005\u0002-A\u0014X\r]1sK\u0012\u001cF/\u0019;f[\u0016tGo]0%KF$Baa\u0005\u0004\u001aA\u0019ac!\u0006\n\u0007\r]qC\u0001\u0003V]&$\bBCB\u000e\u0007\u001b\t\t\u00111\u0001\u0004\u0002\u0005\u0019\u0001\u0010J\u0019\t\u0011\r}\u0001\u0001)Q\u0005\u0007\u0003\t1\u0003\u001d:fa\u0006\u0014X\rZ*uCR,W.\u001a8ug\u0002Bqaa\t\u0001\t#\u0019)#A\tqe\u0016\u0004\u0018M]3e'R\fG/Z7f]R$Baa\u0002\u0004(!A1\u0011FB\u0011\u0001\u0004\t9!A\u0002dc2Dqa!\f\u0001\t\u0003\u001ay#\u0001\u0005u_N#(/\u001b8h)\t\t9\u0001C\u0005\u00044\u0001\t\n\u0011\"\u0005\u00046\u0005aR\u000f\u001d3bi\u0016\u001cu\u000e\\;n]Z\u000bG.^3tI\u0011,g-Y;mi\u0012\u0012TCAB\u001cU\u0011\u00119f!\u000f,\u0005\rm\u0002\u0003BB\u001f\u0007\u000fj!aa\u0010\u000b\t\r\u000531I\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0012\u0018\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0013\u001ayDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!\u0014\u0001#\u0003%\tb!\u000e\u00027U\u0004H-\u0019;f\u0007>dW/\u001c8OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u00115\u0019\t\u0006\u0001I\u0001\u0004\u0003\u0005I\u0011BB*'\u0006y1/\u001e9fe\u0012jw\u000eZ3m)f\u0004X-F\u0001N\u000f!\u00199F\u0001E\u0001\u0005\re\u0013AD\"bgN\fg\u000e\u001a:b!J+\u0007o\u001c\t\u0004O\rmcaB\u0001\u0003\u0011\u0003\u00111QL\n\u0005\u00077\u0012)\u0007C\u0004y\u00077\"\ta!\u0019\u0015\u0005\re\u0003\u0002CB3\u00077\"\taa\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0011\r%4qNB<\u0007w\"bba\u001b\u0004~\r\u00055QQBE\u0007\u0017\u001b)\f\u0005\u0005(\u0001\r54QOB=!\ry1q\u000e\u0003\b#\r\r$\u0019AB9+\r!21\u000f\u0003\u0007?\r=$\u0019\u0001\u000b\u0011\u0007=\u00199\b\u0002\u0004#\u0007G\u0012\r\u0001\u0006\t\u0004\u001f\rmDAB\u0013\u0004d\t\u0007A\u0003C\u0004E\u0007G\u0002\raa \u0011\t\u0019C5Q\u000e\u0005\b\u0019\u000e\r\u0004\u0019ABB!\u0011q\u0015k!\u001e\t\u000fU\u001b\u0019\u00071\u0001\u0004\bB1ajVB;\u0007sBa\u0001YB2\u0001\u0004i\u0006\u0002CBG\u0007G\u0002\raa$\u0002\u0017A|G.\u001f*fa>|\u0005\u000f\u001e\t\u0006-\rE5QS\u0005\u0004\u0007';\"AB(qi&|g\u000e\r\u0003\u0004\u0018\u000em\u0005\u0003C\u0014\u0001\u0007[\u001a)h!'\u0011\u0007=\u0019Y\n\u0002\u0007\u0004\u001e\u000e}\u0015\u0011!A\u0001\u0006\u0003\u0019\u0019L\u0001\u0003`IM\u0012\u0004\u0002CBG\u0007G\u0002\ra!)\u0011\u000bY\u0019\tja)1\t\r\u00156Q\u0016\t\tO\u0001\u00199k!+\u0004,B\u0019qba\u001c\u0011\u0007=\u00199\bE\u0002\u0010\u0007[#Ab!(\u0004 \u0006\u0005\t\u0011!B\u0001\u0007_\u000b2a!-\u001c!\ry11P\t\u0004\u0007sZ\u0002B\u00024\u0004d\u0001\u0007\u0001\u000eC\u0006\u0004:\u000em#\u0019!C\u0001\u0005\rm\u0016\u0001\u00062bg&\u001cGk\\\"bgN\fg\u000e\u001a:b)f\u0004X-\u0006\u0002\u0004>BA\u0011QQB\u0002\u0007\u007f\u000bi\u000f\r\u0003\u0004B\u000e=\u0007CBBb\u0007\u0013\u001ci-\u0004\u0002\u0004F*\u00111qY\u0001\bif\u0004Xm[3z\u0013\u0011\u0019Ym!2\u0003\u000fQK\b/Z&fsB\u0019qba4\u0005\u0017\rE71[A\u0001\u0002\u0003\u0015\t\u0001\u0006\u0002\u0005?\u0012\u001a4\u0007C\u0005\u0004V\u000em\u0003\u0015!\u0003\u0004>\u0006)\"-Y:jGR{7)Y:tC:$'/\u0019+za\u0016\u0004\u0003")
public class CassandraPRepo<F, M, P>
extends PRepo<F, M, P>
implements CassandraSchema<F, M, P>,
CassandraCreate<F, M, P>,
CassandraRetrieve<F, M, P>,
CassandraQuery<F, M, P>,
CassandraUpdate<F, M, P>,
CassandraDelete<F, M, P>,
LazyLogging {
    private final PersistenceConfig persistenceConfig;
    private final Function0<Session> session;
    private final String tableName;
    private final Seq<RealizedPropComponent<P, ?, ?>> partitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents;
    private final Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents;
    private final Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents;
    private final EmblematicToJsonTranslator emblematicToJsonTranslator;
    private final JsonToEmblematicTranslator jsonToEmblematicTranslator;
    private Map<String, PreparedStatement> preparedStatements;
    private Logger logger;
    private PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    private PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    private volatile CassandraQuery$FilterInfo$ FilterInfo$module;
    private Map<RealizedKey<M, P, ?>, PreparedStatement> longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements;
    private PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    private volatile byte bitmap$0;

    public static <F, M, P> CassandraPRepo<F, M, P> apply(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Option<CassandraPRepo<F, M, ? super P>> option, Function0<Session> function0) {
        return CassandraPRepo$.MODULE$.apply(effect, modelType, pType, persistenceConfig, option, function0);
    }

    @Override
    public F delete(PState<P> state) {
        return (F)CassandraDelete.delete$(this, state);
    }

    @Override
    public PreparedStatement deleteStatement() {
        return CassandraDelete.deleteStatement$(this);
    }

    @Override
    public F update(PState<P> state) {
        return (F)CassandraUpdate.update$(this, state);
    }

    @Override
    public Chunkerator<PState<P>> queryToChunkerator(Query<P> query) {
        return CassandraQuery.queryToChunkerator$(this, query);
    }

    @Override
    public String queryWhereClause(CassandraQuery.FilterInfo filterInfo) {
        return CassandraQuery.queryWhereClause$(this, filterInfo);
    }

    @Override
    public <V> F retrieve(V v, Key<M, P, V> evidence$1) {
        return (F)CassandraRetrieve.retrieve$(this, v, evidence$1);
    }

    @Override
    public Option<PState<P>> retrieveFromBoundStatement(BoundStatement statement) {
        return CassandraRetrieve.retrieveFromBoundStatement$(this, statement);
    }

    @Override
    public String keyValSelectStatementConjunction(RealizedKey<M, P, ?> key) {
        return CassandraRetrieve.keyValSelectStatementConjunction$(this, key);
    }

    @Override
    public F create(P p) {
        return (F)CassandraCreate.create$(this, p);
    }

    @Override
    public void createSchemaBlocking() {
        CassandraSchema.createSchemaBlocking$(this);
    }

    @Override
    public void createTable() {
        CassandraSchema.createTable$(this);
    }

    @Override
    public void addColumn(String columnName, String columnType) {
        CassandraSchema.addColumn$(this, columnName, columnType);
    }

    @Override
    public <A> String componentToCassandraType(RealizedPropComponent<? super P, ?, A> component2) {
        return CassandraSchema.componentToCassandraType$(this, component2);
    }

    @Override
    public void createIndexes() {
        CassandraSchema.createIndexes$(this);
    }

    @Override
    public void createIndex(RealizedPropComponent<? super P, ?, ?> component2) {
        CassandraSchema.createIndex$(this, component2);
    }

    @Override
    public void createIndex(String indexName, String columnName) {
        CassandraSchema.createIndex$(this, indexName, columnName);
    }

    private Logger logger$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce = CassandraDelete.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce$lzycompute() : this.longevity$persistence$cassandra$CassandraDelete$$deleteStatementPreparedOnce;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement = CassandraUpdate.longevity$persistence$cassandra$CassandraUpdate$$updateStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement$lzycompute() : this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement;
    }

    @Override
    public CassandraQuery$FilterInfo$ FilterInfo() {
        if (this.FilterInfo$module == null) {
            this.FilterInfo$lzycompute$1();
        }
        return this.FilterInfo$module;
    }

    @Override
    public Map<RealizedKey<M, P, ?>, PreparedStatement> longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements() {
        return this.longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements;
    }

    @Override
    public void longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements_$eq(Map<RealizedKey<M, P, ?>, PreparedStatement> x$1) {
        this.longevity$persistence$cassandra$CassandraRetrieve$$keyValSelectStatements = x$1;
    }

    private PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement$lzycompute() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.longevity$persistence$cassandra$CassandraCreate$$insertStatement = CassandraCreate.longevity$persistence$cassandra$CassandraCreate$$insertStatement$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    }

    @Override
    public PreparedStatement longevity$persistence$cassandra$CassandraCreate$$insertStatement() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.longevity$persistence$cassandra$CassandraCreate$$insertStatement$lzycompute() : this.longevity$persistence$cassandra$CassandraCreate$$insertStatement;
    }

    public /* synthetic */ ModelType longevity$persistence$cassandra$CassandraPRepo$$super$modelType() {
        return super.modelType();
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public Function0<Session> session() {
        return this.session;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> partitionComponents() {
        return this.partitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> postPartitionComponents() {
        return this.postPartitionComponents;
    }

    public Seq<RealizedPropComponent<P, ?, ?>> primaryKeyComponents() {
        return this.primaryKeyComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> actualizedComponents() {
        return this.actualizedComponents;
    }

    public Set<RealizedPropComponent<? super P, ?, ?>> indexedComponents() {
        Set keyComponents = (Set)((TraversableLike)this.realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CassandraPRepo.$anonfun$indexedComponents$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.realizedProp().realizedPropComponents(), Set$.MODULE$.canBuildFrom());
        Set props = (Set)super.pType().indexSet().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.props(), Set$.MODULE$.canBuildFrom());
        Set realizedProps = (Set)props.map((Function1 & Serializable & scala.Serializable)x$6 -> (RealizedProp)this.realizedPType().realizedProps().apply(x$6), Set$.MODULE$.canBuildFrom());
        Set indexComponents = (Set)((GenericTraversableTemplate)realizedProps.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.realizedPropComponents(), Set$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return (Set)keyComponents.$plus$plus((GenTraversableOnce)indexComponents);
    }

    public EmblematicToJsonTranslator emblematicToJsonTranslator() {
        return this.emblematicToJsonTranslator;
    }

    public JsonToEmblematicTranslator jsonToEmblematicTranslator() {
        return this.jsonToEmblematicTranslator;
    }

    public String columnName(RealizedPropComponent<?, ?, ?> prop) {
        return "prop_" + this.scoredPath(prop);
    }

    public String scoredPath(RealizedPropComponent<?, ?, ?> prop) {
        return prop.outerPropPath().inlinedPath().replace('.', '_');
    }

    public String jsonStringForP(P p) {
        String string;
        try {
            JsonAST.JValue x$21 = this.emblematicToJsonTranslator().translate(p, this.pTypeKey());
            Formats x$22 = JsonMethods$.MODULE$.render$default$2(x$21);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$21, x$22));
        }
        catch (CouldNotTraverseException e) {
            throw new NotInDomainModelTranslationException(e.typeKey().name(), e);
        }
        return string;
    }

    public Seq<String> updateColumnNames(boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnNames = isCreate ? this.names$1(this.actualizedComponents()) : this.names$1(this.indexedComponents());
        String string = "p";
        Seq withP = (Seq)componentColumnNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            String string2 = "created_timestamp";
            String string3 = "updated_timestamp";
            seq3 = (Seq)((SeqLike)withP.$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            String string4 = "row_version";
            seq2 = (Seq)withDateTimes.$plus$colon((Object)string4, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            String string5 = "id";
            seq = (Seq)withRowVersion.$plus$colon((Object)string5, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        Seq withId = seq;
        return withId;
    }

    public boolean updateColumnNames$default$1() {
        return true;
    }

    public Seq<Object> updateColumnValues(PState<P> state, boolean isCreate) {
        Seq seq;
        Seq withRowVersion;
        Seq seq2;
        Seq withDateTimes;
        Seq seq3;
        Seq componentColumnValues = isCreate ? this.values$1(this.actualizedComponents(), state) : this.values$1(this.indexedComponents(), state);
        String string = this.jsonStringForP(state.get());
        Seq withP = (Seq)componentColumnValues.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        if (this.persistenceConfig().writeTimestamps()) {
            Object object = state.createdTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.cassandraValue(value)).orNull(Predef$.MODULE$.$conforms());
            Object object2 = state.updatedTimestamp().map((Function1 & Serializable & scala.Serializable)value -> this.cassandraValue(value)).orNull(Predef$.MODULE$.$conforms());
            seq3 = (Seq)((SeqLike)withP.$plus$colon(object2, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq3 = withDateTimes = withP;
        }
        if (this.persistenceConfig().optimisticLocking()) {
            Object object = state.rowVersionOrNull();
            seq2 = (Seq)withDateTimes.$plus$colon(object, Seq$.MODULE$.canBuildFrom());
        } else {
            seq2 = withRowVersion = withDateTimes;
        }
        if (isCreate && !this.hasPrimaryKey()) {
            UUID uUID = this.uuid(state);
            seq = (Seq)withRowVersion.$plus$colon((Object)uUID, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = withRowVersion;
        }
        Seq withId = seq;
        return withId;
    }

    public boolean updateColumnValues$default$2() {
        return true;
    }

    public UUID uuid(PState<P> state) {
        return ((CassandraId)state.id().get()).uuid();
    }

    public String whereAssignments() {
        return this.hasPrimaryKey() ? ((TraversableOnce)((TraversableLike)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString("\nAND\n  ") : "id = :id";
    }

    public Seq<Object> whereBindings(PState<P> state) {
        return this.hasPrimaryKey() ? (Seq)this.primaryKeyComponents().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.outerPropPath().get().apply(state.get()), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{((CassandraId)state.id().get()).uuid()}));
    }

    private <PP, A> Object propValBinding(RealizedPropComponent<PP, ?, A> component2, P p) {
        return this.cassandraValue(component2.outerPropPath().get().apply(p));
    }

    public Object cassandraValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
        } else if (object2 instanceof DateTime) {
            DateTime dateTime = (DateTime)object2;
            object = this.cassandraDate(dateTime);
        } else {
            object = value;
        }
        return object;
    }

    public Date cassandraDate(DateTime d) {
        return new Date(d.getMillis());
    }

    public PState<P> retrieveFromRow(Row row) {
        Tuple2 tuple2;
        None$ id = !this.hasPrimaryKey() ? new Some(new CassandraId(row.getUUID("id"))) : None$.MODULE$;
        None$ rowVersion = this.persistenceConfig().optimisticLocking() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong("row_version"))) : None$.MODULE$;
        Tuple2 tuple22 = tuple2 = this.persistenceConfig().writeTimestamps() ? new Tuple2((Object)CassandraPRepo.toOptDateTime$1("created_timestamp", row), (Object)CassandraPRepo.toOptDateTime$1("updated_timestamp", row)) : new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option createdTimestamp = (Option)tuple2._1();
        Option updatedTimestamp = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)createdTimestamp, (Object)updatedTimestamp);
        Tuple2 tuple24 = tuple23;
        Option createdTimestamp2 = (Option)tuple24._1();
        Option updatedTimestamp2 = (Option)tuple24._2();
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(row.getString("p")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Object p = this.jsonToEmblematicTranslator().translate(json, this.pTypeKey());
        return PState$.MODULE$.apply(id, (Option<Object>)rowVersion, (Option<DateTime>)createdTimestamp2, (Option<DateTime>)updatedTimestamp2, p);
    }

    private Map<String, PreparedStatement> preparedStatements() {
        return this.preparedStatements;
    }

    private void preparedStatements_$eq(Map<String, PreparedStatement> x$1) {
        this.preparedStatements = x$1;
    }

    public PreparedStatement preparedStatement(String cql) {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if (!this.preparedStatements().contains((Object)cql)) {
                this.preparedStatements_$eq((Map<String, PreparedStatement>)this.preparedStatements().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cql), (Object)((Session)this.session().apply()).prepare(cql))));
            }
        }
        return (PreparedStatement)this.preparedStatements().apply((Object)cql);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CassandraPRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    private final void FilterInfo$lzycompute$1() {
        CassandraPRepo cassandraPRepo = this;
        synchronized (cassandraPRepo) {
            if (this.FilterInfo$module == null) {
                this.FilterInfo$module = new CassandraQuery$FilterInfo$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$indexedComponents$1(RealizedKey x$3) {
        return x$3 instanceof RealizedPrimaryKey;
    }

    private final Seq names$1(Set components) {
        return (Seq)((SetLike)components.map((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private final Seq values$1(Set components, PState state$1) {
        return (Seq)((TraversableLike)components.toSeq().sortBy((Function1 & Serializable & scala.Serializable)prop -> this.columnName((RealizedPropComponent<?, ?, ?>)prop), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)component2 -> this.propValBinding((RealizedPropComponent)component2, state$1.get()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Option toOptDateTime$1(String c, Row row$1) {
        return Option$.MODULE$.apply((Object)row$1.getTimestamp(c)).map((Function1 & Serializable & scala.Serializable)x$19 -> new DateTime(x$19, DateTimeZone.UTC));
    }

    public CassandraPRepo(Effect<F> effect, ModelType<M> modelType, PType<M, P> pType, PersistenceConfig persistenceConfig, Function0<Session> session) {
        Seq seq;
        Seq seq2;
        this.persistenceConfig = persistenceConfig;
        this.session = session;
        super(effect, modelType, pType);
        CassandraSchema.$init$(this);
        CassandraCreate.$init$(this);
        CassandraRetrieve.$init$(this);
        CassandraQuery.$init$(this);
        CassandraUpdate.$init$(this);
        CassandraDelete.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.tableName = stringUtil$.MODULE$.camelToUnderscore(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
        Option option = this.realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq2 = (Seq)key.partitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        this.partitionComponents = seq2;
        Option option2 = this.realizedPType().primaryKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            seq = (Seq)key.postPartitionProps().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.realizedPropComponents(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        this.postPartitionComponents = seq;
        this.primaryKeyComponents = (Seq)this.partitionComponents().$plus$plus(this.postPartitionComponents(), Seq$.MODULE$.canBuildFrom());
        this.actualizedComponents = (Set)this.indexedComponents().$plus$plus(this.primaryKeyComponents());
        this.emblematicToJsonTranslator = new EmblematicToJsonTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$cassandra$CassandraPRepo$$super$modelType().emblematic();
            }
        };
        this.jsonToEmblematicTranslator = new JsonToEmblematicTranslator(this){
            private final Emblematic emblematic;

            public Emblematic emblematic() {
                return this.emblematic;
            }
            {
                this.emblematic = $outer.longevity$persistence$cassandra$CassandraPRepo$$super$modelType().emblematic();
            }
        };
        this.preparedStatements = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

