/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.mongo;

import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import java.io.Serializable;
import longevity.exceptions.persistence.DuplicateKeyValException;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.persistence.PRepo;
import longevity.persistence.PState;
import longevity.persistence.mongo.DomainModelToBsonTranslator;
import longevity.persistence.mongo.MongoId;
import longevity.persistence.mongo.MongoRepo;
import longevity.persistence.mongo.MongoSchema;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@ScalaSignature(bytes="\u0006\u0001U4\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C9\u0003\u00155{gnZ8Xe&$XM\u0003\u0002\u0004\t\u0005)Qn\u001c8h_*\u0011QAB\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0001\b\u0003%awN\\4fm&$\u00180F\u0002\n_F\u001a\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0014\u0003\u0019!\u0013N\\5uI\r\u0001A#\u0001\u000b\u0011\u0005-)\u0012B\u0001\f\r\u0005\u0011)f.\u001b;\t\u0011a\u0001\u0001R1A\u0005\u0012e\t1\u0004Z8nC&tWj\u001c3fYR{'i]8o)J\fgn\u001d7bi>\u0014X#\u0001\u000e\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0007#p[\u0006Lg.T8eK2$vNQ:p]R\u0013\u0018M\\:mCR|'\u000fC\u0003 \u0001\u0011E\u0001%\u0001\u0007cg>tgi\u001c:Ti\u0006$X\r\u0006\u0002\"SA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005EN|gNC\u0001'\u0003\ry'oZ\u0005\u0003Q\r\u0012ABQ:p]\u0012{7-^7f]RDQA\u000b\u0010A\u0002-\nQa\u001d;bi\u0016\u00042\u0001L\u00170\u001b\u0005!\u0011B\u0001\u0018\u0005\u0005\u0019\u00016\u000b^1uKB\u0011\u0001'\r\u0007\u0001\t\u0015\u0011\u0004A1\u00014\u0005\u0005\u0001\u0016C\u0001\u001b8!\tYQ'\u0003\u00027\u0019\t9aj\u001c;iS:<\u0007CA\u00069\u0013\tIDBA\u0002B]fDQa\u000f\u0001\u0005\u0012q\n\u0011\u0002\u001e:b]Nd\u0017\r^3\u0015\u0005\u0005j\u0004\"\u0002 ;\u0001\u0004y\u0013!\u00019\t\u000b\u0001\u0003A\u0011C!\u0002;QD'o\\<EkBd\u0017nY1uK.+\u0017PV1m\u000bb\u001cW\r\u001d;j_:$2\u0001\u000e\"D\u0011\u0015qt\b1\u00010\u0011\u0015!u\b1\u0001F\u0003\u0015\u0019\u0017-^:f!\t15*D\u0001H\u0015\tA\u0015*A\u0004n_:<w\u000e\u001a2\u000b\u0003)\u000b1aY8n\u0013\tauIA\nN_:<wn\u0016:ji\u0016,\u0005pY3qi&|g\u000eC\u0003O\u0001\u0011Eq*A\u0004n_:<w.\u00133\u0015\u0005AK\u0006cA\u0006R'&\u0011!\u000b\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Q;V\"A+\u000b\u0005Y\u001b\u0013!\u0002;za\u0016\u001c\u0018B\u0001-V\u0005!y%M[3di&#\u0007\"\u0002\u0016N\u0001\u0004Y\u0003\"B.\u0001\t#a\u0016AC<sSR,\u0017+^3ssR\u0011Ql\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u000e\n1bY8om\u0016\u00148/[8og&\u0011!m\u0018\u0002\u0005\u0005N|g\u000eC\u0003+5\u0002\u00071\u0006C\u0003f\u0001\u0011%a-A\u0005lKf4\u0015\u000e\u001c;feR\u0011Ql\u001a\u0005\u0006U\u0011\u0004\ra\u000b\u0005\u0006S\u0002!IA[\u0001\u0007S\u0012\u00145o\u001c8\u0015\u0005-t\u0007C\u0001\u0012m\u0013\ti7E\u0001\u0007Cg>twJ\u00196fGRLE\rC\u0003+Q\u0002\u00071\u0006B\u0003q\u0001\t\u00071GA\u0001N!\u0011Y\"\u000f^\u0018\n\u0005M\u0014!!C'p]\u001e|'+\u001a9p!\t\u0001t\u000e")
public interface MongoWrite<M, P> {
    public static /* synthetic */ DomainModelToBsonTranslator domainModelToBsonTranslator$(MongoWrite $this) {
        return $this.domainModelToBsonTranslator();
    }

    default public DomainModelToBsonTranslator domainModelToBsonTranslator() {
        return new DomainModelToBsonTranslator(((PRepo)((Object)this)).modelType().emblematic());
    }

    public static /* synthetic */ BsonDocument bsonForState$(MongoWrite $this, PState state) {
        return $this.bsonForState(state);
    }

    /*
     * WARNING - void declaration
     */
    default public BsonDocument bsonForState(PState<P> state) {
        void var2_2;
        BsonDocument document = this.translate(state.get());
        Object object = !((PRepo)((Object)this)).hasPrimaryKey() ? document.append("_id", (BsonValue)this.idBson(state)) : BoxedUnit.UNIT;
        state.rowVersion().foreach((Function1 & Serializable & scala.Serializable)v -> document.append("_rowVersion", (BsonValue)new BsonInt64(BoxesRunTime.unboxToLong((Object)v))));
        state.createdTimestamp().foreach((Function1 & Serializable & scala.Serializable)d -> document.append("_createdTimestamp", (BsonValue)new BsonDateTime(d.getMillis())));
        state.updatedTimestamp().foreach((Function1 & Serializable & scala.Serializable)d -> document.append("_updatedTimestamp", (BsonValue)new BsonDateTime(d.getMillis())));
        return var2_2;
    }

    public static /* synthetic */ BsonDocument translate$(MongoWrite $this, Object p) {
        return $this.translate(p);
    }

    default public BsonDocument translate(P p) {
        return this.domainModelToBsonTranslator().translate(p, true, ((PRepo)((Object)this)).pTypeKey()).asDocument();
    }

    public static /* synthetic */ Nothing$ throwDuplicateKeyValException$(MongoWrite $this, Object p, MongoWriteException cause) {
        return $this.throwDuplicateKeyValException(p, cause);
    }

    default public Nothing$ throwDuplicateKeyValException(P p, MongoWriteException cause) {
        String name;
        String string;
        UnanchoredRegex indexRegex = new StringOps(Predef$.MODULE$.augmentString("index: (?:[\\w\\.]*\\$)?(\\S+)\\s+dup key: \\{ :")).r().unanchored();
        Option option = ((Regex)indexRegex).unapplySeq((CharSequence)(string = cause.getMessage()));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw cause;
        }
        String string2 = name = (String)((LinearSeqOptimized)option.get()).apply(0);
        String name2 = string2;
        RealizedKey realizedKey = (RealizedKey)((PRepo)((Object)this)).realizedPType().keySet().find((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)MongoWrite.$anonfun$throwDuplicateKeyValException$1(this, name2, key))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw cause;
        });
        throw new DuplicateKeyValException(p, realizedKey.key(), (Exception)((Object)cause));
    }

    public static /* synthetic */ Option mongoId$(MongoWrite $this, PState state) {
        return $this.mongoId(state);
    }

    default public Option<ObjectId> mongoId(PState<P> state) {
        return state.id().map((Function1 & Serializable & scala.Serializable)x$1 -> ((MongoId)x$1).objectId());
    }

    public static /* synthetic */ Bson writeQuery$(MongoWrite $this, PState state) {
        return $this.writeQuery(state);
    }

    default public Bson writeQuery(PState<P> state) {
        Bson bson;
        if (((MongoRepo)this).persistenceConfig().optimisticLocking()) {
            Bson bson2;
            Option<Object> option = state.rowVersion();
            if (option instanceof Some) {
                Some some = (Some)option;
                long rv = BoxesRunTime.unboxToLong((Object)some.value());
                bson2 = Filters.eq((String)"_rowVersion", (Object)new BsonInt64(rv));
            } else if (None$.MODULE$.equals(option)) {
                bson2 = Filters.exists((String)"_rowVersion", (boolean)false);
            } else {
                throw new MatchError(option);
            }
            Bson rvBson = bson2;
            bson = Filters.and((Bson[])new Bson[]{this.keyFilter(state), rvBson});
        } else {
            bson = this.keyFilter(state);
        }
        return bson;
    }

    private Bson keyFilter(PState<P> state) {
        Bson bson;
        Option option = ((PRepo)((Object)this)).realizedPType().primaryKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            RealizedPrimaryKey key = (RealizedPrimaryKey)some.value();
            bson = this.pkFilter$1(key, state);
        } else if (None$.MODULE$.equals(option)) {
            bson = Filters.eq((String)"_id", (Object)this.idBson(state));
        } else {
            throw new MatchError(option);
        }
        return bson;
    }

    private BsonObjectId idBson(PState<P> state) {
        return new BsonObjectId((ObjectId)this.mongoId(state).get());
    }

    public static /* synthetic */ boolean $anonfun$throwDuplicateKeyValException$1(MongoWrite $this, String name$1, RealizedKey key) {
        String string = ((MongoSchema)((Object)$this)).indexName(key);
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Bson pkFilter$1(RealizedKey key, PState state$1) {
        String fieldName = key.realizedProp().inlinedPath();
        Object keyVal2 = key.keyValForP(state$1.get());
        BsonValue bson = this.domainModelToBsonTranslator().translate(keyVal2, false, key.keyValTypeKey());
        return Filters.eq((String)fieldName, (Object)bson);
    }

    public static void $init$(MongoWrite $this) {
    }
}

