/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.model.ptype.Index;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.jdbc.JdbcRepo;
import longevity.persistence.jdbc.JdbcRepo$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mcAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u0002R\tQ!\n\u001a2d'\u000eDW-\\1\u000b\u0005\r!\u0011\u0001\u00026eE\u000eT!!\u0002\u0004\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0002\u000f\u0005IAn\u001c8hKZLG/_\u000b\u0005\u0013\u00055\u0003l\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002M\ta\u0001J5oSR$3\u0001\u0001\u000b\u0002)A\u00111\"F\u0005\u0003-1\u0011A!\u00168ji\"1\u0001\u0004\u0001C\t\te\tAb\u0019:fCR,7k\u00195f[\u0006$\u0012A\u0007\u000b\u00037\u0005\u00022\u0001H\u0010\u0015\u001b\u0005i\"B\u0001\u0010\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Au\u0011aAR;ukJ,\u0007\"\u0002\u0012\u0018\u0001\b\u0019\u0013aB2p]R,\u0007\u0010\u001e\t\u00039\u0011J!!J\u000f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B\u0014\u0001\t#\u0019\u0012aC2sK\u0006$X\rV1cY\u0016DQ!\u000b\u0001\u0005\n)\nQ!\u001b3EK\u001a,\u0012a\u000b\t\u0003YEj\u0011!\f\u0006\u0003]=\nA\u0001\\1oO*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u0005\u0019\u0019FO]5oO\")A\u0007\u0001C\u0005k\u0005i\u0012m\u0019;vC2L'0\u001a3D_6\u0004xN\\3oi\u000e{G.^7o\t\u001647/F\u00017!\t9dH\u0004\u00029yA\u0011\u0011\bD\u0007\u0002u)\u00111HE\u0001\u0007yI|w\u000e\u001e \n\u0005ub\u0011A\u0002)sK\u0012,g-\u0003\u00023\u007f)\u0011Q\b\u0004\u0005\u0006\u0003\u0002!I!N\u0001\u000eaJLW.\u0019:z\u0017\u0016LH)\u001a4\t\u000b\r\u0003A\u0011B\u001b\u0002!A\f'\u000f^5uS>t7i\u001c7v[:\u001c\b\"B#\u0001\t\u00131\u0015!C2pYVlg\u000eR3g)\t1t\tC\u0003I\t\u0002\u0007\u0011*A\u0005d_6\u0004xN\\3oiB\"!\n\u00162f!\u0015Y\u0005KU1e\u001b\u0005a%BA'O\u0003!\u0011X-\u00197ju\u0016$'BA(\u0007\u0003\u0015iw\u000eZ3m\u0013\t\tFJA\u000bSK\u0006d\u0017N_3e!J|\u0007oQ8na>tWM\u001c;\u0011\u0005M#F\u0002\u0001\u0003\n+\u001e\u000b\t\u0011!A\u0003\u0002Y\u00131a\u0018\u00132#\t9f\f\u0005\u0002T1\u0012)\u0011\f\u0001b\u00015\n\t\u0001+\u0005\u0002\\=B\u00111\u0002X\u0005\u0003;2\u0011qAT8uQ&tw\r\u0005\u0002\f?&\u0011\u0001\r\u0004\u0002\u0004\u0003:L\bCA*c\t%\u0019w)!A\u0001\u0002\u000b\u0005!LA\u0002`II\u0002\"aU3\u0005\u0013\u0019<\u0015\u0011!A\u0001\u0006\u0003Q&aA0%g!)\u0001\u000e\u0001C\tS\u0006I\u0011\r\u001a3D_2,XN\u001c\u000b\u0004))d\u0007\"B6h\u0001\u00041\u0014AC2pYVlgNT1nK\")Qn\u001aa\u0001m\u0005Q1m\u001c7v[:$\u0016\u0010]3\t\u000b=\u0004A\u0011\u00039\u0002'\r|W\u000e]8oK:$Hk\u001c&eE\u000e$\u0016\u0010]3\u0016\u0005EdHC\u0001\u001cs\u0011\u0015Ae\u000e1\u0001ta\r!h/\u001f\t\u0006\u0017B+\bp\u001f\t\u0003'Z$\u0011b\u001e:\u0002\u0002\u0003\u0005)\u0011\u0001,\u0003\u0007}#C\u0007\u0005\u0002Ts\u0012I!P]A\u0001\u0002\u0003\u0015\tA\u0017\u0002\u0004?\u0012*\u0004CA*}\t\u0015ihN1\u0001[\u0005\u0005\t\u0005\"B@\u0001\t#\u0019\u0012aE2sK\u0006$X-\u00168jcV,\u0017J\u001c3fq\u0016\u001c\bBBA\u0002\u0001\u0011E1#\u0001\fde\u0016\fG/\u001a(p]Vs\u0017.];f\u0013:$W\r_3t\u0011\u001d\t9\u0001\u0001C\t\u0003\u0013\t1b\u0019:fCR,\u0017J\u001c3fqR9A#a\u0003\u0002\u0016\u0005e\u0001\u0002CA\u0007\u0003\u000b\u0001\r!a\u0004\u0002\rUt\u0017.];f!\rY\u0011\u0011C\u0005\u0004\u0003'a!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003/\t)\u00011\u00017\u0003%Ig\u000eZ3y\u001d\u0006lW\r\u0003\u0005\u0002\u001c\u0005\u0015\u0001\u0019AA\u000f\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0011\u000b\u0005}\u0011\u0011\u0006\u001c\u000f\t\u0005\u0005\u0012Q\u0005\b\u0004s\u0005\r\u0012\"A\u0007\n\u0007\u0005\u001dB\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0012Q\u0006\u0002\u0004'\u0016\f(bAA\u0014\u0019!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0012AC:d_J,G\rU1uQR\u00191&!\u000e\t\u0011\u0005]\u0012q\u0006a\u0001\u0003s\tA\u0001\u001d:paB2\u00111HA\"\u0003\u0013\u0002raSA\u001f\u0003\u0003\n9%C\u0002\u0002@1\u0013ABU3bY&TX\r\u001a)s_B\u00042aUA\"\t-\t)%!\u000e\u0002\u0002\u0003\u0005)\u0011\u0001.\u0003\t}#\u0013g\r\t\u0004'\u0006%CaCA&\u0003k\t\t\u0011!A\u0003\u0002i\u0013Aa\u0018\u00132i\u00111\u0011q\n\u0001C\u0002i\u0013\u0011!\u0014\t\b\u0003'\n)&!\u0017X\u001b\u0005\u0011\u0011bAA,\u0005\tA!\n\u001a2d%\u0016\u0004x\u000eE\u0002T\u0003\u001b\u0002")
public interface JdbcSchema<M, P> {
    public static /* synthetic */ Future createSchema$(JdbcSchema $this, ExecutionContext context) {
        return $this.createSchema(context);
    }

    default public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.createTable();
            this.createUniqueIndexes();
            this.createNonUniqueIndexes();
            if (((JdbcRepo)this).persistenceConfig().optimisticLocking()) {
                this.addColumn("row_version", "bigint");
            }
            if (((JdbcRepo)this).persistenceConfig().writeTimestamps()) {
                this.addColumn("created_timestamp", "timestamp");
                this.addColumn("updated_timestamp", "timestamp");
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), context);
    }

    public static /* synthetic */ void createTable$(JdbcSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", "\n    |  ", "\n    |)\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createTable})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((JdbcRepo)this).connection().prepareStatement(createTable).execute();
    }

    private String idDef() {
        return ((PRepo)((Object)this)).hasPrimaryKey() ? "" : "\n  id text,";
    }

    private String actualizedComponentColumnDefs() {
        String s = ((TraversableOnce)((JdbcRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component2 -> this.columnDef((RealizedPropComponent)component2), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
        return s.isEmpty() ? s : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    private String primaryKeyDef() {
        return ((PRepo)((Object)this)).hasPrimaryKey() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
    }

    private String partitionColumns() {
        return ((TraversableOnce)((JdbcRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((JdbcRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? super P, ?, ?> component2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).columnName(component2), this.componentToJdbcType(component2)}));
    }

    public static /* synthetic */ void addColumn$(JdbcSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD COLUMN IF NOT EXISTS ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((JdbcRepo)this).connection().prepareStatement(sql).execute();
    }

    public static /* synthetic */ String componentToJdbcType$(JdbcSchema $this, RealizedPropComponent component2) {
        return $this.componentToJdbcType(component2);
    }

    default public <A> String componentToJdbcType(RealizedPropComponent<? super P, ?, A> component2) {
        return (String)JdbcRepo$.MODULE$.basicToJdbcType().apply(component2.componentTypeKey());
    }

    public static /* synthetic */ void createUniqueIndexes$(JdbcSchema $this) {
        $this.createUniqueIndexes();
    }

    default public void createUniqueIndexes() {
        Set nonPrimaryKeys = (Set)((PRepo)((Object)this)).realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JdbcSchema.$anonfun$createUniqueIndexes$1(x$1)));
        nonPrimaryKeys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            JdbcSchema.$anonfun$createUniqueIndexes$2(this, key);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createNonUniqueIndexes$(JdbcSchema $this) {
        $this.createNonUniqueIndexes();
    }

    default public void createNonUniqueIndexes() {
        ((PRepo)((Object)this)).pType().indexSet().foreach((Function1 & Serializable & scala.Serializable)index -> {
            JdbcSchema.$anonfun$createNonUniqueIndexes$1(this, index);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(JdbcSchema $this, boolean unique, String indexName, Seq columnNames) {
        $this.createIndex(unique, indexName, (Seq<String>)columnNames);
    }

    default public void createIndex(boolean unique, String indexName, Seq<String> columnNames) {
        BoxedUnit boxedUnit;
        String prefix = unique ? "CREATE UNIQUE INDEX" : "CREATE INDEX";
        String columnList = columnNames.mkString(", ");
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, indexName, ((JdbcRepo)this).tableName(), columnList}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createIndex})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((JdbcRepo)this).connection().prepareStatement(createIndex).execute();
    }

    private String scoredPath(RealizedProp<?, ?> prop) {
        return prop.inlinedPath().replace('.', '_');
    }

    public static /* synthetic */ boolean $anonfun$createUniqueIndexes$1(RealizedKey x$1) {
        return x$1 instanceof RealizedPrimaryKey;
    }

    public static /* synthetic */ void $anonfun$createUniqueIndexes$2(JdbcSchema $this, RealizedKey key) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)$this).tableName(), $this.scoredPath(key.realizedProp())}));
        Seq columnsNames = (Seq)key.realizedProp().realizedPropComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((JdbcRepo)$this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        $this.createIndex(true, indexName, (Seq<String>)columnsNames);
    }

    private static Seq toComponents$1(RealizedProp prop) {
        return prop.realizedPropComponents();
    }

    public static /* synthetic */ void $anonfun$createNonUniqueIndexes$1(JdbcSchema $this, Index index) {
        Seq realizedProps = (Seq)index.props().map((Function1 & Serializable & scala.Serializable)x$2 -> (RealizedProp)((PRepo)((Object)$this)).realizedPType().realizedProps().apply(x$2), Seq$.MODULE$.canBuildFrom());
        Seq scoredPaths = (Seq)realizedProps.map((Function1 & Serializable & scala.Serializable)prop -> $this.scoredPath((RealizedProp<?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)$this).tableName(), scoredPaths.mkString("__")}));
        Seq columnsNames = (Seq)((TraversableLike)realizedProps.flatMap((Function1 & Serializable & scala.Serializable)prop -> JdbcSchema.toComponents$1(prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)prop -> ((JdbcRepo)$this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        $this.createIndex(false, indexName, (Seq<String>)columnsNames);
    }

    public static void $init$(JdbcSchema $this) {
    }
}

