/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.PRepo;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.cassandra.CassandraRepo$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mbAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u00022\ty1)Y:tC:$'/Y*dQ\u0016l\u0017M\u0003\u0002\u0004\t\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000b\u0019\t1\u0002]3sg&\u001cH/\u001a8dK*\tq!A\u0005m_:<WM^5usV!\u0011\"!\f['\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\taE\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\tA\u0003\u0005\u0002\f+%\u0011a\u0003\u0004\u0002\u0005+:LG\u000f\u0003\u0004\u0019\u0001\u0011EA!G\u0001\rGJ,\u0017\r^3TG\",W.\u0019\u000b\u00025Q\u00111$\t\t\u00049}!R\"A\u000f\u000b\u0005ya\u0011AC2p]\u000e,(O]3oi&\u0011\u0001%\b\u0002\u0007\rV$XO]3\t\u000b\t:\u00029A\u0012\u0002\u000f\r|g\u000e^3yiB\u0011A\u0004J\u0005\u0003Ku\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b\u001d\u0002A\u0011C\n\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u0005\u0006S\u0001!IAK\u0001\u0006S\u0012$UMZ\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw\rC\u00035\u0001\u0011%Q'A\u000fbGR,\u0018\r\\5{K\u0012\u001cu.\u001c9p]\u0016tGoQ8mk6tG)\u001a4t+\u00051\u0004CA\u001c?\u001d\tAD\b\u0005\u0002:\u00195\t!H\u0003\u0002<%\u00051AH]8pizJ!!\u0010\u0007\u0002\rA\u0013X\rZ3g\u0013\t\u0011tH\u0003\u0002>\u0019!)\u0011\t\u0001C\u0005k\u0005i\u0001O]5nCJL8*Z=EK\u001aDQa\u0011\u0001\u0005\nU\n\u0001\u0003]1si&$\u0018n\u001c8D_2,XN\\:\t\u000b\u0015\u0003A\u0011B\u001b\u0002)A|7\u000f\u001e)beRLG/[8o\u0007>dW/\u001c8t\u0011\u00159\u0005\u0001\"\u0003I\u0003%\u0019w\u000e\\;n]\u0012+g\r\u0006\u00027\u0013\")!J\u0012a\u0001\u0017\u0006I1m\\7q_:,g\u000e\u001e\u0019\u0005\u0019Z#w\rE\u0003N%R\u001bg-D\u0001O\u0015\ty\u0005+\u0001\u0005sK\u0006d\u0017N_3e\u0015\t\tf!A\u0003n_\u0012,G.\u0003\u0002T\u001d\n)\"+Z1mSj,G\r\u0015:pa\u000e{W\u000e]8oK:$\bCA+W\u0019\u0001!\u0011bV%\u0002\u0002\u0003\u0005)\u0011\u0001-\u0003\u0007}#\u0013'\u0005\u0002ZAB\u0011QK\u0017\u0003\u00067\u0002\u0011\r\u0001\u0018\u0002\u0002!F\u0011Q\f\u0019\t\u0003\u0017yK!a\u0018\u0007\u0003\u000f9{G\u000f[5oOB\u00111\"Y\u0005\u0003E2\u00111!\u00118z!\t)F\rB\u0005f\u0013\u0006\u0005\t\u0011!B\u00019\n\u0019q\f\n\u001a\u0011\u0005U;G!\u00035J\u0003\u0003\u0005\tQ!\u0001]\u0005\ryFe\r\u0005\u0006U\u0002!\tb[\u0001\nC\u0012$7i\u001c7v[:$2\u0001\u00067o\u0011\u0015i\u0017\u000e1\u00017\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0006_&\u0004\rAN\u0001\u000bG>dW/\u001c8UsB,\u0007\"B9\u0001\t#\u0011\u0018\u0001G2p[B|g.\u001a8u)>\u001c\u0015m]:b]\u0012\u0014\u0018\rV=qKV\u00111O \u000b\u0003mQDQA\u00139A\u0002U\u00044A\u001e=|!\u0015i%k\u001e>~!\t)\u0006\u0010B\u0005zi\u0006\u0005\t\u0011!B\u00011\n\u0019q\f\n\u001b\u0011\u0005U[H!\u0003?u\u0003\u0003\u0005\tQ!\u0001]\u0005\ryF%\u000e\t\u0003+z$Qa 9C\u0002q\u0013\u0011!\u0011\u0005\u0007\u0003\u0007\u0001A\u0011C\n\u0002\u001b\r\u0014X-\u0019;f\u0013:$W\r_3t\u0011\u001d\t9\u0001\u0001C\t\u0003\u0013\t1b\u0019:fCR,\u0017J\u001c3fqR\u0019A#a\u0003\t\u000f)\u000b)\u00011\u0001\u0002\u000eAB\u0011qBA\n\u00033\ty\u0002\u0005\u0005N%\u0006E\u0011qCA\u000f!\r)\u00161\u0003\u0003\f\u0003+\tY!!A\u0001\u0002\u000b\u0005\u0001LA\u0002`IY\u00022!VA\r\t-\tY\"a\u0003\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\u0007}#s\u0007E\u0002V\u0003?!1\"!\t\u0002\f\u0005\u0005\t\u0011!B\u00019\n\u0019q\f\n\u001d\t\u000f\u0005\u001d\u0001\u0001\"\u0005\u0002&Q)A#a\n\u0002,!9\u0011\u0011FA\u0012\u0001\u00041\u0014!C5oI\u0016Dh*Y7f\u0011\u0019i\u00171\u0005a\u0001m\u00111\u0011q\u0006\u0001C\u0002q\u0013\u0011!\u0014\t\b\u0003g\t)$!\u000fZ\u001b\u0005\u0011\u0011bAA\u001c\u0005\ti1)Y:tC:$'/\u0019*fa>\u00042!VA\u0017\u0001")
public interface CassandraSchema<M, P> {
    public static /* synthetic */ Future createSchema$(CassandraSchema $this, ExecutionContext context) {
        return $this.createSchema(context);
    }

    default public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.createTable();
            this.createIndexes();
            if (((CassandraRepo)this).persistenceConfig().optimisticLocking()) {
                this.addColumn("row_version", "bigint");
            }
            if (((CassandraRepo)this).persistenceConfig().writeTimestamps()) {
                this.addColumn("created_timestamp", "timestamp");
                this.addColumn("updated_timestamp", "timestamp");
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), context);
    }

    public static /* synthetic */ void createTable$(CassandraSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", ",\n    |  ", "\n    |)\n    |WITH COMPRESSION = { 'sstable_compression': 'SnappyCompressor' };\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createTable})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((CassandraRepo)this).session().execute(createTable);
    }

    private String idDef() {
        return ((PRepo)((Object)this)).hasPrimaryKey() ? "" : "\n  id uuid,";
    }

    private String actualizedComponentColumnDefs() {
        return ((TraversableOnce)((CassandraRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component2 -> this.columnDef((RealizedPropComponent)component2), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String primaryKeyDef() {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(((PRepo)((Object)this)).hasPrimaryKey(), ((CassandraRepo)this).postPartitionComponents().nonEmpty());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns(), this.postPartitionColumns()}));
            }
        }
        if (sp2 == null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (!bl || bl3) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()}));
    }

    private String partitionColumns() {
        return ((TraversableOnce)((CassandraRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String postPartitionColumns() {
        return ((TraversableOnce)((CassandraRepo)this).postPartitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? super P, ?, ?> component2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).columnName(component2), this.componentToCassandraType(component2)}));
    }

    public static /* synthetic */ void addColumn$(CassandraSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String cql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            ((CassandraRepo)this).session().execute(cql);
        }
        catch (Throwable throwable) {
            InvalidQueryException invalidQueryException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidQueryException && (invalidQueryException = (InvalidQueryException)throwable2).getMessage().contains("because it conflicts with an existing column")) {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ String componentToCassandraType$(CassandraSchema $this, RealizedPropComponent component2) {
        return $this.componentToCassandraType(component2);
    }

    default public <A> String componentToCassandraType(RealizedPropComponent<? super P, ?, A> component2) {
        return (String)CassandraRepo$.MODULE$.basicToCassandraType().apply(component2.componentTypeKey());
    }

    public static /* synthetic */ void createIndexes$(CassandraSchema $this) {
        $this.createIndexes();
    }

    default public void createIndexes() {
        ((CassandraRepo)this).indexedComponents().foreach((Function1 & Serializable & scala.Serializable)component2 -> {
            this.createIndex(component2);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, RealizedPropComponent component2) {
        $this.createIndex(component2);
    }

    default public void createIndex(RealizedPropComponent<? super P, ?, ?> component2) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), ((CassandraRepo)this).scoredPath(component2)}));
        this.createIndex(indexName, ((CassandraRepo)this).columnName(component2));
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, String indexName, String columnName) {
        $this.createIndex(indexName, columnName);
    }

    default public void createIndex(String indexName, String columnName) {
        BoxedUnit boxedUnit;
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE INDEX IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexName, ((CassandraRepo)this).tableName(), columnName}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createIndex})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((CassandraRepo)this).session().execute(createIndex);
    }

    public static void $init$(CassandraSchema $this) {
    }
}

