/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence;

import emblem.TypeKey;
import emblem.TypeKeyMap;
import emblem.TypeKeyMap$;
import emblem.typeBound.TypeBoundPair;
import java.io.Serializable;
import longevity.config.BackEnd;
import longevity.config.Cassandra$;
import longevity.config.CassandraConfig;
import longevity.config.InMem$;
import longevity.config.JDBC$;
import longevity.config.JdbcConfig;
import longevity.config.LongevityConfig;
import longevity.config.MongoDB$;
import longevity.config.MongoDBConfig;
import longevity.config.PersistenceConfig;
import longevity.config.SQLite$;
import longevity.model.DerivedPType;
import longevity.model.ModelType;
import longevity.model.PType;
import longevity.model.PolyPType;
import longevity.persistence.PRepo;
import longevity.persistence.Repo;
import longevity.persistence.RepoBuilder;
import longevity.persistence.RepoBuilder$repoFactory$10$;
import longevity.persistence.RepoBuilder$repoFactory$6$;
import longevity.persistence.RepoBuilder$repoFactory$7$;
import longevity.persistence.RepoBuilder$repoFactory$8$;
import longevity.persistence.RepoBuilder$repoFactory$9$;
import longevity.persistence.SchemaCreator;
import longevity.persistence.SchemaCreator$;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.jdbc.JdbcRepo;
import longevity.persistence.mongo.MongoRepo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;

public final class RepoBuilder$ {
    public static RepoBuilder$ MODULE$;

    static {
        new RepoBuilder$();
    }

    public <M> Repo<M> buildRepo(ModelType<M> modelType, BackEnd backEnd, LongevityConfig config, boolean test) {
        Repo<M> repo;
        BackEnd backEnd2 = backEnd;
        if (Cassandra$.MODULE$.equals(backEnd2)) {
            CassandraConfig cassandraConfig = test ? config.test().cassandra() : config.cassandra();
            repo = this.cassandraRepo(modelType, new CassandraRepo.CassandraSessionInfo(cassandraConfig), config);
        } else if (InMem$.MODULE$.equals(backEnd2)) {
            repo = this.inMemTestRepo(modelType, config);
        } else if (MongoDB$.MODULE$.equals(backEnd2)) {
            MongoDBConfig mongoConfig = test ? config.test().mongodb() : config.mongodb();
            repo = this.mongoRepo(modelType, new MongoRepo.MongoSessionInfo(mongoConfig), config);
        } else if (SQLite$.MODULE$.equals(backEnd2)) {
            JdbcConfig jdbcConfig = test ? config.test().jdbc() : config.jdbc();
            repo = this.sqliteRepo(modelType, new JdbcRepo.JdbcSessionInfo(jdbcConfig), config);
        } else if (JDBC$.MODULE$.equals(backEnd2)) {
            JdbcConfig jdbcConfig = test ? config.test().jdbc() : config.jdbc();
            repo = this.jdbcRepo(modelType, new JdbcRepo.JdbcSessionInfo(jdbcConfig), config);
        } else {
            throw new MatchError((Object)backEnd2);
        }
        Repo<M> repo2 = repo;
        Object object = config.autocreateSchema() ? Await$.MODULE$.result(repo2.createSchema((ExecutionContext)ExecutionContext$.MODULE$.global()), (Duration)Duration$.MODULE$.apply(1L, "seconds")) : BoxedUnit.UNIT;
        return repo2;
    }

    private <M> Repo<M> cassandraRepo(ModelType<M> modelType, CassandraRepo.CassandraSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepo(modelType, this.repoFactory$1(modelType, session, persistenceConfig, repoFactory$module), session, persistenceConfig);
    }

    private <M> Repo<M> inMemTestRepo(ModelType<M> modelType, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepo(modelType, this.repoFactory$2(modelType, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private <M> Repo<M> mongoRepo(ModelType<M> modelType, MongoRepo.MongoSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepo(modelType, this.repoFactory$3(modelType, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private <M> Repo<M> sqliteRepo(ModelType<M> modelType, JdbcRepo.JdbcSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepo(modelType, this.repoFactory$4(modelType, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private <M> Repo<M> jdbcRepo(ModelType<M> modelType, JdbcRepo.JdbcSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepo(modelType, this.repoFactory$5(modelType, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private <M, R extends PRepo<Object, Object>> Repo<M> buildRepo(ModelType<M> modelType, RepoBuilder.StockRepoFactory<M, R> stockRepoFactory, SchemaCreator schemaCreator, PersistenceConfig persistenceConfig) {
        ObjectRef keyToRepoMap = ObjectRef.create((Object)TypeKeyMap$.MODULE$.apply());
        modelType.pTypePool().filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)RepoBuilder$.isPolyPType$1(pair))).iterator().foreach((Function1 & Serializable & scala.Serializable)pair -> {
            RepoBuilder$.createRepoFromPair$1(pair, stockRepoFactory, keyToRepoMap);
            return BoxedUnit.UNIT;
        });
        modelType.pTypePool().filterNot((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)RepoBuilder$.isPolyPType$1(pair))).iterator().foreach((Function1 & Serializable & scala.Serializable)pair -> {
            RepoBuilder$.createRepoFromPair$1(pair, stockRepoFactory, keyToRepoMap);
            return BoxedUnit.UNIT;
        });
        Repo repo = new Repo<M>(schemaCreator, keyToRepoMap){
            private final TypeKeyMap<Object, PRepo> pRepoMap;

            public TypeKeyMap<Object, PRepo> pRepoMap() {
                return this.pRepoMap;
            }
            {
                this.pRepoMap = ((TypeKeyMap)keyToRepoMap$1.elem).widen();
            }
        };
        repo.pRepoMap().values().foreach((Function1 & Serializable & scala.Serializable)pRepo -> {
            pRepo._repoOption_$eq(new Some((Object)repo));
            return BoxedUnit.UNIT;
        });
        this.autocreateSchema(repo, persistenceConfig);
        return repo;
    }

    private void autocreateSchema(Repo<?> repo, PersistenceConfig persistenceConfig) {
        block0: {
            if (!persistenceConfig.autocreateSchema()) break block0;
            Await$.MODULE$.result(repo.createSchema(ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.apply(10L, "seconds"));
        }
    }

    private static final /* synthetic */ RepoBuilder$repoFactory$6$ repoFactory$lzycompute$1(ModelType modelType$1, CassandraRepo.CassandraSessionInfo session$1, PersistenceConfig persistenceConfig$1, LazyRef repoFactory$module$1) {
        RepoBuilder$repoFactory$6$ repoBuilder$repoFactory$6$;
        LazyRef lazyRef = repoFactory$module$1;
        synchronized (lazyRef) {
            repoBuilder$repoFactory$6$ = repoFactory$module$1.initialized() ? (RepoBuilder$repoFactory$6$)repoFactory$module$1.value() : (RepoBuilder$repoFactory$6$)repoFactory$module$1.initialize((Object)new RepoBuilder$repoFactory$6$(modelType$1, session$1, persistenceConfig$1));
        }
        return repoBuilder$repoFactory$6$;
    }

    private final RepoBuilder$repoFactory$6$ repoFactory$1(ModelType modelType$1, CassandraRepo.CassandraSessionInfo session$1, PersistenceConfig persistenceConfig$1, LazyRef repoFactory$module$1) {
        return repoFactory$module$1.initialized() ? (RepoBuilder$repoFactory$6$)repoFactory$module$1.value() : RepoBuilder$.repoFactory$lzycompute$1(modelType$1, session$1, persistenceConfig$1, repoFactory$module$1);
    }

    private static final /* synthetic */ RepoBuilder$repoFactory$7$ repoFactory$lzycompute$2(ModelType modelType$2, PersistenceConfig persistenceConfig$2, LazyRef repoFactory$module$2) {
        RepoBuilder$repoFactory$7$ repoBuilder$repoFactory$7$;
        LazyRef lazyRef = repoFactory$module$2;
        synchronized (lazyRef) {
            repoBuilder$repoFactory$7$ = repoFactory$module$2.initialized() ? (RepoBuilder$repoFactory$7$)repoFactory$module$2.value() : (RepoBuilder$repoFactory$7$)repoFactory$module$2.initialize((Object)new RepoBuilder$repoFactory$7$(modelType$2, persistenceConfig$2));
        }
        return repoBuilder$repoFactory$7$;
    }

    private final RepoBuilder$repoFactory$7$ repoFactory$2(ModelType modelType$2, PersistenceConfig persistenceConfig$2, LazyRef repoFactory$module$2) {
        return repoFactory$module$2.initialized() ? (RepoBuilder$repoFactory$7$)repoFactory$module$2.value() : RepoBuilder$.repoFactory$lzycompute$2(modelType$2, persistenceConfig$2, repoFactory$module$2);
    }

    private static final /* synthetic */ RepoBuilder$repoFactory$8$ repoFactory$lzycompute$3(ModelType modelType$3, MongoRepo.MongoSessionInfo session$2, PersistenceConfig persistenceConfig$3, LazyRef repoFactory$module$3) {
        RepoBuilder$repoFactory$8$ repoBuilder$repoFactory$8$;
        LazyRef lazyRef = repoFactory$module$3;
        synchronized (lazyRef) {
            repoBuilder$repoFactory$8$ = repoFactory$module$3.initialized() ? (RepoBuilder$repoFactory$8$)repoFactory$module$3.value() : (RepoBuilder$repoFactory$8$)repoFactory$module$3.initialize((Object)new RepoBuilder$repoFactory$8$(modelType$3, session$2, persistenceConfig$3));
        }
        return repoBuilder$repoFactory$8$;
    }

    private final RepoBuilder$repoFactory$8$ repoFactory$3(ModelType modelType$3, MongoRepo.MongoSessionInfo session$2, PersistenceConfig persistenceConfig$3, LazyRef repoFactory$module$3) {
        return repoFactory$module$3.initialized() ? (RepoBuilder$repoFactory$8$)repoFactory$module$3.value() : RepoBuilder$.repoFactory$lzycompute$3(modelType$3, session$2, persistenceConfig$3, repoFactory$module$3);
    }

    private static final /* synthetic */ RepoBuilder$repoFactory$9$ repoFactory$lzycompute$4(ModelType modelType$4, JdbcRepo.JdbcSessionInfo session$3, PersistenceConfig persistenceConfig$4, LazyRef repoFactory$module$4) {
        RepoBuilder$repoFactory$9$ repoBuilder$repoFactory$9$;
        LazyRef lazyRef = repoFactory$module$4;
        synchronized (lazyRef) {
            repoBuilder$repoFactory$9$ = repoFactory$module$4.initialized() ? (RepoBuilder$repoFactory$9$)repoFactory$module$4.value() : (RepoBuilder$repoFactory$9$)repoFactory$module$4.initialize((Object)new RepoBuilder$repoFactory$9$(modelType$4, session$3, persistenceConfig$4));
        }
        return repoBuilder$repoFactory$9$;
    }

    private final RepoBuilder$repoFactory$9$ repoFactory$4(ModelType modelType$4, JdbcRepo.JdbcSessionInfo session$3, PersistenceConfig persistenceConfig$4, LazyRef repoFactory$module$4) {
        return repoFactory$module$4.initialized() ? (RepoBuilder$repoFactory$9$)repoFactory$module$4.value() : RepoBuilder$.repoFactory$lzycompute$4(modelType$4, session$3, persistenceConfig$4, repoFactory$module$4);
    }

    private static final /* synthetic */ RepoBuilder$repoFactory$10$ repoFactory$lzycompute$5(ModelType modelType$5, JdbcRepo.JdbcSessionInfo session$4, PersistenceConfig persistenceConfig$5, LazyRef repoFactory$module$5) {
        RepoBuilder$repoFactory$10$ repoBuilder$repoFactory$10$;
        LazyRef lazyRef = repoFactory$module$5;
        synchronized (lazyRef) {
            repoBuilder$repoFactory$10$ = repoFactory$module$5.initialized() ? (RepoBuilder$repoFactory$10$)repoFactory$module$5.value() : (RepoBuilder$repoFactory$10$)repoFactory$module$5.initialize((Object)new RepoBuilder$repoFactory$10$(modelType$5, session$4, persistenceConfig$5));
        }
        return repoBuilder$repoFactory$10$;
    }

    private final RepoBuilder$repoFactory$10$ repoFactory$5(ModelType modelType$5, JdbcRepo.JdbcSessionInfo session$4, PersistenceConfig persistenceConfig$5, LazyRef repoFactory$module$5) {
        return repoFactory$module$5.initialized() ? (RepoBuilder$repoFactory$10$)repoFactory$module$5.value() : RepoBuilder$.repoFactory$lzycompute$5(modelType$5, session$4, persistenceConfig$5, repoFactory$module$5);
    }

    private static final void createRepoFromPair$1(TypeBoundPair pair, RepoBuilder.StockRepoFactory stockRepoFactory$1, ObjectRef keyToRepoMap$1) {
        None$ none$;
        TypeKey pTypeKey = (TypeKey)pair._1();
        PType pType = (PType)pair._2();
        PType pType2 = pType;
        if (pType2 instanceof DerivedPType) {
            DerivedPType derivedPType = (DerivedPType)pType2;
            none$ = new Some(derivedPType.polyPTypeKey());
        } else {
            none$ = None$.MODULE$;
        }
        None$ polyKey = none$;
        Object repo = stockRepoFactory$1.build(pType, polyKey.map((Function1 & Serializable & scala.Serializable)x$1 -> (PRepo)((TypeKeyMap)keyToRepoMap$1.elem).apply(x$1)));
        keyToRepoMap$1.elem = ((TypeKeyMap)keyToRepoMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pTypeKey), repo), Predef$.MODULE$.$conforms());
    }

    private static final boolean isPolyPType$1(TypeBoundPair pair) {
        return pair._2() instanceof PolyPType;
    }

    private RepoBuilder$() {
        MODULE$ = this;
    }
}

