/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.exceptions.persistence.WriteConflictException;
import longevity.persistence.BaseRepo;
import longevity.persistence.PState;
import longevity.persistence.cassandra.CassandraRepo;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d4\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C2\u0003\u001f\r\u000b7o]1oIJ\fW\u000b\u001d3bi\u0016T!a\u0001\u0003\u0002\u0013\r\f7o]1oIJ\f'BA\u0003\u0007\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\t\u0011\u0002\\8oO\u00164\u0018\u000e^=\u0016\u0005%93C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001'\u00051A%\u001b8ji\u0012\u001a\u0001\u0001F\u0001\u0015!\tYQ#\u0003\u0002\u0017\u0019\t!QK\\5u\u0011\u0015A\u0002\u0001\"\u0011\u001a\u0003\u0019)\b\u000fZ1uKR\u0011!$\u000e\u000b\u00037A\u00022\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Au\u0011aAR;ukJ,\u0007c\u0001\u0012$K5\tA!\u0003\u0002%\t\t1\u0001k\u0015;bi\u0016\u0004\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001S\t\t\u0001+\u0005\u0002+[A\u00111bK\u0005\u0003Y1\u0011qAT8uQ&tw\r\u0005\u0002\f]%\u0011q\u0006\u0004\u0002\u0004\u0003:L\b\"B\u0019\u0018\u0001\b\u0011\u0014aB2p]R,\u0007\u0010\u001e\t\u00039MJ!\u0001N\u000f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"\u0002\u001c\u0018\u0001\u0004\t\u0013!B:uCR,\u0007\"\u0002\u001d\u0001\t\u0013I\u0014a\u00052j]\u0012,\u0006\u000fZ1uKN#\u0018\r^3nK:$Hc\u0001\u001eG\u000fB\u00111\bR\u0007\u0002y)\u0011QHP\u0001\u0005G>\u0014XM\u0003\u0002@\u0001\u00061AM]5wKJT!!\u0011\"\u0002\u0011\u0011\fG/Y:uCbT\u0011aQ\u0001\u0004G>l\u0017BA#=\u00059\u0011u.\u001e8e'R\fG/Z7f]RDQAN\u001cA\u0002\u0005BQ\u0001S\u001cA\u0002)\t!B]8x-\u0016\u00148/[8o\u0011!Q\u0005\u0001#b\u0001\n\u0013Y\u0015aD;qI\u0006$Xm\u0015;bi\u0016lWM\u001c;\u0016\u00031\u0003\"aO'\n\u00059c$!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\")\u0001\u000b\u0001C\u0005#\u0006IQ\u000f\u001d3bi\u0016\u001c\u0015\u000f\\\u000b\u0002%B\u00111K\u0017\b\u0003)b\u0003\"!\u0016\u0007\u000e\u0003YS!a\u0016\n\u0002\rq\u0012xn\u001c;?\u0013\tIF\"\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-\r\u0011\u0015q\u0006\u0001\"\u0003R\u0003E\u0019w\u000e\\;n]\u0006\u001b8/[4o[\u0016tGo\u001d\u0005\u0006A\u0002!I!U\u0001\u0018o&$\bn\\;u\u0019>\u001c7.\u001b8h+B$\u0017\r^3Dc2DQA\u0019\u0001\u0005\nE\u000bAc^5uQ2{7m[5oOV\u0003H-\u0019;f\u0007Fd\u0007c\u00013fK5\t!!\u0003\u0002g\u0005\ti1)Y:tC:$'/\u0019*fa>\u0004")
public interface CassandraUpdate<P> {
    public static /* synthetic */ Future update$(CassandraUpdate $this, PState state, ExecutionContext context) {
        return $this.update(state, context);
    }

    default public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean updateSuccess;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling CassandraRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((BaseRepo)((Object)this)).validateStablePrimaryKey(state);
            PState newState = state.update(((CassandraRepo)this).persistenceConfig().optimisticLocking(), ((CassandraRepo)this).persistenceConfig().writeTimestamps());
            ResultSet resultSet = (ResultSet)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> ((CassandraRepo)this).session().execute((Statement)this.bindUpdateStatement(newState, state.rowVersionOrNull())));
            if (((CassandraRepo)this).persistenceConfig().optimisticLocking() && !(updateSuccess = resultSet.one().getBool(0))) {
                throw new WriteConflictException(state);
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling CassandraRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }, context);
    }

    private BoundStatement bindUpdateStatement(PState<P> state, Object rowVersion) {
        BoxedUnit boxedUnit;
        Seq columnBindings;
        Seq seq;
        if (((CassandraRepo)this).persistenceConfig().optimisticLocking()) {
            Seq<Object> seq2 = ((CassandraRepo)this).updateColumnValues(state, false);
            seq = (Seq)((SeqLike)((CassandraRepo)this).whereBindings(state).$plus$plus$colon(seq2, Seq$.MODULE$.canBuildFrom())).$colon$plus(rowVersion, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq<Object> seq3 = ((CassandraRepo)this).updateColumnValues(state, false);
            seq = columnBindings = (Seq)((CassandraRepo)this).whereBindings(state).$plus$plus$colon(seq3, Seq$.MODULE$.canBuildFrom());
        }
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoking CQL: ", " with bindings: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement().getQueryString(), columnBindings})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement().bind((Object[])columnBindings.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public static /* synthetic */ PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement$(CassandraUpdate $this) {
        return $this.longevity$persistence$cassandra$CassandraUpdate$$updateStatement();
    }

    default public PreparedStatement longevity$persistence$cassandra$CassandraUpdate$$updateStatement() {
        return ((CassandraRepo)this).preparedStatement(this.updateCql());
    }

    private String updateCql() {
        return ((CassandraRepo)this).persistenceConfig().optimisticLocking() ? this.withLockingUpdateCql() : this.withoutLockingUpdateCql();
    }

    private String columnAssignments() {
        return ((TraversableOnce)((CassandraRepo)this).updateColumnNames(false).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    private String withoutLockingUpdateCql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n  |UPDATE ", "\n  |SET\n  |  ", "\n  |WHERE\n  |  ", "\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), this.columnAssignments(), ((CassandraRepo)this).whereAssignments()})))).stripMargin();
    }

    private String withLockingUpdateCql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "\n  |IF\n  |  row_version = :row_version\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.withoutLockingUpdateCql()})))).stripMargin();
    }

    public static void $init$(CassandraUpdate $this) {
    }
}

