/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence;

import emblem.TypeKey;
import emblem.TypeKeyMap;
import emblem.TypeKeyMap$;
import emblem.typeBound.TypeBoundPair;
import java.io.Serializable;
import longevity.config.BackEnd;
import longevity.config.Cassandra$;
import longevity.config.CassandraConfig;
import longevity.config.InMem$;
import longevity.config.JDBC$;
import longevity.config.JdbcConfig;
import longevity.config.LongevityConfig;
import longevity.config.MongoDB$;
import longevity.config.MongoDBConfig;
import longevity.config.PersistenceConfig;
import longevity.config.SQLite$;
import longevity.model.DerivedPType;
import longevity.model.DomainModel;
import longevity.model.PType;
import longevity.model.PolyPType;
import longevity.persistence.BaseRepo;
import longevity.persistence.RepoPool;
import longevity.persistence.RepoPoolBuilder;
import longevity.persistence.RepoPoolBuilder$repoFactory$10$;
import longevity.persistence.RepoPoolBuilder$repoFactory$6$;
import longevity.persistence.RepoPoolBuilder$repoFactory$7$;
import longevity.persistence.RepoPoolBuilder$repoFactory$8$;
import longevity.persistence.RepoPoolBuilder$repoFactory$9$;
import longevity.persistence.SchemaCreator;
import longevity.persistence.SchemaCreator$;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.jdbc.JdbcRepo;
import longevity.persistence.mongo.MongoRepo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;

public final class RepoPoolBuilder$ {
    public static RepoPoolBuilder$ MODULE$;

    static {
        new RepoPoolBuilder$();
    }

    public RepoPool buildRepoPool(DomainModel domainModel2, BackEnd backEnd, LongevityConfig config, boolean test) {
        RepoPool repoPool;
        BackEnd backEnd2 = backEnd;
        if (Cassandra$.MODULE$.equals(backEnd2)) {
            CassandraConfig cassandraConfig = test ? config.test().cassandra() : config.cassandra();
            repoPool = this.cassandraRepoPool(domainModel2, new CassandraRepo.CassandraSessionInfo(cassandraConfig), config);
        } else if (InMem$.MODULE$.equals(backEnd2)) {
            repoPool = this.inMemTestRepoPool(domainModel2, config);
        } else if (MongoDB$.MODULE$.equals(backEnd2)) {
            MongoDBConfig mongoConfig = test ? config.test().mongodb() : config.mongodb();
            repoPool = this.mongoRepoPool(domainModel2, new MongoRepo.MongoSessionInfo(mongoConfig), config);
        } else if (SQLite$.MODULE$.equals(backEnd2)) {
            JdbcConfig jdbcConfig = test ? config.test().jdbc() : config.jdbc();
            repoPool = this.sqliteRepoPool(domainModel2, new JdbcRepo.JdbcSessionInfo(jdbcConfig), config);
        } else if (JDBC$.MODULE$.equals(backEnd2)) {
            JdbcConfig jdbcConfig = test ? config.test().jdbc() : config.jdbc();
            repoPool = this.jdbcRepoPool(domainModel2, new JdbcRepo.JdbcSessionInfo(jdbcConfig), config);
        } else {
            throw new MatchError((Object)backEnd2);
        }
        RepoPool pool = repoPool;
        Object object = config.autocreateSchema() ? Await$.MODULE$.result(pool.createSchema((ExecutionContext)ExecutionContext$.MODULE$.global()), (Duration)Duration$.MODULE$.apply(1L, "seconds")) : BoxedUnit.UNIT;
        return pool;
    }

    private RepoPool cassandraRepoPool(DomainModel domainModel2, CassandraRepo.CassandraSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(domainModel2, this.repoFactory$1(domainModel2, session, persistenceConfig, repoFactory$module), session, persistenceConfig);
    }

    private RepoPool inMemTestRepoPool(DomainModel domainModel2, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(domainModel2, this.repoFactory$2(domainModel2, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private RepoPool mongoRepoPool(DomainModel domainModel2, MongoRepo.MongoSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(domainModel2, this.repoFactory$3(domainModel2, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private RepoPool sqliteRepoPool(DomainModel domainModel2, JdbcRepo.JdbcSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(domainModel2, this.repoFactory$4(domainModel2, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private RepoPool jdbcRepoPool(DomainModel domainModel2, JdbcRepo.JdbcSessionInfo session, PersistenceConfig persistenceConfig) {
        LazyRef repoFactory$module = new LazyRef();
        return this.buildRepoPool(domainModel2, this.repoFactory$5(domainModel2, session, persistenceConfig, repoFactory$module), SchemaCreator$.MODULE$.empty(), persistenceConfig);
    }

    private <R extends BaseRepo<Object>> RepoPool buildRepoPool(DomainModel domainModel2, RepoPoolBuilder.StockRepoFactory<R> stockRepoFactory, SchemaCreator schemaCreator, PersistenceConfig persistenceConfig) {
        ObjectRef keyToRepoMap = ObjectRef.create((Object)TypeKeyMap$.MODULE$.apply());
        domainModel2.pTypePool().filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)this.isPolyPType(pair))).iterator().foreach((Function1 & Serializable & scala.Serializable)pair -> {
            RepoPoolBuilder$.createRepoFromPair$1(pair, stockRepoFactory, keyToRepoMap);
            return BoxedUnit.UNIT;
        });
        domainModel2.pTypePool().filterNot((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)this.isPolyPType(pair))).iterator().foreach((Function1 & Serializable & scala.Serializable)pair -> {
            RepoPoolBuilder$.createRepoFromPair$1(pair, stockRepoFactory, keyToRepoMap);
            return BoxedUnit.UNIT;
        });
        RepoPool repoPool = new RepoPool((TypeKeyMap<Object, BaseRepo>)((TypeKeyMap)keyToRepoMap.elem).widen(), schemaCreator);
        this.finishRepoInitialization(repoPool);
        this.autocreateSchema(repoPool, persistenceConfig);
        return repoPool;
    }

    private boolean isPolyPType(TypeBoundPair<Object, TypeKey, PType, ?> pair) {
        return pair._2() instanceof PolyPType;
    }

    private void finishRepoInitialization(RepoPool repoPool) {
        repoPool.baseRepoMap().values().foreach((Function1 & Serializable & scala.Serializable)repo -> {
            repo._repoPoolOption_$eq((Option<RepoPool>)new Some((Object)repoPool));
            return BoxedUnit.UNIT;
        });
    }

    private void autocreateSchema(RepoPool repoPool, PersistenceConfig persistenceConfig) {
        block0: {
            if (!persistenceConfig.autocreateSchema()) break block0;
            Await$.MODULE$.result(repoPool.createSchema(ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.apply(10L, "seconds"));
        }
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$6$ repoFactory$lzycompute$1(DomainModel domainModel$1, CassandraRepo.CassandraSessionInfo session$1, PersistenceConfig persistenceConfig$1, LazyRef repoFactory$module$1) {
        RepoPoolBuilder$repoFactory$6$ repoPoolBuilder$repoFactory$6$;
        LazyRef lazyRef = repoFactory$module$1;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$6$ = repoFactory$module$1.initialized() ? (RepoPoolBuilder$repoFactory$6$)repoFactory$module$1.value() : (RepoPoolBuilder$repoFactory$6$)repoFactory$module$1.initialize((Object)new RepoPoolBuilder$repoFactory$6$(domainModel$1, session$1, persistenceConfig$1));
        }
        return repoPoolBuilder$repoFactory$6$;
    }

    private final RepoPoolBuilder$repoFactory$6$ repoFactory$1(DomainModel domainModel$1, CassandraRepo.CassandraSessionInfo session$1, PersistenceConfig persistenceConfig$1, LazyRef repoFactory$module$1) {
        return repoFactory$module$1.initialized() ? (RepoPoolBuilder$repoFactory$6$)repoFactory$module$1.value() : RepoPoolBuilder$.repoFactory$lzycompute$1(domainModel$1, session$1, persistenceConfig$1, repoFactory$module$1);
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$7$ repoFactory$lzycompute$2(DomainModel domainModel$2, PersistenceConfig persistenceConfig$2, LazyRef repoFactory$module$2) {
        RepoPoolBuilder$repoFactory$7$ repoPoolBuilder$repoFactory$7$;
        LazyRef lazyRef = repoFactory$module$2;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$7$ = repoFactory$module$2.initialized() ? (RepoPoolBuilder$repoFactory$7$)repoFactory$module$2.value() : (RepoPoolBuilder$repoFactory$7$)repoFactory$module$2.initialize((Object)new RepoPoolBuilder$repoFactory$7$(domainModel$2, persistenceConfig$2));
        }
        return repoPoolBuilder$repoFactory$7$;
    }

    private final RepoPoolBuilder$repoFactory$7$ repoFactory$2(DomainModel domainModel$2, PersistenceConfig persistenceConfig$2, LazyRef repoFactory$module$2) {
        return repoFactory$module$2.initialized() ? (RepoPoolBuilder$repoFactory$7$)repoFactory$module$2.value() : RepoPoolBuilder$.repoFactory$lzycompute$2(domainModel$2, persistenceConfig$2, repoFactory$module$2);
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$8$ repoFactory$lzycompute$3(DomainModel domainModel$3, MongoRepo.MongoSessionInfo session$2, PersistenceConfig persistenceConfig$3, LazyRef repoFactory$module$3) {
        RepoPoolBuilder$repoFactory$8$ repoPoolBuilder$repoFactory$8$;
        LazyRef lazyRef = repoFactory$module$3;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$8$ = repoFactory$module$3.initialized() ? (RepoPoolBuilder$repoFactory$8$)repoFactory$module$3.value() : (RepoPoolBuilder$repoFactory$8$)repoFactory$module$3.initialize((Object)new RepoPoolBuilder$repoFactory$8$(domainModel$3, session$2, persistenceConfig$3));
        }
        return repoPoolBuilder$repoFactory$8$;
    }

    private final RepoPoolBuilder$repoFactory$8$ repoFactory$3(DomainModel domainModel$3, MongoRepo.MongoSessionInfo session$2, PersistenceConfig persistenceConfig$3, LazyRef repoFactory$module$3) {
        return repoFactory$module$3.initialized() ? (RepoPoolBuilder$repoFactory$8$)repoFactory$module$3.value() : RepoPoolBuilder$.repoFactory$lzycompute$3(domainModel$3, session$2, persistenceConfig$3, repoFactory$module$3);
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$9$ repoFactory$lzycompute$4(DomainModel domainModel$4, JdbcRepo.JdbcSessionInfo session$3, PersistenceConfig persistenceConfig$4, LazyRef repoFactory$module$4) {
        RepoPoolBuilder$repoFactory$9$ repoPoolBuilder$repoFactory$9$;
        LazyRef lazyRef = repoFactory$module$4;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$9$ = repoFactory$module$4.initialized() ? (RepoPoolBuilder$repoFactory$9$)repoFactory$module$4.value() : (RepoPoolBuilder$repoFactory$9$)repoFactory$module$4.initialize((Object)new RepoPoolBuilder$repoFactory$9$(domainModel$4, session$3, persistenceConfig$4));
        }
        return repoPoolBuilder$repoFactory$9$;
    }

    private final RepoPoolBuilder$repoFactory$9$ repoFactory$4(DomainModel domainModel$4, JdbcRepo.JdbcSessionInfo session$3, PersistenceConfig persistenceConfig$4, LazyRef repoFactory$module$4) {
        return repoFactory$module$4.initialized() ? (RepoPoolBuilder$repoFactory$9$)repoFactory$module$4.value() : RepoPoolBuilder$.repoFactory$lzycompute$4(domainModel$4, session$3, persistenceConfig$4, repoFactory$module$4);
    }

    private static final /* synthetic */ RepoPoolBuilder$repoFactory$10$ repoFactory$lzycompute$5(DomainModel domainModel$5, JdbcRepo.JdbcSessionInfo session$4, PersistenceConfig persistenceConfig$5, LazyRef repoFactory$module$5) {
        RepoPoolBuilder$repoFactory$10$ repoPoolBuilder$repoFactory$10$;
        LazyRef lazyRef = repoFactory$module$5;
        synchronized (lazyRef) {
            repoPoolBuilder$repoFactory$10$ = repoFactory$module$5.initialized() ? (RepoPoolBuilder$repoFactory$10$)repoFactory$module$5.value() : (RepoPoolBuilder$repoFactory$10$)repoFactory$module$5.initialize((Object)new RepoPoolBuilder$repoFactory$10$(domainModel$5, session$4, persistenceConfig$5));
        }
        return repoPoolBuilder$repoFactory$10$;
    }

    private final RepoPoolBuilder$repoFactory$10$ repoFactory$5(DomainModel domainModel$5, JdbcRepo.JdbcSessionInfo session$4, PersistenceConfig persistenceConfig$5, LazyRef repoFactory$module$5) {
        return repoFactory$module$5.initialized() ? (RepoPoolBuilder$repoFactory$10$)repoFactory$module$5.value() : RepoPoolBuilder$.repoFactory$lzycompute$5(domainModel$5, session$4, persistenceConfig$5, repoFactory$module$5);
    }

    private static final void createRepoFromPair$1(TypeBoundPair pair, RepoPoolBuilder.StockRepoFactory stockRepoFactory$1, ObjectRef keyToRepoMap$1) {
        None$ none$;
        TypeKey pTypeKey = (TypeKey)pair._1();
        PType pType = (PType)pair._2();
        PType pType2 = pType;
        if (pType2 instanceof DerivedPType) {
            DerivedPType derivedPType = (DerivedPType)pType2;
            none$ = new Some(derivedPType.polyPTypeKey());
        } else {
            none$ = None$.MODULE$;
        }
        None$ polyKey = none$;
        Object repo = stockRepoFactory$1.build(pType, polyKey.map((Function1 & Serializable & scala.Serializable)x$1 -> (BaseRepo)((TypeKeyMap)keyToRepoMap$1.elem).apply(x$1)));
        keyToRepoMap$1.elem = ((TypeKeyMap)keyToRepoMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pTypeKey), repo), Predef$.MODULE$.$conforms());
    }

    private RepoPoolBuilder$() {
        MODULE$ = this;
    }
}

