/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.jdbc;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import java.sql.PreparedStatement;
import longevity.exceptions.persistence.WriteConflictException;
import longevity.persistence.BaseRepo;
import longevity.persistence.PState;
import longevity.persistence.jdbc.JdbcRepo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C-\u0003\u0015)#'mY+qI\u0006$XM\u0003\u0002\u0004\t\u0005!!\u000e\u001a2d\u0015\t)a!A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"A\u0004\u0002\u00131|gnZ3wSRLXCA\u0005('\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\taE\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\tA\u0003\u0005\u0002\f+%\u0011a\u0003\u0004\u0002\u0005+:LG\u000fC\u0003\u0019\u0001\u0011\u0005\u0013$\u0001\u0004va\u0012\fG/\u001a\u000b\u00035U\"\"a\u0007\u0019\u0011\u0007qy\u0012%D\u0001\u001e\u0015\tqB\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001I\u000f\u0003\r\u0019+H/\u001e:f!\r\u00113%J\u0007\u0002\t%\u0011A\u0005\u0002\u0002\u0007!N#\u0018\r^3\u0011\u0005\u0019:C\u0002\u0001\u0003\u0006Q\u0001\u0011\r!\u000b\u0002\u0002!F\u0011!&\f\t\u0003\u0017-J!\u0001\f\u0007\u0003\u000f9{G\u000f[5oOB\u00111BL\u0005\u0003_1\u00111!\u00118z\u0011\u0015\tt\u0003q\u00013\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001H\u001a\n\u0005Qj\"\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u00151t\u00031\u0001\"\u0003\u0015\u0019H/\u0019;f\u0011\u0015A\u0004\u0001\"\u0003:\u0003M\u0011\u0017N\u001c3Va\u0012\fG/Z*uCR,W.\u001a8u)\rQ$i\u0011\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\n1a]9m\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003#A\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000fC\u00037o\u0001\u0007\u0011\u0005C\u0003Eo\u0001\u0007!\"\u0001\u0006s_^4VM]:j_:DQA\u0012\u0001\u0005\n\u001d\u000b\u0011\"\u001e9eCR,7+\u001d7\u0016\u0003!\u0003\"!\u0013)\u000f\u0005)s\u0005CA&\r\u001b\u0005a%BA'\u0013\u0003\u0019a$o\\8u}%\u0011q\nD\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P\u0019!)A\u000b\u0001C\u0005\u000f\u0006\t2m\u001c7v[:\f5o]5h]6,g\u000e^:\t\u000bY\u0003A\u0011B$\u0002/]LG\u000f[8vi2{7m[5oOV\u0003H-\u0019;f'Fd\u0007\"\u0002-\u0001\t\u00139\u0015\u0001F<ji\"dunY6j]\u001e,\u0006\u000fZ1uKN\u000bH\u000eE\u0002[7\u0016j\u0011AA\u0005\u00039\n\u0011\u0001B\u00133cGJ+\u0007o\u001c")
public interface JdbcUpdate<P> {
    public static /* synthetic */ Future update$(JdbcUpdate $this, PState state, ExecutionContext context) {
        return $this.update(state, context);
    }

    default public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling JdbcRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((BaseRepo)((Object)this)).validateStablePrimaryKey(state);
            PState newState = state.update(((JdbcRepo)this).persistenceConfig().optimisticLocking(), ((JdbcRepo)this).persistenceConfig().writeTimestamps());
            Object rowCount = package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                try {
                    PreparedStatement stmt = this.bindUpdateStatement(newState, state.rowVersionOrNull());
                    object = BoxesRunTime.boxToInteger((int)stmt.executeUpdate());
                }
                catch (Throwable x$1) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr$1 = ((JdbcRepo)this).convertDuplicateKeyException(newState);
                    if (catchExpr$1.isDefinedAt((Object)x$1)) {
                        object = catchExpr$1.apply((Object)x$1);
                    }
                    throw x$1;
                }
                return object;
            });
            if (((JdbcRepo)this).persistenceConfig().optimisticLocking() && !BoxesRunTime.equals((Object)rowCount, (Object)BoxesRunTime.boxToInteger((int)1))) {
                throw new WriteConflictException(state);
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling JdbcRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }, context);
    }

    private PreparedStatement bindUpdateStatement(PState<P> state, Object rowVersion) {
        BoxedUnit boxedUnit;
        Seq columnBindings;
        Seq seq;
        if (((JdbcRepo)this).persistenceConfig().optimisticLocking()) {
            Seq<Object> seq2 = ((JdbcRepo)this).updateColumnValues(state, false);
            seq = (Seq)((SeqLike)((JdbcRepo)this).whereBindings(state).$plus$plus$colon(seq2, Seq$.MODULE$.canBuildFrom())).$colon$plus(rowVersion, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq<Object> seq3 = ((JdbcRepo)this).updateColumnValues(state, false);
            seq = columnBindings = (Seq)((JdbcRepo)this).whereBindings(state).$plus$plus$colon(seq3, Seq$.MODULE$.canBuildFrom());
        }
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoking SQL: ", " with bindings: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updateSql(), columnBindings})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        PreparedStatement preparedStatement = ((JdbcRepo)this).connection().prepareStatement(this.updateSql());
        ((IterableLike)columnBindings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JdbcUpdate.$anonfun$bindUpdateStatement$1(preparedStatement, x0$1);
            return BoxedUnit.UNIT;
        });
        return preparedStatement;
    }

    private String updateSql() {
        return ((JdbcRepo)this).persistenceConfig().optimisticLocking() ? this.withLockingUpdateSql() : this.withoutLockingUpdateSql();
    }

    private String columnAssignments() {
        return ((TraversableOnce)((JdbcRepo)this).updateColumnNames(false).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    private String withoutLockingUpdateSql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n  |UPDATE ", "\n  |SET\n  |  ", "\n  |WHERE\n  |  ", "\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcRepo)this).tableName(), this.columnAssignments(), ((JdbcRepo)this).whereAssignments()})))).stripMargin();
    }

    private String withLockingUpdateSql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "\n  |AND\n  |  row_version = :old_row_version\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.withoutLockingUpdateSql()})))).stripMargin();
    }

    public static /* synthetic */ void $anonfun$bindUpdateStatement$1(PreparedStatement preparedStatement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object binding = tuple2._1();
        int index = tuple2._2$mcI$sp();
        preparedStatement$1.setObject(index + 1, binding);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(JdbcUpdate $this) {
    }
}

