/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.sqlite;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import java.sql.PreparedStatement;
import longevity.exceptions.persistence.WriteConflictException;
import longevity.persistence.BaseRepo;
import longevity.persistence.PState;
import longevity.persistence.sqlite.SQLiteRepo;
import org.sqlite.SQLiteException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u3\u0011\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001C-\u0003\u0019M\u000bF*\u001b;f+B$\u0017\r^3\u000b\u0005\r!\u0011AB:rY&$XM\u0003\u0002\u0006\r\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\u00059\u0011!\u00037p]\u001e,g/\u001b;z+\tIqe\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002M\ta\u0001J5oSR$3\u0001\u0001\u000b\u0002)A\u00111\"F\u0005\u0003-1\u0011A!\u00168ji\")\u0001\u0004\u0001C!3\u00051Q\u000f\u001d3bi\u0016$\"AG\u001b\u0015\u0005m\u0001\u0004c\u0001\u000f C5\tQD\u0003\u0002\u001f\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0001j\"A\u0002$viV\u0014X\rE\u0002#G\u0015j\u0011\u0001B\u0005\u0003I\u0011\u0011a\u0001U*uCR,\u0007C\u0001\u0014(\u0019\u0001!Q\u0001\u000b\u0001C\u0002%\u0012\u0011\u0001U\t\u0003U5\u0002\"aC\u0016\n\u00051b!a\u0002(pi\"Lgn\u001a\t\u0003\u00179J!a\f\u0007\u0003\u0007\u0005s\u0017\u0010C\u00032/\u0001\u000f!'A\u0004d_:$X\r\u001f;\u0011\u0005q\u0019\u0014B\u0001\u001b\u001e\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u00037/\u0001\u0007\u0011%A\u0003ti\u0006$X\rC\u00039\u0001\u0011%\u0011(A\ncS:$W\u000b\u001d3bi\u0016\u001cF/\u0019;f[\u0016tG\u000fF\u0002;\u0005\u000e\u0003\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u0007M\fHNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\")ag\u000ea\u0001C!)Ai\u000ea\u0001\u0015\u0005Q!o\\<WKJ\u001c\u0018n\u001c8\t\u000b\u0019\u0003A\u0011B$\u0002\u0013U\u0004H-\u0019;f'FdW#\u0001%\u0011\u0005%\u0003fB\u0001&O!\tYE\"D\u0001M\u0015\ti%#\u0001\u0004=e>|GOP\u0005\u0003\u001f2\ta\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011q\n\u0004\u0005\u0006)\u0002!IaR\u0001\u0012G>dW/\u001c8BgNLwM\\7f]R\u001c\b\"\u0002,\u0001\t\u00139\u0015aF<ji\"|W\u000f\u001e'pG.LgnZ+qI\u0006$XmU9m\u0011\u0015A\u0006\u0001\"\u0003H\u0003Q9\u0018\u000e\u001e5M_\u000e\\\u0017N\\4Va\u0012\fG/Z*rYB\u0019!lW\u0013\u000e\u0003\tI!\u0001\u0018\u0002\u0003\u0015M\u000bF*\u001b;f%\u0016\u0004x\u000e")
public interface SQLiteUpdate<P> {
    public static /* synthetic */ Future update$(SQLiteUpdate $this, PState state, ExecutionContext context) {
        return $this.update(state, context);
    }

    default public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"calling SQLiteRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ((BaseRepo)((Object)this)).validateStablePrimaryKey(state);
            PState newState = state.update(((SQLiteRepo)this).persistenceConfig().optimisticLocking());
            int rowCount = BoxesRunTime.unboxToInt((Object)package$.MODULE$.blocking((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int n;
                try {
                    n = this.bindUpdateStatement(newState, state.rowVersionOrNull()).executeUpdate();
                }
                catch (Throwable throwable) {
                    SQLiteException sQLiteException;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SQLiteException && (sQLiteException = (SQLiteException)throwable2).getMessage().contains("UNIQUE constraint failed")) {
                        throw ((SQLiteRepo)this).throwDuplicateKeyValException(state.get(), sQLiteException);
                    }
                    throw throwable;
                }
                return n;
            }));
            if (((SQLiteRepo)this).persistenceConfig().optimisticLocking() && rowCount != 1) {
                throw new WriteConflictException(state);
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done calling SQLiteRepo.update: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }, context);
    }

    private PreparedStatement bindUpdateStatement(PState<P> state, Object rowVersion) {
        BoxedUnit boxedUnit;
        Seq columnBindings;
        Seq seq;
        if (((SQLiteRepo)this).persistenceConfig().optimisticLocking()) {
            Seq<Object> seq2 = ((SQLiteRepo)this).updateColumnValues(state, false);
            seq = (Seq)((SeqLike)((SQLiteRepo)this).whereBindings(state).$plus$plus$colon(seq2, Seq$.MODULE$.canBuildFrom())).$colon$plus(rowVersion, Seq$.MODULE$.canBuildFrom());
        } else {
            Seq<Object> seq3 = ((SQLiteRepo)this).updateColumnValues(state, false);
            seq = columnBindings = (Seq)((SQLiteRepo)this).whereBindings(state).$plus$plus$colon(seq3, Seq$.MODULE$.canBuildFrom());
        }
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoking SQL: ", " with bindings: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updateSql(), columnBindings})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        PreparedStatement preparedStatement = ((SQLiteRepo)this).connection().prepareStatement(this.updateSql());
        ((IterableLike)columnBindings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SQLiteUpdate.$anonfun$bindUpdateStatement$1(preparedStatement, x0$1);
            return BoxedUnit.UNIT;
        });
        return preparedStatement;
    }

    private String updateSql() {
        return ((SQLiteRepo)this).persistenceConfig().optimisticLocking() ? this.withLockingUpdateSql() : this.withoutLockingUpdateSql();
    }

    private String columnAssignments() {
        return ((TraversableOnce)((SQLiteRepo)this).updateColumnNames(false).map((Function1 & Serializable & scala.Serializable)c -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c})), Seq$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    private String withoutLockingUpdateSql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n  |UPDATE ", "\n  |SET\n  |  ", "\n  |WHERE\n  |  ", "\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)this).tableName(), this.columnAssignments(), ((SQLiteRepo)this).whereAssignments()})))).stripMargin();
    }

    private String withLockingUpdateSql() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "\n  |AND\n  |  row_version = :old_row_version\n  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.withoutLockingUpdateSql()})))).stripMargin();
    }

    public static /* synthetic */ void $anonfun$bindUpdateStatement$1(PreparedStatement preparedStatement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object binding = tuple2._1();
        int index = tuple2._2$mcI$sp();
        preparedStatement$1.setObject(index + 1, binding);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(SQLiteUpdate $this) {
    }
}

