/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.sqlite;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.model.ptype.Index;
import longevity.model.realized.RealizedKey;
import longevity.model.realized.RealizedPrimaryKey;
import longevity.model.realized.RealizedProp;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.BaseRepo;
import longevity.persistence.sqlite.SQLiteRepo;
import longevity.persistence.sqlite.SQLiteRepo$;
import org.sqlite.SQLiteException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005UcAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u0002N\ta1+\u0015'ji\u0016\u001c6\r[3nC*\u00111\u0001B\u0001\u0007gFd\u0017\u000e^3\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\nY>tw-\u001a<jif,\"!\u0003-\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\rC\u0003\u0012\u0001\u0011\u00051#\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005!\u0002CA\u0006\u0016\u0013\t1BB\u0001\u0003V]&$\bB\u0002\r\u0001\t#!\u0011$\u0001\u0007de\u0016\fG/Z*dQ\u0016l\u0017\rF\u0001\u001b)\tY\u0012\u0005E\u0002\u001d?Qi\u0011!\b\u0006\u0003=1\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0001SD\u0001\u0004GkR,(/\u001a\u0005\u0006E]\u0001\u001daI\u0001\bG>tG/\u001a=u!\taB%\u0003\u0002&;\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006O\u0001!\tbE\u0001\fGJ,\u0017\r^3UC\ndW\rC\u0003*\u0001\u0011%!&A\u0003jI\u0012+g-F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u0015;sS:<\u0007\"\u0002\u001b\u0001\t\u0013)\u0014!H1diV\fG.\u001b>fI\u000e{W\u000e]8oK:$8i\u001c7v[:$UMZ:\u0016\u0003Y\u0002\"a\u000e \u000f\u0005ab\u0004CA\u001d\r\u001b\u0005Q$BA\u001e\u0013\u0003\u0019a$o\\8u}%\u0011Q\bD\u0001\u0007!J,G-\u001a4\n\u0005Iz$BA\u001f\r\u0011\u0015\t\u0005\u0001\"\u00036\u00035\u0001(/[7bef\\U-\u001f#fM\")1\t\u0001C\u0005k\u0005\u0001\u0002/\u0019:uSRLwN\\\"pYVlgn\u001d\u0005\u0006\u000b\u0002!IAR\u0001\nG>dW/\u001c8EK\u001a$\"AN$\t\u000b!#\u0005\u0019A%\u0002\u0013\r|W\u000e]8oK:$\b\u0007\u0002&UE\u0016\u0004Ra\u0013)SC\u0012l\u0011\u0001\u0014\u0006\u0003\u001b:\u000b\u0001B]3bY&TX\r\u001a\u0006\u0003\u001f\u001a\tQ!\\8eK2L!!\u0015'\u0003+I+\u0017\r\\5{K\u0012\u0004&o\u001c9D_6\u0004xN\\3oiB\u00111\u000b\u0016\u0007\u0001\t%)v)!A\u0001\u0002\u000b\u0005aKA\u0002`IE\n\"a\u00160\u0011\u0005MCF!B-\u0001\u0005\u0004Q&!\u0001)\u0012\u0005ms\u0006CA\u0006]\u0013\tiFBA\u0004O_RD\u0017N\\4\u0011\u0005-y\u0016B\u00011\r\u0005\r\te.\u001f\t\u0003'\n$\u0011bY$\u0002\u0002\u0003\u0005)\u0011\u0001.\u0003\u0007}##\u0007\u0005\u0002TK\u0012IamRA\u0001\u0002\u0003\u0015\tA\u0017\u0002\u0004?\u0012\u001a\u0004\"\u00025\u0001\t#I\u0017!C1eI\u000e{G.^7o)\r!\"\u000e\u001c\u0005\u0006W\u001e\u0004\rAN\u0001\u000bG>dW/\u001c8OC6,\u0007\"B7h\u0001\u00041\u0014AC2pYVlg\u000eV=qK\")q\u000e\u0001C\ta\u0006)2m\\7q_:,g\u000e\u001e+p'Fc\u0015\u000e^3UsB,WCA9})\t1$\u000fC\u0003I]\u0002\u00071\u000fM\u0002umf\u0004Ra\u0013)vqn\u0004\"a\u0015<\u0005\u0013]\u0014\u0018\u0011!A\u0001\u0006\u00031&aA0%iA\u00111+\u001f\u0003\nuJ\f\t\u0011!A\u0003\u0002i\u00131a\u0018\u00136!\t\u0019F\u0010B\u0003~]\n\u0007!LA\u0001B\u0011\u0015y\b\u0001\"\u0005\u0014\u0003M\u0019'/Z1uKVs\u0017.];f\u0013:$W\r_3t\u0011\u0019\t\u0019\u0001\u0001C\t'\u000512M]3bi\u0016tuN\\+oSF,X-\u00138eKb,7\u000fC\u0004\u0002\b\u0001!\t\"!\u0003\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\b)\u0005-\u0011QCA\r\u0011!\ti!!\u0002A\u0002\u0005=\u0011AB;oSF,X\rE\u0002\f\u0003#I1!a\u0005\r\u0005\u001d\u0011un\u001c7fC:Dq!a\u0006\u0002\u0006\u0001\u0007a'A\u0005j]\u0012,\u0007PT1nK\"A\u00111DA\u0003\u0001\u0004\ti\"A\u0006d_2,XN\u001c(b[\u0016\u001c\b#BA\u0010\u0003S1d\u0002BA\u0011\u0003Kq1!OA\u0012\u0013\u0005i\u0011bAA\u0014\u0019\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0016\u0003[\u00111aU3r\u0015\r\t9\u0003\u0004\u0005\b\u0003c\u0001A\u0011BA\u001a\u0003)\u00198m\u001c:fIB\u000bG\u000f\u001b\u000b\u0004W\u0005U\u0002\u0002CA\u001c\u0003_\u0001\r!!\u000f\u0002\tA\u0014x\u000e\u001d\u0019\u0007\u0003w\t\u0019%!\u0013\u0011\u000f-\u000bi$!\u0011\u0002H%\u0019\u0011q\b'\u0003\u0019I+\u0017\r\\5{K\u0012\u0004&o\u001c9\u0011\u0007M\u000b\u0019\u0005B\u0006\u0002F\u0005U\u0012\u0011!A\u0001\u0006\u0003Q&\u0001B0%cM\u00022aUA%\t-\tY%!\u000e\u0002\u0002\u0003\u0005)\u0011\u0001.\u0003\t}#\u0013\u0007\u000e\t\u0006\u0003\u001f\n\tfV\u0007\u0002\u0005%\u0019\u00111\u000b\u0002\u0003\u0015M\u000bF*\u001b;f%\u0016\u0004x\u000e")
public interface SQLiteSchema<P> {
    public static /* synthetic */ Future createSchema$(SQLiteSchema $this, ExecutionContext context) {
        return $this.createSchema(context);
    }

    default public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)this).tableName()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.createTable();
            this.createUniqueIndexes();
            this.createNonUniqueIndexes();
            if (((SQLiteRepo)this).persistenceConfig().optimisticLocking()) {
                this.addColumn("row_version", "bigint");
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)this).tableName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), context);
    }

    public static /* synthetic */ void createTable$(SQLiteSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", "\n    |  ", "\n    |)\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createTable})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((SQLiteRepo)this).connection().prepareStatement(createTable).execute();
    }

    private String idDef() {
        return ((BaseRepo)((Object)this)).hasPrimaryKey() ? "" : "\n  id text,";
    }

    private String actualizedComponentColumnDefs() {
        String s = ((TraversableOnce)((SQLiteRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component2 -> this.columnDef((RealizedPropComponent)component2), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
        return s.isEmpty() ? s : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s}));
    }

    private String primaryKeyDef() {
        return ((BaseRepo)((Object)this)).hasPrimaryKey() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
    }

    private String partitionColumns() {
        return ((TraversableOnce)((SQLiteRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((SQLiteRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? super P, ?, ?> component2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)this).columnName(component2), this.componentToSQLiteType(component2)}));
    }

    public static /* synthetic */ void addColumn$(SQLiteSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            ((SQLiteRepo)this).connection().prepareStatement(sql).execute();
        }
        catch (Throwable throwable) {
            SQLiteException sQLiteException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SQLiteException && (sQLiteException = (SQLiteException)throwable2).getMessage().contains("duplicate column name: ")) {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ String componentToSQLiteType$(SQLiteSchema $this, RealizedPropComponent component2) {
        return $this.componentToSQLiteType(component2);
    }

    default public <A> String componentToSQLiteType(RealizedPropComponent<? super P, ?, A> component2) {
        return (String)SQLiteRepo$.MODULE$.basicToSQLiteType().apply(component2.componentTypeKey());
    }

    public static /* synthetic */ void createUniqueIndexes$(SQLiteSchema $this) {
        $this.createUniqueIndexes();
    }

    default public void createUniqueIndexes() {
        Set nonPrimaryKeys = (Set)((BaseRepo)((Object)this)).realizedPType().keySet().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLiteSchema.$anonfun$createUniqueIndexes$1(x$1)));
        nonPrimaryKeys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            SQLiteSchema.$anonfun$createUniqueIndexes$2(this, key);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createNonUniqueIndexes$(SQLiteSchema $this) {
        $this.createNonUniqueIndexes();
    }

    default public void createNonUniqueIndexes() {
        ((BaseRepo)((Object)this)).pType().indexSet().foreach((Function1 & Serializable & scala.Serializable)index -> {
            SQLiteSchema.$anonfun$createNonUniqueIndexes$1(this, index);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(SQLiteSchema $this, boolean unique, String indexName, Seq columnNames) {
        $this.createIndex(unique, indexName, (Seq<String>)columnNames);
    }

    default public void createIndex(boolean unique, String indexName, Seq<String> columnNames) {
        BoxedUnit boxedUnit;
        String prefix = unique ? "CREATE UNIQUE INDEX" : "CREATE INDEX";
        String columnList = columnNames.mkString(", ");
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, indexName, ((SQLiteRepo)this).tableName(), columnList}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing SQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createIndex})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((SQLiteRepo)this).connection().prepareStatement(createIndex).execute();
    }

    private String scoredPath(RealizedProp<?, ?> prop) {
        return prop.inlinedPath().replace('.', '_');
    }

    public static /* synthetic */ boolean $anonfun$createUniqueIndexes$1(RealizedKey x$1) {
        return x$1 instanceof RealizedPrimaryKey;
    }

    public static /* synthetic */ void $anonfun$createUniqueIndexes$2(SQLiteSchema $this, RealizedKey key) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)$this).tableName(), $this.scoredPath(key.realizedProp())}));
        Seq columnsNames = (Seq)key.realizedProp().realizedPropComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((SQLiteRepo)$this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        $this.createIndex(true, indexName, (Seq<String>)columnsNames);
    }

    private static Seq toComponents$1(RealizedProp prop) {
        return prop.realizedPropComponents();
    }

    public static /* synthetic */ void $anonfun$createNonUniqueIndexes$1(SQLiteSchema $this, Index index) {
        Seq realizedProps = (Seq)index.props().map((Function1 & Serializable & scala.Serializable)x$2 -> (RealizedProp)((BaseRepo)((Object)$this)).realizedPType().realizedProps().apply(x$2), Seq$.MODULE$.canBuildFrom());
        Seq scoredPaths = (Seq)realizedProps.map((Function1 & Serializable & scala.Serializable)prop -> $this.scoredPath((RealizedProp<?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SQLiteRepo)$this).tableName(), scoredPaths.mkString("__")}));
        Seq columnsNames = (Seq)((TraversableLike)realizedProps.flatMap((Function1 & Serializable & scala.Serializable)prop -> SQLiteSchema.toComponents$1(prop), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)prop -> ((SQLiteRepo)$this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom());
        $this.createIndex(false, indexName, (Seq<String>)columnsNames);
    }

    public static void $init$(SQLiteSchema $this) {
    }
}

