/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.mongo;

import akka.NotUsed;
import akka.stream.scaladsl.Source;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import emblem.TypeKey;
import emblem.stringUtil$;
import java.io.Serializable;
import longevity.config.MongoConfig;
import longevity.config.PersistenceConfig;
import longevity.model.DomainModel;
import longevity.model.KeyVal;
import longevity.model.PType;
import longevity.model.ptype.Prop;
import longevity.model.query.Query;
import longevity.model.query.QueryFilter;
import longevity.model.query.RelationalOp;
import longevity.model.realized.RealizedKey;
import longevity.persistence.BaseRepo;
import longevity.persistence.Deleted;
import longevity.persistence.PState;
import longevity.persistence.mongo.BsonToDomainModelTranslator;
import longevity.persistence.mongo.DomainModelToBsonTranslator;
import longevity.persistence.mongo.MongoCreate;
import longevity.persistence.mongo.MongoDelete;
import longevity.persistence.mongo.MongoQuery;
import longevity.persistence.mongo.MongoRead;
import longevity.persistence.mongo.MongoRepo$;
import longevity.persistence.mongo.MongoRetrieve;
import longevity.persistence.mongo.MongoSchema;
import longevity.persistence.mongo.MongoUpdate;
import longevity.persistence.mongo.MongoWrite;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0001\u0003\u0001\u0019A!!C'p]\u001e|'+\u001a9p\u0015\t\u0019A!A\u0003n_:<wN\u0003\u0002\u0006\r\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\u00059\u0011!\u00037p]\u001e,g/\u001b;z+\tI\u0001cE\u0006\u0001\u0015u\tCe\n\u0016.aM2\u0004cA\u0006\r\u001d5\tA!\u0003\u0002\u000e\t\tA!)Y:f%\u0016\u0004x\u000e\u0005\u0002\u0010!1\u0001A!B\t\u0001\u0005\u0004\u0019\"!\u0001)\u0004\u0001E\u0011AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\b\u001d>$\b.\u001b8h!\t)2$\u0003\u0002\u001d-\t\u0019\u0011I\\=\u0011\u0007yyb\"D\u0001\u0003\u0013\t\u0001#AA\u0006N_:<wn\u0011:fCR,\u0007c\u0001\u0010#\u001d%\u00111E\u0001\u0002\f\u001b>twm\u001c#fY\u0016$X\rE\u0002\u001fK9I!A\n\u0002\u0003\u00155{gnZ8Rk\u0016\u0014\u0018\u0010E\u0002\u001fQ9I!!\u000b\u0002\u0003\u00135{gnZ8SK\u0006$\u0007c\u0001\u0010,\u001d%\u0011AF\u0001\u0002\u000e\u001b>twm\u001c*fiJLWM^3\u0011\u0007yqc\"\u0003\u00020\u0005\tYQj\u001c8h_N\u001b\u0007.Z7b!\rq\u0012GD\u0005\u0003e\t\u00111\"T8oO>,\u0006\u000fZ1uKB\u0019a\u0004\u000e\b\n\u0005U\u0012!AC'p]\u001e|wK]5uKB\u0011qGP\u0007\u0002q)\u0011\u0011HO\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003wq\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002{\u0005\u00191m\\7\n\u0005}B$a\u0003'bufdunZ4j]\u001eD\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011%\u0002\u000bA$\u0016\u0010]3\u0011\u0007\r3e\"D\u0001E\u0015\t)e!A\u0003n_\u0012,G.\u0003\u0002H\t\n)\u0001\u000bV=qK&\u0011\u0011\t\u0004\u0005\n\u0015\u0002\u0011\t\u0011)A\u0005\u0017:\u000b1\u0002Z8nC&tWj\u001c3fYB\u00111\tT\u0005\u0003\u001b\u0012\u00131\u0002R8nC&tWj\u001c3fY&\u0011!\n\u0004\u0005\t!\u0002\u0011)\u0019!C\t#\u000691/Z:tS>tW#\u0001*\u0011\u0005M{fB\u0001\u0010U\u000f\u0019)&\u0001#\u0001\u0005-\u0006IQj\u001c8h_J+\u0007o\u001c\t\u0003=]3a!\u0001\u0002\t\u0002\u0011A6CA,Z!\t)\",\u0003\u0002\\-\t1\u0011I\\=SK\u001aDQ!X,\u0005\u0002y\u000ba\u0001P5oSRtD#\u0001,\u0007\t\u0001<\u0006)\u0019\u0002\u0011\u001b>twm\\*fgNLwN\\%oM>\u001cBaX-cKB\u0011QcY\u0005\u0003IZ\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0016M&\u0011qM\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tS~\u0013)\u001a!C\u0001U\u000611m\u001c8gS\u001e,\u0012a\u001b\t\u0003Y:l\u0011!\u001c\u0006\u0003S\u001aI!a\\7\u0003\u00175{gnZ8D_:4\u0017n\u001a\u0005\tc~\u0013\t\u0012)A\u0005W\u000691m\u001c8gS\u001e\u0004\u0003\"B/`\t\u0003\u0019HC\u0001;w!\t)x,D\u0001X\u0011\u0015I'\u000f1\u0001l\u0011!Ax\f#b\u0001\n\u0003I\u0018AB2mS\u0016tG/F\u0001{!\tYh0D\u0001}\u0015\tiH(A\u0004n_:<w\u000e\u001a2\n\u0005}d(aC'p]\u001e|7\t\\5f]RD!\"a\u0001`\u0011\u000b\u0007I\u0011AA\u0003\u0003\t!'-\u0006\u0002\u0002\bA!\u0011\u0011BA\u0007\u001b\t\tYA\u0003\u0002yy&!\u0011qBA\u0006\u00055iuN\\4p\t\u0006$\u0018MY1tK\"I\u00111C0\u0002\u0002\u0013\u0005\u0011QC\u0001\u0005G>\u0004\u0018\u0010F\u0002u\u0003/A\u0001\"[A\t!\u0003\u0005\ra\u001b\u0005\n\u00037y\u0016\u0013!C\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002 )\u001a1.!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\t9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u000e`\u0003\u0003%\t%a\u000e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\nAA[1wC&!\u0011qIA\u001f\u0005\u0019\u0019FO]5oO\"I\u00111J0\u0002\u0002\u0013\u0005\u0011QJ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001f\u00022!FA)\u0013\r\t\u0019F\u0006\u0002\u0004\u0013:$\b\"CA,?\u0006\u0005I\u0011AA-\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AGA.\u0011)\ti&!\u0016\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0004\"CA1?\u0006\u0005I\u0011IA2\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA3!\u0015\t9'!\u001c\u001b\u001b\t\tIGC\u0002\u0002lY\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0011%#XM]1u_JD\u0011\"a\u001d`\u0003\u0003%\t!!\u001e\u0002\u0011\r\fg.R9vC2$B!a\u001e\u0002~A\u0019Q#!\u001f\n\u0007\u0005mdCA\u0004C_>dW-\u00198\t\u0013\u0005u\u0013\u0011OA\u0001\u0002\u0004Q\u0002\"CAA?\u0006\u0005I\u0011IAB\u0003!A\u0017m\u001d5D_\u0012,GCAA(\u0011%\t9iXA\u0001\n\u0003\nI)\u0001\u0005u_N#(/\u001b8h)\t\tI\u0004C\u0005\u0002\u000e~\u000b\t\u0011\"\u0011\u0002\u0010\u00061Q-];bYN$B!a\u001e\u0002\u0012\"I\u0011QLAF\u0003\u0003\u0005\rAG\u0004\n\u0003+;\u0016\u0011!E\u0001\u0003/\u000b\u0001#T8oO>\u001cVm]:j_:LeNZ8\u0011\u0007U\fIJ\u0002\u0005a/\u0006\u0005\t\u0012AAN'\u0015\tI*!(f!\u0019\ty*!*li6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G3\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003O\u000b\tKA\tBEN$(/Y2u\rVt7\r^5p]FBq!XAM\t\u0003\tY\u000b\u0006\u0002\u0002\u0018\"Q\u0011qQAM\u0003\u0003%)%!#\t\u0015\u0005E\u0016\u0011TA\u0001\n\u0003\u000b\u0019,A\u0003baBd\u0017\u0010F\u0002u\u0003kCa![AX\u0001\u0004Y\u0007BCA]\u00033\u000b\t\u0011\"!\u0002<\u00069QO\\1qa2LH\u0003BA_\u0003\u0007\u0004B!FA`W&\u0019\u0011\u0011\u0019\f\u0003\r=\u0003H/[8o\u0011%\t)-a.\u0002\u0002\u0003\u0007A/A\u0002yIAB!\"!3\u0002\u001a\u0006\u0005I\u0011BAf\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0007\u0003BA\u001e\u0003\u001fLA!!5\u0002>\t1qJ\u00196fGRDq!!-X\t\u0003\t).\u0006\u0003\u0002X\u0006uG\u0003DAm\u0003?\f\u0019/!:\u0002h\u0006=\b\u0003\u0002\u0010\u0001\u00037\u00042aDAo\t\u0019\t\u00121\u001bb\u0001'!9\u0011)a5A\u0002\u0005\u0005\b\u0003B\"G\u00037DaASAj\u0001\u0004Y\u0005B\u0002)\u0002T\u0002\u0007A\u000fC\u0004j\u0003'\u0004\r!!;\u0011\u00071\fY/C\u0002\u0002n6\u0014\u0011\u0003U3sg&\u001cH/\u001a8dK\u000e{gNZ5h\u0011!\t\t0a5A\u0002\u0005M\u0018a\u00039pYf\u0014V\r]8PaR\u0004R!FA`\u0003k\u0004D!a>\u0002|B!a\u0004AA}!\ry\u00111 \u0003\r\u0003{\fy0!A\u0001\u0002\u000b\u0005!q\u0002\u0002\u0004?\u0012\n\u0004\u0002CAy\u0003'\u0004\rA!\u0001\u0011\u000bU\tyLa\u00011\t\t\u0015!\u0011\u0002\t\u0005=\u0001\u00119\u0001E\u0002\u0010\u0005\u0013!A\"!@\u0002\u0000\u0006\u0005\t\u0011!B\u0001\u0005\u0017\t2A!\u0004\u001b!\ry\u0011Q\\\t\u0004\u00037T\u0002\"\u0003B\n\u0001\t\u0005\t\u0015!\u0003S\u0003!\u0019Xm]:j_:\u0004\u0003B\u0003B\f\u0001\t\u0015\r\u0011\"\u0005\u0003\u001a\u0005\t\u0002/\u001a:tSN$XM\\2f\u0007>tg-[4\u0016\u0005\u0005%\bB\u0003B\u000f\u0001\t\u0005\t\u0015!\u0003\u0002j\u0006\u0011\u0002/\u001a:tSN$XM\\2f\u0007>tg-[4!\u0011\u001di\u0006\u0001\"\u0001\u0005\u0005C!\"Ba\t\u0003&\t\u001d\"\u0011\u0006B\u0016!\rq\u0002A\u0004\u0005\u0007\u0003\n}\u0001\u0019\u0001\"\t\r)\u0013y\u00021\u0001L\u0011\u0019\u0001&q\u0004a\u0001%\"A!q\u0003B\u0010\u0001\u0004\tI\u000fC\u0004\u00030\u0001!\tB!\r\u0002\u001d\r|G\u000e\\3di&|gNT1nKV\u0011!1\u0007\t\u0005\u0005k\u0011\u0019E\u0004\u0003\u00038\t}\u0002c\u0001B\u001d-5\u0011!1\b\u0006\u0004\u0005{\u0011\u0012A\u0002\u001fs_>$h(C\u0002\u0003BY\ta\u0001\u0015:fI\u00164\u0017\u0002BA$\u0005\u000bR1A!\u0011\u0017\u0011-\u0011I\u0005\u0001EC\u0002\u0013E!Aa\u0013\u0002\u001f5|gnZ8D_2dWm\u0019;j_:,\"A!\u0014\u0011\r\u0005%!q\nB*\u0013\u0011\u0011\t&a\u0003\u0003\u001f5{gnZ8D_2dWm\u0019;j_:\u0004BA!\u0016\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&\u0001\u0003cg>t'B\u0001B/\u0003\ry'oZ\u0005\u0005\u0005C\u00129F\u0001\u0007Cg>tGi\\2v[\u0016tG\u000f\u0003\u0005\u0003f\u0001!\t\u0002\u0002B4\u0003\u0015\u0019Gn\\:f)\t\u0011I\u0007\u0006\u0003\u0003l\tu\u0004C\u0002B7\u0005g\u00129(\u0004\u0002\u0003p)\u0019!\u0011\u000f\f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003v\t=$A\u0002$viV\u0014X\rE\u0002\u0016\u0005sJ1Aa\u001f\u0017\u0005\u0011)f.\u001b;\t\u0011\t}$1\ra\u0002\u0005\u0003\u000b\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\t5$1Q\u0005\u0005\u0005\u000b\u0013yG\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9\u0011q\u0011\u0001\u0005B\t%EC\u0001B\u001a\u0001")
public class MongoRepo<P>
extends BaseRepo<P>
implements MongoCreate<P>,
MongoDelete<P>,
MongoQuery<P>,
MongoRead<P>,
MongoRetrieve<P>,
MongoSchema<P>,
MongoUpdate<P>,
MongoWrite<P>,
LazyLogging {
    private MongoCollection<BsonDocument> mongoCollection;
    private final MongoSessionInfo session;
    private final PersistenceConfig persistenceConfig;
    private Logger logger;
    private DomainModelToBsonTranslator domainModelToBsonTranslator;
    private BsonToDomainModelTranslator longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator;
    private volatile byte bitmap$0;

    public static <P> MongoRepo<P> apply(PType<P> pType, DomainModel domainModel2, MongoSessionInfo mongoSessionInfo, PersistenceConfig persistenceConfig, Option<MongoRepo<? super P>> option) {
        return MongoRepo$.MODULE$.apply(pType, domainModel2, mongoSessionInfo, persistenceConfig, option);
    }

    @Override
    public BsonDocument bsonForState(PState<P> state) {
        return MongoWrite.bsonForState$(this, state);
    }

    @Override
    public BsonDocument translate(P p) {
        return MongoWrite.translate$(this, p);
    }

    @Override
    public Nothing$ throwDuplicateKeyValException(P p, MongoWriteException cause) {
        return MongoWrite.throwDuplicateKeyValException$(this, p, cause);
    }

    @Override
    public Option<ObjectId> mongoId(PState<P> state) {
        return MongoWrite.mongoId$(this, state);
    }

    @Override
    public Bson writeQuery(PState<P> state) {
        return MongoWrite.writeQuery$(this, state);
    }

    @Override
    public Future<PState<P>> update(PState<P> state, ExecutionContext context) {
        return MongoUpdate.update$(this, state, context);
    }

    @Override
    public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return MongoSchema.createSchema$(this, context);
    }

    @Override
    public String indexName(RealizedKey<P, ?> key) {
        return MongoSchema.indexName$(this, key);
    }

    @Override
    public void createIndex(Seq<String> paths, String indexName, boolean unique) {
        MongoSchema.createIndex$(this, paths, indexName, unique);
    }

    @Override
    public void createIndex(Seq<String> paths, String indexName, boolean unique, boolean hashed) {
        MongoSchema.createIndex$(this, paths, indexName, unique, hashed);
    }

    @Override
    public boolean createIndex$default$4() {
        return MongoSchema.createIndex$default$4$(this);
    }

    @Override
    public <V extends KeyVal<P>> Future<Option<PState<P>>> retrieve(V keyVal2, TypeKey<V> evidence$1, ExecutionContext context) {
        return MongoRetrieve.retrieve$(this, keyVal2, evidence$1, context);
    }

    @Override
    public <V extends KeyVal<P>> Bson keyValQuery(V keyVal2, TypeKey<V> evidence$2) {
        return MongoRetrieve.keyValQuery$(this, keyVal2, evidence$2);
    }

    @Override
    public PState<P> bsonToState(BsonDocument document) {
        return MongoRead.bsonToState$(this, document);
    }

    @Override
    public <A> BsonValue propValToMongo(A value, Prop<? super P, A> prop) {
        return MongoRead.propValToMongo$(this, value, prop);
    }

    @Override
    public <A> Bson mongoRelationalFilter(Prop<? super P, A> prop, RelationalOp op, A value) {
        return MongoRead.mongoRelationalFilter$(this, prop, op, value);
    }

    @Override
    public Future<Seq<PState<P>>> retrieveByQuery(Query<P> query, ExecutionContext context) {
        return MongoQuery.retrieveByQuery$(this, query, context);
    }

    @Override
    public Source<PState<P>, NotUsed> streamByQueryImpl(Query<P> query) {
        return MongoQuery.streamByQueryImpl$(this, query);
    }

    @Override
    public Bson mongoFilter(QueryFilter<P> filter) {
        return MongoQuery.mongoFilter$(this, filter);
    }

    @Override
    public Future<Deleted<P>> delete(PState<P> state, ExecutionContext context) {
        return MongoDelete.delete$(this, state, context);
    }

    @Override
    public Future<PState<P>> create(P p, ExecutionContext context) {
        return MongoCreate.create$(this, p, context);
    }

    private Logger logger$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private DomainModelToBsonTranslator domainModelToBsonTranslator$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.domainModelToBsonTranslator = MongoWrite.domainModelToBsonTranslator$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.domainModelToBsonTranslator;
    }

    @Override
    public DomainModelToBsonTranslator domainModelToBsonTranslator() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.domainModelToBsonTranslator$lzycompute() : this.domainModelToBsonTranslator;
    }

    private BsonToDomainModelTranslator longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator = MongoRead.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator;
    }

    @Override
    public BsonToDomainModelTranslator longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator$lzycompute() : this.longevity$persistence$mongo$MongoRead$$bsonToDomainModelTranslator;
    }

    public MongoSessionInfo session() {
        return this.session;
    }

    public PersistenceConfig persistenceConfig() {
        return this.persistenceConfig;
    }

    public String collectionName() {
        return stringUtil$.MODULE$.uncapitalize(stringUtil$.MODULE$.typeName(this.pTypeKey().tpe()));
    }

    private MongoCollection<BsonDocument> mongoCollection$lzycompute() {
        MongoRepo mongoRepo = this;
        synchronized (mongoRepo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mongoCollection = this.session().db().getCollection(this.collectionName(), BsonDocument.class);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mongoCollection;
    }

    public MongoCollection<BsonDocument> mongoCollection() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.mongoCollection$lzycompute() : this.mongoCollection;
    }

    @Override
    public Future<BoxedUnit> close(ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.session().client().close()), executionContext);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MongoRepo[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pTypeKey().name()}));
    }

    public MongoRepo(PType<P> pType, DomainModel domainModel2, MongoSessionInfo session, PersistenceConfig persistenceConfig) {
        this.session = session;
        this.persistenceConfig = persistenceConfig;
        super(pType, domainModel2);
        MongoCreate.$init$(this);
        MongoDelete.$init$(this);
        MongoQuery.$init$(this);
        MongoRead.$init$(this);
        MongoRetrieve.$init$(this);
        MongoSchema.$init$(this);
        MongoUpdate.$init$(this);
        MongoWrite.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class MongoSessionInfo
    implements Product,
    scala.Serializable {
        private MongoClient client;
        private MongoDatabase db;
        private final MongoConfig config;
        private volatile byte bitmap$0;

        public MongoConfig config() {
            return this.config;
        }

        private MongoClient client$lzycompute() {
            MongoSessionInfo mongoSessionInfo = this;
            synchronized (mongoSessionInfo) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.client = new MongoClient(new MongoClientURI(this.config().uri()));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.client;
        }

        public MongoClient client() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.client$lzycompute() : this.client;
        }

        private MongoDatabase db$lzycompute() {
            MongoSessionInfo mongoSessionInfo = this;
            synchronized (mongoSessionInfo) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.db = this.client().getDatabase(this.config().db());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.db;
        }

        public MongoDatabase db() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
        }

        public MongoSessionInfo copy(MongoConfig config) {
            return new MongoSessionInfo(config);
        }

        public MongoConfig copy$default$1() {
            return this.config();
        }

        public String productPrefix() {
            return "MongoSessionInfo";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.config();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MongoSessionInfo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MongoSessionInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            MongoSessionInfo mongoSessionInfo = (MongoSessionInfo)x$1;
            MongoConfig mongoConfig = this.config();
            MongoConfig mongoConfig2 = mongoSessionInfo.config();
            if (mongoConfig == null) {
                if (mongoConfig2 != null) {
                    return false;
                }
            } else if (!((Object)mongoConfig).equals(mongoConfig2)) return false;
            if (!mongoSessionInfo.canEqual(this)) return false;
            return true;
        }

        public MongoSessionInfo(MongoConfig config) {
            this.config = config;
            Product.$init$((Product)this);
        }
    }
}

