/*
 * Decompiled with CFR 0.152.
 */
package longevity.persistence.cassandra;

import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import longevity.model.realized.RealizedPropComponent;
import longevity.persistence.BaseRepo;
import longevity.persistence.cassandra.CassandraRepo;
import longevity.persistence.cassandra.CassandraRepo$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005UbAC\u0001\u0003!\u0003\r\tA\u0001\u0005\u0002.\ty1)Y:tC:$'/Y*dQ\u0016l\u0017M\u0003\u0002\u0004\t\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000b\u0019\t1\u0002]3sg&\u001cH/\u001a8dK*\tq!A\u0005m_:<WM^5usV\u0011\u0011BW\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0019\u0012A\u0002\u0013j]&$He\u0001\u0001\u0015\u0003Q\u0001\"aC\u000b\n\u0005Ya!\u0001B+oSRDa\u0001\u0007\u0001\u0005\u0012\u0011I\u0012\u0001D2sK\u0006$XmU2iK6\fG#\u0001\u000e\u0015\u0005m\t\u0003c\u0001\u000f )5\tQD\u0003\u0002\u001f\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0001j\"A\u0002$viV\u0014X\rC\u0003#/\u0001\u000f1%A\u0004d_:$X\r\u001f;\u0011\u0005q!\u0013BA\u0013\u001e\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003(\u0001\u0011E1#A\u0006de\u0016\fG/\u001a+bE2,\u0007\"B\u0015\u0001\t\u0013Q\u0013!B5e\t\u00164W#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t11\u000b\u001e:j]\u001eDQ\u0001\u000e\u0001\u0005\nU\nQ$Y2uk\u0006d\u0017N_3e\u0007>l\u0007o\u001c8f]R\u001cu\u000e\\;n]\u0012+gm]\u000b\u0002mA\u0011qG\u0010\b\u0003qq\u0002\"!\u000f\u0007\u000e\u0003iR!a\u000f\n\u0002\rq\u0012xn\u001c;?\u0013\tiD\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003e}R!!\u0010\u0007\t\u000b\u0005\u0003A\u0011B\u001b\u0002\u001bA\u0014\u0018.\\1ss.+\u0017\u0010R3g\u0011\u0015\u0019\u0005\u0001\"\u00036\u0003A\u0001\u0018M\u001d;ji&|gnQ8mk6t7\u000fC\u0003F\u0001\u0011%Q'\u0001\u000bq_N$\b+\u0019:uSRLwN\\\"pYVlgn\u001d\u0005\u0006\u000f\u0002!I\u0001S\u0001\nG>dW/\u001c8EK\u001a$\"AN%\t\u000b)3\u0005\u0019A&\u0002\u0013\r|W\u000e]8oK:$\b\u0007\u0002'WI\u001e\u0004R!\u0014*UG\u001al\u0011A\u0014\u0006\u0003\u001fB\u000b\u0001B]3bY&TX\r\u001a\u0006\u0003#\u001a\tQ!\\8eK2L!a\u0015(\u0003+I+\u0017\r\\5{K\u0012\u0004&o\u001c9D_6\u0004xN\\3oiB\u0011QK\u0016\u0007\u0001\t%9\u0016*!A\u0001\u0002\u000b\u0005\u0001LA\u0002`IE\n\"!\u00171\u0011\u0005USF!B.\u0001\u0005\u0004a&!\u0001)\u0012\u0005u\u0003\u0007CA\u0006_\u0013\tyFBA\u0004O_RD\u0017N\\4\u0011\u0005-\t\u0017B\u00012\r\u0005\r\te.\u001f\t\u0003+\u0012$\u0011\"Z%\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\u0007}##\u0007\u0005\u0002VO\u0012I\u0001.SA\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012\u001a\u0004\"\u00026\u0001\t#Y\u0017!C1eI\u000e{G.^7o)\r!BN\u001c\u0005\u0006[&\u0004\rAN\u0001\u000bG>dW/\u001c8OC6,\u0007\"B8j\u0001\u00041\u0014AC2pYVlg\u000eV=qK\")\u0011\u000f\u0001C\te\u0006A2m\\7q_:,g\u000e\u001e+p\u0007\u0006\u001c8/\u00198ee\u0006$\u0016\u0010]3\u0016\u0005MtHC\u0001\u001cu\u0011\u0015Q\u0005\u000f1\u0001va\r1\bp\u001f\t\u0006\u001bJ;(0 \t\u0003+b$\u0011\"\u001f;\u0002\u0002\u0003\u0005)\u0011\u0001-\u0003\u0007}#C\u0007\u0005\u0002Vw\u0012IA\u0010^A\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012*\u0004CA+\u007f\t\u0015y\bO1\u0001]\u0005\u0005\t\u0005BBA\u0002\u0001\u0011E1#A\u0007de\u0016\fG/Z%oI\u0016DXm\u001d\u0005\b\u0003\u000f\u0001A\u0011CA\u0005\u0003-\u0019'/Z1uK&sG-\u001a=\u0015\u0007Q\tY\u0001C\u0004K\u0003\u000b\u0001\r!!\u00041\u0011\u0005=\u00111CA\r\u0003?\u0001\u0002\"\u0014*\u0002\u0012\u0005]\u0011Q\u0004\t\u0004+\u0006MAaCA\u000b\u0003\u0017\t\t\u0011!A\u0003\u0002a\u00131a\u0018\u00137!\r)\u0016\u0011\u0004\u0003\f\u00037\tY!!A\u0001\u0002\u000b\u0005ALA\u0002`I]\u00022!VA\u0010\t-\t\t#a\u0003\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\u0007}#\u0003\bC\u0004\u0002\b\u0001!\t\"!\n\u0015\u000bQ\t9#a\u000b\t\u000f\u0005%\u00121\u0005a\u0001m\u0005I\u0011N\u001c3fq:\u000bW.\u001a\u0005\u0007[\u0006\r\u0002\u0019\u0001\u001c\u0011\u000b\u0005=\u0012\u0011G-\u000e\u0003\tI1!a\r\u0003\u00055\u0019\u0015m]:b]\u0012\u0014\u0018MU3q_\u0002")
public interface CassandraSchema<P> {
    public static /* synthetic */ Future createSchema$(CassandraSchema $this, ExecutionContext context) {
        return $this.createSchema(context);
    }

    default public Future<BoxedUnit> createSchema(ExecutionContext context) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.createTable();
            this.createIndexes();
            if (((CassandraRepo)this).persistenceConfig().optimisticLocking()) {
                this.addColumn("row_version", "bigint");
            }
            if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
                ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done creating schema for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), context);
    }

    public static /* synthetic */ void createTable$(CassandraSchema $this) {
        $this.createTable();
    }

    default public void createTable() {
        BoxedUnit boxedUnit;
        String createTable = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n    |CREATE TABLE IF NOT EXISTS ", " (", "\n    |  p text,\n    |  ", ",\n    |  ", "\n    |)\n    |WITH COMPRESSION = { 'sstable_compression': 'SnappyCompressor' };\n    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), this.idDef(), this.actualizedComponentColumnDefs(), this.primaryKeyDef()})))).stripMargin();
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createTable})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((CassandraRepo)this).session().execute(createTable);
    }

    private String idDef() {
        return ((BaseRepo)((Object)this)).hasPartitionKey() ? "" : "\n  id uuid,";
    }

    private String actualizedComponentColumnDefs() {
        return ((TraversableOnce)((CassandraRepo)this).actualizedComponents().map((Function1 & Serializable & scala.Serializable)component2 -> this.columnDef((RealizedPropComponent)component2), Set$.MODULE$.canBuildFrom())).mkString(",\n  ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String primaryKeyDef() {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(((BaseRepo)((Object)this)).hasPartitionKey(), ((CassandraRepo)this).postPartitionComponents().nonEmpty());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns(), this.postPartitionColumns()}));
            }
        }
        if (sp2 == null) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (!bl || bl3) return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY (id)"})).s((Seq)Nil$.MODULE$);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ((", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionColumns()}));
    }

    private String partitionColumns() {
        return ((TraversableOnce)((CassandraRepo)this).partitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String postPartitionColumns() {
        return ((TraversableOnce)((CassandraRepo)this).postPartitionComponents().map((Function1 & Serializable & scala.Serializable)prop -> ((CassandraRepo)this).columnName((RealizedPropComponent<?, ?, ?>)prop), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String columnDef(RealizedPropComponent<? super P, ?, ?> component2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).columnName(component2), this.componentToCassandraType(component2)}));
    }

    public static /* synthetic */ void addColumn$(CassandraSchema $this, String columnName, String columnType) {
        $this.addColumn(columnName, columnType);
    }

    default public void addColumn(String columnName, String columnType) {
        BoxedUnit boxedUnit;
        String cql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), columnName, columnType}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            ((CassandraRepo)this).session().execute(cql);
        }
        catch (Throwable throwable) {
            InvalidQueryException invalidQueryException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidQueryException && (invalidQueryException = (InvalidQueryException)throwable2).getMessage().contains("because it conflicts with an existing column")) {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static /* synthetic */ String componentToCassandraType$(CassandraSchema $this, RealizedPropComponent component2) {
        return $this.componentToCassandraType(component2);
    }

    default public <A> String componentToCassandraType(RealizedPropComponent<? super P, ?, A> component2) {
        return (String)CassandraRepo$.MODULE$.basicToCassandraType().apply(component2.componentTypeKey());
    }

    public static /* synthetic */ void createIndexes$(CassandraSchema $this) {
        $this.createIndexes();
    }

    default public void createIndexes() {
        ((CassandraRepo)this).indexedComponents().foreach((Function1 & Serializable & scala.Serializable)component2 -> {
            this.createIndex(component2);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, RealizedPropComponent component2) {
        $this.createIndex(component2);
    }

    default public void createIndex(RealizedPropComponent<? super P, ?, ?> component2) {
        String indexName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraRepo)this).tableName(), ((CassandraRepo)this).scoredPath(component2)}));
        this.createIndex(indexName, ((CassandraRepo)this).columnName(component2));
    }

    public static /* synthetic */ void createIndex$(CassandraSchema $this, String indexName, String columnName) {
        $this.createIndex(indexName, columnName);
    }

    default public void createIndex(String indexName, String columnName) {
        BoxedUnit boxedUnit;
        String createIndex = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE INDEX IF NOT EXISTS ", " ON ", " (", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexName, ((CassandraRepo)this).tableName(), columnName}));
        if (((LazyLogging)this).logger().underlying().isDebugEnabled()) {
            ((LazyLogging)this).logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"executing CQL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createIndex})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ((CassandraRepo)this).session().execute(createIndex);
    }

    public static void $init$(CassandraSchema $this) {
    }
}

