/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;

public class GRpcServerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerRunner.class);
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private GRpcServerProperties gRpcServerProperties;
    private Server server;

    public void run(String ... args) throws Exception {
        log.info("Starting gRPC Server ...");
        Collection<ServerInterceptor> globalInterceptors = this.getTypedBeansWithAnnotation(GRpcGlobalInterceptor.class, ServerInterceptor.class);
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)this.gRpcServerProperties.getPort());
        for (BindableService bindableService : this.getTypedBeansWithAnnotation(GRpcService.class, BindableService.class)) {
            ServerServiceDefinition serviceDefinition = bindableService.bindService();
            GRpcService gRpcServiceAnn = bindableService.getClass().getAnnotation(GRpcService.class);
            serviceDefinition = this.bindInterceptors(serviceDefinition, gRpcServiceAnn, globalInterceptors);
            serverBuilder.addService(serviceDefinition);
            log.info("'{}' service has been registered.", (Object)bindableService.getClass().getName());
        }
        this.server = serverBuilder.build().start();
        log.info("gRPC Server started, listening on port {}.", (Object)this.gRpcServerProperties.getPort());
        this.startDaemonAwaitThread();
    }

    private ServerServiceDefinition bindInterceptors(ServerServiceDefinition serviceDefinition, GRpcService gRpcService, Collection<ServerInterceptor> globalInterceptors) {
        Stream<ServerInterceptor> privateInterceptors = Stream.of(gRpcService.interceptors()).map(interceptorClass -> {
            try {
                return 0 < this.applicationContext.getBeanNamesForType(interceptorClass).length ? (ServerInterceptor)this.applicationContext.getBean(interceptorClass) : (ServerInterceptor)interceptorClass.newInstance();
            }
            catch (Exception e) {
                throw new BeanCreationException("Failed to create interceptor instance.", (Throwable)e);
            }
        });
        List interceptors = Stream.concat(gRpcService.applyGlobalInterceptors() ? globalInterceptors.stream() : Stream.empty(), privateInterceptors).distinct().collect(Collectors.toList());
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, interceptors);
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(){

            @Override
            public void run() {
                try {
                    GRpcServerRunner.this.server.awaitTermination();
                }
                catch (InterruptedException e) {
                    log.error("gRPC server stopped.", (Throwable)e);
                }
            }
        };
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    public void destroy() throws Exception {
        log.info("Shutting down gRPC server ...");
        Optional.ofNullable(this.server).ifPresent(Server::shutdown);
        log.info("gRPC server stopped.");
    }

    private <T> Collection<T> getTypedBeansWithAnnotation(Class<? extends Annotation> annotationType, Class<T> beanType) throws Exception {
        return Stream.of(this.applicationContext.getBeanNamesForType(beanType)).filter(name -> {
            BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(name);
            if (beanDefinition.getSource() instanceof StandardMethodMetadata) {
                StandardMethodMetadata metadata = (StandardMethodMetadata)beanDefinition.getSource();
                return metadata.isAnnotated(annotationType.getName());
            }
            return null != this.applicationContext.getBeanFactory().findAnnotationOnBean(name, annotationType);
        }).map(name -> this.applicationContext.getBeanFactory().getBean(name, beanType)).collect(Collectors.toList());
    }
}

