/*
 * Decompiled with CFR 0.152.
 */
package org.logl.vertx;

import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;
import java.util.Map;
import org.logl.LoggerProvider;
import org.logl.vertx.InteractionRecordingLoggerProvider;
import org.logl.vertx.LoglLogDelegate;
import org.logl.vertx.WeakValueHashMap;

public final class LoglLogDelegateFactory
implements LogDelegateFactory {
    private static final Map<String, LoglLogDelegate> delegates = new WeakValueHashMap<String, LoglLogDelegate>();
    private static volatile LoggerProvider loggerProvider = new InteractionRecordingLoggerProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogDelegate createDelegate(String name) {
        Map<String, LoglLogDelegate> map = delegates;
        synchronized (map) {
            return delegates.computeIfAbsent(name, n -> new LoglLogDelegate(loggerProvider.getLogger(n)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProvider(LoggerProvider provider) {
        Map<String, LoglLogDelegate> map = delegates;
        synchronized (map) {
            LoggerProvider oldProvider = loggerProvider;
            loggerProvider = provider;
            delegates.forEach((name, delegate) -> delegate.setLogger(provider.getLogger(name)));
            if (oldProvider instanceof InteractionRecordingLoggerProvider) {
                ((InteractionRecordingLoggerProvider)oldProvider).replayTo(provider);
            }
        }
    }
}

