/*
 * Decompiled with CFR 0.152.
 */
package org.logl.vertx;

import io.vertx.core.spi.logging.LogDelegate;
import org.logl.LogMessage;
import org.logl.Logger;

final class LoglLogDelegate
implements LogDelegate {
    private volatile Logger logger;

    LoglLogDelegate(Logger logger) {
        this.logger = logger;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void fatal(Object message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((CharSequence)message.toString());
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.toString(), t);
        }
    }

    public void error(Object message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((CharSequence)message.toString());
        }
    }

    public void error(Object message, Object ... params) {
        this.logger.error(message.toString(), params);
    }

    public void error(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.toString(), t);
        }
    }

    public void error(Object message, Throwable t, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(LogMessage.patternFormat((String)message.toString(), (Object[])params), t);
        }
    }

    public void warn(Object message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((CharSequence)message.toString());
        }
    }

    public void warn(Object message, Object ... params) {
        this.logger.warn(message.toString(), params);
    }

    public void warn(Object message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message.toString(), t);
        }
    }

    public void warn(Object message, Throwable t, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(LogMessage.patternFormat((String)message.toString(), (Object[])params), t);
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((CharSequence)message.toString());
        }
    }

    public void info(Object message, Object ... params) {
        this.logger.info(message.toString(), params);
    }

    public void info(Object message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message.toString(), t);
        }
    }

    public void info(Object message, Throwable t, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(LogMessage.patternFormat((String)message.toString(), (Object[])params), t);
        }
    }

    public void debug(Object message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)message.toString());
        }
    }

    public void debug(Object message, Object ... params) {
        this.logger.debug(message.toString(), params);
    }

    public void debug(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message.toString(), t);
        }
    }

    public void debug(Object message, Throwable t, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(LogMessage.patternFormat((String)message.toString(), (Object[])params), t);
        }
    }

    public void trace(Object message) {
    }

    public void trace(Object message, Object ... params) {
    }

    public void trace(Object message, Throwable t) {
    }

    public void trace(Object message, Throwable t, Object ... params) {
    }
}

