/*
 * Decompiled with CFR 0.152.
 */
package org.logl.vertx;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import org.logl.Level;
import org.logl.LogMessage;
import org.logl.LogWriter;
import org.logl.Logger;
import org.logl.LoggerProvider;

final class InteractionRecordingLoggerProvider
implements LoggerProvider {
    private final Deque<Consumer<LoggerProvider>> record = new ConcurrentLinkedDeque<Consumer<LoggerProvider>>();

    InteractionRecordingLoggerProvider() {
    }

    public Logger getLogger(String name) {
        return new InteractionRecordingLogger(name);
    }

    void replayTo(LoggerProvider provider) {
        this.record.forEach(e -> e.accept(provider));
    }

    private final class InteractionRecordingLogger
    implements Logger {
        private final String name;
        private final LogWriter errorWriter;
        private final LogWriter warnWriter;
        private final LogWriter infoWriter;
        private final LogWriter debugWriter;

        InteractionRecordingLogger(String name) {
            this.name = name;
            this.errorWriter = new InteractionRecordingLogWriter(Level.ERROR);
            this.warnWriter = new InteractionRecordingLogWriter(Level.WARN);
            this.infoWriter = new InteractionRecordingLogWriter(Level.INFO);
            this.debugWriter = new InteractionRecordingLogWriter(Level.DEBUG);
        }

        public Level getLevel() {
            return Level.DEBUG;
        }

        public LogWriter errorWriter() {
            return this.errorWriter;
        }

        public LogWriter warnWriter() {
            return this.warnWriter;
        }

        public LogWriter infoWriter() {
            return this.infoWriter;
        }

        public LogWriter debugWriter() {
            return this.debugWriter;
        }

        public void batch(Consumer<Logger> fn) {
            throw new UnsupportedOperationException();
        }

        private final class InteractionRecordingLogWriter
        implements LogWriter {
            private final Level level;

            InteractionRecordingLogWriter(Level level) {
                this.level = level;
            }

            public void log(LogMessage message) {
                InteractionRecordingLoggerProvider.this.record.add(p -> p.getLogger(InteractionRecordingLogger.this.name).writer(this.level).log(message));
            }

            public void log(LogMessage message, Throwable cause) {
                InteractionRecordingLoggerProvider.this.record.add(p -> p.getLogger(InteractionRecordingLogger.this.name).writer(this.level).log(message, cause));
            }

            public void batch(Consumer<LogWriter> fn) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

