/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class WeakValueHashMap<K, V>
implements Map<K, V> {
    private final Map<K, WeakReference<V>> map = new HashMap<K, WeakReference<V>>();
    private final Map<Reference<V>, K> rmap = new HashMap<Reference<V>, K>();
    private ReferenceQueue<V> evictions = new ReferenceQueue();

    WeakValueHashMap() {
    }

    @Override
    public int size() {
        this.evict();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.evict();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.evict();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.evict();
        return this.map.values().stream().anyMatch(r -> value.equals(r.get()));
    }

    @Override
    public V get(Object key) {
        this.evict();
        WeakReference<V> ref = this.map.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.evict();
        return this.internalPut(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.evict();
        m.forEach(this::internalPut);
    }

    private V internalPut(K key, V value) {
        WeakReference<V> ref = new WeakReference<V>(value, this.evictions);
        this.rmap.put((Reference<K>)ref, (WeakReference<V>)key);
        WeakReference<V> old = this.map.put(key, ref);
        return old == null ? null : (V)old.get();
    }

    @Override
    public V remove(Object key) {
        this.evict();
        WeakReference<V> ref = this.map.remove(key);
        if (ref == null) {
            return null;
        }
        this.rmap.remove(ref);
        return (V)ref.get();
    }

    @Override
    public void clear() {
        this.evictions = new ReferenceQueue();
        this.rmap.clear();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.evict();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        this.evict();
        return this.map.values().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.evict();
        return this.map.entrySet().stream().flatMap(e -> {
            final Object key = e.getKey();
            final Object value = ((WeakReference)e.getValue()).get();
            return value == null ? Stream.empty() : Stream.of(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            });
        }).collect(Collectors.toSet());
    }

    private void evict() {
        Reference<V> ref;
        while ((ref = this.evictions.poll()) != null) {
            K key = this.rmap.get(ref);
            if (key == null) continue;
            this.map.remove(key, ref);
        }
    }
}

