/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.logl.Level;
import org.logl.LogMessage;
import org.logl.LogWriter;
import org.logl.Logger;
import org.logl.logl.AdjustableLogger;
import org.logl.logl.LevelLogWriter;
import org.logl.logl.LevelLogger;
import org.logl.logl.UnformattedLogger;

final class UnformattedLoggerImpl
implements AdjustableLogger,
LevelLogger {
    private final Locale locale;
    private final AtomicReference<Level> level;
    private final boolean autoFlush;
    private final Supplier<PrintWriter> writerSupplier;
    private final Object lock;
    private final LevelLogWriter errorWriter;
    private final LevelLogWriter warnWriter;
    private final LevelLogWriter infoWriter;
    private final LevelLogWriter debugWriter;

    UnformattedLoggerImpl(UnformattedLogger.Builder builder, Supplier<PrintWriter> writerSupplier, Object lock) {
        this.locale = builder.locale;
        this.level = new AtomicReference<Level>(builder.level);
        this.autoFlush = builder.autoFlush;
        this.writerSupplier = writerSupplier;
        this.lock = lock;
        this.errorWriter = new LevelLogWriter(Level.ERROR, this);
        this.warnWriter = new LevelLogWriter(Level.WARN, this);
        this.infoWriter = new LevelLogWriter(Level.INFO, this);
        this.debugWriter = new LevelLogWriter(Level.DEBUG, this);
    }

    public Level getLevel() {
        return this.level.get();
    }

    @Override
    public Level setLevel(Level level) {
        Objects.requireNonNull(level);
        return this.level.getAndSet(level);
    }

    public void error(LogMessage message) {
        this.log(Level.ERROR, message);
    }

    public void error(CharSequence message) {
        this.log(Level.ERROR, message);
    }

    public void error(Supplier<? extends CharSequence> messageSupplier) {
        this.log(Level.ERROR, messageSupplier);
    }

    public void error(LogMessage message, Throwable cause) {
        this.log(Level.ERROR, message, cause);
    }

    public void error(CharSequence message, Throwable cause) {
        this.log(Level.ERROR, message, cause);
    }

    public void error(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        this.log(Level.ERROR, messageSupplier, cause);
    }

    public void error(String pattern, Object ... args) {
        this.log(Level.ERROR, pattern, args);
    }

    public LogWriter errorWriter() {
        return this.errorWriter;
    }

    public void warn(LogMessage message) {
        this.log(Level.WARN, message);
    }

    public void warn(CharSequence message) {
        this.log(Level.WARN, message);
    }

    public void warn(Supplier<? extends CharSequence> messageSupplier) {
        this.log(Level.WARN, messageSupplier);
    }

    public void warn(LogMessage message, Throwable cause) {
        this.log(Level.WARN, message, cause);
    }

    public void warn(CharSequence message, Throwable cause) {
        this.log(Level.WARN, message, cause);
    }

    public void warn(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        this.log(Level.WARN, messageSupplier, cause);
    }

    public void warn(String pattern, Object ... args) {
        this.log(Level.WARN, pattern, args);
    }

    public LogWriter warnWriter() {
        return this.warnWriter;
    }

    public void info(LogMessage message) {
        this.log(Level.INFO, message);
    }

    public void info(CharSequence message) {
        this.log(Level.INFO, message);
    }

    public void info(Supplier<? extends CharSequence> messageSupplier) {
        this.log(Level.INFO, messageSupplier);
    }

    public void info(LogMessage message, Throwable cause) {
        this.log(Level.INFO, message, cause);
    }

    public void info(CharSequence message, Throwable cause) {
        this.log(Level.INFO, message, cause);
    }

    public void info(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        this.log(Level.INFO, messageSupplier, cause);
    }

    public void info(String pattern, Object ... args) {
        this.log(Level.INFO, pattern, args);
    }

    public LogWriter infoWriter() {
        return this.infoWriter;
    }

    public void debug(LogMessage message) {
        this.log(Level.DEBUG, message);
    }

    public void debug(CharSequence message) {
        this.log(Level.DEBUG, message);
    }

    public void debug(Supplier<? extends CharSequence> messageSupplier) {
        this.log(Level.DEBUG, messageSupplier);
    }

    public void debug(LogMessage message, Throwable cause) {
        this.log(Level.DEBUG, message, cause);
    }

    public void debug(CharSequence message, Throwable cause) {
        this.log(Level.DEBUG, message, cause);
    }

    public void debug(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        this.log(Level.DEBUG, messageSupplier, cause);
    }

    public void debug(String pattern, Object ... args) {
        this.log(Level.DEBUG, pattern, args);
    }

    public LogWriter debugWriter() {
        return this.debugWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, LogMessage message) {
        PrintWriter out;
        Objects.requireNonNull(message);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            out = this.writerSupplier.get();
            this.writeMessage(out, message);
            out.println();
        }
        if (this.autoFlush) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, CharSequence message) {
        PrintWriter out;
        Objects.requireNonNull(message);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            out = this.writerSupplier.get();
            out.println(message);
        }
        if (this.autoFlush) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, Supplier<? extends CharSequence> messageSupplier) {
        Objects.requireNonNull(messageSupplier);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        CharSequence message = messageSupplier.get();
        Object object = this.lock;
        synchronized (object) {
            PrintWriter out = this.writerSupplier.get();
            out.print(message);
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, LogMessage message, Throwable cause) {
        PrintWriter out;
        if (cause == null) {
            this.log(level, message);
            return;
        }
        Objects.requireNonNull(message);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            out = this.writerSupplier.get();
            this.writeMessage(out, message);
            out.println();
            cause.printStackTrace(out);
        }
        if (this.autoFlush) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, CharSequence message, Throwable cause) {
        PrintWriter out;
        if (cause == null) {
            this.log(level, message);
            return;
        }
        Objects.requireNonNull(message);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            out = this.writerSupplier.get();
            out.println(message);
            cause.printStackTrace(out);
        }
        if (this.autoFlush) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (cause == null) {
            this.log(level, messageSupplier);
            return;
        }
        Objects.requireNonNull(messageSupplier);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        CharSequence message = messageSupplier.get();
        Object object = this.lock;
        synchronized (object) {
            PrintWriter out = this.writerSupplier.get();
            out.print(message);
            out.println();
            cause.printStackTrace(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logf(Level level, String format, Object ... args) {
        PrintWriter out;
        Objects.requireNonNull(format);
        if (level.compareTo((Enum)this.level.get()) > 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            out = this.writerSupplier.get();
            out.printf(format, args);
            out.println();
        }
        if (this.autoFlush) {
            out.flush();
        }
    }

    public void batch(Consumer<Logger> fn) {
        Objects.requireNonNull(fn);
        ArrayList<LogEvent> events = new ArrayList<LogEvent>(32);
        fn.accept(new BatchLogger(events::add));
        this.writeEvents(events);
    }

    @Override
    public void batch(Level level, Consumer<LogWriter> fn) {
        Objects.requireNonNull(fn);
        ArrayList<LogEvent> events = new ArrayList<LogEvent>(32);
        fn.accept(new BatchLogWriter(level, events::add));
        this.writeEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEvents(Collection<LogEvent> logEvents) {
        PrintWriter out;
        if (logEvents.isEmpty()) {
            return;
        }
        Level currentLevel = this.level.get();
        Object object = this.lock;
        synchronized (object) {
            out = this.writerSupplier.get();
            for (LogEvent logEvent : logEvents) {
                Throwable cause;
                if (logEvent.level.compareTo((Enum)currentLevel) > 0) continue;
                LogMessage message = logEvent.message;
                if (message != null) {
                    this.writeMessage(out, message);
                    out.println();
                } else {
                    out.println(logEvent.formattedMessage);
                }
                if ((cause = logEvent.cause) == null) continue;
                cause.printStackTrace(out);
            }
        }
        if (this.autoFlush) {
            out.flush();
        }
    }

    private void writeMessage(PrintWriter out, LogMessage message) {
        try {
            message.appendTo(this.locale, (Appendable)out);
        }
        catch (IOException ex) {
            throw new RuntimeException("unexpected exception", ex);
        }
    }

    private static final class BatchLogWriter
    implements LogWriter {
        private final Level level;
        private final Consumer<LogEvent> eventConsumer;

        BatchLogWriter(Level level, Consumer<LogEvent> eventConsumer) {
            this.level = level;
            this.eventConsumer = eventConsumer;
        }

        public void log(LogMessage message) {
            Objects.requireNonNull(message);
            this.eventConsumer.accept(new LogEvent(this.level, message, null));
        }

        public void log(CharSequence message) {
            Objects.requireNonNull(message);
            this.eventConsumer.accept(new LogEvent(this.level, message, null));
        }

        public void log(LogMessage message, Throwable cause) {
            Objects.requireNonNull(message);
            this.eventConsumer.accept(new LogEvent(this.level, message, cause));
        }

        public void log(CharSequence message, Throwable cause) {
            Objects.requireNonNull(message);
            this.eventConsumer.accept(new LogEvent(this.level, message, cause));
        }

        public void batch(Consumer<LogWriter> fn) {
            fn.accept(this);
        }
    }

    private static final class BatchLogger
    implements Logger {
        private final LogWriter errorWriter;
        private final LogWriter warnWriter;
        private final LogWriter infoWriter;
        private final LogWriter debugWriter;

        BatchLogger(Consumer<LogEvent> eventConsumer) {
            this.errorWriter = this.isEnabled(Level.ERROR) ? new BatchLogWriter(Level.ERROR, eventConsumer) : LogWriter.nullWriter();
            this.warnWriter = this.isEnabled(Level.WARN) ? new BatchLogWriter(Level.WARN, eventConsumer) : LogWriter.nullWriter();
            this.infoWriter = this.isEnabled(Level.INFO) ? new BatchLogWriter(Level.INFO, eventConsumer) : LogWriter.nullWriter();
            this.debugWriter = this.isEnabled(Level.DEBUG) ? new BatchLogWriter(Level.DEBUG, eventConsumer) : LogWriter.nullWriter();
        }

        public Level getLevel() {
            return Level.DEBUG;
        }

        public boolean isEnabled(Level level) {
            Objects.requireNonNull(level);
            return true;
        }

        public LogWriter errorWriter() {
            return this.errorWriter;
        }

        public LogWriter warnWriter() {
            return this.warnWriter;
        }

        public LogWriter infoWriter() {
            return this.infoWriter;
        }

        public LogWriter debugWriter() {
            return this.debugWriter;
        }

        public void batch(Consumer<Logger> fn) {
            Objects.requireNonNull(fn);
            fn.accept(this);
        }
    }

    private static final class LogEvent {
        final Level level;
        final CharSequence formattedMessage;
        final LogMessage message;
        final Throwable cause;

        LogEvent(Level level, CharSequence formattedMessage, Throwable cause) {
            this.level = level;
            this.formattedMessage = formattedMessage;
            this.message = null;
            this.cause = cause;
        }

        LogEvent(Level level, LogMessage message, Throwable cause) {
            this.level = level;
            this.formattedMessage = null;
            this.message = message;
            this.cause = cause;
        }
    }
}

