/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.logl.Level;
import org.logl.logl.AdjustableLogger;
import org.logl.logl.AdjustableLoggerProvider;
import org.logl.logl.SimpleLoggerImpl;
import org.logl.logl.WeakValueHashMap;

public final class SimpleLogger {
    private SimpleLogger() {
    }

    public static Builder withZone(ZoneId timeZone) {
        return new Builder().withZone(timeZone);
    }

    public static Builder withLocale(Locale locale) {
        return new Builder().withLocale(locale);
    }

    public static Builder withLogLevel(Level level) {
        return new Builder().withLogLevel(level);
    }

    static Builder usingCurrentTimeSupplier(Supplier<Instant> currentTimeSupplier) {
        return new Builder().usingCurrentTimeSupplier(currentTimeSupplier);
    }

    public static Builder withoutAutoFlush() {
        return new Builder().withoutAutoFlush();
    }

    public static AdjustableLoggerProvider toPrintWriter(PrintWriter writer) {
        return new Builder().toPrintWriter(writer);
    }

    public static AdjustableLoggerProvider toOutputStream(OutputStream stream) {
        return new Builder().toOutputStream(stream);
    }

    public static AdjustableLoggerProvider toPrintWriter(Supplier<PrintWriter> writerSupplier) {
        return new Builder().toPrintWriter(writerSupplier);
    }

    private static class Provider
    implements AdjustableLoggerProvider {
        private final Builder builder;
        private final Supplier<PrintWriter> writerSupplier;
        private final Map<String, SimpleLoggerImpl> loggers = Collections.synchronizedMap(new WeakValueHashMap());

        private Provider(Builder builder, Supplier<PrintWriter> writerSupplier) {
            this.builder = builder;
            this.writerSupplier = writerSupplier;
        }

        @Override
        public AdjustableLogger getLogger(String name) {
            return this.loggers.computeIfAbsent(name, n -> new SimpleLoggerImpl((String)n, this.builder, this.writerSupplier, this));
        }
    }

    public static class Builder {
        ZoneId zone = ZoneOffset.UTC;
        Locale locale = Locale.getDefault();
        Level level = Level.INFO;
        Supplier<Instant> currentTimeSupplier = Instant::now;
        boolean autoFlush = true;

        public Builder withZone(ZoneId timeZone) {
            Objects.requireNonNull(timeZone);
            this.zone = timeZone;
            return this;
        }

        public Builder withLocale(Locale locale) {
            Objects.requireNonNull(locale);
            this.locale = locale;
            return this;
        }

        public Builder withLogLevel(Level level) {
            Objects.requireNonNull(level);
            this.level = level;
            return this;
        }

        public Builder usingCurrentTimeSupplier(Supplier<Instant> currentTimeSupplier) {
            Objects.requireNonNull(currentTimeSupplier);
            this.currentTimeSupplier = currentTimeSupplier;
            return this;
        }

        public Builder withoutAutoFlush() {
            this.autoFlush = false;
            return this;
        }

        public AdjustableLoggerProvider toPrintWriter(PrintWriter writer) {
            Objects.requireNonNull(writer);
            return this.toPrintWriter(() -> writer);
        }

        public AdjustableLoggerProvider toOutputStream(OutputStream stream) {
            Objects.requireNonNull(stream);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8)));
            return this.toPrintWriter(() -> writer);
        }

        public AdjustableLoggerProvider toPrintWriter(Supplier<PrintWriter> writerSupplier) {
            Objects.requireNonNull(writerSupplier);
            return new Provider(this, writerSupplier);
        }
    }
}

