/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.logl.logl.FileRotationListener;
import org.logl.logl.FileRotationStrategy;

public final class RotatingFilePrintWriterSupplier
implements Supplier<PrintWriter>,
Closeable {
    private static final Writer NULL_WRITER = new NullWriter();
    private final Path outputFile;
    private final FileRotationStrategy rotationStrategy;
    private final int maxArchives;
    private final FileRotationListener rotationListener;
    private final Executor rotationExecutor;
    private final ReadWriteLock logFileLock = new ReentrantReadWriteLock(true);
    private final PrintWriter writer = new PrintWriter((Writer)new LockingWriter(), false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean rotating = new AtomicBoolean(false);
    private final AtomicLong written = new AtomicLong(0L);
    private Writer out = NULL_WRITER;

    public RotatingFilePrintWriterSupplier(Path outputFile, FileRotationStrategy rotationStrategy, int maxArchives) throws IOException {
        this(outputFile, rotationStrategy, maxArchives, new NoOpListener(), Runnable::run);
    }

    public RotatingFilePrintWriterSupplier(Path outputFile, FileRotationStrategy rotationStrategy, int maxArchives, FileRotationListener rotationListener) throws IOException {
        this(outputFile, rotationStrategy, maxArchives, rotationListener, Runnable::run);
    }

    public RotatingFilePrintWriterSupplier(Path outputFile, FileRotationStrategy rotationStrategy, int maxArchives, Executor rotationExecutor) throws IOException {
        this(outputFile, rotationStrategy, maxArchives, new NoOpListener(), rotationExecutor);
    }

    public RotatingFilePrintWriterSupplier(Path outputFile, FileRotationStrategy rotationStrategy, int maxArchives, FileRotationListener rotationListener, Executor rotationExecutor) throws IOException {
        this.outputFile = outputFile;
        this.rotationStrategy = rotationStrategy;
        this.maxArchives = maxArchives;
        this.rotationListener = rotationListener;
        this.rotationExecutor = rotationExecutor;
        this.out = RotatingFilePrintWriterSupplier.openOutputFile(outputFile);
    }

    @Override
    public PrintWriter get() {
        if (!this.closed.get() && !this.rotating.get() && this.rotationStrategy.shouldRotate(this.outputFile, this.written.get())) {
            this.rotate();
        }
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        this.logFileLock.writeLock().lock();
        try {
            this.closed.set(true);
            this.out.close();
        }
        finally {
            this.out = NULL_WRITER;
            this.logFileLock.writeLock().unlock();
        }
    }

    void rotate() {
        if (this.rotating.getAndSet(true)) {
            return;
        }
        StringWriter buffer = new StringWriter();
        PrintWriter bufferWriter = new PrintWriter(buffer);
        Runnable runnable = () -> {
            this.logFileLock.writeLock().lock();
            try {
                block32: {
                    try {
                        try {
                            this.out.flush();
                            this.out.close();
                        }
                        catch (Exception e) {
                            this.rotationListener.rotationError(e, bufferWriter);
                            if (!this.closed.get() && this.out == NULL_WRITER) {
                                try {
                                    this.out = RotatingFilePrintWriterSupplier.openOutputFile(this.outputFile);
                                }
                                catch (IOException e2) {
                                    this.rotationListener.rotationError(e2, bufferWriter);
                                }
                            }
                            try {
                                this.out.append(buffer.getBuffer());
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            this.rotating.set(false);
                            this.logFileLock.writeLock().unlock();
                            return;
                        }
                        this.out = NULL_WRITER;
                        this.written.set(0L);
                        if (!Files.exists(this.outputFile, new LinkOption[0])) break block32;
                        try {
                            this.shift();
                            Files.move(this.outputFile, RotatingFilePrintWriterSupplier.archiveFile(this.outputFile, 1), new CopyOption[0]);
                        }
                        catch (Exception e) {
                            this.rotationListener.rotationError(e, bufferWriter);
                            if (!this.closed.get() && this.out == NULL_WRITER) {
                                try {
                                    this.out = RotatingFilePrintWriterSupplier.openOutputFile(this.outputFile);
                                }
                                catch (IOException e3) {
                                    this.rotationListener.rotationError(e3, bufferWriter);
                                }
                            }
                            try {
                                this.out.append(buffer.getBuffer());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.rotating.set(false);
                            this.logFileLock.writeLock().unlock();
                            return;
                        }
                    }
                    finally {
                        if (!this.closed.get() && this.out == NULL_WRITER) {
                            try {
                                this.out = RotatingFilePrintWriterSupplier.openOutputFile(this.outputFile);
                            }
                            catch (IOException e) {
                                this.rotationListener.rotationError(e, bufferWriter);
                            }
                        }
                    }
                }
                this.rotationStrategy.rotationCompleted();
                this.rotationListener.rotationCompleted(bufferWriter);
            }
            finally {
                try {
                    this.out.append(buffer.getBuffer());
                }
                catch (IOException iOException) {}
                this.rotating.set(false);
                this.logFileLock.writeLock().unlock();
            }
        };
        try {
            this.rotationExecutor.execute(runnable);
        }
        catch (Exception e) {
            this.rotating.set(false);
        }
    }

    public List<Path> archives() {
        Path archive;
        ArrayList<Path> archives = new ArrayList<Path>();
        int i = 1;
        while (Files.exists(archive = RotatingFilePrintWriterSupplier.archiveFile(this.outputFile, i), new LinkOption[0])) {
            archives.add(archive);
            ++i;
        }
        return archives;
    }

    private void shift() throws IOException {
        for (int i = RotatingFilePrintWriterSupplier.lastArchiveFileNumber(this.outputFile); i > 0; --i) {
            Path archive = RotatingFilePrintWriterSupplier.archiveFile(this.outputFile, i);
            if (i >= this.maxArchives) {
                Files.delete(archive);
                continue;
            }
            Files.move(archive, RotatingFilePrintWriterSupplier.archiveFile(this.outputFile, i + 1), new CopyOption[0]);
        }
    }

    private static Path archiveFile(Path outputFile, int number) {
        return outputFile.resolveSibling(outputFile.getFileName().toString() + '.' + number);
    }

    private static int lastArchiveFileNumber(Path outputFile) {
        int i = 0;
        while (Files.exists(RotatingFilePrintWriterSupplier.archiveFile(outputFile, i + 1), new LinkOption[0])) {
            ++i;
        }
        return i;
    }

    private static Writer openOutputFile(Path file) throws IOException {
        return Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static long fileSize(Path file) {
        try {
            return Files.size(file);
        }
        catch (IOException e) {
            return Long.MAX_VALUE;
        }
    }

    private static class NoOpListener
    implements FileRotationListener {
        private NoOpListener() {
        }

        @Override
        public void rotationCompleted(PrintWriter out) {
        }

        @Override
        public void rotationError(Exception e, PrintWriter out) {
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private class LockingWriter
    extends Writer {
        private LockingWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RotatingFilePrintWriterSupplier.this.logFileLock.readLock().lock();
            try {
                RotatingFilePrintWriterSupplier.this.out.write(cbuf, off, len);
            }
            finally {
                RotatingFilePrintWriterSupplier.this.logFileLock.readLock().unlock();
            }
            RotatingFilePrintWriterSupplier.this.written.getAndAdd(len);
        }

        @Override
        public void flush() throws IOException {
            RotatingFilePrintWriterSupplier.this.logFileLock.readLock().lock();
            try {
                RotatingFilePrintWriterSupplier.this.out.flush();
            }
            finally {
                RotatingFilePrintWriterSupplier.this.logFileLock.readLock().unlock();
            }
        }

        @Override
        public void close() {
        }
    }
}

