/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;

abstract class NameAbbreviator {
    private NameAbbreviator() {
    }

    static NameAbbreviator forPattern(String pattern) {
        if (pattern.isEmpty()) {
            return new NoOp();
        }
        OptionalInt maybeCount = NameAbbreviator.parseCount(pattern);
        if (maybeCount.isPresent()) {
            int count = maybeCount.getAsInt();
            if (count == 0) {
                throw new IllegalArgumentException("Abbreviation of 0 would output nothing");
            }
            if (count < 0) {
                return new DropElements(-count);
            }
            return new RetainElements(count);
        }
        List<Abbreviation> fragments = NameAbbreviator.parseFragments(pattern);
        return new AbbreviateElements(fragments);
    }

    private static OptionalInt parseCount(String pattern) {
        try {
            return OptionalInt.of(Integer.parseInt(pattern));
        }
        catch (NumberFormatException ex) {
            int patternLength;
            int i = 0;
            char c = pattern.charAt(i);
            if (c == '-' || c == '+') {
                ++i;
            }
            if (i == (patternLength = pattern.length())) {
                return OptionalInt.empty();
            }
            while (i < patternLength && Character.digit(pattern.charAt(i), 10) >= 0) {
                ++i;
            }
            if (i == patternLength) {
                throw new IllegalArgumentException("Abbreviation count is larger than an integer");
            }
            return OptionalInt.empty();
        }
    }

    private static List<Abbreviation> parseFragments(String pattern) {
        ArrayList<Abbreviation> abbreviations = new ArrayList<Abbreviation>();
        int patternLength = pattern.length();
        for (int pos = 0; pos < patternLength; ++pos) {
            int leadingChars = 0;
            StringBuilder ellipsis = new StringBuilder();
            char c = pattern.charAt(pos);
            if (c == '*') {
                leadingChars = Integer.MAX_VALUE;
                ++pos;
            } else {
                int digit;
                while ((digit = Character.digit(c, 10)) >= 0) {
                    if (Integer.MAX_VALUE - (leadingChars *= 10) < digit) {
                        throw new IllegalArgumentException("Abbreviation count is larger than an integer");
                    }
                    leadingChars += digit;
                    if (++pos >= patternLength) break;
                    c = pattern.charAt(pos);
                }
            }
            while (pos < patternLength && (c = pattern.charAt(pos)) != '.') {
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c)) {
                    throw new IllegalArgumentException("Abbreviation fragment contains non-symbol replacement '" + c + "'");
                }
                ellipsis.append(c);
                ++pos;
            }
            abbreviations.add(new Abbreviation(leadingChars, ellipsis.toString()));
        }
        return abbreviations;
    }

    abstract void writeTo(String var1, Appendable var2) throws IOException;

    String abbreviate(String name) {
        StringBuilder builder = new StringBuilder();
        try {
            this.writeTo(name, builder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    private static final class AbbreviateElements
    extends NameAbbreviator {
        private final Abbreviation[] fragments;

        AbbreviateElements(List<Abbreviation> fragments) {
            this.fragments = fragments.toArray(new Abbreviation[fragments.size()]);
        }

        @Override
        void writeTo(String name, Appendable destination) throws IOException {
            int pos = 0;
            int nameLength = name.length();
            for (Abbreviation fragment : this.fragments) {
                if ((pos = fragment.abbreviateNext(name, pos, destination)) < nameLength) continue;
                return;
            }
            Abbreviation lastFragment = this.fragments[this.fragments.length - 1];
            while (pos < nameLength) {
                pos = lastFragment.abbreviateNext(name, pos, destination);
            }
        }
    }

    private static final class Abbreviation {
        private final int leadingChars;
        private final String ellipsis;

        Abbreviation(int leadingChars, String ellipsis) {
            this.leadingChars = leadingChars;
            this.ellipsis = ellipsis;
        }

        public int abbreviateNext(String name, int start, Appendable destination) throws IOException {
            int nameLength = name.length();
            for (int i = start; i < nameLength; ++i) {
                if (name.charAt(i) != '.') continue;
                if (i - start <= this.leadingChars) {
                    destination.append(name, start, i + 1);
                } else {
                    destination.append(name, start, start + this.leadingChars);
                    destination.append(this.ellipsis);
                    destination.append('.');
                }
                return i + 1;
            }
            destination.append(name, start, nameLength);
            return nameLength;
        }
    }

    private static final class RetainElements
    extends NameAbbreviator {
        private final int count;

        RetainElements(int count) {
            this.count = count;
        }

        @Override
        void writeTo(String name, Appendable destination) throws IOException {
            int length = name.length();
            if (length == 0) {
                return;
            }
            int end = length;
            assert (this.count > 0);
            for (int i = this.count; i > 0; --i) {
                if ((end = name.lastIndexOf(46, end - 1)) != -1) continue;
                destination.append(name);
                return;
            }
            destination.append(name, end + 1, length);
        }
    }

    private static final class DropElements
    extends NameAbbreviator {
        private final int count;

        DropElements(int count) {
            this.count = count;
        }

        @Override
        void writeTo(String name, Appendable destination) throws IOException {
            int start = 0;
            for (int i = 0; i < this.count; ++i) {
                int next = name.indexOf(46, start);
                if (next == -1) {
                    destination.append(name, start, name.length());
                    return;
                }
                start = next + 1;
            }
            destination.append(name, start, name.length());
        }
    }

    private static final class NoOp
    extends NameAbbreviator {
        private NoOp() {
        }

        @Override
        void writeTo(String name, Appendable destination) throws IOException {
            destination.append(name);
        }
    }
}

