/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.logl.Level;
import org.logl.LogMessage;
import org.logl.LogWriter;
import org.logl.logl.LevelLogger;

final class LevelLogWriter
implements LogWriter {
    private final Level level;
    private final LevelLogger logger;

    LevelLogWriter(Level level, LevelLogger logger) {
        this.level = level;
        this.logger = logger;
    }

    public void log(LogMessage message) {
        this.logger.log(this.level, message);
    }

    public void log(CharSequence message) {
        this.logger.log(this.level, message);
    }

    public void log(Supplier<? extends CharSequence> messageSupplier) {
        this.logger.log(this.level, messageSupplier);
    }

    public void log(LogMessage message, Throwable cause) {
        this.logger.log(this.level, message, cause);
    }

    public void log(CharSequence message, Throwable cause) {
        this.logger.log(this.level, message, cause);
    }

    public void log(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        this.logger.log(this.level, messageSupplier, cause);
    }

    public void logf(String format, Object ... args) {
        this.logger.logf(this.level, format, args);
    }

    public void batch(Consumer<LogWriter> fn) {
        this.logger.batch(this.level, fn);
    }
}

