/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.logl.Logger;
import org.logl.LoggerProvider;
import org.logl.logl.AdjustableLoggerProvider;
import org.logl.logl.DuplicatingLogger;
import org.logl.logl.WeakValueHashMap;

public final class DuplicatingLoggerProvider
implements AdjustableLoggerProvider {
    private final List<LoggerProvider> loggerProviders;
    private final Map<String, DuplicatingLogger> loggers = Collections.synchronizedMap(new WeakValueHashMap());

    public DuplicatingLoggerProvider(LoggerProvider ... loggerProviders) {
        this(Arrays.asList(loggerProviders));
    }

    public DuplicatingLoggerProvider(Collection<LoggerProvider> loggerProviders) {
        this.loggerProviders = new CopyOnWriteArrayList<LoggerProvider>(loggerProviders);
    }

    public boolean removeProvider(LoggerProvider loggerProvider) {
        if (!this.loggerProviders.remove(loggerProvider)) {
            return false;
        }
        this.loggers.forEach((n, l) -> l.removeLogger(loggerProvider.getLogger(n)));
        return true;
    }

    @Override
    public DuplicatingLogger getLogger(Class<?> loggingClass) {
        return this.getLogger(LoggerProvider.loggerName(loggingClass));
    }

    @Override
    public DuplicatingLogger getLogger(String name) {
        return this.loggers.computeIfAbsent(name, n -> {
            List<Logger> loggers = this.loggerProviders.stream().map(p -> p.getLogger(name)).collect(Collectors.toList());
            return new DuplicatingLogger(loggers);
        });
    }
}

