/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.logl.Level;
import org.logl.LogMessage;
import org.logl.LogWriter;
import org.logl.Logger;
import org.logl.logl.AdjustableLogger;
import org.logl.logl.DuplicatingLogWriter;

public final class DuplicatingLogger
implements AdjustableLogger {
    private List<Logger> loggers;
    private final AtomicReference<Level> level = new AtomicReference<Object>(null);
    private DuplicatingLogWriter errorWriter;
    private DuplicatingLogWriter warnWriter;
    private DuplicatingLogWriter infoWriter;
    private DuplicatingLogWriter debugWriter;

    public DuplicatingLogger(Logger ... loggers) {
        this(Arrays.asList(loggers));
    }

    public DuplicatingLogger(Collection<Logger> loggers) {
        this.loggers = new CopyOnWriteArrayList<Logger>(loggers);
        this.level.set(this.loggers.stream().map(Logger::getLevel).min(Enum::compareTo).orElse(Level.NONE));
        ArrayList<LogWriter> errorWriters = new ArrayList<LogWriter>(this.loggers.size());
        ArrayList<LogWriter> warnWriters = new ArrayList<LogWriter>(this.loggers.size());
        ArrayList<LogWriter> infoWriters = new ArrayList<LogWriter>(this.loggers.size());
        ArrayList<LogWriter> debugWriters = new ArrayList<LogWriter>(this.loggers.size());
        for (Logger logger : this.loggers) {
            errorWriters.add(logger.errorWriter());
            warnWriters.add(logger.warnWriter());
            infoWriters.add(logger.infoWriter());
            debugWriters.add(logger.debugWriter());
        }
        this.errorWriter = new DuplicatingLogWriter(Level.ERROR, this, errorWriters);
        this.warnWriter = new DuplicatingLogWriter(Level.WARN, this, warnWriters);
        this.infoWriter = new DuplicatingLogWriter(Level.INFO, this, infoWriters);
        this.debugWriter = new DuplicatingLogWriter(Level.DEBUG, this, debugWriters);
    }

    public boolean removeLogger(Logger logger) {
        if (!this.loggers.remove(logger)) {
            return false;
        }
        this.errorWriter.remove(logger.errorWriter());
        this.warnWriter.remove(logger.warnWriter());
        this.infoWriter.remove(logger.infoWriter());
        this.debugWriter.remove(logger.debugWriter());
        return true;
    }

    public Level getLevel() {
        return this.level.get();
    }

    @Override
    public Level setLevel(Level level) {
        Objects.requireNonNull(level);
        return this.level.getAndSet(level);
    }

    boolean checkLevel(Level level) {
        return level.compareTo((Enum)this.level.get()) <= 0;
    }

    public boolean isErrorEnabled() {
        return this.checkLevel(Level.ERROR);
    }

    public void error(LogMessage message) {
        if (this.checkLevel(Level.ERROR)) {
            for (Logger logger : this.loggers) {
                logger.error(message);
            }
        }
    }

    public void error(CharSequence message) {
        if (this.checkLevel(Level.ERROR)) {
            for (Logger logger : this.loggers) {
                logger.error(message);
            }
        }
    }

    public void error(Supplier<? extends CharSequence> messageSupplier) {
        if (this.checkLevel(Level.ERROR)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isErrorEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.error(message);
            }
        }
    }

    public void error(LogMessage message, Throwable cause) {
        if (this.checkLevel(Level.ERROR)) {
            for (Logger logger : this.loggers) {
                logger.error(message, cause);
            }
        }
    }

    public void error(CharSequence message, Throwable cause) {
        if (this.checkLevel(Level.ERROR)) {
            for (Logger logger : this.loggers) {
                logger.error(message, cause);
            }
        }
    }

    public void error(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.checkLevel(Level.ERROR)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isErrorEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.error(message, cause);
            }
        }
    }

    public void error(String pattern, Object ... args) {
        if (this.checkLevel(Level.ERROR)) {
            for (Logger logger : this.loggers) {
                logger.error(pattern, args);
            }
        }
    }

    public void errorf(String format, Object ... args) {
        if (this.checkLevel(Level.ERROR)) {
            for (Logger logger : this.loggers) {
                logger.errorf(format, args);
            }
        }
    }

    public LogWriter errorWriter() {
        return this.errorWriter;
    }

    public boolean isWarnEnabled() {
        return Level.WARN.compareTo((Enum)this.level.get()) <= 0;
    }

    public void warn(LogMessage message) {
        if (this.checkLevel(Level.WARN)) {
            for (Logger logger : this.loggers) {
                logger.warn(message);
            }
        }
    }

    public void warn(CharSequence message) {
        if (this.checkLevel(Level.WARN)) {
            for (Logger logger : this.loggers) {
                logger.warn(message);
            }
        }
    }

    public void warn(Supplier<? extends CharSequence> messageSupplier) {
        if (this.checkLevel(Level.WARN)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isWarnEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.warn(message);
            }
        }
    }

    public void warn(LogMessage message, Throwable cause) {
        if (this.checkLevel(Level.WARN)) {
            for (Logger logger : this.loggers) {
                logger.warn(message, cause);
            }
        }
    }

    public void warn(CharSequence message, Throwable cause) {
        if (this.checkLevel(Level.WARN)) {
            for (Logger logger : this.loggers) {
                logger.warn(message, cause);
            }
        }
    }

    public void warn(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.checkLevel(Level.WARN)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isWarnEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.warn(message, cause);
            }
        }
    }

    public void warn(String pattern, Object ... args) {
        if (this.checkLevel(Level.WARN)) {
            for (Logger logger : this.loggers) {
                logger.warn(pattern, args);
            }
        }
    }

    public void warnf(String format, Object ... args) {
        if (this.checkLevel(Level.WARN)) {
            for (Logger logger : this.loggers) {
                logger.warnf(format, args);
            }
        }
    }

    public LogWriter warnWriter() {
        return this.warnWriter;
    }

    public boolean isInfoEnabled() {
        return Level.INFO.compareTo((Enum)this.level.get()) <= 0;
    }

    public void info(LogMessage message) {
        if (this.checkLevel(Level.INFO)) {
            for (Logger logger : this.loggers) {
                logger.info(message);
            }
        }
    }

    public void info(CharSequence message) {
        if (this.checkLevel(Level.INFO)) {
            for (Logger logger : this.loggers) {
                logger.info(message);
            }
        }
    }

    public void info(Supplier<? extends CharSequence> messageSupplier) {
        if (this.checkLevel(Level.INFO)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isInfoEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.info(message);
            }
        }
    }

    public void info(LogMessage message, Throwable cause) {
        if (this.checkLevel(Level.INFO)) {
            for (Logger logger : this.loggers) {
                logger.info(message, cause);
            }
        }
    }

    public void info(CharSequence message, Throwable cause) {
        if (this.checkLevel(Level.INFO)) {
            for (Logger logger : this.loggers) {
                logger.info(message, cause);
            }
        }
    }

    public void info(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.checkLevel(Level.INFO)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isInfoEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.info(message, cause);
            }
        }
    }

    public void info(String pattern, Object ... args) {
        if (this.checkLevel(Level.INFO)) {
            for (Logger logger : this.loggers) {
                logger.info(pattern, args);
            }
        }
    }

    public void infof(String format, Object ... args) {
        if (this.checkLevel(Level.INFO)) {
            for (Logger logger : this.loggers) {
                logger.infof(format, args);
            }
        }
    }

    public LogWriter infoWriter() {
        return this.infoWriter;
    }

    public boolean isDebugEnabled() {
        return Level.DEBUG.compareTo((Enum)this.level.get()) <= 0;
    }

    public void debug(LogMessage message) {
        if (this.checkLevel(Level.DEBUG)) {
            for (Logger logger : this.loggers) {
                logger.debug(message);
            }
        }
    }

    public void debug(CharSequence message) {
        if (this.checkLevel(Level.DEBUG)) {
            for (Logger logger : this.loggers) {
                logger.debug(message);
            }
        }
    }

    public void debug(Supplier<? extends CharSequence> messageSupplier) {
        if (this.checkLevel(Level.DEBUG)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isDebugEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.debug(message);
            }
        }
    }

    public void debug(LogMessage message, Throwable cause) {
        if (this.checkLevel(Level.DEBUG)) {
            for (Logger logger : this.loggers) {
                logger.debug(message, cause);
            }
        }
    }

    public void debug(CharSequence message, Throwable cause) {
        if (this.checkLevel(Level.DEBUG)) {
            for (Logger logger : this.loggers) {
                logger.debug(message, cause);
            }
        }
    }

    public void debug(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.checkLevel(Level.DEBUG)) {
            CharSequence message = null;
            for (Logger logger : this.loggers) {
                if (!logger.isDebugEnabled()) continue;
                if (message == null) {
                    message = messageSupplier.get();
                }
                logger.debug(message, cause);
            }
        }
    }

    public void debug(String pattern, Object ... args) {
        if (this.checkLevel(Level.DEBUG)) {
            for (Logger logger : this.loggers) {
                logger.debug(pattern, args);
            }
        }
    }

    public void debugf(String format, Object ... args) {
        if (this.checkLevel(Level.DEBUG)) {
            for (Logger logger : this.loggers) {
                logger.debugf(format, args);
            }
        }
    }

    public LogWriter debugWriter() {
        return this.debugWriter;
    }

    public void batch(Consumer<Logger> fn) {
        this.batch(0, new ArrayList<Logger>(this.loggers.size()), fn);
    }

    private void batch(int index, ArrayList<Logger> batchLoggers, Consumer<Logger> fn) {
        if (index < this.loggers.size()) {
            Logger logger = this.loggers.get(index);
            logger.batch(bulkLogger -> {
                batchLoggers.add((Logger)bulkLogger);
                this.batch(index + 1, batchLoggers, fn);
            });
        } else {
            fn.accept(new DuplicatingLogger(batchLoggers));
        }
    }
}

