/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.logl.Level;
import org.logl.LogMessage;
import org.logl.LogWriter;
import org.logl.logl.DuplicatingLogger;

final class DuplicatingLogWriter
implements LogWriter {
    private final Level level;
    private final DuplicatingLogger logger;
    private final List<LogWriter> logWriters;

    DuplicatingLogWriter(Level level, DuplicatingLogger logger, List<LogWriter> logWriters) {
        this.level = level;
        this.logger = logger;
        this.logWriters = new CopyOnWriteArrayList<LogWriter>(logWriters);
    }

    boolean remove(LogWriter logWriter) {
        return this.logWriters.remove(logWriter);
    }

    public void log(LogMessage message) {
        if (this.logger.checkLevel(this.level)) {
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(message);
            }
        }
    }

    public void log(CharSequence message) {
        if (this.logger.checkLevel(this.level)) {
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(message);
            }
        }
    }

    public void log(Supplier<? extends CharSequence> messageSupplier) {
        if (this.logger.checkLevel(this.level)) {
            CharSequence message = messageSupplier.get();
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(message);
            }
        }
    }

    public void log(LogMessage message, Throwable cause) {
        if (this.logger.checkLevel(this.level)) {
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(message, cause);
            }
        }
    }

    public void log(CharSequence message, Throwable cause) {
        if (this.logger.checkLevel(this.level)) {
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(message, cause);
            }
        }
    }

    public void log(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.logger.checkLevel(this.level)) {
            CharSequence message = messageSupplier.get();
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(message, cause);
            }
        }
    }

    public void log(String pattern, Object ... args) {
        if (this.logger.checkLevel(this.level)) {
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(pattern, args);
            }
        }
    }

    public void logf(String format, Object ... args) {
        if (this.logger.checkLevel(this.level)) {
            for (LogWriter logWriter : this.logWriters) {
                logWriter.log(format, args);
            }
        }
    }

    public void batch(Consumer<LogWriter> fn) {
        this.batch(0, new ArrayList<LogWriter>(this.logWriters.size()), fn);
    }

    private void batch(int index, ArrayList<LogWriter> batchLoggers, Consumer<LogWriter> fn) {
        if (index < this.logWriters.size()) {
            LogWriter logWriter = this.logWriters.get(index);
            logWriter.batch(bulkLogger -> {
                batchLoggers.add((LogWriter)bulkLogger);
                this.batch(index + 1, batchLoggers, fn);
            });
        } else {
            fn.accept(new DuplicatingLogWriter(this.level, this.logger, batchLoggers));
        }
    }
}

