/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.logl.logl.FileRotationStrategy;

final class DefaultFileRotationStrategy
implements FileRotationStrategy {
    private final long thresholdBytes;
    private final long delayMillis;
    private final Supplier<Instant> currentTimeSupplier;
    private AtomicReference<Instant> nextRotation = new AtomicReference<Instant>(Instant.MIN);

    DefaultFileRotationStrategy(long thresholdBytes, long delayMillis, Supplier<Instant> currentTimeSupplier) {
        this.thresholdBytes = thresholdBytes;
        this.delayMillis = delayMillis;
        this.currentTimeSupplier = currentTimeSupplier;
    }

    @Override
    public boolean shouldRotate(Path outputFile, long bytesWritten) {
        if (!Files.exists(outputFile, new LinkOption[0])) {
            return true;
        }
        if (this.currentTimeSupplier.get().isBefore(this.nextRotation.get())) {
            return false;
        }
        return bytesWritten >= this.thresholdBytes;
    }

    @Override
    public void rotationCompleted() {
        if (this.delayMillis > 0L) {
            this.nextRotation.set(this.currentTimeSupplier.get().plusMillis(this.delayMillis));
        }
    }
}

