/*
 * Decompiled with CFR 0.152.
 */
package org.logl.logl;

import java.io.PrintWriter;
import java.time.ZonedDateTime;

final class DateFormatter {
    private static final String[] COMMON_YEARS;
    private static final String[] TWO_DIGIT_INTS;
    private static final String[] THREE_DIGIT_INTS;

    private DateFormatter() {
    }

    static void formatTo(ZonedDateTime dateTime, PrintWriter out) {
        int year = dateTime.getYear();
        if (year >= 1900 && year < 2100) {
            out.write(COMMON_YEARS[year - 1900]);
        } else {
            String ys = Integer.toString(year % 10000);
            out.write("   ", 0, 4 - ys.length());
            out.write(ys);
        }
        out.write(45);
        out.write(TWO_DIGIT_INTS[dateTime.getMonth().getValue()]);
        out.write(45);
        out.write(TWO_DIGIT_INTS[dateTime.getDayOfMonth()]);
        out.write(32);
        out.write(TWO_DIGIT_INTS[dateTime.getHour()]);
        out.write(58);
        out.write(TWO_DIGIT_INTS[dateTime.getMinute()]);
        out.write(58);
        out.write(TWO_DIGIT_INTS[dateTime.getSecond()]);
        out.write(46);
        int millis = dateTime.getNano() / 1000000;
        out.write(THREE_DIGIT_INTS[millis]);
        int offsetSeconds = dateTime.getOffset().getTotalSeconds();
        if (offsetSeconds < 0) {
            out.write(45);
            offsetSeconds = -offsetSeconds;
        } else {
            out.write(43);
        }
        int offsetMinutes = offsetSeconds / 60;
        int offsetHours = offsetMinutes / 60;
        out.write(TWO_DIGIT_INTS[offsetHours]);
        out.write(TWO_DIGIT_INTS[offsetMinutes % 60]);
    }

    static {
        int i;
        COMMON_YEARS = new String[200];
        for (i = 0; i < 200; ++i) {
            DateFormatter.COMMON_YEARS[i] = Integer.toString(i + 1900);
        }
        TWO_DIGIT_INTS = new String[61];
        for (i = 0; i <= 60; ++i) {
            DateFormatter.TWO_DIGIT_INTS[i] = String.format("%02d", i);
        }
        THREE_DIGIT_INTS = new String[1000];
        for (i = 0; i < 1000; ++i) {
            DateFormatter.THREE_DIGIT_INTS[i] = String.format("%03d", i);
        }
    }
}

