/*
 * Decompiled with CFR 0.152.
 */
package org.logl;

import java.util.Objects;
import java.util.function.Consumer;
import org.logl.Level;
import org.logl.LogWriter;
import org.logl.Logger;
import org.logl.NullLogWriter;

final class NullLogger
implements Logger {
    private static final NullLogger INSTANCE = new NullLogger();
    private LogWriter logWriter = NullLogWriter.instance();

    static NullLogger instance() {
        return INSTANCE;
    }

    private NullLogger() {
    }

    @Override
    public Level getLevel() {
        return Level.NONE;
    }

    @Override
    public boolean isEnabled(Level level) {
        Objects.requireNonNull(level);
        return false;
    }

    @Override
    public LogWriter errorWriter() {
        return this.logWriter;
    }

    @Override
    public LogWriter warnWriter() {
        return this.logWriter;
    }

    @Override
    public LogWriter infoWriter() {
        return this.logWriter;
    }

    @Override
    public LogWriter debugWriter() {
        return this.logWriter;
    }

    @Override
    public void batch(Consumer<Logger> fn) {
        Objects.requireNonNull(fn);
        fn.accept(this);
    }
}

