/*
 * Decompiled with CFR 0.152.
 */
package org.logl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

final class MessageFormatter {
    private static final char DELIM_START = '{';
    private static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    MessageFormatter() {
    }

    static void formatTo(String pattern, Object[] args, Appendable appendable) throws IOException {
        int j;
        if (args == null || args.length == 0) {
            appendable.append(pattern);
            return;
        }
        int patternLength = pattern.length();
        int n = 0;
        int i = 0;
        while (n < args.length && i < patternLength && (j = pattern.indexOf(DELIM_STR, i)) >= 0) {
            if (j > 0 && pattern.charAt(j - 1) == '\\') {
                appendable.append(pattern, i, j - 1);
                if (j <= 1 || pattern.charAt(j - 2) != '\\') {
                    appendable.append(pattern, i, j - 1);
                    appendable.append('{');
                    i = j + 1;
                    continue;
                }
            } else {
                appendable.append(pattern, i, j);
            }
            MessageFormatter.appendParameter(appendable, args[n++], null);
            i = j + 2;
        }
        if (i < patternLength) {
            appendable.append(pattern, i, patternLength);
        }
    }

    private static void appendParameter(Appendable appendable, Object parameter, Set<Object[]> seen) throws IOException {
        if (parameter == null) {
            appendable.append("null");
            return;
        }
        if (!parameter.getClass().isArray()) {
            String paramString;
            try {
                paramString = parameter.toString();
            }
            catch (Exception e) {
                paramString = "[FAILED toString()]";
            }
            appendable.append(paramString);
            return;
        }
        if (parameter instanceof boolean[]) {
            MessageFormatter.appendBooleanArray(appendable, (boolean[])parameter);
        } else if (parameter instanceof byte[]) {
            MessageFormatter.appendByteArray(appendable, (byte[])parameter);
        } else if (parameter instanceof char[]) {
            MessageFormatter.appendCharArray(appendable, (char[])parameter);
        } else if (parameter instanceof short[]) {
            MessageFormatter.appendShortArray(appendable, (short[])parameter);
        } else if (parameter instanceof int[]) {
            MessageFormatter.appendIntArray(appendable, (int[])parameter);
        } else if (parameter instanceof long[]) {
            MessageFormatter.appendLongArray(appendable, (long[])parameter);
        } else if (parameter instanceof float[]) {
            MessageFormatter.appendFloatArray(appendable, (float[])parameter);
        } else if (parameter instanceof double[]) {
            MessageFormatter.appendDoubleArray(appendable, (double[])parameter);
        } else {
            MessageFormatter.appendObjectArray(appendable, (Object[])parameter, seen);
        }
    }

    private static void appendBooleanArray(Appendable appendable, boolean[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        for (int i = 0; i < l; ++i) {
            appendable.append(a[i] ? "true, " : "false, ");
        }
        appendable.append(a[l] ? "true]" : "false]");
    }

    private static void appendByteArray(Appendable appendable, byte[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        if (appendable instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)appendable;
            for (int i = 0; i < l; ++i) {
                builder.append(a[i]);
                builder.append(", ");
            }
            builder.append(a[l]);
        } else {
            for (int i = 0; i < l; ++i) {
                appendable.append(String.valueOf(a[i]));
                appendable.append(", ");
            }
            appendable.append(String.valueOf(a[l]));
        }
        appendable.append(']');
    }

    private static void appendCharArray(Appendable appendable, char[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        for (int i = 0; i < l; ++i) {
            appendable.append(a[i]);
            appendable.append(", ");
        }
        appendable.append(a[l]);
        appendable.append(']');
    }

    private static void appendShortArray(Appendable appendable, short[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        if (appendable instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)appendable;
            for (int i = 0; i < l; ++i) {
                builder.append(a[i]);
                builder.append(", ");
            }
            builder.append(a[l]);
        } else {
            for (int i = 0; i < l; ++i) {
                appendable.append(String.valueOf(a[i]));
                appendable.append(", ");
            }
            appendable.append(String.valueOf(a[l]));
        }
        appendable.append(']');
    }

    private static void appendIntArray(Appendable appendable, int[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        if (appendable instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)appendable;
            for (int i = 0; i < l; ++i) {
                builder.append(a[i]);
                builder.append(", ");
            }
            builder.append(a[l]);
        } else {
            for (int i = 0; i < l; ++i) {
                appendable.append(String.valueOf(a[i]));
                appendable.append(", ");
            }
            appendable.append(String.valueOf(a[l]));
        }
        appendable.append(']');
    }

    private static void appendLongArray(Appendable appendable, long[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        if (appendable instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)appendable;
            for (int i = 0; i < l; ++i) {
                builder.append(a[i]);
                builder.append(", ");
            }
            builder.append(a[l]);
        } else {
            for (int i = 0; i < l; ++i) {
                appendable.append(String.valueOf(a[i]));
                appendable.append(", ");
            }
            appendable.append(String.valueOf(a[l]));
        }
        appendable.append(']');
    }

    private static void appendFloatArray(Appendable appendable, float[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        if (appendable instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)appendable;
            for (int i = 0; i < l; ++i) {
                builder.append(a[i]);
                builder.append(", ");
            }
            builder.append(a[l]);
        } else {
            for (int i = 0; i < l; ++i) {
                appendable.append(String.valueOf(a[i]));
                appendable.append(", ");
            }
            appendable.append(String.valueOf(a[l]));
        }
        appendable.append(']');
    }

    private static void appendDoubleArray(Appendable appendable, double[] a) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        int l = a.length - 1;
        if (appendable instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)appendable;
            for (int i = 0; i < l; ++i) {
                builder.append(a[i]);
                builder.append(", ");
            }
            builder.append(a[l]);
        } else {
            for (int i = 0; i < l; ++i) {
                appendable.append(String.valueOf(a[i]));
                appendable.append(", ");
            }
            appendable.append(String.valueOf(a[l]));
        }
        appendable.append(']');
    }

    private static void appendObjectArray(Appendable appendable, Object[] a, Set<Object[]> seen) throws IOException {
        if (a.length == 0) {
            appendable.append("[]");
            return;
        }
        appendable.append('[');
        if (seen != null && seen.contains(a)) {
            appendable.append("...]");
            return;
        }
        if (seen == null) {
            seen = new HashSet<Object[]>();
            seen.add(a);
        } else if (seen.contains(a)) {
            appendable.append("...]");
            return;
        }
        int l = a.length - 1;
        for (int i = 0; i < l; ++i) {
            MessageFormatter.appendParameter(appendable, a[i], seen);
            appendable.append(", ");
        }
        MessageFormatter.appendParameter(appendable, a[l], seen);
        appendable.append(']');
    }
}

